/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Icon;
import java.awt.Graphics;
import javax.swing.SwingUtilities;

public class IconInside
extends Icon {
    static final int L = 12;
    static String INSIDE;
    private boolean activated = false;
    private static final int[][] TX;

    protected IconInside(Aladin aladin) {
        super(aladin, 32, 24);
        INSIDE = Aladin.chaine.getString("INSIDE");
    }

    protected void drawElague(Graphics g, int x, int y) {
        for (int i = 0; i < TX.length; ++i) {
            g.drawLine(TX[i][1] + x, TX[i][0] + y, TX[i][2] + x, TX[i][0] + y);
        }
    }

    @Override
    protected boolean isAvailable() {
        return !this.aladin.view.isFree() && !this.aladin.directory.isFree();
    }

    @Override
    protected boolean isActivated() {
        return this.activated;
    }

    @Override
    protected void drawLogo(Graphics g) {
        super.drawLogo(g);
        int x = 10;
        int y = 1;
        boolean isAvailable = this.isAvailable();
        if (isAvailable) {
            g.setColor(this.getFillInColor());
            g.fillRect(x, y, 13, 10);
        }
        g.setColor(this.getLogoColor());
        this.drawElague(g, x, y);
        g.setColor(this.getLabelColor());
        g.setFont(Aladin.SPLAIN);
        g.drawString(INSIDE, this.W / 2 - g.getFontMetrics().stringWidth(INSIDE) / 2, this.H - 2);
    }

    @Override
    protected void submit() {
        if (!this.isAvailable()) {
            return;
        }
        this.activated = !this.activated;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IconInside.this.aladin.directory.resumeTree();
            }
        });
        this.repaint();
    }

    @Override
    protected String getHelpTip() {
        return Aladin.chaine.getString("INSIDETIP");
    }

    @Override
    protected String getHelpKey() {
        return "Inside.HELP";
    }

    static {
        TX = new int[][]{{0, 0, 13}, {1, 0, 0}, {1, 13, 13}, {2, 0, 0}, {2, 13, 13}, {3, 0, 0}, {3, 13, 13}, {4, 0, 0}, {4, 13, 13}, {5, 0, 0}, {5, 6, 6}, {5, 13, 13}, {6, 0, 0}, {6, 5, 7}, {6, 13, 13}, {7, 0, 0}, {7, 4, 8}, {7, 13, 13}, {8, 0, 0}, {8, 5, 7}, {8, 13, 13}, {9, 0, 2}, {9, 5, 7}, {9, 11, 13}, {10, 5, 7}, {11, 5, 7}};
    }
}

