/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Icon;
import java.awt.Graphics;
import javax.swing.SwingUtilities;

public class IconFilter
extends Icon {
    static final int L = 12;
    private String title = aladin.getChaine().getString("DTFILTER");
    private static final int[][] TX = new int[][]{{0, 9, 21}, {1, 9, 10}, {1, 20, 21}, {2, 10, 20}, {3, 11, 19}, {4, 12, 18}, {5, 13, 17}, {6, 14, 16}, {7, 14, 16}, {8, 14, 16}, {9, 14, 16}, {10, 14, 16}, {11, 14, 15}, {12, 14, 14}};

    protected IconFilter(Aladin aladin) {
        super(aladin, 32, 24);
    }

    protected void drawIcon(Graphics g, int x, int y) {
        for (int i = 0; i < TX.length; ++i) {
            g.drawLine(TX[i][1] + x, TX[i][0] + y, TX[i][2] + x, TX[i][0] + y);
        }
    }

    @Override
    protected boolean isAvailable() {
        return this.isActivated();
    }

    @Override
    protected boolean isActivated() {
        return this.aladin.directory.hasCollections() && this.aladin.directory.hasFilter();
    }

    @Override
    protected void drawLogo(Graphics g) {
        super.drawLogo(g);
        int x = 3;
        int y = 1;
        g.setColor(this.getLogoColor());
        this.drawIcon(g, x, y);
        g.setColor(this.getLabelColor());
        g.setFont(Aladin.SPLAIN);
        g.drawString(this.title, this.W / 2 - g.getFontMetrics().stringWidth(this.title) / 2, this.H - 2);
    }

    @Override
    protected void submit() {
        if (!this.isAvailable()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IconFilter.this.aladin.directory.fullReset();
            }
        });
    }

    @Override
    protected String getHelpTip() {
        return Aladin.chaine.getString("DTFILTERTIP");
    }

    @Override
    protected String getHelpKey() {
        return "Filter.HELP";
    }
}

