/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public final class Help
extends JComponent
implements MouseMotionListener,
MouseListener {
    String text;
    Font font = FI;
    FontMetrics fm = null;
    int ws = 520;
    int hs = 520;
    boolean flagFold = true;
    Aladin aladin;
    static Font FI = Aladin.JOLI;
    static Font FG;
    static Font FTITRE;
    static int dy;
    private static Color BGD;
    String DEFAUT;
    String VIEW;
    Stack stack = new Stack();
    private boolean center = false;
    private static final int MAXLINK = 200;
    private String[] link = new String[200];
    private Rectangle[] xyLink = new Rectangle[200];
    private int nbLink = 0;
    private int ostyle = 0;
    private int owidth = -1;
    private int oheight = -1;
    private boolean first = true;

    protected Help(Aladin aladin) {
        this.aladin = aladin;
        BGD = Aladin.COLOR_BACKGROUND;
        this.setBackground(BGD);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    protected String H() {
        if (this.VIEW == null) {
            this.VIEW = Aladin.chaine.getString("View.HELP");
        }
        return this.VIEW;
    }

    protected void setText(String text) {
        this.flagFold = true;
        if (text != null && text.length() > 1) {
            if (text.charAt(0) == '-') {
                this.font = Aladin.PLAIN;
                text = text.substring(1);
            } else if (text.charAt(0) == '|') {
                this.flagFold = false;
                this.font = Aladin.COURIER;
                text = text.substring(1);
            }
        } else {
            this.font = FI;
        }
        this.fm = null;
        this.text = text;
        this.repaint();
    }

    protected void setHyperText(String link, String text) {
        this.resetLink();
        if (link != null) {
            this.stack(link);
        }
        this.setText(text);
    }

    private void goBack() {
        this.stack.pop();
        this.aladin.command.execHelpCmd((String)this.stack.pop());
    }

    private void stack(String link) {
        this.stack.push(link);
    }

    protected void resetStack() {
        while (!this.stack.empty()) {
            this.stack.pop();
        }
    }

    private int hasStack() {
        return this.stack.size() - 1;
    }

    protected void setDefault() {
        if (this.DEFAUT == null) {
            this.DEFAUT = Aladin.chaine.getString("Help.HELP");
        }
        this.setText(this.DEFAUT);
    }

    protected void setCenter(boolean center) {
        this.center = center;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getLink(e.getX(), e.getY()) != null) {
            Aladin.makeCursor(this, 2);
        } else {
            Aladin.makeCursor(this, 0);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.aladin.status.setText("");
        if (this.aladin.inHelp) {
            this.setText(this.H());
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        String wordLink;
        if (this.aladin.msgOn) {
            this.aladin.endMsg();
        }
        if ((wordLink = this.getLink(e.getX(), e.getY())) != null) {
            if (wordLink.equals("Home")) {
                this.resetStack();
                wordLink = "";
            }
            if (wordLink.equals("Back")) {
                this.goBack();
            } else {
                this.aladin.command.execHelpCmd(wordLink);
            }
        } else {
            this.aladin.helpOff();
        }
    }

    int getTextHeight(Graphics g, String s, int x, int y) {
        return this.drawString1(g, s, x, y, false);
    }

    int drawString(Graphics g, String s, int x, int y) {
        return this.drawString1(g, s, x, y, true);
    }

    private int drawString1(Graphics g, String s, int x, int y, boolean draw) {
        boolean ligneVide;
        Aladin imo;
        boolean flag_center = false;
        Container container = imo = this.aladin.isFullScreen() ? this.aladin.fullScreen.viewSimple : this.aladin;
        if (this.fm == null) {
            return y;
        }
        dy = this.fm.getHeight() + 2;
        boolean bl = ligneVide = s.trim().length() == 0;
        if (s.charAt(0) == '%' || (flag_center = s.indexOf("*%") == 0)) {
            String imgFile = s.substring(flag_center ? 2 : 1);
            Image i = this.aladin.getImagette(imgFile);
            if (i == null) {
                return y;
            }
            if (flag_center) {
                x = this.ws / 2 - i.getWidth(imo) / 2;
            }
            if (draw) {
                g.drawImage(i, x, y, imo);
            }
            return y += i.getHeight(imo) + dy;
        }
        if (s.charAt(0) == '!') {
            g.setFont(FTITRE);
            x = this.ws / 2 - this.fm.stringWidth(s) / 2;
            y += dy / 2;
            if (draw) {
                g.drawString(s.substring(1), x, y);
            }
            y = (int)((double)y + 1.5 * (double)dy);
            g.setFont(this.font);
            return y;
        }
        if (s.charAt(0) == '*' || this.center) {
            if (s.charAt(0) == '*') {
                s = s.substring(1);
            }
            x = this.ws / 2 - this.fm.stringWidth(s) / 2;
            if (draw) {
                g.drawString(s, x, y);
            }
            return y += dy;
        }
        boolean flagLink = false;
        StringTokenizer st = new StringTokenizer(s, " \t,|(.", true);
        while (st.hasMoreTokens()) {
            int w;
            String mot = st.nextToken();
            int style = 0;
            int n = mot.length();
            if (n > 1 && mot.charAt(0) == '@') {
                flagLink = true;
                mot = mot.substring(1);
                --n;
            } else {
                flagLink = false;
            }
            if (n > 2 && mot.charAt(0) == '#' && mot.charAt(n - 1) == '#') {
                style = 2;
                mot = mot.substring(1, n - 1);
                n -= 2;
            }
            if (n > 2 && mot.charAt(0) == '_' && mot.charAt(n - 1) == '_') {
                style |= 1;
                mot = mot.substring(1, n - 1);
                n -= 2;
            }
            if (mot.length() >= 2 && mot.startsWith("\\@")) {
                mot = mot.substring(1);
            }
            if (x + (w = this.fm.stringWidth(mot)) > this.ws) {
                x = 10;
                y += dy;
                if (mot.equals(" ")) continue;
            }
            if (!draw) continue;
            x = this.drawWord(g, mot, x, y, flagLink, style);
        }
        return y + (ligneVide ? dy - 8 : dy);
    }

    private void resetLink() {
        this.nbLink = 0;
    }

    private boolean addLink(String word, int x, int y, int w, int h) {
        if (this.nbLink == 200) {
            return false;
        }
        this.link[this.nbLink] = word;
        this.xyLink[this.nbLink++] = new Rectangle(x, y, w, h);
        return true;
    }

    private String getLink(int x, int y) {
        for (int i = 0; i < this.nbLink; ++i) {
            if (!this.xyLink[i].contains(x, y)) continue;
            return this.link[i];
        }
        return null;
    }

    private int drawWord(Graphics g, String word, int x, int y, boolean flagLink, int style) {
        Color c = null;
        if (style != this.ostyle) {
            this.ostyle = style;
            g.setFont(g.getFont().deriveFont(style));
            this.fm = g.getFontMetrics();
        }
        int w = this.fm.stringWidth(word);
        if (flagLink) {
            flagLink = this.addLink(word, x, y + 2 - dy, w, dy);
        }
        if (flagLink) {
            c = g.getColor();
            g.setColor(Aladin.COLOR_FOREGROUND_ANCHOR);
        }
        g.drawString(word, x, y);
        if (c != null) {
            g.setColor(c);
        }
        return x + w;
    }

    private void testFont(Graphics g) {
        int w2;
        this.first = false;
        FontMetrics fm = g.getFontMetrics(Aladin.COURIER);
        int w1 = fm.stringWidth("ceci est un test");
        if (w1 != (w2 = fm.stringWidth("wwwwwwwwwwwwwwww"))) {
            Aladin.COURIER = new Font("Monospaced", 0, Aladin.SIZE);
            Aladin.BCOURIER = new Font("Monospaced", 1, Aladin.SIZE);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        String s;
        int margeY;
        int margeX;
        block21: {
            if (this.first) {
                this.testFont(g);
            }
            super.paintComponent(g);
            g.setFont(this.font);
            this.aladin.setAliasing(g, 1);
            if (this.fm == null) {
                this.fm = g.getFontMetrics();
            }
            if (this.text == null) {
                return;
            }
            this.ws = this.getSize().width;
            this.hs = this.getSize().height;
            if (this.owidth != this.ws || this.oheight != this.hs) {
                this.resetLink();
                this.owidth = this.ws;
                this.oheight = this.hs;
            }
            g.setColor(BGD);
            g.fillRect(2, 2, this.ws - 3, this.hs - 3);
            Util.drawEdge(g, this.ws, this.hs);
            margeX = (this.ws - 600) / 2;
            if (margeX < 0) {
                margeX = 0;
            }
            margeY = this.hs > 500 ? 20 : 0;
            boolean flagBanner = this.center;
            if (flagBanner) {
                try {
                    double sx2;
                    double sy2;
                    boolean vertical;
                    Image img = this.aladin.getImagette("Background.jpg");
                    this.aladin.waitImage(img);
                    int wi = img.getWidth(this);
                    int hi = img.getHeight(this);
                    boolean bl = vertical = Math.abs(1.0 - (double)hi / (double)this.hs) < Math.abs(1.0 - (double)wi / (double)this.ws);
                    if (vertical) {
                        sy2 = hi;
                        sx2 = (double)this.ws * ((double)hi / (double)this.hs);
                    } else {
                        sx2 = wi;
                        sy2 = (double)this.hs * ((double)wi / (double)this.ws);
                    }
                    g.drawImage(img, 1, 1, this.ws - 2, this.hs - 2, 0, 0, (int)sx2, (int)sy2, this);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block21;
                    e.printStackTrace();
                }
            }
        }
        StringTokenizer st = new StringTokenizer(this.text, "\n");
        int x = 10;
        int y = 0;
        boolean beta = Aladin.BETA;
        boolean proto = Aladin.PROTO;
        proto = false;
        beta = false;
        if (this.center) {
            while (st.hasMoreElements()) {
                s = (String)st.nextElement();
                if (s.startsWith("BETA:")) {
                    if (!beta) continue;
                    s = s.substring("BETA:".length());
                }
                if (s.startsWith("PROTO:")) {
                    if (!proto) continue;
                    s = s.substring("PROTO:".length());
                }
                y = this.getTextHeight(g, s, x - 2, y - 2);
            }
            y = this.getHeight() / 2 - y / 2;
            if (y < 15) {
                y = 15;
            }
        } else {
            y = 15;
        }
        st = new StringTokenizer(this.text, "\n");
        x = 10;
        g.setColor(new Color(200, 200, 200));
        while (st.hasMoreElements()) {
            s = (String)st.nextElement();
            if (s.startsWith("BETA:")) {
                if (!beta) continue;
                s = s.substring("BETA:".length());
            }
            if (s.startsWith("PROTO:")) {
                if (!proto) continue;
                s = s.substring("PROTO:".length());
            }
            y = this.drawString(g, s, margeX + x - 2, margeY + y - 2) - margeY;
        }
        if (this.hasStack() > 0) {
            this.drawWord(g, "Back", this.ws - margeX - 40, margeY + 15, true, 0);
        }
        if (this.hasStack() > 1) {
            this.drawWord(g, "Home", this.ws - margeX - 80, margeY + 15, true, 0);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    static {
        FTITRE = FG = Aladin.BJOLI;
        dy = -1;
    }
}

