/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.HealpixKey;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGRgb;
import cds.aladin.PlanImage;
import cds.allsky.BuilderRgb;
import cds.allsky.TabRgb;
import cds.fits.Fits;
import cds.tools.Util;
import java.awt.image.IndexColorModel;

public class HealpixKeyRgb
extends HealpixKey {
    protected HealpixKey[] cmp;
    private int missing;

    protected HealpixKeyRgb(PlanBGRgb planBG, int order, long npix) {
        super(planBG, order, npix, 0);
        this.fromNet = false;
        this.missing = planBG.tabRgb.getMissing();
        this.cmp = new HealpixKey[3];
        for (int c = 0; c < 3; ++c) {
            if (c == this.missing) continue;
            PlanBG p = c == 0 ? planBG.red : (c == 1 ? planBG.green : planBG.blue);
            this.cmp[c] = p.getHealpix(order, npix, true);
        }
    }

    protected HealpixKeyRgb(HealpixKeyRgb father, int child) {
        super(father, child);
    }

    @Override
    protected int getStatus() {
        return 6;
    }

    @Override
    protected boolean shouldBeCached() {
        return false;
    }

    @Override
    protected void loadNow() throws Exception {
        Aladin.makeCursor(Aladin.aladin, 1);
        if (this.anc != null) {
            this.anc.loadNow();
            return;
        }
        for (int c = 0; c < 3; ++c) {
            if (c == this.missing) continue;
            this.cmp[c].loadNow();
            if (this.width != 0) continue;
            this.height = this.width = this.cmp[c].width;
        }
        Aladin.makeCursor(Aladin.aladin, 0);
    }

    @Override
    protected int[] getPixelFromAncetreRGB() throws Exception {
        if (this.anc.rgb == null) {
            this.anc.rgb = this.anc.getPixelRgb();
        }
        return super.getPixelFromAncetreRGB();
    }

    @Override
    protected int[] getPixelRgb() {
        if (this.rgb == null) {
            this.createRGB();
        }
        return this.rgb;
    }

    protected void createRGB() {
        Fits[] fits = new Fits[3];
        double[] pixelMin = new double[3];
        double[] pixelMax = new double[3];
        byte[][] tcm = new byte[3][];
        double luptonQ = 20.0;
        double[] luptonM = new double[3];
        double[] luptonS = new double[3];
        TabRgb t = ((PlanBGRgb)this.planBG).tabRgb;
        int mode = t.getRGBMethod();
        int format = t.getFormat();
        boolean flagGauss = t.getGauss() && this.order == this.planBG.maxOrder;
        try {
            for (int c = 0; c < 3; ++c) {
                if (c == this.missing) continue;
                HealpixKey a = this.cmp[c];
                if (a == null) {
                    throw new Exception("Composante " + c + " pour " + this.order + "/" + this.npix + " est nulle !!");
                }
                fits[c] = new Fits(a.width, a.width, a.planBG.bitpix);
                fits[c].bscale = a.planBG.bScale;
                fits[c].bzero = a.planBG.bZero;
                fits[c].blank = a.planBG.blank;
                if (a.pixelsOrigin == null) {
                    a.loadPixelsOrigin(2);
                }
                if (a.pixelsOrigin == null) {
                    throw new Exception("Composante " + c + " pour " + this.order + "/" + this.npix + " n'a pas (encore) les pixelsOriginaux !!");
                }
                fits[c].pixels = a.pixelsOrigin;
                if (mode == 0) {
                    pixelMin[c] = t.getCutMin(c);
                    pixelMax[c] = t.getCutMax(c);
                    IndexColorModel cm = null;
                    if (t.hasManual()) {
                        double pixelMiddle = t.getCutMiddle(c);
                        int indexMiddle = (int)(256.0 * (pixelMiddle - pixelMin[c]) / (pixelMax[c] - pixelMin[c]));
                        int transfertFct = PlanImage.getTransfertFct(t.getTransfertFct(c));
                        cm = CanvasColorMap.getCM(0, indexMiddle, 255, false, 0, transfertFct, true);
                    } else {
                        cm = (IndexColorModel)a.planBG.getCM();
                    }
                    tcm[c] = Util.getTableCM(cm, 2);
                    continue;
                }
                luptonQ = t.getLuptonQ();
                luptonM[c] = t.getLuptonM(c);
                luptonS[c] = t.getLuptonS(c);
            }
            Fits out = null;
            out = mode == 0 ? BuilderRgb.createLeaveRGBClassic(fits, this.width, format, flagGauss, this.missing, pixelMin, pixelMax, tcm) : BuilderRgb.createLeaveRGBLupton(fits, this.width, format, flagGauss, this.missing, luptonQ, luptonM, luptonS);
            this.rgb = out.rgb;
            int[] line = new int[this.width];
            for (int y = 0; y < this.height / 2; ++y) {
                System.arraycopy(this.rgb, y * this.width, line, 0, this.width);
                System.arraycopy(this.rgb, (this.height - y - 1) * this.width, this.rgb, y * this.width, this.width);
                System.arraycopy(line, 0, this.rgb, (this.height - y - 1) * this.width, this.width);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

