/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.HealpixKeyCat;
import cds.aladin.Legende;
import cds.aladin.MyByteArrayStream;
import cds.aladin.Obj;
import cds.aladin.PlanBG;
import cds.aladin.Source;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import cds.xml.Field;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HealpixKeyProgen
extends HealpixKeyCat {
    private static String STC = "POLYGON J2000 ";

    protected HealpixKeyProgen(PlanBG planBG) {
        super(planBG);
    }

    protected HealpixKeyProgen(PlanBG planBG, int order, long npix) {
        super(planBG, order, npix);
    }

    @Override
    protected InputStream getInputStreamFromStream() throws Exception {
        try {
            return this.json2TSV(this.stream);
        }
        catch (Exception e) {
            Aladin cfr_ignored_0 = this.planBG.aladin;
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    private InputStream json2TSV(byte[] stream) throws Exception {
        String s;
        Legende leg = this.planBG.getFirstLegende();
        MyByteArrayStream out = new MyByteArrayStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(stream)));
        boolean first = true;
        while ((s = reader.readLine()) != null) {
            String s1;
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
                s1 = this.addLeg(leg);
                out.write(s1);
            }
            s1 = this.parseJson(s, leg);
            out.write(s1);
        }
        reader.close();
        InputStream in = out.getInputStream();
        out.close();
        return in;
    }

    private String addLeg(Legende leg) {
        StringBuilder res = new StringBuilder(1000);
        for (int i = 0; i < leg.field.length; ++i) {
            if (res.length() > 0) {
                res.append('\t');
            }
            res.append(leg.field[i].name);
        }
        res.append('\n');
        return res.toString();
    }

    private String parseJson(String json, Legende leg) throws Exception {
        double[] coo = null;
        Field[] field = leg.field;
        ArrayList<String> jsonVal = this.getJsonVal(json);
        String[] jsonKey = new String[jsonVal.size()];
        this.getJsonLeg(json).toArray(jsonKey);
        StringBuilder res = new StringBuilder(1000);
        for (int i = 0; i < field.length; ++i) {
            String s;
            String pattern = field[i].hpxFinderPattern;
            if (pattern == null) {
                s = jsonVal.get(i);
            } else {
                String[] nv = new String[3];
                int offset = 0;
                StringBuilder s1 = new StringBuilder(20);
                while ((offset = this.getSimplePattern(nv, pattern, offset)) != -1) {
                    String prefix = nv[0];
                    String nom = nv[1];
                    String regex = nv[2];
                    if (prefix != null) {
                        s1.append(prefix);
                    }
                    if (nom == null) continue;
                    int indJson = Util.indexInArrayOf(nom, jsonKey);
                    if (indJson == -1) {
                        if (nom.equals("_RAJ2000") || nom.equals("ra")) {
                            if (coo == null) {
                                coo = this.getJsonCenter(json);
                            }
                            s1.append(coo[0] + "");
                            break;
                        }
                        if (!nom.equals("_DEJ2000") && !nom.equals("dec")) break;
                        if (coo == null) {
                            coo = this.getJsonCenter(json);
                        }
                        s1.append(coo[1] + "");
                        break;
                    }
                    s = jsonVal.get(indJson);
                    if (regex == null) {
                        s1.append(s);
                        continue;
                    }
                    Matcher m = null;
                    try {
                        Pattern p = Pattern.compile(regex);
                        m = p.matcher(s);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (m.matches()) {
                        int n = m.groupCount();
                        for (int j = 1; j <= n; ++j) {
                            String s2 = m.group(j);
                            s1.append(s2);
                        }
                        continue;
                    }
                    s1.append("**Regexp_error**");
                }
                s = s1.toString();
            }
            if (res.length() > 0) {
                res.append('\t');
            }
            res.append(s);
        }
        res.append('\n');
        return res.toString();
    }

    private int getSimplePattern(String[] nv, String s, int offset) {
        int mode = 0;
        int debDeb = offset;
        int deb = offset;
        int nb = 0;
        int len = s.length();
        nv[2] = null;
        nv[1] = null;
        nv[0] = null;
        if (offset >= len) {
            return -1;
        }
        while (offset < len) {
            char ch = s.charAt(offset);
            switch (mode) {
                case 0: {
                    if (ch != '$' || s.charAt(offset + 1) != '[') break;
                    if (offset > deb) {
                        nv[0] = s.substring(deb, offset);
                    }
                    mode = 1;
                    deb = ++offset + 1;
                    break;
                }
                case 1: {
                    if (ch == ']') {
                        nv[1] = s.substring(deb, offset);
                        return offset + 1;
                    }
                    if (ch != ':') break;
                    mode = 2;
                    nb = 0;
                    nv[1] = s.substring(deb, offset);
                    deb = offset + 1;
                    break;
                }
                case 2: {
                    if (nb == 0 && ch == ']') {
                        nv[2] = s.substring(deb, offset);
                        return offset + 1;
                    }
                    if (ch == '[' && s.charAt(offset - 1) != '\\') {
                        ++nb;
                        break;
                    }
                    if (nb <= 0 || ch != ']' || s.charAt(offset - 1) == '\\') break;
                    --nb;
                }
            }
            ++offset;
        }
        if (deb >= 0) {
            nv[0] = s.substring(debDeb, offset);
            nv[2] = null;
            nv[1] = null;
        }
        return offset;
    }

    private ArrayList<String> getJsonLeg(String s) {
        return this.getJson(s, 0);
    }

    private ArrayList<String> getJsonVal(String s) {
        return this.getJson(s, 1);
    }

    private ArrayList<String> getJson(String s, int mode) {
        ArrayList<String> res = new ArrayList<String>(5);
        char[] a = s.toCharArray();
        int m = 0;
        int start = 0;
        int crochet = 0;
        boolean backslash = false;
        char quote = '\u0000';
        for (int i = 0; i < a.length; ++i) {
            char c = a[i];
            switch (m) {
                case 0: {
                    if (!(c == '\"' | c == '\'')) break;
                    m = 1;
                    quote = c;
                    start = i;
                    break;
                }
                case 1: {
                    if (c != quote || backslash) break;
                    if (mode == 0) {
                        res.add(Tok.unQuote(s.substring(start, i + 1)));
                    }
                    m = 2;
                    break;
                }
                case 2: {
                    if (c != ':') break;
                    m = 3;
                    break;
                }
                case 3: {
                    if (c == '[') {
                        m = 4;
                        start = i;
                        break;
                    }
                    if (Character.isSpace(c)) break;
                    start = i;
                    if (c == '\"' || c == '\'') {
                        m = 5;
                        quote = c;
                        break;
                    }
                    m = 6;
                    break;
                }
                case 4: {
                    if (c == '[' && !backslash) {
                        ++crochet;
                        break;
                    }
                    if (c != ']' || backslash || --crochet != 0) break;
                    if (mode == 1) {
                        res.add(s.substring(start, i + 1));
                    }
                    m = 0;
                    break;
                }
                case 5: {
                    if (c != quote || backslash) break;
                    if (mode == 1) {
                        res.add(Tok.unQuote(s.substring(start, i + 1)));
                    }
                    m = 0;
                    break;
                }
                case 6: {
                    if (!Character.isSpace(c) && c != '}') break;
                    if (mode == 1) {
                        res.add(s.substring(start, i));
                    }
                    m = 0;
                }
            }
            backslash = c == '\\';
        }
        return res;
    }

    private double[] getJsonCenter(String s) throws Exception {
        int quote = 34;
        int i = s.indexOf(STC);
        int j = s.indexOf(quote, i);
        if (j == -1) {
            quote = 39;
            j = s.indexOf(quote, i);
        }
        String listCoo = s.substring(i + STC.length(), j);
        StringTokenizer st = new StringTokenizer(listCoo);
        double[] coo = new double[2];
        int n = 0;
        while (st.hasMoreTokens()) {
            double ra = Double.parseDouble(st.nextToken());
            double de = Double.parseDouble(st.nextToken());
            coo[0] = coo[0] + ra;
            coo[1] = coo[1] + de;
            ++n;
        }
        coo[0] = coo[0] / (double)n;
        coo[1] = coo[1] / (double)n;
        return coo;
    }

    @Override
    protected boolean isLast() {
        return false;
    }

    @Override
    protected boolean isReallyLast(ViewSimple v) {
        return false;
    }

    protected int draw(TreeMap<String, Source> progen) {
        int nb = 0;
        if (this.pcat == null || !this.pcat.hasObj()) {
            return 0;
        }
        Iterator<Obj> it = this.pcat.iterator();
        while (it.hasNext()) {
            Source src = (Source)it.next();
            String id = src.id + src.raj + src.dej;
            if (progen.get(id) != null) continue;
            progen.put(id, src);
            ++nb;
        }
        this.resetTimer();
        return nb;
    }
}

