/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Comparator;

public class GluApp
implements Comparator {
    public static String JAVAPATH = "java";
    public static String JAVAWS = "javaws";
    private Aladin aladin;
    String ordre = "Y";
    public String tagGlu;
    public String aladinLabel;
    public String description;
    public String verboseDescr;
    public String institute;
    public String releaseNumber;
    public String nextNumber;
    public String copyright;
    public String docUrl;
    public String jarUrl;
    public String javaParam;
    public String downloadUrl;
    public String wsUrl;
    public String appletUrl;
    public String activated;
    public String system;
    public String dir;
    protected long downloading;
    protected boolean interrupt;
    private int type;
    static final int JAVA = 1;
    static final int PLASTIC = 2;
    protected static final int JAR = 1;
    protected static final int DOWNLOAD = 2;
    protected static final int WEBSTART = 3;
    protected static final int APPLET = 4;

    public GluApp(Aladin aladin, String tagGlu, String aladinLabel, String aladinMenuNumber, String description, String verboseDescription, String institute, String releaseNumber, String copyright, String docUser, String jar, String javaParam, String dir, String download, String webstart, String applet, String aladinActivated, String system, int type) {
        this.aladin = aladin;
        this.tagGlu = tagGlu;
        this.aladinLabel = aladinLabel;
        this.ordre = aladinMenuNumber;
        this.description = description;
        this.verboseDescr = verboseDescription;
        this.institute = institute;
        this.releaseNumber = releaseNumber;
        this.copyright = copyright;
        this.docUrl = docUser;
        this.jarUrl = jar;
        this.javaParam = javaParam;
        this.downloadUrl = download;
        this.wsUrl = webstart;
        this.appletUrl = applet;
        this.dir = dir;
        this.type = type;
        this.system = system;
        this.activated = aladinActivated;
        this.downloading = -1L;
    }

    public GluApp(Aladin aladin, String tagGlu) {
        this.aladin = aladin;
        this.tagGlu = tagGlu;
        this.downloading = -1L;
    }

    protected void merge(String aladinLabel, String aladinMenuNumber, String description, String verboseDescr, String institute, String releaseNumber, String copyright, String docUser, String jar, String javaParam, String download, String webstart, String applet, String aladinActivated, int type) {
        this.tagGlu = this.tagGlu;
        this.aladinLabel = aladinLabel;
        this.ordre = aladinMenuNumber;
        this.description = description;
        this.verboseDescr = verboseDescr;
        this.institute = institute;
        if (!this.releaseNumber.equals(releaseNumber)) {
            this.nextNumber = releaseNumber;
        }
        this.copyright = copyright;
        this.docUrl = docUser;
        this.jarUrl = jar;
        this.javaParam = javaParam;
        this.downloadUrl = download;
        this.wsUrl = webstart;
        this.appletUrl = applet;
        this.activated = this.activated == null ? aladinActivated : this.activated;
        this.type = type;
    }

    protected int getInstallMode() {
        if (this.wsUrl != null) {
            return 3;
        }
        if (this.appletUrl != null) {
            return 4;
        }
        if (this.jarUrl != null) {
            return 1;
        }
        if (this.downloadUrl != null) {
            return 2;
        }
        return 0;
    }

    protected boolean canBeInstall() {
        int mode = this.getInstallMode();
        return mode != 0 && mode != 3 && mode != 4;
    }

    protected boolean isDownloading() {
        return this.downloading != -1L;
    }

    protected boolean canBeRun() {
        int mode = this.getInstallMode();
        if (mode == 3 || mode == 4) {
            return true;
        }
        if (this.isDownloading()) {
            return false;
        }
        return this.dir != null || this.system != null;
    }

    protected boolean canBeMenu() {
        if (!this.canBeRun()) {
            return false;
        }
        return this.isActivated();
    }

    protected boolean isActivated() {
        return this.activated != null && !this.activated.equals("No");
    }

    protected boolean hasNewRelease() {
        return this.nextNumber != null;
    }

    protected static String glu(String key, String value) {
        if (value == null || value.trim().startsWith("--")) {
            return "";
        }
        return "%" + Util.align(key, 20) + value + Util.CR;
    }

    protected String getGluDic() {
        StringBuffer s = new StringBuffer();
        s.append(GluApp.glu("ActionName", this.tagGlu));
        s.append(GluApp.glu("DistribDomain", "ALADIN"));
        s.append(GluApp.glu("Owner", "CDS'aladin"));
        s.append(GluApp.glu("Description", this.description));
        s.append(GluApp.glu("VerboseDescr", this.verboseDescr));
        s.append(GluApp.glu("Institute", this.institute));
        s.append(GluApp.glu("ReleaseNumber", this.releaseNumber));
        s.append(GluApp.glu("NextNumber", this.nextNumber));
        s.append(GluApp.glu("Copyright", this.copyright));
        s.append(GluApp.glu("Doc.User", this.docUrl));
        s.append(GluApp.glu("Jar", this.jarUrl));
        s.append(GluApp.glu("Webstart", this.wsUrl));
        s.append(GluApp.glu("Applet", this.appletUrl));
        s.append(GluApp.glu("Download", this.downloadUrl));
        s.append(GluApp.glu("JavaParam", this.javaParam));
        s.append(GluApp.glu("Aladin.VOLabel", this.aladinLabel));
        s.append(GluApp.glu("Aladin.Activated", this.activated));
        s.append(GluApp.glu("Dir", this.dir));
        s.append(GluApp.glu("System", this.system));
        s.append(Util.CR);
        return s.toString();
    }

    protected String getCommand() {
        if (this.getInstallMode() == 3) {
            return JAVAWS + " " + this.wsUrl;
        }
        if (this.dir == null) {
            return null;
        }
        if (this.system != null) {
            return this.system;
        }
        return this.getJavaCommand();
    }

    protected String getJavaCommand() {
        if (this.javaParam != null) {
            return JAVAPATH + " " + this.javaParam;
        }
        return null;
    }

    protected boolean hasDedicatedCommand() {
        return this.system != null;
    }

    protected boolean hasDedicatedDir() {
        return this.dir != null && !this.dir.equals(this.aladin.getVOPath());
    }

    protected String getDir() {
        int mode = this.getInstallMode();
        if (mode == 4 || mode == 3) {
            return null;
        }
        return this.dir;
    }

    protected boolean exec() {
        this.aladin.log("VOToolExec", this.tagGlu);
        if (this.getInstallMode() == 4) {
            return this.execApplet();
        }
        final String dir = this.getDir();
        Aladin.trace(1, "Exec: " + (dir != null ? "cd " + dir + ";" : "") + this.getCommand());
        try {
            new Thread(this.tagGlu){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(GluApp.this.getCommand(), null, dir == null ? null : new File(dir));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean execApplet() {
        this.aladin.glu.showDocument("Http", this.appletUrl, true);
        return true;
    }

    protected String getJarName() {
        try {
            return this.jarUrl.substring(this.jarUrl.lastIndexOf(47));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int install() {
        this.aladin.log("VOToolInstall", this.tagGlu);
        switch (this.getInstallMode()) {
            case 1: {
                this.installJar();
                return -3;
            }
            case 2: {
                this.aladin.glu.showDocument("Http", this.downloadUrl, true);
                return -1;
            }
        }
        return -2;
    }

    protected void interrupt() {
        this.interrupt = true;
    }

    synchronized void setDownloading(long n) {
        this.downloading = n;
    }

    protected boolean installJar() {
        this.setDownloading(0L);
        this.interrupt = false;
        new Thread("Install"){

            @Override
            public void run() {
                try {
                    int n;
                    URL u = new URL(GluApp.this.jarUrl);
                    InputStream inp = u.openStream();
                    if (inp == null) {
                        throw new Exception();
                    }
                    DataInputStream in = new DataInputStream(inp);
                    if (in == null) {
                        throw new Exception();
                    }
                    String file = GluApp.this.aladin.getVOPath() + Util.FS + GluApp.this.getJarName();
                    String tmp = file + ".tmp";
                    File g = new File(tmp);
                    g.delete();
                    RandomAccessFile out = new RandomAccessFile(tmp, "rw");
                    byte[] buf = new byte[512];
                    while (!GluApp.this.interrupt && in.available() == 0) {
                        Util.pause(100);
                    }
                    while (!GluApp.this.interrupt && (n = in.read(buf)) > 0) {
                        out.write(buf, 0, n);
                        GluApp.this.setDownloading(GluApp.this.downloading + (long)n);
                    }
                    in.close();
                    out.close();
                    if (GluApp.this.interrupt) {
                        g.delete();
                        GluApp.this.setDownloading(-1L);
                    } else {
                        File f = new File(file);
                        f.delete();
                        g.renameTo(f);
                        GluApp.this.dir = GluApp.this.aladin.getVOPath();
                        if (GluApp.this.nextNumber != null) {
                            GluApp.this.releaseNumber = GluApp.this.nextNumber;
                        }
                        GluApp.this.nextNumber = null;
                    }
                }
                catch (Exception e) {
                    GluApp.this.aladin;
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    GluApp.this.aladin;
                    Aladin.error("Installation error");
                }
                GluApp.this.setDownloading(-1L);
                ((GluApp)GluApp.this).aladin.frameVOTool.downloadEnd();
            }
        }.start();
        return true;
    }

    public GluApp() {
    }

    protected static Comparator getComparator() {
        return new GluApp();
    }

    public int compare(Object o1, Object o2) {
        GluApp a1 = (GluApp)o1;
        GluApp a2 = (GluApp)o2;
        if (a1.ordre == a2.ordre) {
            return 0;
        }
        if (a1.ordre == null) {
            return -1;
        }
        if (a2.ordre == null) {
            return 1;
        }
        return a1.ordre.compareTo(a2.ordre);
    }
}

