/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMocGenImg;
import cds.aladin.Plan;
import cds.aladin.prop.PropPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FrameTMocGenCat
extends FrameMocGenImg {
    private JTextField duration;
    private JCheckBox boxDuration;

    protected FrameTMocGenCat(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.INFO = Aladin.chaine.getString("TMOCGENCATINFO");
    }

    @Override
    protected boolean isPlanOk(Plan p) {
        return p.isCatalogTime();
    }

    @Override
    protected JComboBox getComboRes() {
        return FrameTMocGenCat.makeComboTimeRes();
    }

    @Override
    protected void addSpecifPanel(JPanel p, GridBagConstraints c, GridBagLayout g) {
        JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
        ButtonGroup bg = new ButtonGroup();
        JCheckBox box = new JCheckBox();
        bg.add(box);
        box.setSelected(true);
        PropPanel.addCouple(frame, p, " - No duration", "Only the epoch is used to populate the temporal MOC", box, g, c);
        JPanel p2 = new JPanel(new BorderLayout(0, 0));
        this.duration = new JTextField("3", 5);
        box = this.boxDuration = new JCheckBox();
        bg.add(box);
        p2.add((Component)box, "West");
        p2.add((Component)this.duration, "Center");
        p2.add((Component)new JLabel(" in secondes"), "East");
        PropPanel.addCouple(frame, p, " - Duration from starting time:", "Duration of the event", p2, g, c);
    }

    private double getDuration() throws Exception {
        double x = 0.0;
        try {
            String s = this.duration.getText().trim();
            if (s.length() > 0) {
                x = Double.parseDouble(s);
            }
        }
        catch (Exception e) {
            this.duration.setForeground(Color.red);
            throw e;
        }
        this.duration.setForeground(Color.black);
        return x;
    }

    @Override
    protected void submit() {
        try {
            Plan[] ps = new Plan[]{this.getPlan(this.ch[0])};
            int order = this.getOrder();
            double duration = this.boxDuration.isSelected() ? this.getDuration() : 0.0;
            String param = "";
            if (duration > 0.0) {
                param = " -duration=" + duration;
            }
            this.a.console.printCommand("cmoc -time -order=" + order + param + " " + FrameTMocGenCat.labelList(ps));
            this.a.calque.newPlanTMoc(ps[0].label + " TMOC", ps, order, duration);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("TMOC generation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

