/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.GrabItFrame;
import cds.aladin.GrabUtil;
import cds.aladin.Server;
import cds.aladin.ServerGlu;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class FrameSimple
extends JFrame
implements ActionListener,
GrabItFrame {
    private static final long serialVersionUID = 3541428440636805284L;
    Aladin aladin;
    Server server;
    JPanel buttonsPanel;
    protected String CLOSE;
    protected String TIPSUBMIT;
    protected String TIPCLOSE;

    protected FrameSimple() {
    }

    protected void createChaine() {
        this.CLOSE = Aladin.chaine.getString("CLOSE");
        this.TIPSUBMIT = Aladin.chaine.getString("TIPSUBMIT");
        this.TIPCLOSE = Aladin.chaine.getString("TIPCLOSE");
    }

    protected FrameSimple(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.setFont(Aladin.PLAIN);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameSimple.this.processAnyClosingActions();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameSimple.this.processAnyClosingActions();
            }
        }, KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(520, 450);
    }

    protected void show(JComponent panel, String title) {
        if (!(panel == null || panel.getRootPane() != null && panel.getParent().equals(this.getContentPane()))) {
            this.setTitle(title);
            this.server = null;
            this.getContentPane().removeAll();
            this.getContentPane().add((Component)panel, "Center");
            this.getContentPane().revalidate();
            this.getContentPane().repaint();
            this.getRootPane().setBorder(BorderFactory.createLineBorder(Color.gray));
            this.getRootPane().getInsets().set(2, 2, 0, 2);
            this.pack();
        }
        this.setVisible(true);
    }

    protected void show(Server server, String title) {
        this.setTitle(title);
        if (server != null && server != this.server) {
            this.setTitle(title);
            if (this.server == null) {
                this.aladin.grabUtilInstance.grabItServers.add(server);
            } else {
                this.aladin.grabUtilInstance.removeAndAdd(this.server, server);
            }
            this.server = server;
            this.createServerFrame();
            this.server.updateWidgets(this);
            this.pack();
        }
        this.setVisible(true);
    }

    public void createServerFrame() {
        this.getContentPane().removeAll();
        this.getContentPane().setBackground(Aladin.COLOR_MAINPANEL_BACKGROUND);
        this.getContentPane().add((Component)this.server, "Center");
        this.buttonsPanel = new JPanel(new FlowLayout(1));
        JButton button = new JButton("Reset");
        button.addActionListener(this);
        button.setActionCommand("RESET");
        this.buttonsPanel.add(button);
        button = new JButton("Clear");
        button.addActionListener(this);
        button.setActionCommand("CLEAR");
        this.buttonsPanel.add(button);
        button = new JButton("Submit");
        button.addActionListener(this);
        button.setActionCommand("SUBMIT");
        button.setToolTipText(this.TIPSUBMIT);
        this.buttonsPanel.add(button);
        button = new JButton(this.CLOSE);
        button.addActionListener(this);
        button.setActionCommand(this.CLOSE);
        button.setToolTipText(this.TIPCLOSE);
        this.buttonsPanel.add(button);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        try {
            this.getContentPane().revalidate();
        }
        catch (Throwable e) {
            this.pack();
        }
        this.getContentPane().repaint();
        this.getRootPane().setBorder(BorderFactory.createLineBorder(Color.gray));
        this.getRootPane().getInsets().set(2, 2, 0, 2);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (this.server != null) {
            if (command.equals("SUBMIT")) {
                this.server.submit();
            } else if (command.equals("RESET")) {
                this.server.reset();
            } else if (command.equals("CLEAR")) {
                this.server.clear();
            }
        }
        if (command.equals(this.CLOSE)) {
            this.processAnyClosingActions();
        }
    }

    @Override
    public void setGrabItCoord(Coord c) {
        GrabUtil.setGrabItCoord(this.aladin, this.server, c);
    }

    @Override
    public void stopGrabIt() {
        GrabUtil.stopGrabIt(this.aladin, this, this.server);
    }

    @Override
    public boolean isGrabIt() {
        return this.server.modeCoo != 0 && this.server.grab != null && this.server.grab.getModel().isSelected();
    }

    @Override
    public void setGrabItRadius(double x1, double y1, double x2, double y2) {
        GrabUtil.setGrabItRadius(this.aladin, this.server, x1, y1, x2, y2);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.processAnyClosingActions();
        }
        super.processWindowEvent(e);
    }

    protected void processAnyClosingActions() {
        try {
            if (this.server != null && this.server instanceof ServerGlu) {
                ((ServerGlu)this.server).cleanUpFOV();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
    }
}

