/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameMocGenImg;
import cds.aladin.Plan;
import cds.aladin.Server;
import cds.aladin.prop.PropPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FrameSTMocGenCat
extends FrameMocGenImg {
    private JTextField radius;
    private JCheckBox boxRad;
    private JCheckBox boxFov;
    JComboBox mocTimeOrder;
    private JTextField duration;
    private JCheckBox boxDuration;

    protected FrameSTMocGenCat(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.INFO = Aladin.chaine.getString("STMOCGENCATINFO");
    }

    @Override
    protected boolean isPlanOk(Plan p) {
        return p.isCatalogTime();
    }

    protected JComboBox getComboTimeRes() {
        return FrameSTMocGenCat.makeComboTimeRes();
    }

    @Override
    protected void addSpecifPanel(JPanel p, GridBagConstraints c, GridBagLayout g) {
        JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
        PropPanel.addFilet(p, g, c);
        PropPanel.addSectionTitle(p, "Temporal parameters", g, c);
        ButtonGroup bg = new ButtonGroup();
        JCheckBox box = new JCheckBox();
        bg.add(box);
        box.setSelected(true);
        PropPanel.addCouple(frame, p, " - No duration", "Only the epoch is used to populate the temporal MOC", box, g, c);
        JPanel p2 = new JPanel(new BorderLayout(0, 0));
        this.duration = new JTextField("3", 5);
        box = this.boxDuration = new JCheckBox();
        bg.add(box);
        p2.add((Component)box, "West");
        p2.add((Component)this.duration, "Center");
        p2.add((Component)new JLabel(" in secondes"), "East");
        PropPanel.addCouple(frame, p, " - Duration from starting time:", "Duration of the event", p2, g, c);
        c.gridwidth = 0;
        JPanel pp = new JPanel();
        pp.add(new JLabel("Time resolution :"));
        this.mocTimeOrder = this.getComboTimeRes();
        pp.add(this.mocTimeOrder);
        g.setConstraints(pp, c);
        p.add(pp);
        PropPanel.addFilet(p, g, c);
        PropPanel.addSectionTitle(p, "Spacial parameters", g, c);
        bg = new ButtonGroup();
        box = new JCheckBox();
        bg.add(box);
        box.setSelected(true);
        PropPanel.addCouple(frame, p, " - Only the central position:", "Only the source position (lon,lat) is used to populate the MOC", box, g, c);
        p2 = new JPanel(new BorderLayout(0, 0));
        this.radius = new JTextField("3", 5);
        box = this.boxRad = new JCheckBox();
        bg.add(box);
        p2.add((Component)box, "West");
        p2.add((Component)this.radius, "Center");
        p2.add((Component)new JLabel(" in arcsec"), "East");
        PropPanel.addCouple(frame, p, " -Radius around position:", "A circle of the disgnated radius centered on each source is used to populate the MOC", p2, g, c);
        box = this.boxFov = new JCheckBox();
        bg.add(box);
        PropPanel.addCouple(frame, p, " - FoV associated to each source:", "The Field of View (for instance s_region information) associated to each source is used to populate the MOC.", box, g, c);
    }

    private double getDuration() throws Exception {
        double x = 0.0;
        try {
            String s = this.duration.getText().trim();
            if (s.length() > 0) {
                x = Double.parseDouble(s);
            }
        }
        catch (Exception e) {
            this.duration.setForeground(Color.red);
            throw e;
        }
        this.duration.setForeground(Color.black);
        return x;
    }

    protected int getTimeOrder() {
        return this.mocTimeOrder.getSelectedIndex() + 3;
    }

    private double getRadius() throws Exception {
        double x = 0.0;
        try {
            String s = this.radius.getText().trim();
            if (s.length() > 0) {
                x = Server.getAngleInArcmin(s, 16) / 60.0;
            }
        }
        catch (Exception e) {
            this.radius.setForeground(Color.red);
            throw e;
        }
        this.radius.setForeground(Color.black);
        return x;
    }

    @Override
    protected void submit() {
        try {
            double duration;
            StringBuilder param = new StringBuilder();
            Plan[] ps = new Plan[]{this.getPlan(this.ch[0])};
            int spaceOrder = this.getOrder();
            int timeOrder = this.getTimeOrder();
            double d = duration = this.boxDuration.isSelected() ? this.getDuration() : 0.0;
            if (duration > 0.0) {
                param.append(" -duration=" + duration);
            }
            double radius = this.boxRad.isSelected() ? this.getRadius() : 0.0;
            boolean fov = this.boxFov.isSelected();
            if (fov) {
                param.append(" -fov");
            } else if (radius > 0.0) {
                param.append(" -radius=" + Coord.getUnit(radius));
            }
            this.a.console.printCommand("cmoc -spacetime -order=" + spaceOrder + "/" + timeOrder + param + " " + FrameSTMocGenCat.labelList(ps));
            this.a.calque.newPlanSTMoc(ps[0].label + " STMOC", ps, spaceOrder, timeOrder, duration, radius, fov);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("STMOC generation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

