/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import cds.tools.Util;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameRGB
extends FrameRGBBlink {
    String R;
    String G;
    String B;
    String X;
    String TITLE;
    String INFO;
    String HELP1;
    String RED;
    String GREEN;
    String BLUE;
    String LUM;
    String RSAMPREF;
    String SUBSTR;
    private ButtonGroup cbg;
    private JRadioButton cbDiff;
    private JRadioButton cbX;
    protected JComboBox cR;
    protected JComboBox cG;
    protected JComboBox cB;
    protected JComboBox cL;
    private static String[] WAVEBAND = new String[]{"92CM", "100MU", "60MU", "25MU", "12MU", "z", "2MASS J", "IRSA  J", "H", "K", "IR", "i", "N", "red", "ER", "SR", "E", "F", "green", "V", "g", "blue", "O", "J", "u"};
    private static double[] WAVELEN = new double[]{920000.0, 100.0, 60.0, 25.0, 12.0, 1.0, 1.2, 1.6, 2.2, 0.8, 0.8, 0.8, 0.8, 0.6, 0.6, 0.6, 0.6, 0.6, 0.5, 0.5, 0.5, 0.4, 0.4, 0.4, 0.3};
    private Object[] choicePlanSort = null;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.X = Aladin.chaine.getString("IMGBEST");
        this.TITLE = Aladin.chaine.getString("RGBTITLE");
        this.INFO = Aladin.chaine.getString("RGBINFO");
        this.HELP1 = Aladin.chaine.getString("IMGHELP1");
        this.RED = Aladin.chaine.getString("RGBRED");
        this.GREEN = Aladin.chaine.getString("RGBGREEN");
        this.BLUE = Aladin.chaine.getString("RGBBLUE");
        this.LUM = "Luminosity";
        this.RSAMPREF = Aladin.chaine.getString("RGBRSAMPREF");
        this.SUBSTR = Aladin.chaine.getString("RGBSUBSTR");
        this.R = "R";
        this.G = "G";
        this.B = "B";
    }

    protected FrameRGB(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return 11;
    }

    @Override
    protected int getNb() {
        return 3;
    }

    @Override
    protected String getLabelSelector(int i) {
        return i == 0 ? this.RED : (i == 1 ? this.GREEN : (i == 2 ? this.BLUE : this.LUM));
    }

    @Override
    protected Color getColorLabel(int i) {
        return i == 0 ? Color.red : (i == 1 ? Color.green : (i == 2 ? Color.blue : Color.black));
    }

    @Override
    protected JPanel getAddPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        JLabel lx = new JLabel(this.RSAMPREF);
        this.cbg = new ButtonGroup();
        JRadioButton cbR = new JRadioButton(this.R);
        cbR.setActionCommand(this.R);
        this.cbg.add(cbR);
        JRadioButton cbG = new JRadioButton(this.G);
        cbG.setActionCommand(this.G);
        this.cbg.add(cbG);
        JRadioButton cbB = new JRadioButton(this.B);
        cbB.setActionCommand(this.B);
        this.cbg.add(cbB);
        this.cbX = new JRadioButton(this.X);
        this.cbX.setActionCommand(this.X);
        this.cbg.add(this.cbX);
        this.cbX.setSelected(true);
        JPanel pp = new JPanel();
        pp.add(lx);
        pp.add(cbR);
        pp.add(cbG);
        pp.add(cbB);
        pp.add(this.cbX);
        c.gridwidth = 0;
        c.weightx = 10.0;
        g.setConstraints(pp, c);
        p.add(pp);
        this.cbDiff = new JRadioButton(this.SUBSTR);
        this.cbDiff.setEnabled(false);
        c.fill = 0;
        g.setConstraints(this.cbDiff, c);
        p.add(this.cbDiff);
        c.fill = 1;
        return p;
    }

    @Override
    protected void reset() {
        this.cbX.setSelected(true);
        super.reset();
    }

    @Override
    protected void adjustWidgets() {
        this.adjustCbDiff();
    }

    private void adjustCbDiff() {
        boolean newEnabled;
        int i = (this.ch[0].getSelectedIndex() > 0 ? 1 : 0) + (this.ch[1].getSelectedIndex() > 0 ? 1 : 0) + (this.ch[2].getSelectedIndex() > 0 ? 1 : 0);
        boolean enabled = this.cbDiff.isEnabled();
        boolean bl = newEnabled = i == 2;
        if (enabled == newEnabled) {
            return;
        }
        this.cbDiff.setEnabled(newEnabled);
    }

    private double getWaveLen(String info) {
        if (info == null) {
            return Double.MAX_VALUE;
        }
        for (int i = 0; i < WAVEBAND.length; ++i) {
            int offset = -1;
            do {
                if ((offset = Util.indexOfIgnoreCase(info, WAVEBAND[i], offset + 1)) < 0 || offset != 0 && Character.isLetter(info.charAt(offset - 1)) || offset + WAVEBAND[i].length() != info.length() && Character.isLetter(info.charAt(offset + WAVEBAND[i].length()))) continue;
                return WAVELEN[i];
            } while (offset != -1);
        }
        return Double.MAX_VALUE;
    }

    private void sortPlan() {
        Vector<Plan> v = new Vector<Plan>(this.choicePlan.length);
        int n = 0;
        for (int i = 0; i < this.choicePlan.length; ++i) {
            if (!this.choicePlan[i].selected) continue;
            ++n;
        }
        boolean flagAll = n <= 1;
        for (int i = 0; i < this.choicePlan.length && v.size() <= 3; ++i) {
            if (!flagAll && !this.choicePlan[i].selected) continue;
            v.addElement(this.choicePlan[i]);
        }
        this.choicePlanSort = v.toArray();
        Arrays.sort(this.choicePlanSort, new Comparator(){

            public int compare(Object o1, Object o2) {
                double wb2;
                PlanImage p1 = (PlanImage)o1;
                PlanImage p2 = (PlanImage)o2;
                double wb1 = FrameRGB.this.getWaveLen(p1.survey());
                return wb1 == (wb2 = FrameRGB.this.getWaveLen(p2.survey())) ? 0 : (wb1 > wb2 ? -1 : 1);
            }
        });
    }

    @Override
    protected synchronized int[] getChoiceOrder() {
        int n = this.getNb();
        this.sortPlan();
        int[] def = new int[this.choicePlanSort.length];
        for (int i = 0; i < this.choicePlanSort.length; ++i) {
            def[i] = Util.indexInArrayOf(this.choicePlanSort[i], this.choicePlan) + 1;
        }
        this.choicePlanSort = null;
        return def;
    }

    @Override
    public void show() {
        this.cR = this.ch[0];
        this.cG = this.ch[1];
        this.cB = this.ch[2];
        super.show();
    }

    @Override
    protected void submit() {
        boolean diff;
        PlanImage r = (PlanImage)this.getPlan(this.ch[0]);
        PlanImage g = (PlanImage)this.getPlan(this.ch[1]);
        PlanImage b = (PlanImage)this.getPlan(this.ch[2]);
        String s = this.cbg.getSelection().getActionCommand();
        PlanImage ref = s.equals(this.R) ? r : (s.equals(this.B) ? b : (s.equals(this.G) ? g : null));
        boolean bl = diff = this.cbDiff.isEnabled() && this.cbDiff.isSelected();
        if (r != null && g != null && b != null && ref == null) {
            this.a.console.printCommand("RGB " + Tok.quote(r.label) + " " + Tok.quote(g.label) + " " + Tok.quote(b.label));
        }
        this.a.calque.newPlanImageRGB(r, g, b, ref, null, diff);
        this.hide();
    }
}

