/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.MyLabel;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Server;
import cds.aladin.ViewSimple;
import cds.aladin.prop.PropPanel;
import cds.astro.AstroMath;
import cds.astro.Astrocoo;
import cds.astro.ICRS;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FrameNewCalib
extends JFrame
implements ActionListener,
ChangeListener {
    static final int SIMPLE = 0;
    static final int QUADRUPLET = 1;
    static final int WCS = 2;
    static int num = 0;
    String TITLE;
    String SUBMIT;
    String MODIFY;
    String UNDO;
    String REDO;
    String HELP;
    String RESET;
    String CLEAR;
    String CANCEL;
    String ONE;
    String TWO;
    String THREE;
    String HELPSTRING;
    String MYPROJ;
    String ADJUST1;
    String ADJUST2;
    String TRUE;
    String FALSE;
    String CHOOSECAL;
    String LABEL;
    String FRAME;
    String COORD;
    String XY;
    String PIXSIZE;
    String PROJECT;
    String ROT;
    String RASYM;
    String QUADMSG;
    String XYPOS;
    String ERRNOXY;
    String ERRNOBEST;
    String ERRIMG;
    Aladin a;
    Plan plan;
    Projection oldp;
    MyLabel titleFrame;
    JTextField labelT;
    JTextField cooT;
    JTextField xyT;
    JTextField xyS;
    JTextField rotT;
    JTextArea wcsT;
    JComboBox frameChoice = null;
    JComboBox projChoice = null;
    JRadioButton trueSym;
    JRadioButton falseSym;
    ButtonGroup symRadio = null;
    JPanel pSym;
    JButton modifyButton;
    JButton resetButton;
    int maxPosT = 7;
    FrameNewCalibTextField[] xyPosT;
    FrameNewCalibTextField[] cooPosT;
    String label;
    double raj;
    double dej;
    double cx;
    double cy;
    double rm;
    double r;
    double rot;
    boolean sym;
    int t;
    int system;
    JTextField focusTextField = null;
    boolean flagXY = false;
    JPanel panelOne;
    JPanel panelTwo;
    JPanel panelThree;
    JTabbedPane panelMethod;
    private JButton undoButton;
    private JButton redoButton;
    int modeCalib;
    private Stack undo;
    private Stack redo;
    private long oplanHashCode = -1L;
    public static int W = 20;
    private Obj prevObj = null;
    Plan drawPlan = null;

    protected void createChaine() {
        this.TITLE = Aladin.chaine.getString("NCTITLE");
        this.SUBMIT = Aladin.chaine.getString("NCSUBMIT");
        this.MODIFY = Aladin.chaine.getString("NCMODIFY");
        this.UNDO = Aladin.chaine.getString("NCUNDO");
        this.REDO = Aladin.chaine.getString("NCREDO");
        this.HELP = Aladin.chaine.getString("NCHELP");
        this.RESET = Aladin.chaine.getString("NCRESET");
        this.CLEAR = Aladin.chaine.getString("NCCLEAR");
        this.CANCEL = Aladin.chaine.getString("NCCANCEL");
        this.ONE = Aladin.chaine.getString("NCONE");
        this.TWO = Aladin.chaine.getString("NCTWO");
        this.THREE = Aladin.chaine.getString("NCTHREE");
        this.HELPSTRING = Aladin.chaine.getString("NCHELPSTRING");
        this.MYPROJ = Aladin.chaine.getString("NCMYPROJ");
        this.ADJUST1 = Aladin.chaine.getString("NCADJUST1");
        this.ADJUST2 = Aladin.chaine.getString("NCADJUST2");
        this.TRUE = Aladin.chaine.getString("NCTRUE");
        this.FALSE = Aladin.chaine.getString("NCFALSE");
        this.CHOOSECAL = Aladin.chaine.getString("NCCHOOSECAL");
        this.LABEL = Aladin.chaine.getString("NCLABEL");
        this.FRAME = Aladin.chaine.getString("UPFRAMEB");
        this.COORD = Aladin.chaine.getString("NCCOORD");
        this.XY = Aladin.chaine.getString("NCXY");
        this.PIXSIZE = Aladin.chaine.getString("NCPIXSIZE");
        this.PROJECT = Aladin.chaine.getString("NCPROJECT");
        this.ROT = Aladin.chaine.getString("NCROT");
        this.RASYM = Aladin.chaine.getString("NCRASYM");
        this.QUADMSG = Aladin.chaine.getString("NCQUADMSG");
        this.XYPOS = Aladin.chaine.getString("NCXYPOS");
        this.ERRNOXY = Aladin.chaine.getString("NCERRNOXY");
        this.ERRIMG = Aladin.chaine.getString("NCERRIMG");
        this.ERRNOBEST = Aladin.chaine.getString("NCERRNOBEST");
    }

    protected FrameNewCalib(Aladin aladin, Plan p, Projection oldp) {
        this.a = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.TITLE);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.plan = p;
        this.oldp = oldp;
        this.setLocation(Aladin.computeLocation(this));
        this.createPanel();
        this.pack();
        this.majFrameNewCalib(p, oldp);
    }

    protected void majFrameNewCalib(Plan p) {
        this.majFrameNewCalib(p, null);
    }

    protected void majFrameNewCalib(Plan p, Projection oldp) {
        this.plan = p;
        this.oldp = oldp;
        this.modifyButton.setText(oldp == null ? this.SUBMIT : this.MODIFY);
        this.initUndo();
        this.setData();
        this.show();
        this.a.calque.zoom.wenOn();
        this.resumeFlagPlanRecalibrating();
    }

    private void initUndo() {
        this.undo = new Stack();
        this.redo = new Stack();
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    private void setUndo(Projection p) {
        this.redo = new Stack();
        this.undo.push(p.copy());
    }

    private boolean undoable() {
        return !this.undo.empty();
    }

    private boolean redoable() {
        return !this.redo.empty();
    }

    private void undo() throws Exception {
        Projection p = (Projection)this.undo.pop();
        this.redo.push(this.plan.projd.copy());
        this.oldp = this.plan.projd = p;
        this.setData(p, true);
        this.submit(true);
    }

    private void redo() throws Exception {
        Projection p = (Projection)this.redo.pop();
        this.undo.push(this.plan.projd.copy());
        this.oldp = this.plan.projd = p;
        this.setData(p, true);
        this.submit(true);
    }

    private String getNewLabel() {
        return this.MYPROJ + " " + ++num;
    }

    private void setData() {
        this.setData(this.plan.projd, false);
    }

    private void setData(Projection proj, boolean modifModeCalib) {
        double rm1 = 0.0;
        double r1 = 0.0;
        this.titleFrame.setText(this.oldp == null ? this.ADJUST1 + " \"" + this.plan.label + "\"" : this.ADJUST2 + " \"" + this.plan.label + "\"");
        if (this.plan.isSimpleCatalog() && !this.plan.hasXYorig) {
            ((PlanCatalog)this.plan).setXYorig();
        }
        if (Projection.isOk(proj)) {
            this.label = this.oldp != null ? proj.label : this.getNewLabel();
            try {
                Coord co = proj.c.getProjCenter();
                this.raj = co.al;
                this.dej = co.del;
                this.cx = co.x;
                this.cy = co.y;
                this.rm = proj.c.getImgWidth() * 60.0;
                rm1 = proj.c.getImgHeight() * 60.0;
                this.r = proj.c.getImgSize().width;
                r1 = proj.c.getImgSize().height;
                this.rot = proj.c.getProjRot();
                this.sym = proj.c.getProjSym();
                this.system = proj.c.getSystem();
                this.t = proj.c.getProj();
            }
            catch (Exception e) {
                System.err.println("Error on projd: " + e);
            }
        } else {
            this.label = this.getNewLabel();
            this.rot = 0.0;
            r1 = 0.0;
            this.r = 0.0;
            this.cy = 0.0;
            this.cx = 0.0;
            this.dej = 0.0;
            this.raj = 0.0;
            this.sym = false;
            this.system = Calib.ICRS;
            this.t = 1;
            if (this.plan.isImage()) {
                this.r = ((PlanImage)this.plan).naxis1;
                r1 = ((PlanImage)this.plan).naxis2;
                this.cx = ((PlanImage)this.plan).naxis1 / 2;
                this.cy = ((PlanImage)this.plan).naxis2 / 2;
                this.rm = rm1 = this.r / 60.0;
                if (this.plan.hasFitsHeader()) {
                    try {
                        String ra = this.plan.headerFits.getStringFromHeader("OBJCTRA");
                        String de = this.plan.headerFits.getStringFromHeader("OBJCTDEC");
                        Astrocoo c = new Astrocoo();
                        c.set(ra + " " + de);
                        this.raj = c.getLon();
                        this.dej = c.getLat();
                    }
                    catch (Exception e) {}
                }
            } else if (this.plan.isSimpleCatalog() && this.plan.hasXYorig) {
                double[] m = new double[4];
                ((PlanCatalog)this.plan).getXYRange(m);
                r1 = this.r = Math.max(m[1] - m[0], m[3] - m[2]);
                this.cx = m[0] + (m[1] - m[0]) / 2.0;
                this.cy = m[2] + (m[3] - m[2]) / 2.0;
            }
        }
        this.labelT.setText(this.label);
        this.cooT.setText(Coord.getSexa(this.raj, this.dej, "s"));
        this.xyT.setText(Util.myRound(this.cx + "", 2) + " " + Util.myRound(this.cy + "", 2));
        this.xyS.setText(this.rm == 0.0 || this.r == 0.0 ? "1\"" : Coord.getUnit(this.rm / 60.0 / this.r));
        this.rotT.setText(this.rot + "");
        this.setSymRadio(this.sym);
        this.setFrameChoice(this.system);
        this.setProjChoice(this.t >= 0 ? this.t : 0);
        this.setCoo(proj);
        if (modifModeCalib && proj != null) {
            this.modeCalib = 0;
            if (proj.modeCalib == 4) {
                this.modeCalib = 1;
            } else if (proj.modeCalib == 2) {
                this.modeCalib = 2;
            }
        }
        this.panelMethod.setSelectedIndex(this.modeCalib);
        if (this.modeCalib == 1) {
            this.setFocusPos(this.xyPosT[0]);
            this.a.calque.repaintAll();
        }
        if (proj == null) {
            this.getWCS(new Projection(this.label, 3, this.raj, this.dej, this.rm, rm1, this.cx, this.cy, this.r, r1, this.rot, this.sym, 2, this.system));
        } else {
            this.getWCS(proj);
        }
        this.pack();
    }

    protected void newXY(PointD orig, PointD dest, ViewSimple v) {
        if (this.modeCalib != 0) {
            return;
        }
        Coord c1 = new Coord();
        Coord c2 = new Coord();
        double diffAlpha = 0.0;
        double diffDelta = 0.0;
        c1.x = orig.x;
        c1.y = orig.y;
        c2.x = dest.x;
        c2.y = dest.y;
        Plan ref = v.pref;
        Projection proj = v.getProj();
        try {
            if (ref != null && Projection.isOk(proj)) {
                proj.getCoord(c1);
                proj.getCoord(c2);
                if (!Double.isNaN(c1.al) && !Double.isNaN(c2.al)) {
                    double drac;
                    double dra = c2.al - c1.al;
                    double dde = c2.del - c1.del;
                    diffAlpha = drac = dra * AstroMath.cosd(c1.del);
                    diffDelta = dde;
                }
            }
            Coord co = new Coord(this.raj, this.dej);
            co.al += diffAlpha;
            co.del += diffDelta;
            this.cooT.setText(co.getSexa(" "));
            this.modifyButton.setEnabled(true);
        }
        catch (Exception e) {
            return;
        }
    }

    private void clear() {
        this.cooT.setText("");
        this.xyT.setText("");
        this.xyS.setText("");
        this.rotT.setText("0");
        this.setSymRadio(this.sym);
        this.setFrameChoice(this.system);
        this.setProjChoice(this.t >= 0 ? this.t : 0);
        this.setCoo(null);
        this.getWCS(null);
    }

    private void getWCS(Projection p) {
        this.wcsT.setText("");
        if (p == null) {
            return;
        }
        this.wcsT.setText(p.getWCS());
    }

    private void updaterm() {
        double x = Server.getAngleInArcmin(this.xyS.getText(), 1);
        if (this.r <= 0.0) {
            this.r = 1024.0;
        }
        this.rm = x * this.r;
    }

    private void setFrameChoice(int system) {
        if (this.frameChoice == null) {
            this.frameChoice = Localisation.createFrameComboBis();
        }
        try {
            this.frameChoice.setSelectedIndex(system);
        }
        catch (Exception e) {
            this.frameChoice.setSelectedIndex(0);
        }
    }

    private void setProjChoice(int type) {
        int i;
        if (this.projChoice == null) {
            this.projChoice = new JComboBox<String>(Projection.getAlaProj());
        }
        if ((i = Projection.getAlaProjIndex(Calib.getProjName(type))) >= Projection.getAlaProj().length) {
            i = 2;
        }
        this.projChoice.setSelectedIndex(i);
    }

    private void setSymRadio(boolean sym) {
        if (this.symRadio == null) {
            this.symRadio = new ButtonGroup();
            this.trueSym = new JRadioButton(this.TRUE);
            this.symRadio.add(this.trueSym);
            this.trueSym.setSelected(true);
            this.falseSym = new JRadioButton(this.FALSE);
            this.symRadio.add(this.falseSym);
            this.pSym = new JPanel();
            this.pSym.add(this.trueSym);
            this.pSym.add(this.falseSym);
        }
        if (sym) {
            this.trueSym.setSelected(true);
        } else {
            this.falseSym.setSelected(true);
        }
    }

    private void createPanel() {
        JPanel p = new JPanel(new BorderLayout());
        JPanel panelT = new JPanel();
        this.titleFrame = new MyLabel(this.CHOOSECAL, 1, Aladin.ITALIC);
        panelT.add(this.titleFrame);
        JPanel panelH = new JPanel();
        panelH.setLayout(new BorderLayout());
        Aladin.makeAdd(panelH, panelT, "North");
        JPanel panelN = new JPanel();
        panelN.setFont(Aladin.BOLD);
        panelN.add(new JLabel(this.LABEL));
        this.labelT = new JTextField(20);
        panelN.add(this.labelT);
        Aladin.makeAdd(panelH, panelN, "Center");
        Aladin.makeAdd(p, panelH, "North");
        panelT.setBackground(Aladin.BLUE);
        panelH.setBackground(Aladin.BLUE);
        panelN.setBackground(Aladin.BLUE);
        this.titleFrame.setBackground(Aladin.BLUE);
        p.setBackground(Aladin.BLUE);
        this.getContentPane().setBackground(Aladin.BLUE);
        this.panelOne = this.createPanelOne();
        this.panelTwo = this.createPanelTwo();
        this.panelThree = this.createPanelThree();
        this.panelMethod = new JTabbedPane();
        this.panelMethod.addChangeListener(this);
        this.panelMethod.add(this.ONE, this.panelOne);
        this.panelMethod.add(this.TWO, this.panelTwo);
        this.panelMethod.add(this.THREE, this.panelThree);
        Aladin.makeAdd(p, this.panelMethod, "Center");
        JPanel v = this.valid();
        Aladin.makeAdd(p, v, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Aladin.makeAdd(this, p, "Center");
    }

    private JPanel createPanelOne() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 17;
        c.insets.bottom = 2;
        JPanel p = new JPanel(g);
        this.cooT = new JTextField(20);
        this.xyT = new JTextField(20);
        this.xyS = new JTextField(20);
        this.rotT = new JTextField(20);
        this.frameChoice = Localisation.createFrameComboBis();
        this.setSymRadio(this.sym);
        this.setProjChoice(this.t);
        PropPanel.addCouple(p, this.COORD, this.cooT, g, c);
        PropPanel.addCouple(p, this.XY, this.xyT, g, c);
        PropPanel.addCouple(p, this.PIXSIZE, this.xyS, g, c);
        PropPanel.addCouple(p, this.FRAME, this.frameChoice, g, c);
        PropPanel.addCouple(p, this.PROJECT, this.projChoice, g, c);
        PropPanel.addCouple(p, this.ROT, this.rotT, g, c);
        PropPanel.addCouple(p, this.RASYM, this.pSym, g, c);
        return p;
    }

    private JPanel createPanelTwo() {
        JPanel p = new JPanel(new BorderLayout(0, 0));
        this.xyPosT = new FrameNewCalibTextField[this.maxPosT];
        this.cooPosT = new FrameNewCalibTextField[this.maxPosT];
        int scrollWidth = 150;
        int scrollHeight = 200;
        JPanel panelL = new JPanel();
        panelL.setLayout(new BorderLayout());
        panelL.setFont(Aladin.ITALIC);
        MyLabel l0 = new MyLabel(this.QUADMSG);
        JPanel l1 = new JPanel();
        l1.setLayout(new FlowLayout(1));
        l1.add(new JLabel(this.XYPOS));
        JPanel l2 = new JPanel();
        l2.setLayout(new FlowLayout(1));
        l2.add(new JLabel("hh mm ss +dd mm ss"));
        Aladin.makeAdd(panelL, l0, "North");
        Aladin.makeAdd(panelL, l1, "West");
        Aladin.makeAdd(panelL, l2, "East");
        Aladin.makeAdd(p, panelL, "North");
        JPanel panelScroll = new JPanel();
        panelScroll.setLayout(new GridLayout(0, 2));
        for (int i = 0; i < this.maxPosT; ++i) {
            this.xyPosT[i] = new FrameNewCalibTextField();
            this.cooPosT[i] = new FrameNewCalibTextField();
            panelScroll.add(this.xyPosT[i]);
            panelScroll.add(this.cooPosT[i]);
        }
        JScrollPane scroll = new JScrollPane(panelScroll);
        scroll.setPreferredSize(new Dimension(scrollWidth, scrollHeight));
        Aladin.makeAdd(p, scroll, "Center");
        return p;
    }

    private JPanel createPanelThree() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        JPanel panelScroll = new JPanel();
        panelScroll.setLayout(new BorderLayout(0, 0));
        this.wcsT = new JTextArea(50, 70);
        this.wcsT.setFont(Aladin.COURIER);
        Aladin.makeAdd(panelScroll, this.wcsT, "Center");
        JScrollPane scroll = new JScrollPane(panelScroll);
        scroll.setPreferredSize(new Dimension(150, 200));
        Aladin.makeAdd(p, scroll, "Center");
        return p;
    }

    protected JPanel valid() {
        JButton b;
        JPanel p = new JPanel(new FlowLayout(1));
        p.setFont(Aladin.LBOLD);
        p.setBackground(Aladin.BLUE);
        Insets m = new Insets(2, 2, 2, 2);
        this.modifyButton = b = new JButton(this.oldp == null ? this.SUBMIT : this.MODIFY);
        p.add(b);
        b.setFont(b.getFont().deriveFont(1));
        b.addActionListener(this);
        b.setMargin(m);
        b.setOpaque(false);
        this.undoButton = b = new JButton(this.UNDO);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(m);
        b.setOpaque(false);
        this.redoButton = b = new JButton(this.REDO);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(m);
        b.setOpaque(false);
        b = new JButton(this.HELP);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(m);
        b.setOpaque(false);
        this.resetButton = b = new JButton(this.RESET);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(m);
        b.setOpaque(false);
        b = new JButton(this.CLEAR);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(m);
        b.setOpaque(false);
        b = new JButton(this.CANCEL);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(m);
        b.setOpaque(false);
        return p;
    }

    protected int getModeCalib() {
        return this.modeCalib;
    }

    private void changeMethod() {
        int mode;
        this.modeCalib = mode = this.panelMethod.getSelectedIndex();
        if (this.modeCalib == 1) {
            this.xyPosT[0].requestFocus();
            this.setFocusPos(this.xyPosT[0]);
            if (!this.plan.hasNoReduction() && (long)this.plan.hashCode() != this.oplanHashCode) {
                if (Aladin.confirmation(this, Aladin.chaine.getString("NCALIBAGAIN") + "\n=> " + this.plan.label)) {
                    this.oplanHashCode = this.plan.hashCode();
                }
            }
        }
        this.resumeFlagPlanRecalibrating();
    }

    private void resumeFlagPlanRecalibrating() {
    }

    protected void reset() {
        this.setData();
        this.setFocusPos(this.xyPosT[0]);
    }

    private void setCoo(Projection p) {
        for (int i = 0; i < this.maxPosT; ++i) {
            String xy;
            String co;
            if (p == null || p.coo == null || i >= p.coo.length) {
                co = "";
                xy = "";
            } else {
                xy = p.coo[i].x + " " + p.coo[i].y;
                co = p.coo[i].getSexa();
            }
            this.xyPosT[i].setText(xy);
            this.cooPosT[i].setText(co);
        }
    }

    private Coord[] getCoo() throws Exception {
        int i = 0;
        FrameNewCalibTextField comp = this.xyPosT[0];
        Vector<Coord> v = new Vector<Coord>();
        Coord[] coo = null;
        try {
            for (i = 0; i < this.maxPosT; ++i) {
                String xy = this.xyPosT[i].getText().trim();
                String co = this.cooPosT[i].getText().trim();
                if (xy.length() == 0 || co.length() == 0) continue;
                comp = this.cooPosT[i];
                Coord c = new Coord(co);
                comp = this.xyPosT[i];
                StringTokenizer st = new StringTokenizer(xy);
                c.x = Double.valueOf(st.nextToken());
                c.y = Double.valueOf(st.nextToken());
                v.addElement(c);
            }
            int n = v.size();
            Enumeration e = v.elements();
            coo = new Coord[n];
            for (i = 0; i < n; ++i) {
                coo[i] = (Coord)e.nextElement();
            }
        }
        catch (Exception e) {
            ((Component)comp).requestFocus();
            this.setFocusPos(comp);
            e.printStackTrace();
            throw new Exception("Error on field " + i);
        }
        return coo;
    }

    private int getHauteur() {
        if (this.plan.isImage()) {
            return ((PlanImage)this.plan).height;
        }
        double[] m = new double[4];
        ((PlanCatalog)this.plan).getXYRange(m);
        return (int)Math.round(m[3] - m[2]);
    }

    private void submit(boolean flagModif) {
        Projection p = null;
        String label = this.labelT.getText();
        String error = null;
        double r1 = 0.0;
        double rm1 = 0.0;
        if (flagModif && this.oldp != null) {
            this.oldp.frame = 0;
        }
        try {
            if (this.modeCalib == 0) {
                error = "coordinate";
                Astrocoo c = new Astrocoo(new ICRS(), this.cooT.getText());
                double raj = c.getLon();
                double dej = c.getLat();
                StringTokenizer st = new StringTokenizer(this.xyT.getText());
                error = "XY position";
                double cx = Double.valueOf(st.nextToken());
                double cy = Double.valueOf(st.nextToken());
                error = "Pixel size";
                this.updaterm();
                r1 = this.r;
                rm1 = this.rm;
                if (this.plan.isImage()) {
                    r1 = ((PlanImage)this.plan).naxis2;
                    rm1 = this.rm * r1 / this.r;
                }
                error = "rotation";
                double rot = Double.valueOf(this.rotT.getText());
                int type = Projection.getProjType((String)this.projChoice.getSelectedItem());
                int system = Localisation.getFrameComboBisValue((String)this.frameChoice.getSelectedItem());
                boolean sym = this.trueSym.isSelected();
                error = null;
                if (flagModif && this.oldp != null) {
                    p = this.oldp;
                    p.modify(label, 3, raj, dej, this.rm, rm1, cx, cy, this.r, r1, rot, sym, type, system);
                } else {
                    p = new Projection(label, 3, raj, dej, this.rm, rm1, cx, cy, this.r, r1, rot, sym, type, system);
                }
            } else if (this.modeCalib == 1) {
                Coord[] coo = this.getCoo();
                if (coo == null) {
                    return;
                }
                p = flagModif ? this.oldp : (this.plan.projd != null ? this.plan.projd.copy() : new Projection(label, 3, coo[0].al, coo[0].del, this.cx, this.cy, coo[0].x, coo[0].y, this.cx * 2.0, this.cy * 2.0, 0.0, false, 2, this.system));
                p.modify(label, coo);
            } else if (this.modeCalib == 2) {
                String s = this.wcsT.getText();
                HeaderFits headerFits = new HeaderFits(s);
                Calib c = new Calib(headerFits);
                p = flagModif ? this.oldp : new Projection(label, 2, c.alphai, c.deltai, this.rm, rm1, this.cx, this.cy, this.r, r1, this.rot, this.sym, 2, this.system);
                p.modify(label, c);
            }
            if (this.plan.hasXYorig) {
                this.plan.pcat.setCoord(p);
            }
            if (!flagModif) {
                this.plan.setNewProjD(p);
            } else {
                this.plan.projd = p;
            }
            this.plan.co = new Coord(this.raj, this.dej);
            Properties.majProp();
            this.plan.setHasSpecificCalib();
            this.a.view.newView(1);
            this.a.calque.repaintAll();
            this.oldp = p;
            this.modifyButton.setEnabled(false);
            this.resetButton.setEnabled(false);
            this.setData();
            this.a.log("Recalibration", "[" + this.plan.getLogInfo() + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            error = error == null ? "Calibration error: \n" + e : "Calibration error\non \"" + error + "\" field";
            Aladin.error(this, error, 1);
        }
        this.a.view.repaintAll();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!(e.getSource() instanceof JTabbedPane)) {
            return;
        }
        this.changeMethod();
        if (this.undoButton != null) {
            this.undoButton.setEnabled(this.undoable());
        }
        if (this.redoButton != null) {
            this.redoButton.setEnabled(this.redoable());
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.panelMethod == null) {
            return;
        }
        Object s = evt.getSource();
        if (s instanceof JButton) {
            String what = ((JButton)s).getActionCommand();
            if (this.CANCEL.equals(what)) {
                this.hide();
            } else if (this.UNDO.equals(what)) {
                try {
                    this.undo();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.REDO.equals(what)) {
                try {
                    this.redo();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.HELP.equals(what)) {
                Aladin.info(this, this.HELPSTRING);
            } else if (this.CLEAR.equals(what)) {
                this.clear();
            } else if (this.RESET.equals(what)) {
                this.reset();
                if (this.modifyButton.getText().equals(this.MODIFY)) {
                    this.modifyButton.setEnabled(false);
                }
            } else if (this.MODIFY.equals(what)) {
                this.setUndo(this.plan.projd);
                this.submit(true);
            } else if (this.SUBMIT.equals(what)) {
                Projection p = this.plan.projd;
                this.submit(false);
                if (p != null) {
                    this.setUndo(p.copy());
                    this.undoButton.setEnabled(true);
                }
                this.modifyButton.setText(this.MODIFY);
            }
        }
        this.undoButton.setEnabled(this.undoable());
        this.redoButton.setEnabled(this.redoable());
    }

    private int getIndexPos(Component c) {
        for (int i = 0; i < this.maxPosT; ++i) {
            if (c != this.xyPosT[i] && c != this.cooPosT[i]) continue;
            return i;
        }
        return -1;
    }

    private void setFocusPos(Component c) {
        int i = this.getIndexPos(c);
        if (this.focusTextField != null) {
            this.focusTextField.setBackground(Color.white);
        }
        if (i == -1) {
            this.focusTextField = null;
            return;
        }
        this.flagXY = c == this.xyPosT[i];
        this.focusTextField = (JTextField)c;
        this.focusTextField.setBackground(Color.yellow);
        String s = this.flagXY ? this.xyPosT[i].getText().trim() : this.cooPosT[i].getText().trim();
        this.setRepere(s, this.flagXY);
        c.requestFocus();
    }

    private void setRepere(String s, boolean flagXY) {
        Coord coo;
        block7: {
            if (s.length() == 0) {
                return;
            }
            if (flagXY) {
                try {
                    StringTokenizer st = new StringTokenizer(s);
                    coo = new Coord();
                    coo.x = Double.valueOf(st.nextToken()) - 0.5;
                    coo.y = Double.valueOf(st.nextToken()) - 0.5;
                    coo.y = (double)this.getHauteur() - coo.y;
                    this.plan.projd.getCoord(coo);
                    if (Double.isNaN(coo.al)) {
                        return;
                    }
                    break block7;
                }
                catch (Exception e) {
                    return;
                }
            }
            try {
                coo = new Coord(s);
            }
            catch (Exception e) {
                return;
            }
        }
        this.a.view.setRepere(coo);
    }

    private void changeFocus() {
        int i = this.getIndexPos(this.focusTextField);
        if (i == -1) {
            this.focusTextField = null;
            return;
        }
        this.focusTextField.setBackground(Color.white);
        if (this.focusTextField == this.xyPosT[i]) {
            this.focusTextField = this.cooPosT[i];
            this.flagXY = false;
        } else if (++i == this.maxPosT) {
            this.focusTextField = null;
        } else {
            this.focusTextField = this.xyPosT[i];
            this.flagXY = true;
        }
        if (this.focusTextField != null) {
            this.focusTextField.setBackground(Color.yellow);
            this.focusTextField.requestFocus();
        }
    }

    protected static void test(int i, int j, int src, double[] pix, int[] source, double sigma, double fond) {
        for (int sidetest = 1; sidetest <= 4; ++sidetest) {
            int jj;
            int ii;
            switch (sidetest) {
                case 1: {
                    ii = i - 1;
                    jj = j;
                    break;
                }
                case 2: {
                    ii = i + 1;
                    jj = j;
                    break;
                }
                case 3: {
                    ii = i;
                    jj = j - 1;
                    break;
                }
                case 4: {
                    ii = i;
                    jj = j + 1;
                    break;
                }
                default: {
                    ii = i;
                    jj = j;
                }
            }
            if (ii < 0 || ii >= W || jj < 0 || jj >= W || source[jj * W + ii] != 0 || !(pix[jj * W + ii] - fond > 3.0 * sigma)) continue;
            source[jj * FrameNewCalib.W + ii] = src;
            FrameNewCalib.test(ii, jj, src, pix, source, sigma, fond);
        }
    }

    protected static PointD[] bestPoint(double[] pix, Plan lePlan) throws Exception {
        double bb;
        int j;
        int i;
        int W = (int)Math.sqrt(pix.length);
        double x = 0.0;
        double y = 0.0;
        double alsig = 0.0;
        double max = 0.0;
        double fond1 = 0.0;
        double fond = 0.0;
        double w = 0.0;
        double sigma1 = 0.0;
        double sigma = 0.0;
        int[] source = new int[W * W];
        for (i = 0; i < W; ++i) {
            for (j = 0; j < W; ++j) {
                if (!(max < pix[i * W + j])) continue;
                max = pix[i * W + j];
                x = j;
                y = i;
            }
        }
        for (i = 0; i < W; ++i) {
            fond1 = 0.0;
            for (j = 0; j < W; ++j) {
                fond1 += pix[i * W + j];
            }
            fond += fond1 / (double)W;
        }
        double oldfond = fond /= (double)W;
        for (i = 0; i < W; ++i) {
            sigma1 = 0.0;
            for (j = 0; j < W; ++j) {
                sigma1 += (pix[i * W + j] - fond) * (pix[i * W + j] - fond);
            }
            sigma += sigma1 / (double)W;
        }
        sigma /= (double)W;
        double oldsigma = sigma = Math.sqrt(sigma);
        double nfond = 0.0;
        fond = 0.0;
        for (i = 0; i < W; ++i) {
            fond1 = 0.0;
            for (j = 0; j < W; ++j) {
                if (!(pix[i * W + j] - oldfond < 4.0 * oldsigma)) continue;
                fond1 += pix[i * W + j];
                nfond += 1.0;
            }
            fond += fond1 / (double)W;
        }
        fond /= nfond / (double)W;
        sigma = 0.0;
        for (i = 0; i < W; ++i) {
            sigma1 = 0.0;
            for (j = 0; j < W; ++j) {
                if (!(pix[i * W + j] - oldfond < 4.0 * oldsigma)) continue;
                sigma1 += (pix[i * W + j] - fond) * (pix[i * W + j] - fond);
            }
            sigma += sigma1 / nfond;
        }
        sigma = Math.sqrt(sigma);
        int flag = 0;
        for (i = 0; i < W; ++i) {
            for (j = 0; j < W; ++j) {
                source[i * W + j] = 0;
            }
        }
        for (i = 0; i < W; ++i) {
            for (j = 0; j < W; ++j) {
                if (source[i * W + j] != 0 || !(pix[i * W + j] - fond > 3.0 * sigma)) continue;
                source[i * W + j] = ++flag;
                FrameNewCalib.test(j, i, flag, pix, source, sigma, fond);
            }
        }
        double mindist = (double)(W * W) / 2.0;
        int selsource = 1;
        for (i = 0; i < W; ++i) {
            for (j = 0; j < W; ++j) {
                if (source[i * W + j] == 0 || !(mindist > ((double)W / 2.0 - (double)i) * ((double)W / 2.0 - (double)i) + ((double)W / 2.0 - (double)j) * ((double)W / 2.0 - (double)j))) continue;
                mindist = ((double)W / 2.0 - (double)i) * ((double)W / 2.0 - (double)i) + ((double)W / 2.0 - (double)j) * ((double)W / 2.0 - (double)j);
                selsource = source[i * W + j];
            }
        }
        x = 0.0;
        y = 0.0;
        w = 0.0;
        for (i = 0; i < W; ++i) {
            for (j = 0; j < W; ++j) {
                if (source[i * W + j] != selsource) continue;
                y += (pix[i * W + j] - fond) * (double)i;
                x += (pix[i * W + j] - fond) * (double)j;
                w += pix[i * W + j] - fond;
            }
        }
        if (w == 0.0) {
            x = (double)W / 2.0;
            y = (double)W / 2.0;
            throw new Exception("Too large source for the centering algorithm");
        }
        i = (int)(y /= w);
        j = (int)(x /= w);
        double a = pix[i * W + j] - fond;
        double b = 256.0;
        double alsig1 = 0.0;
        for (j = 0; j < (int)x + 1; ++j) {
            if (!(pix[i * W + j] - fond > 3.0 * sigma)) continue;
            bb = pix[i * W + j] - fond - a / 2.0;
            if (bb < 0.0) {
                bb = -bb;
            }
            if (!(bb < b)) continue;
            b = bb;
            alsig1 = x - (double)j;
        }
        alsig += alsig1;
        b = 256.0;
        for (j = (int)x + 1; j < W; ++j) {
            if (!(pix[i * W + j] - fond > 3.0 * sigma)) continue;
            bb = pix[i * W + j] - fond - a / 2.0;
            if (bb < 0.0) {
                bb = -bb;
            }
            if (!(bb < b)) continue;
            b = bb;
            alsig1 = (double)j - x;
        }
        alsig += alsig1;
        i = (int)y;
        j = (int)x;
        a = (double)((int)pix[i * W + j] & 0xFF) - fond;
        b = 256.0;
        for (i = 0; i < (int)y + 1; ++i) {
            if (!(pix[i * W + j] - fond > 3.0 * sigma)) continue;
            bb = pix[i * W + j] - fond - a / 2.0;
            if (bb < 0.0) {
                bb = -bb;
            }
            if (!(bb < b)) continue;
            b = bb;
            alsig1 = y - (double)i;
        }
        alsig += alsig1;
        b = 256.0;
        for (i = (int)y + 1; i < W; ++i) {
            if (!(pix[i * W + j] - fond > 3.0 * sigma)) continue;
            bb = pix[i * W + j] - fond - a / 2.0;
            if (bb < 0.0) {
                bb = -bb;
            }
            if (!(bb < b)) continue;
            b = bb;
            alsig1 = (double)i - y;
        }
        alsig += alsig1;
        double fwhm = 2.0 * (alsig /= 4.0);
        double Min = ((PlanImage)lePlan).pixelMin;
        double Max = ((PlanImage)lePlan).pixelMax;
        fond *= (Max - Min) / 256.0;
        PointD[] p = new PointD[]{new PointD(x - (double)W / 2.0 + 0.5, y - (double)W / 2.0 + 0.5), new PointD(fond += Min, sigma *= (Max - Min) / 256.0), new PointD(a *= (Max - Min) / 256.0, fwhm)};
        return p;
    }

    protected boolean isGettingOriginalXY() {
        return this.plan.hasXYorig && this.flagXY;
    }

    protected PointD mouse(double x, double y, PlanImage pi, Position o) {
        String s;
        PointD rep = null;
        Point pp = null;
        if (this.modeCalib != 1) {
            return rep;
        }
        Aladin.trace(4, "FrameNewCalib.mouse() x=" + x + " y=" + y + (o != null ? " source=" + o.id : ""));
        if (this.focusTextField == null) {
            return rep;
        }
        if (this.plan.isCatalog() && !this.plan.hasXYorig && !Projection.isOk(this.plan.projd)) {
            return rep;
        }
        if (this.flagXY) {
            if (this.plan.hasXYorig) {
                if (o == null) {
                    Aladin.error(this.ERRNOXY);
                    return null;
                }
                x = o.x;
                y = o.y;
                this.prevObj = o;
            } else {
                if (pi != this.plan) {
                    Aladin.error(this.ERRIMG);
                    return null;
                }
                this.prevObj = null;
                try {
                    pp = new Point((int)x, (int)y);
                    double[] iqe = pi.getPixelStats(pp);
                    if (iqe == null) {
                        throw new Exception("IQE autocenter failed => use XY mouse position");
                    }
                    x = iqe[0];
                    y = iqe[2];
                }
                catch (Exception e) {
                    this.a.status.setText(e.getMessage() + "\n " + this.ERRNOBEST);
                }
            }
            rep = new PointD(x, y);
            if (this.plan.isImage()) {
                y = (double)((PlanImage)this.plan).naxis2 - y;
            }
            s = Util.myRound("" + x, 4) + "  " + Util.myRound("" + y, 4);
        } else if (Projection.isOk(this.a.calque.getPlanRef().projd) || this.plan.hasXYorig) {
            String s1 = null;
            if (o != null && o != this.prevObj) {
                s = Coord.getSexa(o.raj, o.dej);
                s1 = Coord.getSexa(o.raj, o.dej, ":");
            } else {
                Projection p;
                Plan pl = this.a.calque.getPlanRef();
                Projection projection = p = pl == null || pl.projd == null ? null : pl.projd;
                if (p == null) {
                    Aladin.error("No RA/DEC reference plane !");
                    return null;
                }
                try {
                    pp = new Point((int)x, (int)y);
                    double[] iqe = ((PlanImage)pl).getPixelStats(pp);
                    if (iqe == null) {
                        throw new Exception("IQE autocenter failed => assume XY mouse");
                    }
                    x = iqe[0];
                    y = iqe[2];
                }
                catch (Exception e) {
                    // empty catch block
                }
                Coord c = new Coord();
                c.x = x;
                c.y = y;
                p.getCoord(c);
                if (Double.isNaN(c.al)) {
                    s = "";
                } else {
                    s = Coord.getSexa(c.al, c.del);
                    s1 = Coord.getSexa(c.al, c.del, ":");
                }
            }
        } else {
            if (o == null || o == this.prevObj) {
                Aladin.error("No object near the pointer, try again !!");
                return null;
            }
            s = Coord.getSexa(o.raj, o.dej);
        }
        this.focusTextField.setText(s);
        this.changeFocus();
        return rep;
    }

    @Override
    public void hide() {
        if (this.plan != null) {
            this.plan = null;
        }
        super.hide();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.hide();
        }
        super.processWindowEvent(e);
    }

    class FrameNewCalibTextField
    extends JTextField
    implements MouseListener {
        FrameNewCalibTextField() {
            super(15);
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            FrameNewCalib.this.setFocusPos(this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void setText(String s) {
            super.setText(s);
            FrameNewCalib.this.modifyButton.setEnabled(true);
            FrameNewCalib.this.resetButton.setEnabled(true);
        }
    }
}

