/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameMocGenImg;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanMoc;
import cds.aladin.PlanMocAlgo;
import cds.aladin.prop.PropPanel;
import cds.moc.Moc;
import cds.moc.TMoc;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

public final class FrameMocOperation
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String SUNION;
    String INTER;
    String SUB;
    String DIFF;
    String COMP;
    String PLANE;
    private ButtonGroup cbg;
    private JRadioButton rUnion;
    private JRadioButton rInter;
    private JRadioButton rSub;
    private JRadioButton rDiff;
    private JRadioButton rComp;
    private JComboBox mocTimeOrder;
    private JComboBox mocSpaceOrder;
    private JSlider sliderAcc;
    private int initSpaceOrder = -1;
    private int initTimeOrder = -1;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCTITLE");
        this.INFO = Aladin.chaine.getString("MOCINFO");
        this.HELP1 = Aladin.chaine.getString("MOCHELP");
        this.SUNION = Aladin.chaine.getString("MOCUNION");
        this.INTER = Aladin.chaine.getString("MOCINTER");
        this.SUB = Aladin.chaine.getString("MOCSUB");
        this.DIFF = Aladin.chaine.getString("MOCDIFF");
        this.COMP = Aladin.chaine.getString("MOCCOMP");
        this.PLANE = Aladin.chaine.getString("MOCPLANE");
    }

    protected FrameMocOperation(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return 22;
    }

    @Override
    protected int getNb() {
        return 10;
    }

    @Override
    protected String getLabelSelector(int i) {
        return this.PLANE;
    }

    @Override
    protected Plan[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlans(PlanMoc.class);
        if (v == null) {
            return new PlanImage[0];
        }
        Object[] pi = new PlanImage[v.size()];
        v.copyInto(pi);
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    protected JComboBox getComboSpaceRes() {
        return FrameMocGenImg.makeComboSpaceRes();
    }

    protected JComboBox getComboTimeRes() {
        return FrameMocGenImg.makeComboTimeRes();
    }

    protected JComboBox getComboSpaceAcc() {
        return FrameMocOperation.makeComboSpaceAcc(9);
    }

    protected JComboBox getComboTimeAcc() {
        return this.makeComboTimeAcc(9);
    }

    protected JComboBox makeComboTimeAcc(int first) {
        return this.makeComboTimeAcc(first, null);
    }

    protected JComboBox makeComboTimeAcc(int first, JComboBox c) {
        int select = 0;
        if (c == null) {
            c = new JComboBox<String>();
        } else {
            c.getSelectedIndex();
            c.removeAll();
        }
        for (int o = 0; o < 5; ++o) {
            c.setActionCommand(o + "");
            String s = TMoc.getTemps(TMoc.getDuration(first) * (long)o);
            c.addItem(s);
        }
        c.setSelectedIndex(select);
        return c;
    }

    protected static JComboBox makeComboSpaceAcc(int first) {
        return FrameMocOperation.makeComboSpaceAcc(first, null);
    }

    protected static JComboBox makeComboSpaceAcc(int first, JComboBox c) {
        int select = 0;
        if (c == null) {
            c = new JComboBox<String>();
        } else {
            c.getSelectedIndex();
            c.removeAll();
        }
        for (int o = 0; o < 5; ++o) {
            c.setActionCommand(o + "");
            String s = Coord.getUnit(CDSHealpix.pixRes(first) * (double)o / 3600.0);
            c.addItem(s);
        }
        c.setSelectedIndex(select);
        return c;
    }

    @Override
    protected JPanel getAddPanel() {
        JRadioButton cb;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.cbg = new ButtonGroup();
        JPanel pp = new JPanel();
        this.rUnion = cb = new JRadioButton(this.SUNION);
        cb.setActionCommand(this.SUNION);
        this.cbg.add(cb);
        pp.add(cb);
        this.rInter = cb = new JRadioButton(this.INTER);
        cb.setActionCommand(this.INTER);
        this.cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        this.rSub = cb = new JRadioButton(this.SUB);
        cb.setActionCommand(this.SUB);
        this.cbg.add(cb);
        pp.add(cb);
        this.rDiff = cb = new JRadioButton(this.DIFF);
        cb.setActionCommand(this.DIFF);
        this.cbg.add(cb);
        pp.add(cb);
        this.rComp = cb = new JRadioButton(this.COMP);
        cb.setActionCommand(this.COMP);
        this.cbg.add(cb);
        pp.add(cb);
        c.gridwidth = 0;
        c.weightx = 10.0;
        g.setConstraints(pp, c);
        p.add(pp);
        PropPanel.addSectionTitle(p, new JLabel("Target resolution"), g, c);
        c.gridwidth = 0;
        pp = new JPanel();
        pp.add(new JLabel("Space "));
        this.mocSpaceOrder = this.getComboSpaceRes();
        pp.add(this.mocSpaceOrder);
        pp.add(new JLabel("    Time "));
        this.mocTimeOrder = this.getComboTimeRes();
        pp.add(this.mocTimeOrder);
        g.setConstraints(pp, c);
        p.add(pp);
        return p;
    }

    private int getOperation(String s) {
        if (s.equals(this.SUNION)) {
            return 0;
        }
        if (s.equals(this.INTER)) {
            return 1;
        }
        if (s.equals(this.SUB)) {
            return 2;
        }
        if (s.equals(this.DIFF)) {
            return 3;
        }
        return 4;
    }

    protected PlanMoc[] getPlans() {
        ArrayList<PlanMoc> pListA = new ArrayList<PlanMoc>();
        for (JComboBox c : this.ch) {
            int i = c.getSelectedIndex() - 1;
            if (i < 0) continue;
            pListA.add((PlanMoc)this.choicePlan[i]);
        }
        PlanMoc[] pList = new PlanMoc[pListA.size()];
        pListA.toArray(pList);
        return pList;
    }

    protected int getTimeOrder() {
        return this.mocTimeOrder.isEnabled() ? this.mocTimeOrder.getSelectedIndex() + 3 : -1;
    }

    protected int getSpaceOrder() {
        return this.mocSpaceOrder.isEnabled() ? this.mocSpaceOrder.getSelectedIndex() + 3 : -1;
    }

    @Override
    protected void submit() {
        try {
            PlanMoc[] pList = this.getPlans();
            String s = this.cbg.getSelection().getActionCommand();
            int fct = this.getOperation(s);
            String label = s.substring(0, 3) + " " + pList[0].label + (pList.length == 1 ? "" : pList[1].label + (pList.length == 2 ? "" : "..."));
            int spaceOrder = this.getSpaceOrder();
            int timeOrder = this.getTimeOrder();
            Plan[] ps = new Plan[pList.length];
            for (int i = 0; i < ps.length; ++i) {
                ps[i] = pList[i];
            }
            this.a.console.printCommand("cmoc -" + PlanMocAlgo.getOpName(fct) + " " + FrameMocGenImg.labelList(ps));
            this.a.calque.newPlanMoc(label, pList, fct, spaceOrder, timeOrder);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("MOC operation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
        PlanMoc[] pList = this.getPlans();
        boolean un = pList.length == 1;
        boolean deux = pList.length == 2;
        boolean plus = pList.length > 1;
        boolean time = false;
        boolean space = false;
        boolean setTimeOrder = false;
        boolean setSpaceOrder = false;
        for (PlanMoc p : pList) {
            Moc moc = p.getMoc();
            if (moc.isTime()) {
                time = true;
                if (this.initTimeOrder == -1) {
                    this.initTimeOrder = p.moc.getTimeOrder();
                    setTimeOrder = true;
                }
            }
            if (!moc.isSpace()) continue;
            space = true;
            this.initSpaceOrder = p.moc.getSpaceOrder();
            setSpaceOrder = true;
        }
        if (!time) {
            this.initTimeOrder = -1;
        }
        if (!space) {
            this.initSpaceOrder = -1;
        }
        this.rUnion.setEnabled(plus);
        this.rInter.setEnabled(plus);
        this.rDiff.setEnabled(deux);
        this.rSub.setEnabled(deux);
        this.rComp.setEnabled(un);
        if (setSpaceOrder) {
            this.mocSpaceOrder.setSelectedIndex(this.initSpaceOrder - 3);
        }
        if (setTimeOrder) {
            this.mocTimeOrder.setSelectedIndex(this.initTimeOrder - 3);
        }
        this.mocSpaceOrder.setEnabled(space);
        this.mocTimeOrder.setEnabled(time);
    }
}

