/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameMocGenImg;
import cds.aladin.Plan;
import cds.aladin.Server;
import cds.aladin.prop.PropPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class FrameMocGenCat
extends FrameMocGenImg {
    private JTextField radius;
    private JCheckBox boxRad;
    private JCheckBox boxFov;

    protected FrameMocGenCat(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.INFO = Aladin.chaine.getString("MOCGENCATINFO");
    }

    @Override
    protected boolean isPlanOk(Plan p) {
        return p.isCatalog();
    }

    @Override
    protected void addSpecifPanel(JPanel p, GridBagConstraints c, GridBagLayout g) {
        JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
        ButtonGroup bg = new ButtonGroup();
        JCheckBox box = new JCheckBox();
        bg.add(box);
        box.setSelected(true);
        PropPanel.addCouple(frame, p, " - Only the central position:", "Only the source position (lon,lat) is used to populate the MOC", box, g, c);
        JPanel p2 = new JPanel(new BorderLayout(0, 0));
        this.radius = new JTextField("3", 5);
        box = this.boxRad = new JCheckBox();
        bg.add(box);
        p2.add((Component)box, "West");
        p2.add((Component)this.radius, "Center");
        p2.add((Component)new JLabel(" in arcsec"), "East");
        PropPanel.addCouple(frame, p, " -Radius around position:", "A circle of the disgnated radius centered on each source is used to populate the MOC", p2, g, c);
        box = this.boxFov = new JCheckBox();
        bg.add(box);
        PropPanel.addCouple(frame, p, " - FoV associated to each source:", "The Field of View (for instance s_region information) associated to each source is used to populate the MOC.", box, g, c);
    }

    private double getRadius() throws Exception {
        double x = 0.0;
        try {
            String s = this.radius.getText().trim();
            if (s.length() > 0) {
                x = Server.getAngleInArcmin(s, 16) / 60.0;
            }
        }
        catch (Exception e) {
            this.radius.setForeground(Color.red);
            throw e;
        }
        this.radius.setForeground(Color.black);
        return x;
    }

    @Override
    protected void submit() {
        try {
            Plan[] ps = new Plan[]{this.getPlan(this.ch[0])};
            int order = this.getOrder();
            double radius = this.boxRad.isSelected() ? this.getRadius() : 0.0;
            boolean fov = this.boxFov.isSelected();
            String param = "";
            if (fov) {
                param = " -fov";
            } else if (radius > 0.0) {
                param = " -radius=" + Coord.getUnit(radius);
            }
            this.a.console.printCommand("cmoc -order=" + order + param + " " + FrameMocGenCat.labelList(ps));
            this.a.calque.newPlanMoc(ps[0].label + " MOC", ps, order, radius, 0.0, 0.0, Double.NaN, fov);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("MOC generation failed !");
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

