/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MySplitPane;
import cds.aladin.Server;
import cds.aladin.ServerGlu;
import cds.aladin.TapClient;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class FrameInfoServer
extends JFrame
implements ActionListener {
    static String TITLE;
    static String CLOSE;
    static String INFO;
    static String TYPE;
    static String DESC;
    static String MORE;
    static String ORIGIN;
    static String LASTQUERY;
    static String STATUS;
    static String ERRORMSG;
    static String IDENTIFIER;
    private JTextArea ta;
    private JLabel nom;
    private JButton btInfo;
    private Aladin aladin;
    private Server server;
    private Future<JPanel> additionalComponent;
    private MySplitPane centerPanel;
    private int flagUpdate;
    private int guiType;

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("ISTITLE");
        CLOSE = Aladin.chaine.getString("CLOSE");
        INFO = Aladin.chaine.getString("ISINFO");
        TYPE = Aladin.chaine.getString("ISTYPE");
        DESC = Aladin.chaine.getString("ISDESC");
        MORE = Aladin.chaine.getString("ISMORE");
        IDENTIFIER = Aladin.chaine.getString("ISIDENTIFIER");
        ORIGIN = Aladin.chaine.getString("ISORIGIN");
        LASTQUERY = Aladin.chaine.getString("ISLASTQUERY");
        STATUS = Aladin.chaine.getString("ISSTATUS");
        ERRORMSG = Aladin.chaine.getString("ERROR");
    }

    protected FrameInfoServer(Aladin aladin) {
        JButton b;
        this.aladin = aladin;
        this.guiType = 0;
        Aladin.setIcon(this);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.createChaine();
        this.setTitle(TITLE);
        this.ta = new JTextArea(20, 85);
        this.ta.setFont(Aladin.COURIER);
        this.ta.setBackground(Color.white);
        this.ta.setEditable(false);
        JScrollPane js = new JScrollPane(this.ta);
        JPanel tnom = new JPanel(new FlowLayout(1));
        this.nom = new JLabel(TITLE);
        this.nom.setFont(Aladin.LLITALIC);
        this.nom.setForeground(Aladin.COLOR_GREEN);
        tnom.add(this.nom);
        JPanel submit = new JPanel();
        this.btInfo = b = new JButton(INFO);
        submit.add(b);
        b.addActionListener(this);
        b = new JButton(CLOSE);
        submit.add(b);
        b.addActionListener(this);
        this.getContentPane().add((Component)tnom, "North");
        this.getContentPane().add((Component)js, "Center");
        this.getContentPane().add((Component)submit, "South");
        this.setLocation(Aladin.computeLocation(this));
    }

    protected FrameInfoServer(Aladin aladin, Future<JPanel> infoPanel) {
        JButton b;
        this.aladin = aladin;
        this.guiType = 1;
        Aladin.setIcon(this);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.createChaine();
        this.setTitle(TITLE);
        this.ta = new JTextArea(20, 85);
        this.ta.setFont(Aladin.COURIER);
        this.ta.setBackground(Color.white);
        this.ta.setEditable(false);
        JScrollPane js = new JScrollPane(this.ta);
        this.additionalComponent = infoPanel;
        try {
            JScrollPane mainScrollPane = new JScrollPane(this.additionalComponent.get());
            mainScrollPane.setName("INFOGUI");
            mainScrollPane.getVerticalScrollBar().setUnitIncrement(4);
            this.centerPanel = new MySplitPane(aladin, 0, js, mainScrollPane, 1);
            this.centerPanel.setBackground(Aladin.BLUE);
            js.setMinimumSize(new Dimension(800, 200));
            js.setPreferredSize(new Dimension(800, 300));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        JPanel tnom = new JPanel(new FlowLayout(1));
        this.nom = new JLabel(TITLE);
        this.nom.setFont(Aladin.LLITALIC);
        this.nom.setForeground(Aladin.COLOR_GREEN);
        tnom.add(this.nom);
        JPanel submit = new JPanel();
        this.btInfo = b = new JButton(INFO);
        submit.add(b);
        b.addActionListener(this);
        b = new JButton(CLOSE);
        submit.add(b);
        b.addActionListener(this);
        this.getContentPane().add((Component)tnom, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)submit, "South");
        this.setLocation(Aladin.computeLocation(this));
    }

    public void updateInfoPanel() throws Exception {
        if (this.centerPanel != null && this.additionalComponent != null) {
            Component[] components;
            for (Component component : components = this.centerPanel.getComponents()) {
                if (component.getName() == null || !component.getName().equals("INFOGUI")) continue;
                JScrollPane oldScrollPane = (JScrollPane)component;
                try {
                    JScrollPane mainScrollPane = new JScrollPane(this.additionalComponent.get());
                    mainScrollPane.setName("INFOGUI");
                    mainScrollPane.setBounds(10, 10, 800, 600);
                    mainScrollPane.getVerticalScrollBar().setUnitIncrement(4);
                    this.getContentPane().remove(this.centerPanel);
                    this.centerPanel.remove(oldScrollPane);
                    this.centerPanel.add(mainScrollPane);
                    this.getContentPane().add((Component)this.centerPanel, "Center");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }
    }

    private String A(String s) {
        return Util.align(s, 14) + ": ";
    }

    protected void show(Server s) {
        this.server = s;
        this.btInfo.setEnabled(this.server.docUser != null);
        this.nom.setText(s.aladinLabel.replace('\n', ' '));
        String gluRecord = null;
        if (s instanceof ServerGlu) {
            gluRecord = "GLU record:\n" + ((ServerGlu)s).record.toString();
        }
        this.ta.setText("\n" + (s.description != s.aladinLabel ? this.A(DESC) + Util.fold(s.description, 70) + "\n" : "") + (s.type != 8 && s.type != 16 ? this.A(TYPE) + s.getType() + "\n" : "") + (s.docUser != null && s.docUser != s.aladinLabel ? this.A(MORE) + s.docUser + "\n" : "") + (s.institute != null && s.institute != s.aladinLabel && s.institute != s.description ? this.A(ORIGIN) + s.institute + "\n" : "") + (s.type != 8 && s.type != 16 && s.statusUrl != null ? this.A(LASTQUERY) + s.statusUrl + "\n" : "") + (s.type == 8 || s.type == 16 ? "" : this.A(STATUS) + (s.statusAllVO != null ? s.statusAllVO.getText() + "\n" : "Not yet tested\n")) + (s.statusError != null ? this.A(ERRORMSG) + s.statusError + "\n" : "") + (s instanceof ServerGlu ? this.A(IDENTIFIER) + ((ServerGlu)s).gluTag + "\n" : "") + (s.verboseDescr != null ? "\n" + Util.fold(s.verboseDescr) + "\n" : "") + (gluRecord != null ? "\n\n" + gluRecord : ""));
        this.ta.setCaretPosition(0);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String what = evt.getActionCommand();
        if (what.equals(CLOSE)) {
            this.setVisible(false);
        } else if (what.equals(INFO)) {
            this.aladin.glu.showDocument("Http", this.server.docUser, true);
        }
    }

    public Future<JPanel> getAdditionalComponent() {
        return this.additionalComponent;
    }

    public void setAdditionalComponent(Future<JPanel> additionalComponent) {
        this.additionalComponent = additionalComponent;
    }

    public int isFlagUpdate() {
        return this.flagUpdate;
    }

    public void setFlagUpdate(int flagUpdate) {
        this.flagUpdate = flagUpdate;
    }

    public int getGuiType() {
        return this.guiType;
    }

    public void setGuiType(int guiType) {
        this.guiType = guiType;
    }

    public boolean isOfDynamicTapServerType() {
        boolean typeIsTap = false;
        if (this.guiType == 1) {
            typeIsTap = true;
        }
        return typeIsTap;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isThisInfoPanel(TapClient tapClient) {
        boolean result = false;
        if (this.isOfDynamicTapServerType() && this.server != null && this.server.tapClient != null && this.additionalComponent != null && tapClient.infoPanel != null && this.additionalComponent.equals(tapClient.infoPanel)) {
            result = true;
        }
        return result;
    }

    public void showHidetapInfoText(boolean show) {
        if (!(this.centerPanel == null || this.isVisible() && show == this.centerPanel.getTopComponent().isVisible())) {
            this.centerPanel.getTopComponent().setVisible(show);
            if (!show) {
                int dividerSize = (Integer)UIManager.get("SplitPane.dividerSize");
                double proportionalLocation = this.centerPanel.getHeight() > 1500 ? 0.05 : 0.2;
                this.centerPanel.setDividerSize(dividerSize);
                this.centerPanel.setDividerLocation(proportionalLocation);
            }
            this.centerPanel.resetToPreferredSizes();
            this.centerPanel.revalidate();
            this.centerPanel.repaint();
        }
    }
}

