/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Chaine;
import cds.aladin.FrameHeaderPDS;
import cds.aladin.FrameHipsProperties;
import cds.aladin.MyInputStream;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FrameHeaderFits
extends JFrame {
    private JTextPane ta;
    private JTextField ts;
    static String CLOSE;
    static String CLEAR;
    static String SAVE;
    static String CANCEL;
    static String SAVEINFO;
    private DefaultStyledDocument df;
    private JButton clear;
    private JButton cancel;
    private JButton save;
    private Plan plan;
    protected HeaderFits headerFits;
    private static SimpleAttributeSet atKey;
    private static SimpleAttributeSet atValue;
    private static SimpleAttributeSet atComment;
    private static SimpleAttributeSet atCom;
    private static SimpleAttributeSet atHist;
    private static SimpleAttributeSet atYellow;
    private static SimpleAttributeSet atWhite;
    private static SimpleAttributeSet atErr;
    private boolean first = true;
    boolean isEdited = false;
    private String originalHeader = null;

    static void createChaine(Chaine chaine) {
        SAVE = chaine.getString("HSAVE");
        CANCEL = chaine.getString("HUNDO");
        CLOSE = chaine.getString("CLOSE");
        CLEAR = chaine.getString("CLEAR");
        SAVEINFO = chaine.getString("HSAVEINFO");
    }

    public FrameHeaderFits() {
        this.headerFits = new HeaderFits();
    }

    public FrameHeaderFits(HeaderFits headerFits) {
        this.headerFits = headerFits;
        this.makeTA(false);
    }

    protected FrameHeaderFits(Plan plan, MyInputStream dis) throws Exception {
        super("FITS header");
        this.plan = plan;
        Aladin.setIcon(this);
        this.makeTA(true);
        this.headerFits = new HeaderFits();
        this.headerFits.readHeader(dis, this);
    }

    protected FrameHeaderFits(Plan plan, String s) {
        this(plan, s, false);
    }

    protected FrameHeaderFits(Plan plan, String s, boolean specialHHH) {
        Aladin.setIcon(this);
        this.plan = plan;
        this.makeTA(true);
        this.headerFits = new HeaderFits();
        this.headerFits.readFreeHeader(s, specialHHH, this);
    }

    protected void free() {
        this.dispose();
    }

    protected HeaderFits getHeaderFits() {
        return this.headerFits;
    }

    private void search(String key) {
        int pos;
        if (key.length() == 0) {
            this.first = true;
        }
        if (atKey == null) {
            atKey = new SimpleAttributeSet();
            atKey.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.blue);
            atKey.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atValue = new SimpleAttributeSet();
            atValue.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.black);
            atValue.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atComment = new SimpleAttributeSet();
            atComment.addAttribute(StyleConstants.CharacterConstants.Foreground, Aladin.COLOR_LABEL);
            atComment.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atCom = new SimpleAttributeSet();
            atCom.addAttribute(StyleConstants.CharacterConstants.Foreground, Aladin.COLOR_GREEN);
            atCom.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atErr = new SimpleAttributeSet();
            atErr.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.red);
            atErr.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atHist = new SimpleAttributeSet();
            atHist.addAttribute(StyleConstants.CharacterConstants.Foreground, new Color(127, 0, 85));
            atHist.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atWhite = new SimpleAttributeSet();
            atWhite.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atYellow = new SimpleAttributeSet();
            atYellow.addAttribute(StyleConstants.CharacterConstants.Background, Color.yellow);
        }
        String s = this.ta.getText();
        if (this.first && s.length() < 131072) {
            this.first = false;
            int opos = 0;
            while ((pos = s.indexOf("\n", opos)) >= 0) {
                String k = "";
                if (opos + 7 < s.length()) {
                    k = s.substring(opos, opos + 8).trim();
                }
                if (k.equals("HISTORY") || k.equals("CONTINUE")) {
                    this.df.setCharacterAttributes(opos, pos, atHist, true);
                } else if (k.startsWith("/") || k.equals("COMMENT") || k.startsWith("#")) {
                    this.df.setCharacterAttributes(opos, pos, atComment, true);
                } else {
                    int com;
                    int keyLen;
                    boolean flagPDS;
                    boolean bl = flagPDS = this instanceof FrameHeaderPDS || this instanceof FrameHipsProperties;
                    if (flagPDS) {
                        keyLen = s.indexOf(61, opos);
                        if (keyLen > opos && (pos == -1 || keyLen <= pos)) {
                            this.df.setCharacterAttributes(opos, keyLen, atKey, true);
                            this.df.setCharacterAttributes(keyLen + 1, pos, atValue, true);
                        }
                    } else if (k.equals("HIERARCH")) {
                        keyLen = s.indexOf(61, opos);
                        if (keyLen > 0) {
                            this.df.setCharacterAttributes(opos, opos + 8, atHist, true);
                            this.df.setCharacterAttributes(opos + 8, keyLen, atKey, true);
                            this.df.setCharacterAttributes(keyLen + 1, pos, atValue, true);
                            com = s.indexOf(47, keyLen);
                            if (com >= 0) {
                                this.df.setCharacterAttributes(com, pos, atCom, true);
                            }
                        }
                    } else {
                        boolean comment;
                        boolean bl2 = comment = s.indexOf(61, opos) != opos + 8;
                        if (comment) {
                            this.df.setCharacterAttributes(opos, pos, atErr, true);
                        } else {
                            this.df.setCharacterAttributes(opos, opos + 8, atKey, true);
                            this.df.setCharacterAttributes(opos + 9, pos, atValue, true);
                            com = s.indexOf(47, opos + 30);
                            if (com >= 0) {
                                this.df.setCharacterAttributes(com, pos, atCom, true);
                            }
                        }
                    }
                }
                opos = pos + 1;
            }
        } else {
            this.df.setCharacterAttributes(0, s.length() - 1, atWhite, false);
        }
        if (key.length() == 0) {
            this.clear.setEnabled(false);
            return;
        }
        this.clear.setEnabled(true);
        pos = -1;
        while ((pos = s.indexOf(key, pos + 1)) >= 0) {
            this.df.setCharacterAttributes(pos, key.length(), atYellow, false);
        }
        pos = -1;
        int firstPos = -1;
        while ((pos = s.indexOf(key, pos + 1)) >= 0) {
            this.df.setCharacterAttributes(pos, key.length(), atYellow, false);
            if (firstPos != -1) continue;
            firstPos = pos;
        }
        if (firstPos != -1) {
            this.ta.setCaretPosition(firstPos);
        }
    }

    protected void save() {
        String s = this.ta.getText();
        try {
            this.applyThisHeader(s);
        }
        catch (Exception e) {
            Aladin.error(this, "Not a valid FITS header: " + e.getMessage());
            return;
        }
        if (!Aladin.confirmation(this, SAVEINFO)) {
            return;
        }
        this.plan.aladin.save(this.plan.aladin.EXPORT);
    }

    private void applyThisHeader(String s) throws Exception {
        this.setOriginalHeaderFits(null);
        this.headerFits = new HeaderFits(s, this);
        if (this.plan != null) {
            Calib c = new Calib(this.headerFits);
            this.plan.projd = new Projection(2, c);
            this.plan.setHasSpecificCalib();
            this.plan.aladin.view.newView(1);
            this.plan.aladin.view.repaintAll();
        }
        this.ta.setText(this.getOriginalHeaderFits());
        this.search("");
    }

    protected String getOriginalHeaderFits() {
        return this.headerFits.getOriginalHeaderFits();
    }

    protected void setOriginalHeaderFits(String s) {
        this.headerFits.setOriginalHeaderFits(s);
    }

    public void appendMHF(String s) {
        this.headerFits.appendMHF(s);
    }

    protected void cancel() {
        try {
            this.applyThisHeader(this.originalHeader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateWidgets() {
        if (this.originalHeader == null) {
            return;
        }
        this.isEdited = true;
        if (this.cancel != null) {
            this.cancel.setEnabled(!this.originalHeader.equals(this.ta.getText()));
        }
        if (this.save != null) {
            this.save.setEnabled(!this.originalHeader.equals(this.ta.getText()));
        }
    }

    public void makeTA(boolean savable) {
        this.makeTA(savable, 600, 600);
    }

    public void makeTA(boolean savable, int width, int height) {
        JButton b;
        this.df = new DefaultStyledDocument();
        this.ta = new JTextPane(this.df);
        this.ta.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FrameHeaderFits.this.updateWidgets();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FrameHeaderFits.this.updateWidgets();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FrameHeaderFits.this.updateWidgets();
            }
        });
        this.ta.setFont(Aladin.COURIER);
        this.ta.setEditable(savable);
        JScrollPane sc = new JScrollPane(this.ta, 20, 30);
        sc.setPreferredSize(new Dimension(width, height));
        JPanel p = new JPanel();
        this.ts = new JTextField(10);
        this.ts.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String s = ((JTextField)e.getSource()).getText();
                FrameHeaderFits.this.search(s);
            }
        });
        try {
            p.add(Aladin.createLabel(Aladin.chaine.getString("MFSEARCHL")));
        }
        catch (Exception e1) {
            p.add(Aladin.createLabel("Search"));
        }
        p.add(this.ts);
        this.clear = b = new JButton(CLEAR);
        b.setEnabled(false);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameHeaderFits.this.ts.setText("");
                FrameHeaderFits.this.search("");
            }
        });
        p.add(new JLabel(" - "));
        this.save = b = new JButton(SAVE);
        b.setEnabled(false);
        if (savable) {
            p.add(b);
        }
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameHeaderFits.this.save();
            }
        });
        this.cancel = b = new JButton(CANCEL);
        b.setEnabled(false);
        if (savable) {
            p.add(b);
        }
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameHeaderFits.this.cancel();
            }
        });
        b = new JButton(CLOSE);
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameHeaderFits.this.setVisible(false);
            }
        });
        Aladin.makeAdd(this, sc, "Center");
        Aladin.makeAdd(this, p, "South");
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, null);
        this.setLocation(Aladin.computeLocation(this));
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.setVisible(false);
        }
        super.processWindowEvent(e);
    }

    protected void seeHeaderFits() {
        this.ta.setText(this.getOriginalHeaderFits());
        this.originalHeader = this.ta.getText();
        this.isEdited = false;
        this.ta.setCaretPosition(0);
        this.ts.requestFocusInWindow();
        this.first = true;
        this.search("");
        this.pack();
        this.setVisible(true);
    }

    protected int getSizeHeader() {
        return this.headerFits.getSizeHeader();
    }

    protected boolean hasKey(String key) {
        return this.headerFits.hasKey(key);
    }

    protected int getIntFromHeader(String key) throws NumberFormatException, NullPointerException {
        return this.headerFits.getIntFromHeader(key);
    }

    protected void setKeyword(String key, String value) {
        this.headerFits.setKeyword(key, value);
    }

    protected double getDoubleFromHeader(String key) throws NumberFormatException, NullPointerException {
        return this.headerFits.getDoubleFromHeader(key);
    }

    protected String getStringFromHeader(String key) throws NullPointerException {
        return this.headerFits.getStringFromHeader(key);
    }

    protected void setToHeader(String key, String value) {
        this.headerFits.setToHeader(key, value);
    }

    protected void setKeyValue(String key, String value) {
        this.headerFits.setKeyValue(key, value);
    }

    protected void writeHeader(OutputStream os) throws Exception {
        this.headerFits.writeHeader(os);
    }

    static {
        atKey = null;
    }
}

