/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinData;
import cds.aladin.Coord;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Kernel;
import cds.aladin.KernelList;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import cds.aladin.prop.PropPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public final class FrameConvolution
extends FrameRGBBlink {
    String TITLE;
    String INFO;
    String HELP1;
    String FWHM;
    String SIGMA;
    String RADIUS;
    String PIXRES;
    String PLANE;
    String KERNEL;
    String GAUSSIAN;
    JTextField pixres;
    JTextField fwhm;
    JTextField sigma;
    JTextField radius;
    JRadioButton gaussian;
    JRadioButton kernels;
    JComboBox comboKernel;
    JButton show;
    private boolean lockRadius = false;
    private double res = 2.777777777777778E-4;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("CONVTITLE");
        this.INFO = Aladin.chaine.getString("CONVINFO");
        this.HELP1 = Aladin.chaine.getString("CONVHELP");
        this.PIXRES = Aladin.chaine.getString("CONVPIXRES");
        this.FWHM = "FWHM";
        this.SIGMA = "or   Sigma";
        this.RADIUS = Aladin.chaine.getString("CONVRADIUS");
        this.KERNEL = Aladin.chaine.getString("CONVKERNEL");
        this.GAUSSIAN = Aladin.chaine.getString("CONVGAUSSIAN");
        this.PLANE = Aladin.chaine.getString("ARITHPLANE");
    }

    protected FrameConvolution(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected String getLabelSelector(int i) {
        return this.PLANE;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 1;
    }

    @Override
    protected JButton[] getAddButtons() {
        this.show = new JButton("Show");
        JButton[] tb = new JButton[]{this.show};
        this.show.setEnabled(false);
        tb[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameConvolution.this.showKernel((PlanImage)FrameConvolution.this.getPlan(FrameConvolution.this.ch[0]));
            }
        });
        return tb;
    }

    protected PlanImage[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlans(1);
        if (v == null) {
            return new PlanImage[0];
        }
        Object[] pi = new PlanImage[v.size()];
        v.copyInto(pi);
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        ButtonGroup bg = new ButtonGroup();
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 0;
        c.gridwidth = 0;
        c.weightx = 10.0;
        JPanel p = new JPanel();
        p.setLayout(g);
        PropPanel.addFilet(p, g, c, 15, 0);
        c.anchor = 13;
        JRadioButton r = this.gaussian = new JRadioButton(this.GAUSSIAN, true);
        r.setFont(r.getFont().deriveFont(1));
        g.setConstraints(r, c);
        p.add(r);
        bg.add(r);
        c.anchor = 10;
        JPanel pp = new JPanel(new GridLayout(2, 4, 5, 5));
        pp.add(new JLabel(this.FWHM, 4));
        this.fwhm = new JTextField(5);
        pp.add(this.fwhm);
        pp.add(new JLabel(this.SIGMA, 4));
        this.sigma = new JTextField(5);
        pp.add(this.sigma);
        pp.add(new JLabel(this.PIXRES, 4));
        this.pixres = new JTextField(5);
        pp.add(this.pixres);
        this.pixres.setEditable(false);
        pp.add(new JLabel(this.RADIUS, 4));
        this.radius = new JTextField(5);
        pp.add(this.radius);
        this.fwhm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameConvolution.this.gaussian.setSelected(true);
                FrameConvolution.this.lockRadius = false;
                FrameConvolution.this.radius.setText("");
                FrameConvolution.this.sigma.setText("");
                FrameConvolution.this.show.setEnabled(true);
                FrameConvolution.this.adjustWidgets();
            }
        });
        this.fwhm.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                FrameConvolution.this.radius.setText("");
                FrameConvolution.this.sigma.setText("");
            }
        });
        this.sigma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameConvolution.this.gaussian.setSelected(true);
                FrameConvolution.this.lockRadius = false;
                FrameConvolution.this.radius.setText("");
                FrameConvolution.this.show.setEnabled(true);
                FrameConvolution.this.fwhm.setText("");
                FrameConvolution.this.adjustWidgets();
            }
        });
        this.sigma.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                FrameConvolution.this.radius.setText("");
                FrameConvolution.this.fwhm.setText("");
            }
        });
        this.radius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameConvolution.this.gaussian.setSelected(true);
                FrameConvolution.this.lockRadius = true;
                FrameConvolution.this.adjustWidgets();
            }
        });
        this.radius.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                FrameConvolution.this.lockRadius = true;
            }
        });
        g.setConstraints(pp, c);
        p.add(pp);
        PropPanel.addFilet(p, g, c, 10, 0);
        c.anchor = 13;
        r = this.kernels = new JRadioButton(this.KERNEL);
        r.setFont(r.getFont().deriveFont(1));
        g.setConstraints(r, c);
        p.add(r);
        bg.add(r);
        c.anchor = 10;
        c.fill = 0;
        this.comboKernel = new JComboBox<String>(this.a.kernelList.getKernelListAsVector());
        this.comboKernel.setMinimumSize(new Dimension(200, this.comboKernel.getPreferredSize().height));
        this.comboKernel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameConvolution.this.kernels.setSelected(true);
                FrameConvolution.this.show.setEnabled(true);
            }
        });
        g.setConstraints(this.comboKernel, c);
        p.add(this.comboKernel);
        PropPanel.addFilet(p, g, c, 15, 0);
        return p;
    }

    public void reloadComboKernel(String item) {
        boolean g = this.gaussian.isSelected();
        String c = item == null ? (String)this.comboKernel.getSelectedItem() : item;
        this.comboKernel.removeAllItems();
        Enumeration<String> e = this.a.kernelList.getKernelListAsVector().elements();
        while (e.hasMoreElements()) {
            this.comboKernel.addItem(e.nextElement());
        }
        if (c != null) {
            this.comboKernel.setSelectedItem(c);
        }
        this.gaussian.setSelected(g);
    }

    private void showKernel(PlanImage p) {
        try {
            String conv = this.getConvCmd();
            Kernel k = this.a.kernelList.getKernel(conv, this.res);
            AladinData ad = this.a.createAladinImage(k.name);
            String name = ad.getLabel();
            ad.setPixels(k.matrix, -64);
            if (!p.hasNoReduction()) {
                double cd = p.projd.getPixResAlpha();
                Coord c = new Coord(this.a.view.repere.raj, this.a.view.repere.dej);
                int n = k.matrix.length;
                String s = "SIMPLE  = T\nBITPIX  = -64\nNAXIS   = 2\nNAXIS1  = " + n + "\n" + "NAXIS2  = " + n + "\n" + "CRPIX1  = " + (n / 2 + 1) + "\n" + "CRPIX2  = " + (n / 2 + 1) + "\n" + "CRVAL1  = " + c.al + "\n" + "CRVAL2  = " + c.del + "\n" + "CTYPE1  = RA---TAN\n" + "CTYPE2  = DEC--TAN\n" + "RADECSYS= FK5\n" + "CD1_1   = " + -cd + "\n" + "CD1_2   = 0\n" + "CD2_1   = 0\n" + "CD2_2   = " + cd + "\n";
                ad.setFitsHeader(s);
                this.a.command.execNow("set " + name + " opacity=75");
                this.a.command.execNow("set " + name + " shown");
                this.a.command.execNow("cm " + name + " asinh reverse autocut");
            } else {
                this.a.command.execNow("show " + name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getConvCmd() throws Exception {
        String conv = null;
        if (this.gaussian.isSelected()) {
            StringBuffer param = new StringBuffer();
            String s = this.fwhm.getText().trim();
            if (s.length() > 0) {
                if (param.length() > 0) {
                    param.append(',');
                }
                param.append("fwhm=" + s);
            } else {
                s = this.sigma.getText().trim();
                if (s.length() > 0) {
                    if (param.length() > 0) {
                        param.append(',');
                    }
                    param.append("sigma=" + s);
                }
            }
            s = this.radius.getText().trim();
            if (s.length() > 0) {
                if (param.length() > 0) {
                    param.append(',');
                }
                param.append("radius=" + s);
            }
            conv = "gauss(" + param + ")";
            double[] p = KernelList.parseGaussCmd(conv);
            p = KernelList.computeGaussParam(p[0], p[1], this.res, 0);
            this.fwhm.setText(Coord.getUnit(p[0]));
            this.sigma.setText(Coord.getUnit(p[1]));
            if (!this.lockRadius) {
                this.radius.setText("" + (int)p[2]);
            }
        } else {
            conv = (String)this.comboKernel.getSelectedItem();
        }
        return conv;
    }

    @Override
    protected void submit() {
        try {
            PlanImage p1 = (PlanImage)this.getPlan(this.ch[0]);
            String conv = this.getConvCmd();
            String label = conv.replace('=', ':');
            this.a.console.printCommand(label + "=conv " + Tok.quote(p1.label) + " " + Tok.quote(conv));
            this.a.calque.newPlanImageAlgo(label, p1, null, 6, 0.0, conv, 0);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("Convolution failed !");
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.fwhm.setText("");
        this.sigma.setText("");
        this.adjustWidgets();
        this.comboKernel.setSelectedIndex(0);
        this.gaussian.setSelected(true);
        this.show.setEnabled(false);
    }

    @Override
    protected void adjustWidgets() {
        PlanImage p1 = (PlanImage)this.getPlan(this.ch[0]);
        String resolution = "--";
        if (p1 != null) {
            try {
                this.res = p1.projd.getPixResDelta();
                resolution = Coord.getUnit(this.res);
            }
            catch (Exception e) {
                resolution = "--";
            }
        }
        boolean fwhmFlag = false;
        boolean sigmaFlag = false;
        StringBuffer param = new StringBuffer();
        String s = this.fwhm.getText().trim();
        if (s.length() > 0) {
            if (param.length() > 0) {
                param.append(',');
            }
            param.append("fwhm=" + s);
            sigmaFlag = true;
        } else {
            s = this.sigma.getText().trim();
            if (s.length() > 0) {
                if (param.length() > 0) {
                    param.append(',');
                }
                param.append("sigma=" + s);
                fwhmFlag = true;
            }
        }
        s = this.radius.getText().trim();
        if (s.length() > 0) {
            if (param.length() > 0) {
                param.append(',');
            }
            param.append("radius=" + s);
        } else {
            this.lockRadius = false;
        }
        if (param.length() > 0) {
            double[] p = KernelList.parseGaussCmd("gauss(" + param + ")");
            p = KernelList.computeGaussParam(p[0], p[1], this.res, 0);
            if (!this.lockRadius) {
                this.radius.setText("" + (int)p[2]);
            }
            if (sigmaFlag) {
                this.sigma.setText(Coord.getUnit(p[1]));
            } else if (fwhmFlag) {
                this.fwhm.setText(Coord.getUnit(p[0]));
            }
        } else {
            this.radius.setText("");
        }
        this.pixres.setText(resolution);
    }
}

