/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ColumnCalculator;
import cds.aladin.FilterProperties;
import cds.aladin.MetaDataTree;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Source;
import cds.savot.model.SavotField;
import cds.tools.Util;
import cds.tools.parser.Parser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FrameColumnCalculator
extends JFrame
implements ActionListener {
    private static String TITLE;
    private static String ADDCOL;
    private static String ADDNEW;
    private static String NAME;
    private static String UNIT;
    private static String DECI;
    private static String KEEP;
    private static String EXPR;
    private static String NOEXPR;
    private static String COL;
    private static String CREATIONOK;
    private static String PICKNAME;
    private static String PICKOP;
    private static String FUNCT;
    private static String NEEDNAME;
    private static String ALLREADYEXIST;
    private static String ERROR;
    private static String CLOSE;
    protected static String[] OPERATORS;
    private static final Insets BUTTON_INSETS;
    private Plan pc;
    private JButton[] buttons;
    private JTextField nameTF;
    private JTextField ucdTF;
    private JTextField unitTF;
    private JTextArea expressionTA;
    private JComboBox nbDecChoice;
    private Vector vCol;
    private JComboBox funcChoice;
    private Aladin a;

    public FrameColumnCalculator(Aladin a) {
        this.a = a;
        Aladin.setIcon(this);
        this.getContentPane().setLayout(new BorderLayout());
        Util.setCloseShortcut(this, true, a);
        this.setLocation(Aladin.computeLocation(this));
    }

    protected void createChaine() {
        if (TITLE != null) {
            return;
        }
        TITLE = Aladin.chaine.getString("CCTITLE");
        ADDCOL = Aladin.chaine.getString("CCADDCOL");
        ADDNEW = Aladin.chaine.getString("CCADDNEW");
        NAME = Aladin.chaine.getString("CCNAME");
        UNIT = Aladin.chaine.getString("CCUNIT");
        DECI = Aladin.chaine.getString("CCDECI");
        KEEP = Aladin.chaine.getString("CCKEEP");
        EXPR = Aladin.chaine.getString("CCEXPR");
        PICKNAME = Aladin.chaine.getString("CCPICKNAME");
        PICKOP = Aladin.chaine.getString("CCPICKOP");
        FUNCT = Aladin.chaine.getString("CCFUNCT");
        NEEDNAME = Aladin.chaine.getString("CCNEEDNAME");
        NOEXPR = Aladin.chaine.getString("CCNOEXPR");
        ALLREADYEXIST = Aladin.chaine.getString("CCALLREADYEXIST");
        ERROR = Aladin.chaine.getString("ERROR");
        CLOSE = Aladin.chaine.getString("CLOSE");
        COL = Aladin.chaine.getString("CCCOL");
        CREATIONOK = Aladin.chaine.getString("CCCREATIONOK");
        this.setTitle(TITLE);
    }

    protected void update(Plan pc) {
        this.pc = pc;
        this.createChaine();
        this.vCol = null;
        this.getContentPane().removeAll();
        this.buildFrame();
    }

    private void buildFrame() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        JPanel topPanel = this.topPanel();
        p.add(topPanel);
        JPanel pButtons = this.createButtons();
        p.add(pButtons);
        JPanel funcPanel = this.funcPanel();
        p.add(funcPanel);
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, ADDNEW + " " + this.pc.label, 2, 2), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.bottomPanel(), "South");
        this.pack();
    }

    private JPanel topPanel() {
        JPanel p = new JPanel();
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        p.setLayout(g);
        c.anchor = 17;
        this.nameTF = new JTextField(20);
        JLabel lName = new JLabel(NAME);
        lName.setFont(Aladin.BOLD);
        FilterProperties.addCouple(p, lName, this.nameTF, g, c);
        this.ucdTF = new JTextField(20);
        FilterProperties.addCouple(p, "UCD", this.ucdTF, g, c);
        this.unitTF = new JTextField(20);
        FilterProperties.addCouple(p, UNIT, this.unitTF, g, c);
        this.nbDecChoice = new JComboBox();
        this.nbDecChoice.setFont(Aladin.PLAIN);
        for (int i = 1; i < 13; ++i) {
            this.nbDecChoice.addItem(i + "");
        }
        this.nbDecChoice.setSelectedIndex(3);
        JPanel pDec = new JPanel(new FlowLayout(1, 0, 2));
        pDec.add(this.nbDecChoice);
        JLabel decLabel = new JLabel(" " + DECI);
        decLabel.setFont(Aladin.ITALIC);
        pDec.add(decLabel);
        FilterProperties.addCouple(p, KEEP, pDec, g, c);
        this.expressionTA = new JTextArea("", 5, 35);
        this.expressionTA.setLineWrap(true);
        this.expressionTA.setWrapStyleWord(true);
        this.expressionTA.setFont(Aladin.COURIER);
        JLabel lExp = new JLabel(EXPR);
        lExp.setFont(Aladin.BOLD);
        c.gridwidth = -1;
        g.setConstraints(lExp, c);
        p.add(lExp);
        JLabel lExample = new JLabel("eg: ${Bmag}-${Vmag}");
        lExample.setFont(Aladin.ITALIC);
        c.gridwidth = 0;
        c.anchor = 10;
        g.setConstraints(lExample, c);
        p.add(lExample);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JScrollPane scrollExprTA = new JScrollPane(this.expressionTA, 20, 31);
        g.setConstraints(scrollExprTA, c);
        p.add(scrollExprTA);
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 10;
        return p;
    }

    private JPanel funcPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        for (int i = 0; i < OPERATORS.length; ++i) {
            JButton b = this.createButton(OPERATORS[i]);
            b.setMaximumSize(new Dimension(30, 35));
            b.setPreferredSize(new Dimension(30, 35));
            b.setFont(Aladin.COURIER);
            p.add(b);
            p.add(Box.createHorizontalGlue());
        }
        this.funcChoice = new JComboBox();
        this.funcChoice.setFont(Aladin.PLAIN);
        this.funcChoice.addActionListener(this);
        this.funcChoice.addItem(FUNCT);
        String[] func = Parser.getAvailFunc();
        FilterProperties.sortLexico(func);
        for (int i = 0; i < func.length; ++i) {
            this.funcChoice.addItem(func[i]);
        }
        p.add(this.funcChoice);
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, PICKOP, 2, 2, Aladin.COURIER), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return p;
    }

    private JPanel bottomPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        JButton b = this.createButton(ADDCOL);
        p.add(b);
        b.setFont(Aladin.BOLD);
        b.setMargin(null);
        b = this.createButton(CLOSE);
        p.add(b);
        b.setFont(Aladin.PLAIN);
        b.setMargin(null);
        return p;
    }

    private JButton createButton(String s) {
        JButton b = new JButton(s);
        b.setMargin(BUTTON_INSETS);
        b.addActionListener(this);
        return b;
    }

    private JPanel createButtons() {
        JPanel retPanel;
        String[] columns = this.getCol(this.pc);
        int nbCol = 4;
        int maxNbRow = 5;
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(0, nbCol, 3, 3));
        this.buttons = new JButton[columns.length];
        boolean needScroll = columns.length > nbCol * maxNbRow;
        int maxWidth = 0;
        FontMetrics fm = null;
        if (needScroll) {
            fm = Toolkit.getDefaultToolkit().getFontMetrics(Aladin.PLAIN);
        }
        for (int i = columns.length - 1; i >= 0; --i) {
            int tmp;
            this.buttons[i] = this.createButton(columns[i]);
            this.buttons[i].setFont(Aladin.PLAIN);
            if (needScroll && (tmp = fm.stringWidth(columns[i])) > maxWidth) {
                maxWidth = tmp;
            }
            p.add(this.buttons[i]);
        }
        if (needScroll) {
            JScrollPane sp = new JScrollPane(p, 20, 31);
            sp.setPreferredSize(new Dimension((maxWidth + 20) * nbCol + 40, 140));
            JPanel newPanel = new JPanel();
            newPanel.add(sp);
            retPanel = newPanel;
        } else {
            retPanel = p;
        }
        retPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, PICKNAME, 2, 2, Aladin.COURIER), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return retPanel;
    }

    private String[] getCol(Plan p) {
        if (this.vCol == null) {
            this.vCol = new Vector();
            Iterator<Obj> it = p.iterator();
            while (it.hasNext()) {
                Obj o = it.next();
                if (!(o instanceof Source)) continue;
                Source s = (Source)o;
                for (int k = s.getLeg().field.length - 1; k >= 0; --k) {
                    String str = s.getLeg().field[k].name;
                    if (this.vCol.indexOf(str) >= 0) continue;
                    this.vCol.addElement(str);
                }
            }
        }
        Object[] result = new String[this.vCol.size()];
        this.vCol.copyInto(result);
        return result;
    }

    protected static String[] getCol(Plan p, Vector v) {
        v = new Vector<String>();
        Iterator<Obj> it = p.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Source)) continue;
            Source s = (Source)o;
            for (int k = s.getLeg().field.length - 1; k >= 0; --k) {
                String str = s.getLeg().field[k].name;
                if (v.indexOf(str) >= 0) continue;
                v.addElement(str);
            }
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        String what = ae.getActionCommand();
        if (what.equals(CLOSE)) {
            this.setVisible(false);
        } else if (what.equals(ADDCOL)) {
            this.addColumn();
        } else if (src.equals(this.funcChoice)) {
            int index = this.funcChoice.getSelectedIndex();
            if (index > 0) {
                int pos = FilterProperties.insertInTA(this.expressionTA, this.funcChoice.getItemAt(index).toString() + "()", this.expressionTA.getCaretPosition());
                this.expressionTA.setCaretPosition(pos - 1);
                this.expressionTA.requestFocus();
                this.funcChoice.setSelectedIndex(0);
            }
        } else if (src instanceof JButton) {
            String btnLabel = ((JButton)src).getText();
            if (this.vCol.contains(btnLabel)) {
                FilterProperties.insertInTA(this.expressionTA, "${" + btnLabel + "}", this.expressionTA.getCaretPosition());
            } else {
                FilterProperties.insertInTA(this.expressionTA, btnLabel, this.expressionTA.getCaretPosition());
            }
            this.expressionTA.requestFocus();
        }
    }

    private void addColumn() {
        int nbDec;
        String name = this.nameTF.getText();
        String ucd = this.ucdTF.getText();
        String unit = this.unitTF.getText();
        String expr = MetaDataTree.replace(MetaDataTree.replace(this.expressionTA.getText(), "\n", "", -1), "\r", "", -1);
        try {
            nbDec = Integer.parseInt(this.nbDecChoice.getSelectedItem().toString());
        }
        catch (NumberFormatException e) {
            nbDec = 4;
        }
        if (name.length() == 0) {
            Aladin.error(this, NEEDNAME, 1);
            return;
        }
        if (expr.length() == 0) {
            Aladin.error(this, NOEXPR, 1);
            return;
        }
        if (this.colExist(name)) {
            Aladin.error(this, ALLREADYEXIST + name + "]");
            return;
        }
        Aladin.trace(3, "expr is : " + expr);
        SavotField f = new SavotField();
        f.setName(name);
        f.setUcd(ucd);
        f.setUnit(unit);
        this.a.console.printCommand("addcol " + this.pc.label + "," + name + "," + expr + "," + unit + "," + ucd + "," + nbDec);
        ColumnCalculator cc = new ColumnCalculator(new SavotField[]{f}, new String[]{expr}, this.pc, nbDec, this.a);
        if (!cc.createParser()) {
            Aladin.error(this, ERROR + " : " + cc.getError(), 1);
            return;
        }
        cc.compute();
        Aladin.info(COL + " '" + name + "' " + CREATIONOK);
        this.setVisible(false);
    }

    private boolean colExist(String s) {
        String[] noms = this.getCol(this.pc);
        return Util.indexInArrayOf(s, noms) >= 0;
    }

    protected static boolean colExist(String s, Plan p) {
        String[] noms = FrameColumnCalculator.getCol(p, new Vector());
        return Util.indexInArrayOf(s, noms) >= 0;
    }

    static {
        OPERATORS = new String[]{"+", "-", "*", "/", "^", "(", ")"};
        BUTTON_INSETS = new Insets(1, 2, 1, 2);
    }
}

