/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CDSXMatch;
import cds.aladin.ColFilter;
import cds.aladin.Legende;
import cds.aladin.MyButton;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class FrameCDSXMatch
extends JFrame
implements Runnable,
ActionListener {
    static final String ADVANCED_OPTIONS = "Advanced options";
    static final String POS_XMATCH_ELLIPSES = "Ellipses";
    static String TITRE;
    static String CLOSE;
    static String XMATCH;
    static String POS_XMATCH;
    static String CROSS_ID;
    static String ONLYPOS;
    static String THRESHOLD;
    static String THRESHOLD1;
    static String CHOOSEMATCH;
    static String BESTMATCH;
    static String ALLMATCH;
    static String NOMATCH;
    static String JOIN;
    static String XID;
    static String ERR1;
    static String ERR2;
    static final String[] LIST_UCD_MAJOR_AXIS;
    static final String[] LIST_UCD_MINOR_AXIS;
    static final String[] LIST_UCD_PA;
    static final String[] xmatchNames;
    Aladin aladin;
    JCheckBox allMatch;
    JCheckBox bestMatch;
    JCheckBox noMatch;
    JCheckBox ellAllMatch;
    JCheckBox ellBestMatch;
    JCheckBox ellNoMatch;
    JTabbedPane tabbedPane;
    JComboBox RAChoiceA;
    JComboBox RAChoiceB;
    JComboBox DEChoiceA;
    JComboBox DEChoiceB;
    JComboBox XIDChoiceA;
    JComboBox XIDChoiceB;
    JComboBox ellRAChoiceA;
    JComboBox ellRAChoiceB;
    JComboBox ellDEChoiceA;
    JComboBox ellDEChoiceB;
    JComboBox ellMAChoiceA;
    JComboBox ellMAChoiceB;
    JComboBox ellMIChoiceA;
    JComboBox ellMIChoiceB;
    JComboBox ellPAChoiceA;
    JComboBox ellPAChoiceB;
    JTextField minDist;
    JTextField maxDist;
    JTextField nbSigmaMin;
    JTextField nbSigmaMax;
    JComboBox labelAXMatch;
    JComboBox labelBXMatch;
    JComboBox labelAXID;
    JComboBox labelBXID;
    JComboBox ellLabelA;
    JComboBox ellLabelB;
    Thread runme;
    JPanel xIDOptionsP;
    private OptionFrame optionFrame;
    Plan[] cats;
    String memPlanA;
    String memPlanB;
    private static String[] tabbedPaneComponents;
    ColFilter colFilterT;
    Plan p1T;
    Plan p2T;
    String labelT;
    double[] seuilsT;
    int index1T;
    int index2T;
    int[] coordTab1T;
    int[] coordTab2T;
    int[] ellipseParam1T;
    int[] ellipseParam2T;
    int methodeT;
    int typeT;

    protected void createChaine() {
        TITRE = Aladin.chaine.getString("XMTITRE");
        CLOSE = Aladin.chaine.getString("CLOSE");
        XMATCH = Aladin.chaine.getString("XMXMATCH");
        POS_XMATCH = Aladin.chaine.getString("XMPOS_XMATCH");
        CROSS_ID = Aladin.chaine.getString("XMCROSS_ID");
        ONLYPOS = Aladin.chaine.getString("XMONLYPOS");
        THRESHOLD = Aladin.chaine.getString("XMTHRESHOLD");
        THRESHOLD1 = Aladin.chaine.getString("XMTHRESHOLD1");
        CHOOSEMATCH = Aladin.chaine.getString("XMCHOOSEMATCH");
        BESTMATCH = Aladin.chaine.getString("XMBESTMATCH");
        ALLMATCH = Aladin.chaine.getString("XMALLMATCH");
        NOMATCH = Aladin.chaine.getString("XMNOMATCH");
        JOIN = Aladin.chaine.getString("XMJOIN");
        XID = Aladin.chaine.getString("XMXID");
        ERR1 = Aladin.chaine.getString("XMERR1");
        ERR2 = Aladin.chaine.getString("XMERR2");
        String[] tab = new String[]{POS_XMATCH, CROSS_ID, POS_XMATCH_ELLIPSES};
        tabbedPaneComponents = tab;
    }

    public FrameCDSXMatch(Aladin aladin) {
        Aladin.setIcon(this);
        this.aladin = aladin;
        this.createChaine();
        this.setTitle(TITRE);
        Util.setCloseShortcut(this, false, aladin);
        this.setLocation(Aladin.computeLocation(this));
    }

    private void buildFrame() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.memPlanB = null;
        this.memPlanA = null;
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        JPanel p = new JPanel();
        p.setLayout(g);
        JLabel titre = new JLabel(TITRE, 0);
        titre.setFont(Aladin.LBOLD);
        g.setConstraints(titre, c);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(POS_XMATCH, this.posXMatchPanel());
        this.tabbedPane.addTab(CROSS_ID, this.posXIDPanel());
        this.tabbedPane.addTab(POS_XMATCH_ELLIPSES, this.posXMatchEllipsesPanel());
        g.setConstraints(this.tabbedPane, c);
        p.add(this.tabbedPane);
        this.populateChoicesWithPlanes();
        g.setConstraints(this.tabbedPane, c);
        p.add(this.tabbedPane);
        this.initComboBoxes();
        this.getContentPane().add((Component)p, "Center");
        JPanel bottomPanel = this.bottomPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pack();
    }

    protected void update() {
        this.buildFrame();
        this.setVisible(true);
        this.toFront();
    }

    private JPanel bottomPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        JButton b = new JButton(ADVANCED_OPTIONS);
        p.add(b);
        b.addActionListener(this);
        b = new JButton(XMATCH);
        b.addActionListener(this);
        b.setFont(Aladin.BOLD);
        p.add(b);
        b = new JButton(CLOSE);
        p.add(b);
        b.addActionListener(this);
        return p;
    }

    private void initComboBoxes() {
        if (this.cats.length > 0) {
            Plan pc = this.cats[0];
            this.memPlanA = pc.label;
            this.populateRADECChoices(this.RAChoiceA, this.DEChoiceA, pc, true);
            this.labelAXMatch.setSelectedItem(pc.label);
            this.populateRADECChoices(this.XIDChoiceA, null, pc, false);
            this.labelAXID.setSelectedItem(pc.label);
            this.populateRADECChoices(this.ellRAChoiceA, this.ellDEChoiceA, pc, true);
            this.populateChoice(this.ellMAChoiceA, pc, LIST_UCD_MAJOR_AXIS);
            this.populateChoice(this.ellMIChoiceA, pc, LIST_UCD_MINOR_AXIS);
            this.populateChoice(this.ellPAChoiceA, pc, LIST_UCD_PA);
            this.ellLabelA.setSelectedItem(pc.label);
            pc = this.cats.length > 1 ? this.cats[1] : this.cats[0];
            this.memPlanB = pc.label;
            this.populateRADECChoices(this.RAChoiceB, this.DEChoiceB, pc, true);
            this.labelBXMatch.setSelectedItem(pc.label);
            this.populateRADECChoices(this.XIDChoiceB, null, pc, false);
            this.labelBXID.setSelectedItem(pc.label);
            this.populateRADECChoices(this.ellRAChoiceB, this.ellDEChoiceB, pc, true);
            this.populateChoice(this.ellMAChoiceB, pc, LIST_UCD_MAJOR_AXIS);
            this.populateChoice(this.ellMIChoiceB, pc, LIST_UCD_MINOR_AXIS);
            this.populateChoice(this.ellPAChoiceB, pc, LIST_UCD_PA);
            this.ellLabelB.setSelectedItem(pc.label);
        }
    }

    private JPanel posXMatchPanel() {
        this.labelAXMatch = new JComboBox();
        this.labelAXMatch.addActionListener(this);
        this.labelAXMatch.setFont(Aladin.BOLD);
        this.labelBXMatch = new JComboBox();
        this.labelBXMatch.addActionListener(this);
        this.labelBXMatch.setFont(Aladin.BOLD);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, POS_XMATCH, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        p.setLayout(g);
        c.anchor = 10;
        c.insets = new Insets(3, 3, 3, 3);
        JLabel explain = new JLabel(ONLYPOS, 0);
        g.setConstraints(explain, c);
        p.add(explain);
        GridBagLayout gg = new GridBagLayout();
        GridBagConstraints d = new GridBagConstraints();
        d.gridwidth = 1;
        d.gridheight = 1;
        d.fill = 0;
        d.insets = new Insets(0, 3, 0, 3);
        JPanel xMatchOptionsP = new JPanel();
        xMatchOptionsP.setLayout(gg);
        JComponent[][] components = new JComponent[2][6];
        components[0][0] = this.labelAXMatch;
        components[1][0] = this.labelBXMatch;
        components[0][1] = new JLabel("");
        components[1][1] = new JLabel("");
        components[0][2] = new JLabel("RA");
        components[1][2] = new JLabel("RA");
        this.RAChoiceA = new JComboBox();
        this.RAChoiceB = new JComboBox();
        components[0][3] = this.RAChoiceA;
        components[1][3] = this.RAChoiceB;
        components[0][4] = new JLabel("DEC");
        components[1][4] = new JLabel("DEC");
        this.DEChoiceA = new JComboBox();
        this.DEChoiceB = new JComboBox();
        components[0][5] = this.DEChoiceA;
        components[1][5] = this.DEChoiceB;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 6; ++j) {
                d.gridx = j;
                d.gridy = i;
                d.anchor = j == 0 ? 17 : 13;
                d.fill = components[i][j] instanceof JComboBox ? 2 : 0;
                gg.setConstraints(components[i][j], d);
                xMatchOptionsP.add(components[i][j]);
            }
        }
        c.anchor = 17;
        g.setConstraints(xMatchOptionsP, c);
        p.add(xMatchOptionsP);
        JPanel xMatchOptionsP2 = new JPanel();
        GridBagLayout g2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 0;
        xMatchOptionsP2.setLayout(g2);
        JLabel threshExplain = new JLabel(THRESHOLD, 0);
        c2.gridwidth = 0;
        c2.anchor = 10;
        g2.setConstraints(threshExplain, c2);
        xMatchOptionsP2.add(threshExplain);
        JPanel distPanel = new JPanel();
        distPanel.setLayout(new FlowLayout(1));
        this.minDist = new JTextField("0", 4);
        distPanel.add(this.minDist);
        distPanel.add(new JLabel(THRESHOLD1));
        this.maxDist = new JTextField("4", 4);
        distPanel.add(this.maxDist);
        c2.gridwidth = 0;
        g2.setConstraints(distPanel, c2);
        xMatchOptionsP2.add(distPanel);
        JLabel method = new JLabel(CHOOSEMATCH);
        method.setFont(Aladin.BOLD);
        g2.setConstraints(method, c2);
        xMatchOptionsP2.add(method);
        c2.anchor = 17;
        c2.insets = new Insets(0, 40, 0, 0);
        this.bestMatch = new JCheckBox(BESTMATCH);
        this.bestMatch.addActionListener(this);
        this.bestMatch.setSelected(true);
        g2.setConstraints(this.bestMatch, c2);
        xMatchOptionsP2.add(this.bestMatch);
        this.allMatch = new JCheckBox(ALLMATCH);
        this.allMatch.addActionListener(this);
        g2.setConstraints(this.allMatch, c2);
        xMatchOptionsP2.add(this.allMatch);
        this.noMatch = new JCheckBox(NOMATCH);
        this.noMatch.addActionListener(this);
        g2.setConstraints(this.noMatch, c2);
        xMatchOptionsP2.add(this.noMatch);
        c.anchor = 10;
        g.setConstraints(xMatchOptionsP2, c);
        p.add(xMatchOptionsP2);
        return p;
    }

    private ColFilter getColFilter() {
        if (this.optionFrame == null) {
            return null;
        }
        this.optionFrame.saveValues();
        Field[] field1 = this.getSelectedFields(this.optionFrame.col1);
        Field[] field2 = this.getSelectedFields(this.optionFrame.col2);
        return new ColFilter(field1, field2, this.optionFrame.prefix1, this.optionFrame.prefix2, this.optionFrame.suffix1, this.optionFrame.suffix2);
    }

    private Field[] getSelectedFields(ColButton[] col) {
        Vector<Field> v = new Vector<Field>();
        for (int i = 0; i < col.length; ++i) {
            if (col[i].mode != -1) continue;
            v.addElement(col[i].field);
        }
        Object[] f = new Field[v.size()];
        v.copyInto(f);
        v = null;
        return f;
    }

    private JPanel posXMatchEllipsesPanel() {
        this.ellLabelA = new JComboBox();
        this.ellLabelA.addActionListener(this);
        this.ellLabelA.setFont(Aladin.BOLD);
        this.ellLabelB = new JComboBox();
        this.ellLabelB.addActionListener(this);
        this.ellLabelB.setFont(Aladin.BOLD);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, POS_XMATCH_ELLIPSES, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        p.setLayout(g);
        c.anchor = 10;
        c.insets = new Insets(3, 3, 3, 3);
        JLabel explain = new JLabel("Only positional offset is used to find the matches.", 0);
        g.setConstraints(explain, c);
        p.add(explain);
        GridBagLayout gg = new GridBagLayout();
        GridBagConstraints d = new GridBagConstraints();
        d.gridwidth = 1;
        d.gridheight = 1;
        d.fill = 0;
        d.insets = new Insets(0, 3, 0, 3);
        JPanel xMatchOptionsP = new JPanel();
        xMatchOptionsP.setLayout(gg);
        JComponent[][] components = new JComponent[4][6];
        JLabel l = new JLabel("Catalogue A");
        l.setFont(Aladin.BOLD);
        components[0][0] = l;
        l = new JLabel("Catalogue B");
        l.setFont(Aladin.BOLD);
        components[2][0] = l;
        components[0][1] = this.ellLabelA;
        components[2][1] = this.ellLabelB;
        components[0][2] = new JLabel("RA");
        components[2][2] = new JLabel("RA");
        this.ellRAChoiceA = new JComboBox();
        this.ellRAChoiceB = new JComboBox();
        components[0][3] = this.ellRAChoiceA;
        components[2][3] = this.ellRAChoiceB;
        components[0][4] = new JLabel("DEC");
        components[2][4] = new JLabel("DEC");
        this.ellDEChoiceA = new JComboBox();
        this.ellDEChoiceB = new JComboBox();
        components[0][5] = this.ellDEChoiceA;
        components[2][5] = this.ellDEChoiceB;
        components[1][0] = new JLabel("Maj. axis");
        components[3][0] = new JLabel("Maj. axis");
        this.ellMAChoiceA = new JComboBox();
        this.ellMAChoiceB = new JComboBox();
        components[1][1] = this.ellMAChoiceA;
        components[3][1] = this.ellMAChoiceB;
        components[1][2] = new JLabel("Min. axis");
        components[3][2] = new JLabel("Min. axis");
        this.ellMIChoiceA = new JComboBox();
        this.ellMIChoiceB = new JComboBox();
        components[1][3] = this.ellMIChoiceA;
        components[3][3] = this.ellMIChoiceB;
        components[1][4] = new JLabel("PA");
        components[3][4] = new JLabel("PA");
        this.ellPAChoiceA = new JComboBox();
        this.ellPAChoiceB = new JComboBox();
        components[1][5] = this.ellPAChoiceA;
        components[3][5] = this.ellPAChoiceB;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 6; ++j) {
                d.gridx = j;
                d.gridy = i;
                d.anchor = j == 0 ? 17 : 13;
                d.fill = components[i][j] instanceof JComboBox ? 2 : 0;
                gg.setConstraints(components[i][j], d);
                xMatchOptionsP.add(components[i][j]);
            }
        }
        c.anchor = 17;
        g.setConstraints(xMatchOptionsP, c);
        p.add(xMatchOptionsP);
        JPanel xMatchOptionsP2 = new JPanel();
        GridBagLayout g2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 0;
        xMatchOptionsP2.setLayout(g2);
        JLabel threshExplain = new JLabel("Number of sigmas threshold", 0);
        c2.gridwidth = 0;
        c2.anchor = 10;
        g2.setConstraints(threshExplain, c2);
        xMatchOptionsP2.add(threshExplain);
        JPanel distPanel = new JPanel();
        distPanel.setLayout(new FlowLayout(1));
        this.nbSigmaMin = new JTextField("0", 4);
        distPanel.add(this.nbSigmaMin);
        distPanel.add(new JLabel("<= nbSigmas <="));
        this.nbSigmaMax = new JTextField("3", 4);
        distPanel.add(this.nbSigmaMax);
        c2.gridwidth = 0;
        g2.setConstraints(distPanel, c2);
        xMatchOptionsP2.add(distPanel);
        JLabel method = new JLabel("Choose match method");
        method.setFont(Aladin.BOLD);
        g2.setConstraints(method, c2);
        xMatchOptionsP2.add(method);
        c2.anchor = 17;
        c2.insets = new Insets(0, 40, 0, 0);
        this.ellBestMatch = new JCheckBox("Best matches");
        this.ellBestMatch.addActionListener(this);
        this.ellBestMatch.setSelected(true);
        g2.setConstraints(this.ellBestMatch, c2);
        xMatchOptionsP2.add(this.ellBestMatch);
        this.ellAllMatch = new JCheckBox("All matches");
        this.ellAllMatch.addActionListener(this);
        g2.setConstraints(this.ellAllMatch, c2);
        xMatchOptionsP2.add(this.ellAllMatch);
        this.ellNoMatch = new JCheckBox("Sources without match");
        this.ellNoMatch.addActionListener(this);
        g2.setConstraints(this.ellNoMatch, c2);
        xMatchOptionsP2.add(this.ellNoMatch);
        c.anchor = 10;
        g.setConstraints(xMatchOptionsP2, c);
        p.add(xMatchOptionsP2);
        return p;
    }

    private JPanel posXIDPanel() {
        this.labelAXID = new JComboBox();
        this.labelAXID.addActionListener(this);
        this.labelAXID.setFont(Aladin.BOLD);
        this.labelBXID = new JComboBox();
        this.labelBXID.addActionListener(this);
        this.labelBXID.setFont(Aladin.BOLD);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, CROSS_ID, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        p.setLayout(g);
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        JLabel explain = new JLabel(JOIN, 0);
        g.setConstraints(explain, c);
        p.add(explain);
        GridBagLayout gg = new GridBagLayout();
        GridBagConstraints d = new GridBagConstraints();
        d.gridwidth = 1;
        d.gridheight = 1;
        d.fill = 0;
        d.insets = new Insets(0, 3, 0, 3);
        this.xIDOptionsP = new JPanel();
        this.xIDOptionsP.setLayout(gg);
        JComponent[][] components = new JComponent[2][4];
        components[0][0] = this.labelAXID;
        components[1][0] = this.labelBXID;
        components[0][1] = new JLabel("");
        components[1][1] = new JLabel("");
        components[0][2] = new JLabel(XID);
        components[1][2] = new JLabel(XID);
        this.XIDChoiceA = new JComboBox();
        this.XIDChoiceB = new JComboBox();
        components[0][3] = this.XIDChoiceA;
        components[1][3] = this.XIDChoiceB;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                d.gridx = j;
                d.gridy = i;
                d.fill = components[i][j] instanceof JComboBox ? 2 : 0;
                d.anchor = j == 0 ? 17 : 13;
                gg.setConstraints(components[i][j], d);
                this.xIDOptionsP.add(components[i][j]);
            }
        }
        c.anchor = 17;
        g.setConstraints(this.xIDOptionsP, c);
        p.add(this.xIDOptionsP);
        return p;
    }

    private void populateChoicesWithPlanes() {
        Vector<Plan> v = new Vector<Plan>();
        int nbSelected = 0;
        int nbActive = 0;
        for (int i = 0; i < this.aladin.calque.plan.length; ++i) {
            Plan p = this.aladin.calque.plan[i];
            if (!p.isSimpleCatalog() || !p.flagOk) continue;
            if (p.selected && p.active) {
                v.insertElementAt(p, nbSelected++);
            } else if (p.active) {
                v.insertElementAt(p, nbSelected + nbActive++);
            } else {
                v.addElement(p);
            }
            this.labelAXMatch.addItem(p.label);
            this.labelAXID.addItem(p.label);
            this.ellLabelA.addItem(p.label);
            this.labelBXMatch.addItem(p.label);
            this.labelBXID.addItem(p.label);
            this.ellLabelB.addItem(p.label);
        }
        this.cats = new Plan[v.size()];
        v.copyInto(this.cats);
        v = null;
    }

    private void populateRADECChoices(JComboBox ra, JComboBox dec, Plan p, boolean select) {
        Legende leg;
        ra.removeAllItems();
        if (dec != null) {
            if (dec.getItemCount() > 0) {
                dec.setSelectedIndex(0);
            }
            dec.removeAllItems();
        }
        if ((leg = p.getFirstLegende()) == null) {
            return;
        }
        for (int i = 0; i < leg.field.length; ++i) {
            ra.addItem(leg.field[i].name);
            if (dec == null) continue;
            dec.addItem(leg.field[i].name);
        }
        if (select) {
            int[] idx = CDSXMatch.findCoord(p);
            if (idx == null) {
                return;
            }
            if (idx[0] >= 0) {
                ra.setSelectedIndex(idx[0]);
            }
            if (idx[1] >= 0 && dec != null) {
                dec.setSelectedIndex(idx[1]);
            }
        }
    }

    private void populateChoice(JComboBox c, Plan pc, String[] ucds) {
        int idx;
        c.removeAllItems();
        Legende leg = pc.getFirstLegende();
        if (pc == null) {
            return;
        }
        for (int i = 0; i < leg.field.length; ++i) {
            c.addItem(leg.field[i].name);
        }
        if (ucds != null && (idx = CDSXMatch.findIdx(pc, ucds)) >= 0) {
            c.setSelectedIndex(idx);
        }
    }

    @Override
    public void setVisible(boolean flag) {
        this.aladin.toolBox.setMode(17, flag ? -1 : 1);
        super.setVisible(flag);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String what = ae.getActionCommand();
        Object target = ae.getSource();
        if (what.equals(CLOSE)) {
            this.setVisible(false);
        } else if (what.equals(ADVANCED_OPTIONS)) {
            this.showOptionsFrame();
        } else if (what.equals(XMATCH)) {
            this.launchXMatch();
        } else if (target == this.labelAXMatch || target == this.labelAXID || target == this.ellLabelA) {
            String selectedPlane = ((JComboBox)target).getSelectedItem().toString();
            if (this.memPlanA != null && this.memPlanA.equals(selectedPlane)) {
                return;
            }
            this.memPlanA = selectedPlane;
            int indice = this.aladin.calque.getIndexPlan(selectedPlane);
            if (indice < 0) {
                return;
            }
            Plan pc = this.aladin.calque.plan[indice];
            this.populateRADECChoices(this.RAChoiceA, this.DEChoiceA, pc, true);
            this.populateRADECChoices(this.XIDChoiceA, null, pc, false);
            this.populateRADECChoices(this.ellRAChoiceA, this.ellDEChoiceA, pc, true);
            this.populateChoice(this.ellMAChoiceA, pc, LIST_UCD_MAJOR_AXIS);
            this.populateChoice(this.ellMIChoiceA, pc, LIST_UCD_MINOR_AXIS);
            this.populateChoice(this.ellPAChoiceA, pc, LIST_UCD_PA);
            if (target != this.labelAXMatch) {
                this.labelAXMatch.setSelectedItem(pc.label);
            }
            if (target != this.labelAXID) {
                this.labelAXID.setSelectedItem(pc.label);
            }
            if (target != this.ellLabelA) {
                this.ellLabelA.setSelectedItem(pc.label);
            }
            if (this.optionFrame != null) {
                this.optionFrame.update(pc, this.optionFrame.pc2);
            }
        } else if (target == this.labelBXMatch || target == this.labelBXID || target == this.ellLabelB) {
            String selectedPlane = ((JComboBox)target).getSelectedItem().toString();
            if (this.memPlanB != null && this.memPlanB.equals(selectedPlane)) {
                return;
            }
            this.memPlanB = selectedPlane;
            int indice = this.aladin.calque.getIndexPlan(selectedPlane);
            if (indice < 0) {
                return;
            }
            Plan pc = this.aladin.calque.plan[indice];
            this.populateRADECChoices(this.RAChoiceB, this.DEChoiceB, pc, true);
            this.populateRADECChoices(this.XIDChoiceB, null, pc, false);
            this.populateRADECChoices(this.ellRAChoiceB, this.ellDEChoiceB, pc, true);
            this.populateChoice(this.ellMAChoiceB, pc, LIST_UCD_MAJOR_AXIS);
            this.populateChoice(this.ellMIChoiceB, pc, LIST_UCD_MINOR_AXIS);
            this.populateChoice(this.ellPAChoiceB, pc, LIST_UCD_PA);
            if (target != this.labelBXMatch) {
                this.labelBXMatch.setSelectedItem(pc.label);
            }
            if (target != this.labelBXID) {
                this.labelBXID.setSelectedItem(pc.label);
            }
            if (target != this.ellLabelB) {
                this.ellLabelB.setSelectedItem(pc.label);
            }
            if (this.optionFrame != null) {
                this.optionFrame.update(this.optionFrame.pc1, pc);
            }
        } else if (target.equals(this.allMatch)) {
            if (this.allMatch.isSelected() && this.bestMatch.isSelected()) {
                this.bestMatch.setSelected(false);
            } else if (!this.allMatch.isSelected() && !this.noMatch.isSelected()) {
                this.allMatch.setSelected(true);
            }
        } else if (target.equals(this.bestMatch)) {
            if (this.allMatch.isSelected() && this.bestMatch.isSelected()) {
                this.allMatch.setSelected(false);
            } else if (!this.bestMatch.isSelected() && !this.noMatch.isSelected()) {
                this.bestMatch.setSelected(true);
            }
        } else if (target.equals(this.ellAllMatch)) {
            if (this.ellAllMatch.isSelected() && this.ellBestMatch.isSelected()) {
                this.ellBestMatch.setSelected(false);
            } else if (!this.ellAllMatch.isSelected() && !this.ellNoMatch.isSelected()) {
                this.ellAllMatch.setSelected(true);
            }
        } else if (target.equals(this.ellBestMatch)) {
            if (this.ellAllMatch.isSelected() && this.ellBestMatch.isSelected()) {
                this.ellAllMatch.setSelected(false);
            } else if (!this.ellBestMatch.isSelected() && !this.ellNoMatch.isSelected()) {
                this.ellBestMatch.setSelected(true);
            }
        }
    }

    private void launchXMatch() {
        this.colFilterT = this.getColFilter();
        String tab = tabbedPaneComponents[this.tabbedPane.getSelectedIndex()];
        if (tab.equals(POS_XMATCH)) {
            this.launchPosXMatch();
        } else if (tab.equals(CROSS_ID)) {
            this.launchXID();
        } else if (tab.equals(POS_XMATCH_ELLIPSES)) {
            this.launchPosXMatchEllipses();
        }
    }

    private void launchXID() {
        this.typeT = 2;
        this.index1T = this.XIDChoiceA.getSelectedIndex();
        this.index2T = this.XIDChoiceB.getSelectedIndex();
        this.p1T = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.labelAXID.getSelectedItem().toString())];
        this.p2T = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.labelBXID.getSelectedItem().toString())];
        this.runme = new Thread((Runnable)this, "AladinXmatch");
        Util.decreasePriority(Thread.currentThread(), this.runme);
        this.runme.start();
    }

    private void launchPosXMatch() {
        this.typeT = 1;
        this.methodeT = 0;
        if (this.allMatch.isSelected()) {
            this.methodeT |= 2;
        }
        if (this.bestMatch.isSelected()) {
            this.methodeT |= 1;
        }
        if (this.noMatch.isSelected()) {
            this.methodeT |= 4;
        }
        if (this.methodeT == 0) {
            Aladin.error(this, ERR1, 1);
            return;
        }
        this.seuilsT = new double[2];
        try {
            this.seuilsT[0] = Double.valueOf(this.minDist.getText());
            this.seuilsT[1] = Double.valueOf(this.maxDist.getText());
        }
        catch (NumberFormatException e) {
            Aladin.error(this, ERR2, 1);
            return;
        }
        this.p1T = this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.labelAXMatch.getSelectedItem().toString())];
        this.p2T = this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.labelBXMatch.getSelectedItem().toString())];
        this.coordTab1T = new int[2];
        this.coordTab1T[0] = this.RAChoiceA.getSelectedIndex();
        this.coordTab1T[1] = this.DEChoiceA.getSelectedIndex();
        this.coordTab2T = new int[2];
        this.coordTab2T[0] = this.RAChoiceB.getSelectedIndex();
        this.coordTab2T[1] = this.DEChoiceB.getSelectedIndex();
        this.runme = new Thread((Runnable)this, "AladinXmatchPos");
        Util.decreasePriority(Thread.currentThread(), this.runme);
        this.runme.start();
    }

    private void launchPosXMatchEllipses() {
        this.typeT = 3;
        this.methodeT = 0;
        if (this.ellAllMatch.isSelected()) {
            this.methodeT |= 2;
        }
        if (this.ellBestMatch.isSelected()) {
            this.methodeT |= 1;
        }
        if (this.ellNoMatch.isSelected()) {
            this.methodeT |= 4;
        }
        if (this.methodeT == 0) {
            Aladin.error(this, "No cross-match method chosen !", 1);
            return;
        }
        this.seuilsT = new double[2];
        try {
            this.seuilsT[0] = Double.valueOf(this.nbSigmaMin.getText());
            this.seuilsT[1] = Double.valueOf(this.nbSigmaMax.getText());
        }
        catch (NumberFormatException e) {
            Aladin.error(this, "Could not parse min or max distance !", 1);
            return;
        }
        this.p1T = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.ellLabelA.getSelectedItem().toString())];
        this.p2T = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.ellLabelB.getSelectedItem().toString())];
        this.coordTab1T = new int[2];
        this.coordTab1T[0] = this.ellRAChoiceA.getSelectedIndex();
        this.coordTab1T[1] = this.ellDEChoiceA.getSelectedIndex();
        this.coordTab2T = new int[2];
        this.coordTab2T[0] = this.RAChoiceB.getSelectedIndex();
        this.coordTab2T[1] = this.DEChoiceB.getSelectedIndex();
        this.ellipseParam1T = new int[3];
        this.ellipseParam1T[0] = this.ellMAChoiceA.getSelectedIndex();
        this.ellipseParam1T[1] = this.ellMIChoiceA.getSelectedIndex();
        this.ellipseParam1T[2] = this.ellPAChoiceA.getSelectedIndex();
        this.ellipseParam2T = new int[3];
        this.ellipseParam2T[0] = this.ellMAChoiceB.getSelectedIndex();
        this.ellipseParam2T[1] = this.ellMIChoiceB.getSelectedIndex();
        this.ellipseParam2T[2] = this.ellPAChoiceB.getSelectedIndex();
        this.runme = new Thread((Runnable)this, "AladinXmatchEllipse");
        Util.decreasePriority(Thread.currentThread(), this.runme);
        this.runme.start();
    }

    @Override
    public void run() {
        CDSXMatch xMatch = new CDSXMatch(this.aladin);
        xMatch.setColFilter(this.colFilterT);
        if (this.typeT == 1) {
            xMatch.posXMatch(this.p1T, this.p2T, null, this.coordTab1T, this.coordTab2T, this.seuilsT, this.methodeT, this.aladin);
        } else if (this.typeT == 2) {
            xMatch.xID(this.p1T, this.p2T, this.labelT, this.index1T, this.index2T, this.aladin);
        } else if (this.typeT == 3) {
            xMatch.posXMatchEllipses(this.p1T, this.p2T, null, this.coordTab1T, this.coordTab2T, this.ellipseParam1T, this.ellipseParam2T, this.seuilsT[0], this.seuilsT[1], this.methodeT, this.aladin);
        }
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 201) {
            this.hide();
        }
        return super.handleEvent(e);
    }

    private void showOptionsFrame() {
        if (this.optionFrame == null) {
            this.optionFrame = new OptionFrame(this.aladin);
        }
        PlanCatalog pc1 = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.memPlanA)];
        PlanCatalog pc2 = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.memPlanB)];
        this.optionFrame.update(pc1, pc2);
        this.optionFrame.setVisible(true);
        this.optionFrame.toFront();
    }

    static {
        LIST_UCD_MAJOR_AXIS = new String[]{"EXTENSION_DIAM", "phys.angSize.smajAxis;pos.errorEllipse", "phys.angSize.smajAxis"};
        LIST_UCD_MINOR_AXIS = new String[]{"EXTENSION_MIN", "phys.angSize.sminAxis;pos.errorEllipse", "phys.angSize.sminAxis"};
        LIST_UCD_PA = new String[]{"POS_POS-ANG", "pos.posAng;pos.errorEllipse", "pos.posAng"};
        xmatchNames = new String[]{POS_XMATCH, CROSS_ID};
    }

    class OptionFrame
    extends JFrame {
        static final String SELECT_ALL = "Select all";
        static final String SELECT_NONE = "Deselect all";
        Aladin aladin;
        String prefix1;
        String prefix2;
        String suffix1;
        String suffix2;
        JButton bAll1;
        JButton bAll2;
        Field[] fields1;
        Field[] fields2;
        JTextField prefix1TF;
        JTextField prefix2TF;
        JTextField suffix1TF;
        JTextField suffix2TF;
        Plan pc1;
        Plan pc2;
        ColButton[] col1;
        ColButton[] col2;
        JLabel ucdLabel;
        Vector conflict;

        OptionFrame(Aladin aladin) {
            super("Options for xmatch ouput");
            this.prefix1 = "";
            this.prefix2 = "";
            this.suffix1 = "_tab1";
            this.suffix2 = "_tab2";
            this.conflict = new Vector();
            this.aladin = aladin;
            Aladin.setIcon(this);
            Util.setCloseShortcut(this, false, aladin);
            this.getContentPane().setLayout(new BorderLayout());
            this.setLocation(100, 100);
        }

        void hilightBtnsWithUcd(String ucd) {
            this.conflict.clear();
            this.hilightBtnsWithUcd(ucd, this.col1);
            this.hilightBtnsWithUcd(ucd, this.col2);
            if (this.conflict.size() >= 2) {
                Enumeration e = this.conflict.elements();
                while (e.hasMoreElements()) {
                    ((ColButton)e.nextElement()).hilight(true, Color.RED);
                }
            }
        }

        void hilightBtnsWithUcd(String ucd, ColButton[] btns) {
            if (ucd != null) {
                ucd = this.getUcdRoot(ucd.toLowerCase());
            }
            for (int i = 0; i < btns.length; ++i) {
                if (ucd == null) {
                    btns[i].hilight(false);
                    continue;
                }
                if (btns[i].field.ucd == null || btns[i].field.ucd.length() == 0) continue;
                String otmp = btns[i].field.ucd.toLowerCase();
                String tmp = this.getUcdRoot(otmp);
                if (tmp.equals(ucd)) {
                    btns[i].hilight(true);
                    if (otmp.indexOf(";meta.main") < 0 && otmp.indexOf("_main") < 0) continue;
                    this.conflict.addElement(btns[i]);
                    continue;
                }
                if (!btns[i].hl) continue;
                btns[i].hilight(false);
            }
        }

        private String getUcdRoot(String s) {
            String tmp = s.toLowerCase();
            int k = tmp.indexOf(";meta.main");
            if (k < 0) {
                k = tmp.indexOf("_main");
            }
            if (k >= 0) {
                tmp = tmp.substring(0, k);
            }
            return tmp;
        }

        void update(Plan pc1, Plan pc2) {
            this.pc1 = pc1;
            this.pc2 = pc2;
            if (this.prefix1TF != null) {
                this.saveValues();
            }
            this.getContentPane().removeAll();
            this.buildFrame();
        }

        private void buildFrame() {
            JPanel p = new JPanel();
            GridBagLayout g = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 0, 5);
            c.fill = 1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.5;
            p.setLayout(g);
            p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Output options", 2, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            this.prefix1TF = new JTextField(this.prefix1, 5);
            this.suffix1TF = new JTextField(this.suffix1, 5);
            JPanel panelPc1 = this.getPanelForCat("Catalogue A : " + this.pc1.getLabel(), this.pc1, this.prefix1TF, this.suffix1TF, this.col1, this.fields1, true);
            c.anchor = 17;
            g.setConstraints(panelPc1, c);
            p.add(panelPc1);
            this.prefix2TF = new JTextField(this.prefix2, 5);
            this.suffix2TF = new JTextField(this.suffix2, 5);
            JPanel panelPc2 = this.getPanelForCat("Catalogue B : " + this.pc2.getLabel(), this.pc2, this.prefix2TF, this.suffix2TF, this.col2, this.fields2, false);
            c.anchor = 17;
            g.setConstraints(panelPc2, c);
            p.add(panelPc2);
            c.anchor = 10;
            c.weightx = 0.0;
            c.weighty = 0.0;
            JLabel l3 = new JLabel("UCD: ");
            l3.setFont(Aladin.ITALIC);
            c.anchor = 17;
            c.gridwidth = -1;
            g.setConstraints(l3, c);
            p.add(l3);
            this.ucdLabel = new JLabel("                                  ");
            this.ucdLabel.setFont(Aladin.BOLD);
            this.ucdLabel.setForeground(Aladin.MYBLUE);
            c.fill = 1;
            c.gridwidth = 0;
            g.setConstraints(this.ucdLabel, c);
            p.add(this.ucdLabel);
            this.getContentPane().add((Component)p, "Center");
            this.getContentPane().add((Component)this.bottomPanel(), "South");
            this.pack();
        }

        JPanel getPanelForCat(String title, Plan pc, JTextField prefTF, JTextField sufTF, ColButton[] buttons, Field[] fields, boolean flag) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 3));
            p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, title, 4, 2, Aladin.LITALIC), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
            JPanel prefixPanel = new JPanel(new FlowLayout());
            JLabel l1 = new JLabel("Column prefix");
            prefixPanel.add(l1);
            prefixPanel.add(prefTF);
            JLabel l2 = new JLabel("Column suffix");
            prefixPanel.add(l2);
            prefixPanel.add(sufTF);
            p.add(prefixPanel);
            p.add(Box.createRigidArea(new Dimension(0, 10)));
            JPanel subPanel = new JPanel();
            subPanel.setLayout(new BoxLayout(subPanel, 3));
            subPanel.setBorder(BorderFactory.createTitledBorder(null, "Choose columns to keep", 2, 2));
            JButton bAll = new JButton(SELECT_NONE);
            bAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    OptionFrame.this.switchState((JButton)ae.getSource());
                }
            });
            bAll.setFont(Aladin.ITALIC);
            bAll.setForeground(Color.blue);
            bAll.setAlignmentX(0.5f);
            subPanel.add(bAll);
            if (flag) {
                this.bAll1 = bAll;
            } else {
                this.bAll2 = bAll;
            }
            JPanel colPanel = this.createButtons(pc, buttons, fields, flag);
            colPanel.setAlignmentY(0.5f);
            subPanel.add(colPanel);
            p.add(subPanel);
            return p;
        }

        private JPanel createButtons(Plan pc, ColButton[] b, Field[] f, boolean flag) {
            f = pc.getFirstLegende().field;
            int nbCol = 4;
            int maxNbRow = 5;
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(0, nbCol, 0, 0));
            b = new ColButton[f.length];
            boolean needScroll = f.length > nbCol * maxNbRow;
            int maxWidth = 0;
            FontMetrics fm = null;
            if (needScroll) {
                fm = Toolkit.getDefaultToolkit().getFontMetrics(Aladin.SPLAIN);
            }
            for (int i = 0; i < f.length; ++i) {
                int tmp;
                b[i] = new ColButton(this.aladin, f[i].name, f[i]);
                b[i].setFont(Aladin.SPLAIN);
                if (needScroll && (tmp = fm.stringWidth(f[i].name)) > maxWidth) {
                    maxWidth = tmp;
                }
                p.add(b[i]);
            }
            if (flag) {
                this.col1 = b;
                this.fields1 = f;
            } else {
                this.col2 = b;
                this.fields2 = f;
            }
            if (needScroll) {
                ScrollPane sp = new ScrollPane(0);
                sp.setSize((maxWidth + 20) * nbCol + 30, 140);
                sp.add(p);
                JPanel newPanel = new JPanel();
                newPanel.add(sp);
                return newPanel;
            }
            return p;
        }

        private void saveValues() {
            this.prefix1 = this.prefix1TF.getText();
            this.prefix2 = this.prefix2TF.getText();
            this.suffix1 = this.suffix1TF.getText();
            this.suffix2 = this.suffix2TF.getText();
        }

        private JPanel bottomPanel() {
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(1));
            JButton b = new JButton(CLOSE);
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    OptionFrame.this.setVisible(false);
                }
            });
            return p;
        }

        private void switchState(JButton b) {
            boolean state = b.getText().equals(SELECT_ALL);
            this.selectAll(state, b == this.bAll1 ? this.col1 : this.col2);
            b.setText(state ? SELECT_NONE : SELECT_ALL);
        }

        private void selectAll(boolean state, ColButton[] btns) {
            for (int i = 0; i < btns.length; ++i) {
                if (state) {
                    btns[i].push();
                    continue;
                }
                btns[i].pop();
            }
        }

        @Override
        public boolean handleEvent(Event e) {
            if (e.id == 201) {
                this.setVisible(false);
            }
            return super.handleEvent(e);
        }
    }

    class ColButton
    extends MyButton {
        Field field;
        Color hlColor;
        boolean hl;

        ColButton(Aladin aladin, String name, Field field) {
            super(aladin, name);
            this.hlColor = Color.black;
            this.hl = false;
            this.enableEvents(64L);
            this.field = field;
            this.setAlwaysUp(true);
            this.push();
        }

        private void hilight(boolean b) {
            this.hilight(b, Aladin.MYBLUE);
        }

        private void hilight(boolean b, Color c) {
            Color toSet;
            this.hl = b;
            Color color = toSet = b ? c : Color.black;
            if (!toSet.equals(this.hlColor)) {
                this.hlColor = toSet;
                this.repaint();
            }
        }

        @Override
        void draw(Graphics g) {
            if (this.getColor() == Aladin.COLOR_GREEN && !this.hl) {
                g.setColor(Aladin.MYBLUE);
                g.fillRect(1, 1, this.W - 2, this.H - 2);
            } else {
                if (!this.hl) {
                    g.setColor(this.getBackground());
                } else {
                    g.setColor(this.hlColor);
                }
                g.fillRect(0, 0, this.W, this.H);
            }
            if (this.mode == -1) {
                g.setColor(this.hl ? this.hlColor : Color.gray);
                g.fillRect(0, 1, this.W, this.H - 1);
            }
            if (this.image != null) {
                int h = this.image.getHeight(this);
                if (h > this.H) {
                    g.drawImage(this.image, 2, 2, this.W - 4, this.H - 4, this);
                } else {
                    g.drawImage(this.image, 2, 2 + (this.H - h) / 2, this);
                }
            }
            g.setColor(Color.black);
            if (this.type != 0 && this.mode == -1) {
                g.setColor(Color.black);
                g.drawLine(0, 1, this.W - 1, 1);
                if (this.type != 3) {
                    g.drawLine(0, 1, 0, this.H - 1);
                }
                g.setColor(Color.white);
                if (this.type != 4) {
                    g.drawLine(1, this.H - 1, this.W - 1, this.H - 1);
                }
                if (this.type != 2) {
                    g.drawLine(this.W - 1, 1, this.W - 1, this.H - 1);
                }
            } else if (!this.modeMenu || this.modeMenu && this.getColor() == Aladin.COLOR_GREEN) {
                g.setColor(this.mode != -1 ? Color.white : Color.darkGray);
                g.drawLine(1, 1, this.W - 2, 1);
                g.drawLine(1, 1, 1, this.H - 2);
                g.setColor(this.mode != -1 ? Color.darkGray : Color.white);
                g.drawLine(this.W - 2, 1, this.W - 2, this.H - 2);
                g.drawLine(this.W - 2, this.H - 2, 1, this.H - 2);
            }
            if (this.withTriangle) {
                g.setColor(this.mode == -1 ? LIGHT_GREY : GREY);
                g.drawLine(this.W - 16, this.H / 2 + 5, this.W - 9, this.H / 2 + 1);
                g.setColor(this.mode == -1 ? GREY : LIGHT_GREY);
                g.drawLine(this.W - 9, this.H / 2, this.W - 16, this.H / 2 - 4);
                g.drawLine(this.W - 16, this.H / 2 - 3, this.W - 16, this.H / 2 + 5);
            }
        }

        private void switchUcdMain() {
            String ucd = this.field.ucd;
            if (ucd == null) {
                return;
            }
            int k = ucd.toLowerCase().indexOf(";meta.main");
            String newVal = k >= 0 ? ucd.substring(0, k) : ((k = ucd.toLowerCase().indexOf("_main")) >= 0 ? ucd.substring(0, k) : (ucd.toUpperCase().equals(ucd) ? ucd + "_MAIN" : ucd + ";meta.main"));
            this.field.ucd = newVal;
            ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel.setText(this.field.ucd == null ? "" : this.field.ucd);
            FrameCDSXMatch.this.optionFrame.hilightBtnsWithUcd(this.field.ucd);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.pm == null) {
                this.postEvent(new Event(new JButton(this.text), 1001, this.text));
            }
            if ((e.getModifiers() & 2) > 0) {
                this.switchUcdMain();
                return;
            }
            if (this.mode == -1) {
                this.pop();
            } else if (this.mode == 1) {
                this.push();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (FrameCDSXMatch.this.optionFrame != null && ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel != null && this.field != null) {
                ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel.setText(this.field.ucd == null ? "" : this.field.ucd);
                FrameCDSXMatch.this.optionFrame.hilightBtnsWithUcd(this.field.ucd);
            }
            super.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (FrameCDSXMatch.this.optionFrame != null && ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel != null) {
                ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel.setText("");
                FrameCDSXMatch.this.optionFrame.hilightBtnsWithUcd(null);
            }
            super.mouseExited(e);
        }
    }
}

