/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.PlanBG;
import cds.allsky.ContextGui;
import cds.allsky.MainPanel;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FrameAllskyTool
extends JFrame {
    public Aladin aladin;
    public MainPanel mainPanel;
    public ContextGui context;
    private String title;

    private FrameAllskyTool(Aladin aladin) {
        Aladin.setIcon(this);
        this.aladin = aladin;
        this.createChaine(Aladin.getChaine());
        this.setTitle(this.title);
        this.context = new ContextGui();
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FrameAllskyTool.this.close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout(1, 1));
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.setLocation(500, 100);
        this.pack();
    }

    private void createChaine(Chaine chaine) {
        this.title = chaine.getString("TITLEALLSKY");
    }

    private JPanel createPanel() {
        JPanel p = new JPanel(new BorderLayout(1, 1));
        this.mainPanel = new MainPanel(this.aladin, this.context);
        p.add((Component)this.mainPanel, "Center");
        return p;
    }

    public static void display(Aladin aladin) {
        FrameAllskyTool.display(aladin, false);
    }

    public static void display(Aladin aladin, boolean flagRGB) {
        if (aladin.frameAllsky == null) {
            aladin.frameAllsky = new FrameAllskyTool(aladin);
        }
        aladin.frameAllsky.setVisible(true);
        if (flagRGB) {
            aladin.frameAllsky.mainPanel.showRgbTab();
        }
    }

    public void close() {
        this.setVisible(false);
    }

    public void export(PlanBG plan, String exportpath) {
        plan.setBitpix(-32);
        while (!plan.isSync()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.aladin.save.saveImage(exportpath, plan, 1);
    }

    public void showPublish() {
        this.mainPanel.showPubTab();
    }

    public void showDisplay() {
        this.mainPanel.showJpgTab();
    }

    public void updateCurrentCM() {
        this.mainPanel.updateCurrentCM();
    }
}

