/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FootprintBean;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.TreeBuilder;
import cds.aladin.ViewSimple;
import cds.aladin.stc.STCCircle;
import cds.aladin.stc.STCFrame;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;

public class Fov {
    protected static final double X_SPECTRUM = 0.0;
    protected static final double Y_SPECTRUM = 0.02;
    double alpha;
    double delta;
    double x;
    double y;
    double[] xTab;
    double[] yTab;
    double angle;
    double cutout_x;
    double cutout_y;
    Color color = Color.red;
    boolean spectrumFov = false;
    private PointD[] bords = new PointD[4];
    protected PlanField pf;
    private List<STCObj> stcObjects;
    FootprintBean fpBean;
    String key;
    private String size;

    Fov(List<STCObj> stcObjects) {
        this.stcObjects = stcObjects;
        this.delta = Double.NaN;
        this.alpha = Double.NaN;
    }

    Fov(double alpha, double delta, double x, double y, double angle) {
        this.alpha = alpha;
        this.delta = delta;
        this.x = x;
        this.y = y;
        this.angle = angle;
        this.computePoints();
    }

    Fov(double alpha, double delta, double[] minRADec, double[] maxRADec, double angle) {
        this.alpha = alpha;
        this.delta = delta;
        this.angle = angle;
        this.bords = new PointD[4];
        this.bords[0] = new PointD(minRADec[0], minRADec[1]);
        this.bords[1] = new PointD(minRADec[0], maxRADec[1]);
        this.bords[2] = new PointD(maxRADec[0], maxRADec[1]);
        this.bords[3] = new PointD(maxRADec[0], minRADec[1]);
    }

    Fov(double alpha, double delta, ArrayList<PointD[]> polygons) {
    }

    Fov(double alpha, double delta, double[] xTab, double[] yTab, double angle, double x, double y) {
        this.alpha = alpha;
        this.delta = delta;
        this.xTab = xTab;
        this.yTab = yTab;
        this.angle = angle;
        this.x = x;
        this.y = y;
        this.computePoints();
    }

    Fov(String sexa, double x, double y, double angle) throws Exception {
        Coord coo = new Coord(sexa);
        this.alpha = coo.al;
        this.delta = coo.del;
        this.x = x;
        this.y = y;
        this.angle = angle;
        this.computePoints();
    }

    Fov(double alpha, double delta, double angle) {
        this.alpha = alpha;
        this.delta = delta;
        this.angle = angle;
        this.spectrumFov = true;
        this.computePoints();
    }

    Fov(Aladin aladin, FootprintBean fpBean, String key, double alpha, double delta, double angle) {
        this.pf = new PlanField(aladin, fpBean, key);
        this.pf.make(alpha, delta, angle);
        this.fpBean = fpBean;
        this.key = key;
        this.alpha = alpha;
        this.delta = delta;
        this.angle = angle;
    }

    private void computePoints() {
        double angleRad = Fov.deg2rad(-this.angle);
        if (this.xTab != null && this.yTab != null) {
            this.bords = new PointD[this.xTab.length];
            for (int i = 0; i < this.xTab.length; ++i) {
                double curDelta = this.delta + this.yTab[i] * Math.cos(angleRad) + this.xTab[i] * Math.sin(angleRad);
                double curAlpha = this.alpha + (this.xTab[i] * Math.cos(angleRad) - this.yTab[i] * Math.sin(angleRad)) / Math.cos(Fov.deg2rad(curDelta));
                this.bords[i] = new PointD(curAlpha, curDelta);
            }
        } else {
            double yUsed;
            double xUsed;
            if (this.spectrumFov) {
                xUsed = 0.0;
                yUsed = 0.02;
            } else {
                xUsed = this.x;
                yUsed = this.y;
            }
            for (int i = 0; i < 4; ++i) {
                int signX = i == 1 || i == 2 ? -1 : 1;
                int signY = i < 2 ? 1 : -1;
                double curDelta = this.delta + (double)signY * yUsed / 2.0 * Math.cos(angleRad) + (double)signX * xUsed / 2.0 * Math.sin(angleRad);
                double curAlpha = this.alpha + ((double)signX * xUsed / 2.0 * Math.cos(angleRad) - (double)signY * yUsed / 2.0 * Math.sin(angleRad)) / Math.cos(Fov.deg2rad(curDelta));
                this.bords[i] = new PointD(curAlpha, curDelta);
            }
        }
    }

    private static double deg2rad(double angle) {
        return angle * Math.PI / 180.0;
    }

    protected Point[] getBorders(PointD[] borders, Projection proj, ViewSimple v) {
        Point[] tab = new Point[borders.length];
        Coord coord = new Coord(this.alpha, this.delta);
        try {
            if (!Double.isNaN(this.alpha)) {
                coord = proj.getXY(coord);
                if (Double.isNaN(coord.x)) {
                    return null;
                }
            }
            for (int i = 0; i < borders.length; ++i) {
                coord = new Coord(borders[i].x, borders[i].y);
                coord = proj.getXY(coord);
                if (Double.isNaN(coord.x)) {
                    return null;
                }
                tab[i] = v.getViewCoord(coord.x, coord.y);
                if (tab[i] != null) continue;
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return tab;
    }

    protected PointD[] getBordersSpectrum(Projection proj, ViewSimple v) {
        PointD[] tab = new PointD[this.bords.length];
        Coord coord = new Coord(this.alpha, this.delta);
        try {
            coord = proj.getXY(coord);
            if (Double.isNaN(coord.x)) {
                return null;
            }
            for (int i = 0; i < this.bords.length; ++i) {
                coord = new Coord(this.bords[i].x, this.bords[i].y);
                coord = proj.getXY(coord);
                if (Double.isNaN(coord.x)) {
                    return null;
                }
                tab[i] = v.getViewCoordDble(coord.x, coord.y);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return tab;
    }

    protected PointD[] getPoints(Projection proj) {
        PointD[] tab = new PointD[this.bords.length];
        Coord coord = new Coord(this.alpha, this.delta);
        try {
            coord = proj.getXY(coord);
            if (Double.isNaN(coord.x)) {
                return tab;
            }
            for (int i = 0; i < this.bords.length; ++i) {
                coord = new Coord(this.bords[i].x, this.bords[i].y);
                coord = proj.getXY(coord);
                if (Double.isNaN(coord.x)) {
                    return tab;
                }
                tab[i] = new PointD(coord.x, coord.y);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return tab;
    }

    protected List<STCObj> getStcObjects() {
        return this.stcObjects;
    }

    protected void draw(Projection proj, ViewSimple v, Graphics g, int dx, int dy, Color col) {
        g.setColor(col != null ? col : this.color);
        if (this.spectrumFov) {
            g.setFont(Aladin.BOLD);
            Coord coord = new Coord(this.alpha, this.delta);
            coord = proj.getXY(coord);
            PointD center = v.getViewCoordDble(coord.x, coord.y);
            if (Double.isNaN(center.x) || Double.isNaN(center.y)) {
                return;
            }
            g.drawString("S", (int)center.x, (int)center.y);
            return;
        }
        if (this.pf != null) {
            this.pf.c = this.color;
            this.pf.pcat.draw(g, null, v, true, dx, dy);
            return;
        }
        if (this.stcObjects != null) {
            ArrayList<PointD[]> polygons = new ArrayList<PointD[]>();
            ArrayList<STCCircle> stcCircles = new ArrayList<STCCircle>();
            for (STCObj stcObj : this.stcObjects) {
                STCFrame frame = stcObj.getFrame();
                if (frame != STCFrame.FK5 && frame != STCFrame.ICRS && frame != STCFrame.J2000 && frame != STCFrame.UNKNOWNFRAME) continue;
                if (stcObj.getShapeType() == STCObj.ShapeType.POLYGON) {
                    STCPolygon stcPolygon = (STCPolygon)stcObj;
                    PointD[] polygonBords = new PointD[stcPolygon.getxCorners().size()];
                    for (int i = 0; i < polygonBords.length; ++i) {
                        polygonBords[i] = new PointD(stcPolygon.getxCorners().get(i), stcPolygon.getyCorners().get(i));
                    }
                    polygons.add(polygonBords);
                    continue;
                }
                if (stcObj.getShapeType() != STCObj.ShapeType.CIRCLE) continue;
                STCCircle stcCircle = (STCCircle)stcObj;
                stcCircles.add(stcCircle);
            }
            this.doDraw(polygons, proj, v, g, dx, dy, col);
            if (!stcCircles.isEmpty()) {
                this.doDrawCircles(stcCircles, proj, v, g, dx, dy, col);
            }
            return;
        }
        ArrayList<PointD[]> polygons = new ArrayList<PointD[]>();
        polygons.add(this.bords);
        this.doDraw(polygons, proj, v, g, dx, dy, col);
    }

    private void doDraw(List<PointD[]> polygons, Projection proj, ViewSimple v, Graphics g, int dx, int dy, Color col) {
        for (PointD[] polygon : polygons) {
            Point[] bordsXY = this.getBorders(polygon, proj, v);
            if (bordsXY == null) continue;
            int[] xCoord = new int[bordsXY.length];
            int[] yCoord = new int[bordsXY.length];
            for (int i = 0; i < bordsXY.length; ++i) {
                xCoord[i] = bordsXY[i].x + dx;
                yCoord[i] = bordsXY[i].y + dy;
            }
            if (Aladin.ENABLE_FOOTPRINT_OPACITY && g instanceof Graphics2D) {
                Graphics2D g2d = null;
                Composite saveComposite = null;
                g2d = (Graphics2D)g;
                saveComposite = g2d.getComposite();
                Composite myComposite = Util.getFootprintComposite(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
                g2d.setComposite(myComposite);
                g2d.fill(new Polygon(xCoord, yCoord, xCoord.length));
                g2d.setComposite(saveComposite);
            }
            for (int i = 0; i < bordsXY.length; ++i) {
                int iNext = (i + 1) % bordsXY.length;
                g.drawLine(xCoord[i], yCoord[i], xCoord[iNext], yCoord[iNext]);
            }
        }
    }

    public static double getPlotRadiusForCircleFromCoord(Projection proj, Coord centre, double radius) {
        Coord c0 = new Coord(centre.al, centre.del);
        proj.getXY(c0);
        Coord c1 = new Coord(0.0, 0.0);
        c1.al = c0.al;
        c1.del = c0.del + radius;
        if (c0.del > 90.0) {
            c1.del = c0.del - radius;
        }
        proj.getXY(c1);
        double dy = c1.y - c0.y;
        double dx = c1.x - c0.x;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private void doDrawCircles(List<STCCircle> stcCircles, Projection proj, ViewSimple v, Graphics g, int dx, int dy, Color col) {
        for (STCCircle stcCircle : stcCircles) {
            if (stcCircle == null || stcCircle.getCenter() == null || Double.isNaN(stcCircle.getCenter().al) || Double.isNaN(stcCircle.getCenter().del) || stcCircle.getRadius() == 0.0) continue;
            Coord centre = stcCircle.getCenter();
            Coord coord = new Coord(centre.al, centre.del);
            coord = proj.getXY(coord);
            double radius = Server.getAngleInArcmin(String.valueOf(stcCircle.getRadius()), 8) / 60.0;
            int plotRadius = (int)Math.round(Fov.getPlotRadiusForCircleFromCoord(proj, coord, radius) * v.getZoom());
            PointD ptD = v.getViewCoordDble(coord.x, coord.y);
            if (Aladin.ENABLE_FOOTPRINT_OPACITY && g instanceof Graphics2D) {
                Graphics2D g2d = null;
                Composite saveComposite = null;
                g2d = (Graphics2D)g;
                saveComposite = g2d.getComposite();
                Composite myComposite = Util.getFootprintComposite(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
                g2d.setComposite(myComposite);
                g2d.fillOval((int)(ptD.x - (double)plotRadius), (int)(ptD.y - (double)plotRadius), plotRadius * 2, plotRadius * 2);
                g2d.setComposite(saveComposite);
            }
            g.drawOval((int)(ptD.x - (double)plotRadius), (int)(ptD.y - (double)plotRadius), plotRadius * 2, plotRadius * 2);
        }
    }

    protected boolean contains(double x, double y, Plan ref, ViewSimple v) {
        if (this.spectrumFov) {
            return false;
        }
        if (this.pf != null) {
            return false;
        }
        int[] cx = new int[this.bords.length];
        int[] cy = new int[this.bords.length];
        Point[] bordsXY = this.getBorders(this.bords, v.getProj(), v);
        if (bordsXY == null) {
            return false;
        }
        for (int i = 0; i < this.bords.length; ++i) {
            cx[i] = bordsXY[i].x;
            cy[i] = bordsXY[i].y;
        }
        Polygon polygon = new Polygon(cx, cy, this.bords.length);
        return polygon.contains(x, y);
    }

    protected PointD[] getPoints() {
        return this.bords;
    }

    protected String getSizeStr(boolean cutout) {
        if (this.spectrumFov) {
            return "";
        }
        if (this.pf != null) {
            return "";
        }
        if (this.size == null) {
            this.size = cutout ? TreeBuilder.getUnit(Double.toString(this.cutout_x), "deg") + " x " + TreeBuilder.getUnit(Double.toString(this.cutout_y), "deg") : TreeBuilder.getUnit(Double.toString(this.x), "deg") + " x " + TreeBuilder.getUnit(Double.toString(this.y), "deg");
        }
        return this.size;
    }
}

