/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.FootprintBean;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.SubFootprintBean;
import cds.savot.model.FieldSet;
import cds.savot.model.MarkupComment;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import cds.savot.pull.SavotPullParser;
import cds.tools.Util;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FootprintParser {
    private static final String SPHERICAL_COORDS = "stc:AstroCoordSystem.CoordFrame.SPHERICAL";
    private MyInputStream mis;
    private byte[] beginStream;
    private SavotVOTable votable;
    private Hashtable<String, FootprintBean> hash;
    private SavotResource[] resources;
    boolean sphericalCoordinates = false;
    private static Hashtable<String, FootprintBean> footprintHash = new Hashtable();
    private Hashtable<String, MarkupComment> refMem;
    int counter = 0;
    int tabIndex = 0;
    private static int BUF_LENGTH = 10000;

    public FootprintParser(MyInputStream mis, byte[] beginStream) {
        this.mis = mis;
        this.beginStream = beginStream;
    }

    public FootprintParser(SavotResource[] resources) {
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, FootprintBean> getFooprintHash() {
        InputStream is = null;
        ResourceSet resSet = new ResourceSet();
        try {
            if (this.mis != null) {
                is = this.buildInputStream();
                SavotPullParser parser = new SavotPullParser(is, 0, null, false);
                this.votable = parser.getVOTable();
                resSet = this.votable.getResources();
            } else {
                for (int i = 0; i < this.resources.length; ++i) {
                    resSet.addItem(this.resources[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Aladin.error("Problem during parsing of footprints !");
            Hashtable<String, FootprintBean> hashtable = null;
            return hashtable;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        int nbRes = resSet.getItemCount();
        this.hash = new Hashtable();
        for (int i = 0; i < nbRes; ++i) {
            Aladin.trace(3, "Footprint: Processing resource: " + i);
            this.processFovResource((SavotResource)resSet.getItemAt(i));
        }
        return this.hash;
    }

    private void processFovResource(SavotResource res) {
        FootprintBean fpBean = new FootprintBean();
        this.sphericalCoordinates = false;
        this.tabIndex = 0;
        this.refMem = new Hashtable();
        String id = res.getId();
        fpBean.setInstrumentName(id);
        ParamSet params = res.getParams();
        int nbParam = params.getItemCount();
        for (int i = 0; i < nbParam; ++i) {
            SavotParam param = (SavotParam)params.getItemAt(i);
            if (param.getUtype().trim().equalsIgnoreCase(SPHERICAL_COORDS)) {
                this.sphericalCoordinates = true;
            }
            if (param.getUcd().equalsIgnoreCase("pos.eq.ra;meta.main")) {
                fpBean.setRa(param.getValue());
            } else if (param.getUcd().equalsIgnoreCase("pos.eq.dec;meta.main")) {
                fpBean.setDe(param.getValue());
            }
            if (param.getUcd().equalsIgnoreCase("pos.eq.ra")) {
                fpBean.setRaRot(param.getValue());
                continue;
            }
            if (param.getUcd().equalsIgnoreCase("pos.eq.dec")) {
                fpBean.setDeRot(param.getValue());
                continue;
            }
            if (param.getUcd().equalsIgnoreCase("pos.posAng") || param.getUtype().equals("stc:AstroCoordSystem.CoordFrame.Cart2DRefFrame.Transform2.PosAngle")) {
                double d;
                try {
                    d = Double.valueOf(param.getValue());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                fpBean.setPosAngle(d);
                continue;
            }
            if (param.getName().equalsIgnoreCase("Movable")) {
                boolean b;
                try {
                    b = Boolean.valueOf(param.getValue());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                fpBean.setMovable(b);
                continue;
            }
            if (param.getName().equalsIgnoreCase("Rollable")) {
                boolean b;
                try {
                    b = Boolean.valueOf(param.getValue());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                fpBean.setRollable(b);
                continue;
            }
            if (param.getId().equals("InstrumentDescription")) {
                fpBean.setInstrumentDesc(param.getValue());
                continue;
            }
            if (param.getId().equals("InstrumentName")) {
                fpBean.setInstrumentName(param.getValue());
                continue;
            }
            if (param.getId().equals("TelescopeName")) {
                fpBean.setTelescopeName(param.getValue());
                continue;
            }
            if (!param.getId().equals("Origin")) continue;
            fpBean.setOrigin(param.getValue());
        }
        SubFootprintBean sub = this.processResource(res);
        if (sub != null && sub.getNbOfSubParts() > 0) {
            fpBean.addSubFootprintBean(sub);
        }
        ResourceSet resources = res.getResources();
        for (int i = 0; i < resources.getItemCount(); ++i) {
            sub = this.processResource((SavotResource)resources.getItemAt(i));
            if (sub == null) continue;
            fpBean.addSubFootprintBean(sub);
            String subfpId = ((SavotResource)resources.getItemAt(i)).getId();
            if (subfpId == null || subfpId.length() <= 0) continue;
            FootprintBean container = new FootprintBean();
            container.addSubFootprintBean(sub);
            container.setDisplayInFovList(false);
            if (this.hash.contains(subfpId)) continue;
            this.hash.put(subfpId, container);
        }
        this.hash.put(id, fpBean);
        if (footprintHash.get(id) != null) {
            Aladin.trace(1, "Footprint with ID " + id + "already exists ...\n Existing definition will be erased");
        }
        Aladin.trace(3, "Footprint : add to footprintHash footprint with key " + id + "**");
        footprintHash.put(id, fpBean);
    }

    private SubFootprintBean processResource(SavotResource res) {
        SubFootprintBean subFpBean = new SubFootprintBean();
        subFpBean.setInSphericalCoords(this.sphericalCoordinates);
        TableSet tables = res.getTables();
        int nbTab = tables.getItemCount();
        for (int i = 0; i < nbTab; ++i) {
            SubFootprintBean sub = this.processTable((SavotTable)tables.getItemAt(i));
            if (sub == null) continue;
            subFpBean.addSubFootprintBean(sub);
        }
        String id = res.getName();
        subFpBean.setName(id);
        subFpBean.setColor(this.getColor(res));
        return subFpBean;
    }

    protected static FootprintBean getBeanFromID(String id) {
        if (footprintHash == null) {
            return null;
        }
        Enumeration<String> e = footprintHash.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (!key.equalsIgnoreCase(id)) continue;
            return footprintHash.get(key);
        }
        return null;
    }

    private SubFootprintBean processTable(SavotTable table) {
        String type = this.getRegionType(table);
        if (!(type != null && (type.equals("Box") || type.equals("Polygon") || type.equals("Circle") || type.equals("Pickle") || type.equals("String")))) {
            return null;
        }
        String id = table.getId();
        SubFootprintBean subFpBean = null;
        if (type.equals("Polygon")) {
            FieldSet fields = table.getFields();
            int nbFields = fields.getItemCount();
            int idxRAOffset = -1;
            int idxDEOffset = -1;
            for (int i = 0; i < nbFields; ++i) {
                SavotField field = (SavotField)fields.getItemAt(i);
                String utype = (field = this.getField(field)).getUtype();
                if (utype.equals("stc:AstroCoordArea/Region/reg:Polygon/Vertex/Position[1]") || utype.equalsIgnoreCase("stc:AstroCoordArea.Polygon.Vertex.Position.C1")) {
                    idxRAOffset = i;
                    continue;
                }
                if (!utype.equals("stc:AstroCoordArea/Region/reg:Polygon/Vertex/Position[2]") && !utype.equalsIgnoreCase("stc:AstroCoordArea.Polygon.Vertex.Position.C2")) continue;
                idxDEOffset = i;
            }
            if (idxRAOffset < 0 || idxDEOffset < 0) {
                return null;
            }
            TRSet trs = table.getData().getTableData().getTRs();
            int nbRows = trs.getItemCount();
            double[] raOffset = new double[nbRows];
            double[] deOffset = new double[nbRows];
            double deOff = 0.0;
            double raOff = 0.0;
            this.counter += nbRows;
            for (int i = 0; i < nbRows; ++i) {
                SavotTR tr = (SavotTR)trs.getItemAt(i);
                TDSet tds = tr.getTDs();
                try {
                    String tmp = tds.getContent(idxRAOffset);
                    raOff = Double.valueOf(tmp);
                    tmp = tds.getContent(idxDEOffset);
                    deOff = Double.valueOf(tmp);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                raOffset[i] = raOff / 3600.0;
                deOffset[i] = deOff / 3600.0;
            }
            subFpBean = new SubFootprintBean(raOffset, deOffset, id);
            subFpBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFpBean;
        }
        if (type.equals("Box")) {
            ParamSet params = table.getParams();
            int nbParams = params.getItemCount();
            SavotParam ctrRAOffsetParam = null;
            SavotParam ctrDEOffsetParam = null;
            SavotParam sizeRAParam = null;
            SavotParam sizeDEParam = null;
            for (int i = 0; i < nbParams; ++i) {
                SavotParam param = (SavotParam)params.getItemAt(i);
                String utype = (param = this.getParam(param)).getUtype();
                if (utype.equals("stc:AstroCoordArea/Region/reg:Box/Center[1]")) {
                    ctrRAOffsetParam = param;
                    continue;
                }
                if (utype.equals("stc:AstroCoordArea/Region/reg:Box/Center[2]")) {
                    ctrDEOffsetParam = param;
                    continue;
                }
                if (utype.equals("stc:AstroCoordArea/Region/reg:Box/Size[1]")) {
                    sizeRAParam = param;
                    continue;
                }
                if (!utype.equals("stc:AstroCoordArea/Region/reg:Box/Size[2]")) continue;
                sizeDEParam = param;
            }
            if (ctrRAOffsetParam == null || ctrDEOffsetParam == null || sizeRAParam == null || sizeDEParam == null) {
                return null;
            }
            double[] raOffset = new double[4];
            double[] deOffset = new double[4];
            this.counter += 4;
            double sizeDE = -1.0;
            double sizeRA = -1.0;
            double ctrDEOffset = -1.0;
            double ctrRAOffset = -1.0;
            try {
                ctrRAOffset = Double.valueOf(ctrRAOffsetParam.getValue());
                ctrDEOffset = Double.valueOf(ctrDEOffsetParam.getValue());
                sizeRA = Double.valueOf(sizeRAParam.getValue());
                sizeDE = Double.valueOf(sizeDEParam.getValue());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return null;
            }
            for (int i = 0; i < 4; ++i) {
                int signRA = i == 1 || i == 2 ? 1 : -1;
                int signDE = i == 0 || i == 1 ? 1 : -1;
                raOffset[i] = (ctrRAOffset + (double)signRA * sizeRA * 0.5) / 3600.0;
                deOffset[i] = (ctrDEOffset + (double)signDE * sizeDE * 0.5) / 3600.0;
            }
            subFpBean = new SubFootprintBean(raOffset, deOffset, id);
            subFpBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFpBean;
        }
        if (type.equals("Circle")) {
            ParamSet params = table.getParams();
            int nbParams = params.getItemCount();
            SavotParam ctrXOffsetParam = null;
            SavotParam ctrYOffsetParam = null;
            SavotParam radiusParam = null;
            for (int i = 0; i < nbParams; ++i) {
                SavotParam param = (SavotParam)params.getItemAt(i);
                String utype = (param = this.getParam(param)).getUtype();
                if (utype.equals("stc:AstroCoordArea/Region/reg:Sector/Center[1]") || utype.equals("stc:AstroCoordArea.Circle.Center.C1")) {
                    ctrXOffsetParam = param;
                    continue;
                }
                if (utype.equals("stc:AstroCoordArea/Region/reg:Sector/Center[2]") || utype.equals("stc:AstroCoordArea.Circle.Center.C2")) {
                    ctrYOffsetParam = param;
                    continue;
                }
                if (!utype.equals("stc:AstroCoordArea/Region/reg:Circle/radius") && !utype.equals("stc:AstroCoordArea.Circle.radius")) continue;
                radiusParam = param;
            }
            if (ctrXOffsetParam == null || ctrYOffsetParam == null || radiusParam == null) {
                return null;
            }
            try {
                double ctrXOffset = Double.valueOf(ctrXOffsetParam.getValue());
                double ctrYOffset = Double.valueOf(ctrYOffsetParam.getValue());
                double radius = Double.valueOf(radiusParam.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            subFpBean = new SubFootprintBean(ctrXOffset /= 3600.0, ctrYOffset /= 3600.0, radius /= 3600.0, id);
            subFpBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFpBean;
        }
        if (type.equals("Pickle")) {
            double externalRad;
            double internalRad;
            double endAngle;
            double startAngle;
            ParamSet params = table.getParams();
            int nbParams = params.getItemCount();
            SavotParam ctrXOffsetParam = null;
            SavotParam ctrYOffsetParam = null;
            SavotParam internalRadParam = null;
            SavotParam externalRadParam = null;
            SavotParam startAngleParam = null;
            SavotParam endAngleParam = null;
            for (int i = 0; i < nbParams; ++i) {
                SavotParam param = (SavotParam)params.getItemAt(i);
                String utype = (param = this.getParam(param)).getUtype();
                if (utype.equals("stc:AstroCoordArea/Region/reg:Sector/Center[1]")) {
                    ctrXOffsetParam = param;
                    continue;
                }
                if (utype.equals("stc:AstroCoordArea/Region/reg:Sector/Center[2]")) {
                    ctrYOffsetParam = param;
                    continue;
                }
                if (utype.equals("stc:AstroCoordArea/Region/reg:Sector/angle1")) {
                    startAngleParam = param;
                    continue;
                }
                if (utype.equals("stc:AstroCoordArea/Region/reg:Sector/angle2")) {
                    endAngleParam = param;
                    continue;
                }
                if (utype.equals("stc:AstroCoordArea/Region/reg:Circle/radius") && internalRadParam == null) {
                    internalRadParam = param;
                    continue;
                }
                if (!utype.equals("stc:AstroCoordArea/Region/reg:Circle/radius")) continue;
                externalRadParam = param;
            }
            if (ctrXOffsetParam == null || ctrYOffsetParam == null || startAngleParam == null || endAngleParam == null || internalRadParam == null || externalRadParam == null) {
                return null;
            }
            try {
                double ctrXOffset = Double.valueOf(ctrXOffsetParam.getValue());
                double ctrYOffset = Double.valueOf(ctrYOffsetParam.getValue());
                startAngle = Double.valueOf(startAngleParam.getValue());
                endAngle = Double.valueOf(endAngleParam.getValue());
                internalRad = Double.valueOf(internalRadParam.getValue());
                externalRad = Double.valueOf(externalRadParam.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            double tmp = internalRad;
            if (internalRad > externalRad) {
                internalRad = externalRad;
                externalRad = tmp;
            }
            double angle = endAngle - startAngle;
            subFpBean = new SubFootprintBean(ctrXOffset /= 3600.0, ctrYOffset /= 3600.0, startAngle, angle, internalRad /= 3600.0, externalRad /= 3600.0, id);
            subFpBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFpBean;
        }
        if (type.equals("String")) {
            ParamSet params = table.getParams();
            int nbParams = params.getItemCount();
            SavotParam raParam = null;
            SavotParam decParam = null;
            SavotParam contentParam = null;
            for (int i = 0; i < nbParams; ++i) {
                SavotParam param = (SavotParam)params.getItemAt(i);
                String utype = (param = this.getParam(param)).getUtype();
                if (utype.equals("stc:AstroCoord.Position2D.Value2.C1")) {
                    raParam = param;
                    continue;
                }
                if (utype.equals("stc:AstroCoord.Position2D.Value2.C2")) {
                    decParam = param;
                    continue;
                }
                if (!utype.equals("app:footprint.render.overlay.string.content")) continue;
                contentParam = param;
            }
            if (raParam == null || decParam == null || contentParam == null) {
                System.err.println("something is missing");
                return null;
            }
            try {
                double ra = Double.valueOf(raParam.getValue());
                double dec = Double.valueOf(decParam.getValue());
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return null;
            }
            subFpBean = new SubFootprintBean(ra /= 3600.0, dec /= 3600.0, "center", contentParam.getValue());
            subFpBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFpBean;
        }
        return null;
    }

    private SavotField getField(SavotField field) {
        String ref = field.getRef();
        if (ref != null && ref.length() > 0) {
            return (SavotField)this.refMem.get(ref);
        }
        String id = field.getId();
        if (id != null && id.length() > 0) {
            this.refMem.put(id, field);
            return field;
        }
        return field;
    }

    private SavotParam getParam(SavotParam param) {
        String ref = param.getRef();
        if (ref != null && ref.length() > 0) {
            return (SavotParam)this.refMem.get(ref);
        }
        String id = param.getId();
        if (id != null && id.length() > 0) {
            this.refMem.put(id, param);
            return param;
        }
        return param;
    }

    private String getRegionType(SavotTable table) {
        ParamSet params = table.getParams();
        int nbParam = params.getItemCount();
        for (int i = 0; i < nbParam; ++i) {
            SavotParam param = (SavotParam)params.getItemAt(i);
            if (param.getName().equals("Region") || param.getUtype().equalsIgnoreCase("dal:footprint.geom.segment.shape")) {
                return param.getValue();
            }
            if (!param.getUtype().equalsIgnoreCase("app:footprint.render.overlay.string")) continue;
            return "String";
        }
        return null;
    }

    private InputStream buildInputStream() throws IOException {
        MyByteArrayStream is = new MyByteArrayStream();
        if (this.beginStream != null) {
            is.write(this.beginStream);
        }
        byte[] buf = new byte[BUF_LENGTH];
        while (this.mis.available() > 0) {
            int len = this.mis.read(buf);
            is.write(buf, 0, len);
        }
        return is.getInputStream();
    }

    private Color getColor(SavotResource res) {
        ParamSet params = res.getParams();
        int nbParams = params.getItemCount();
        for (int i = 0; i < nbParams; ++i) {
            SavotParam param = (SavotParam)params.getItemAt(i);
            if ((param = this.getParam(param)) == null || !param.getName().equalsIgnoreCase("color")) continue;
            String val = param.getValue();
            int idx = Util.indexInArrayOf(val, Action.COLORNAME);
            if (idx >= 0) {
                return Action.MYCOLORS[idx];
            }
            return Action.decodeStaticRGB(val);
        }
        return null;
    }
}

