/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.SubFootprintBean;
import java.util.Hashtable;
import java.util.Vector;

public class FootprintBean {
    private static Hashtable hash = new Hashtable();
    private double posAngle = 0.0;
    private String ra;
    private String de;
    private String raRot;
    private String deRot;
    private boolean raIsSet = false;
    private boolean decIsSet = false;
    private boolean raRotIsSet = false;
    private boolean decRotIsSet = false;
    private boolean movable = false;
    private boolean rollable = false;
    private String instrumentName;
    private String telescopeName;
    private String instrumentDesc;
    private boolean displayInFovList = true;
    private String origin;
    Vector<SubFootprintBean> subFootprints = new Vector();

    FootprintBean() {
    }

    protected void addSubFootprintBean(SubFootprintBean sFpBean) {
        this.subFootprints.add(sFpBean);
    }

    public boolean isDisplayInFovList() {
        return this.displayInFovList;
    }

    public void setDisplayInFovList(boolean displayInFovList) {
        this.displayInFovList = displayInFovList;
    }

    protected SubFootprintBean[] getBeans() {
        Object[] beans = new SubFootprintBean[this.subFootprints.size()];
        this.subFootprints.copyInto(beans);
        return beans;
    }

    static void registerNewTemplate(String id, FootprintBean footprint) {
        if (hash.get(id) != null) {
            return;
        }
        hash.put(id, footprint);
    }

    static FootprintBean getTemplate(String id) {
        return (FootprintBean)hash.get(id);
    }

    protected boolean isMovable() {
        return this.movable;
    }

    protected void setMovable(boolean movable) {
        this.movable = movable;
    }

    protected double getPosAngle() {
        return this.posAngle;
    }

    protected void setPosAngle(double posAngle) {
        this.posAngle = posAngle;
    }

    protected boolean isRollable() {
        return this.rollable;
    }

    protected void setRollable(boolean rollable) {
        this.rollable = rollable;
    }

    protected void setRa(String ra) {
        this.ra = ra;
        this.raIsSet = true;
    }

    protected void setDe(String de) {
        this.de = de;
        this.decIsSet = true;
    }

    protected void setRaRot(String ra) {
        this.raRot = ra;
        this.raRotIsSet = true;
    }

    protected void setDeRot(String de) {
        this.deRot = de;
        this.decRotIsSet = true;
    }

    protected double getRa() throws Exception {
        Coord c = new Coord(this.ra + " " + this.de);
        return c.al;
    }

    protected double getDe() throws Exception {
        Coord c = new Coord(this.ra + " " + this.de);
        return c.del;
    }

    protected double getRaRot() throws Exception {
        Coord c = new Coord(this.raRot + " " + this.deRot);
        return c.al;
    }

    protected double getDeRot() throws Exception {
        Coord c = new Coord(this.raRot + " " + this.deRot);
        return c.del;
    }

    protected boolean coordsAreSet() {
        return this.raIsSet && this.decIsSet;
    }

    protected boolean rotAreSet() {
        return this.raRotIsSet && this.decRotIsSet;
    }

    protected String getInstrumentDesc() {
        return this.instrumentDesc == null ? "" : this.instrumentDesc;
    }

    protected void setInstrumentDesc(String instrumentDesc) {
        this.instrumentDesc = instrumentDesc;
    }

    protected String getInstrumentName() {
        return this.instrumentName == null ? "" : this.instrumentName;
    }

    protected void setInstrumentName(String instrumentName) {
        this.instrumentName = instrumentName;
    }

    protected String getTelescopeName() {
        return this.telescopeName == null ? "" : this.telescopeName;
    }

    protected void setTelescopeName(String telescopeName) {
        this.telescopeName = telescopeName;
    }

    public String getOrigin() {
        return this.origin == null ? "" : this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
}

