/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FilterProperties;
import cds.aladin.MyLabel;
import cds.aladin.PlanFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class FilterHelp
extends JFrame
implements ActionListener {
    private static FilterHelp singleton = null;
    private static final String COPY_DEF = "Copy/Paste this definition";
    private static final String TITRE = "Examples of filters";
    private static final Color BKGD = Color.white;
    private static final Font TITLE_FONT = Aladin.BOLD;
    private static final Color TITLE_COLOR = new Color(127, 159, 191);
    private static final Font COMMENT_FONT = Aladin.PLAIN;
    private static final Color COMMENT_COLOR = new Color(63, 127, 95);
    private static final Font DEF_FONT = Aladin.COURIER;
    private static final Color DEF_COLOR = Color.black;
    private static final Color CONDITION_COLOR = new Color(165, 75, 135);

    private FilterHelp() {
        super(TITRE);
        Aladin.setIcon(this);
        this.setSize(550, (int)((double)Aladin.SCREENSIZE.height * 0.7));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        this.getContentPane().add(mainPanel);
        mainPanel.add((Component)this.suite(), "Center");
        this.setLocation(350, 200);
    }

    private JScrollPane suite() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        panel.setLayout(g);
        String[] def = PlanFilter.PREDEFFILTERS;
        String[] names = PlanFilter.PREDEFLABELS;
        String line = null;
        for (int i = 0; i < names.length; ++i) {
            String curName = names[i];
            this.writeTitle(panel, g, c, curName);
            StringBuffer comments = new StringBuffer();
            StringTokenizer st = new StringTokenizer(def[i], "\n");
            st.nextToken();
            while (st.hasMoreTokens() && (line = st.nextToken().trim()).startsWith("#")) {
                comments.append(line.substring(1).trim());
                if (!st.hasMoreElements()) continue;
                comments.append('\n');
            }
            this.writeComment(panel, g, c, comments.toString());
            StringBuffer curDef = new StringBuffer();
            if (line.length() != 0) {
                curDef.append(line + "\n");
            }
            while (st.hasMoreTokens() && !(line = st.nextToken().trim()).startsWith("#")) {
                if (line.length() == 0) continue;
                curDef.append(line);
                if (!st.hasMoreElements()) continue;
                curDef.append('\n');
            }
            this.writeDefinition(panel, g, c, curDef.toString());
            JButton b = new JButton(COPY_DEF);
            b.addActionListener(this);
            b.setActionCommand(i + "");
            Insets save = c.insets;
            c.insets = new Insets(10, save.left, save.right, 0);
            c.anchor = 10;
            g.setConstraints(b, c);
            panel.add(b);
            c.insets = save;
        }
        JScrollPane scroll = new JScrollPane(panel);
        scroll.setOpaque(false);
        scroll.getVerticalScrollBar().setUnitIncrement(50);
        return scroll;
    }

    private void writeTitle(JPanel p, GridBagLayout g, GridBagConstraints c, String title) {
        JLabel l = new JLabel(title);
        l.setFont(TITLE_FONT);
        l.setForeground(TITLE_COLOR);
        Insets save = c.insets;
        c.insets = new Insets(10, save.left, 10, save.right);
        c.anchor = 17;
        c.gridwidth = 0;
        g.setConstraints(l, c);
        p.add(l);
        c.insets = save;
    }

    private void writeComment(JPanel p, GridBagLayout g, GridBagConstraints c, String comment) {
        MyLabel l = new MyLabel(comment, 0);
        l.setFont(COMMENT_FONT);
        l.setForeground(COMMENT_COLOR);
        Insets save = c.insets;
        c.insets = new Insets(0, 45, 10, 0);
        c.anchor = 17;
        c.gridwidth = 0;
        g.setConstraints(l, c);
        p.add(l);
        c.insets = save;
    }

    private void writeDefinition(JPanel p, GridBagLayout g, GridBagConstraints c, String def) {
        Insets save = c.insets;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 15, 0, 0);
        c.gridwidth = 0;
        StringTokenizer st = new StringTokenizer(def, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int idxAction = line.indexOf(" {");
            if (line.trim().endsWith("||")) {
                idxAction = line.length();
            }
            if (idxAction > 0) {
                JPanel pp = new JPanel(new FlowLayout(0, 0, 0));
                String cond = line.substring(0, idxAction);
                String action = line.substring(idxAction);
                JLabel lCond = new JLabel(cond);
                lCond.setFont(DEF_FONT);
                lCond.setForeground(CONDITION_COLOR);
                pp.add(lCond);
                JLabel lAction = new JLabel(action);
                lAction.setFont(DEF_FONT);
                lAction.setForeground(DEF_COLOR);
                pp.add(lAction);
                g.setConstraints(pp, c);
                p.add(pp);
                continue;
            }
            JLabel l = new JLabel(line);
            l.setFont(DEF_FONT);
            l.setForeground(DEF_COLOR);
            c.gridwidth = 0;
            g.setConstraints(l, c);
            p.add(l);
        }
        c.insets = save;
    }

    private void makeAdd(Component comp, GridBagLayout g, GridBagConstraints c, int gridwidth, JPanel p) {
        c.gridwidth = gridwidth;
        g.setConstraints(comp, c);
        p.add(comp);
    }

    protected static FilterHelp getInstance() {
        if (singleton == null) {
            singleton = new FilterHelp();
        }
        return singleton;
    }

    @Override
    public void toFront() {
        this.move(350, 200);
        super.toFront();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object target = ae.getSource();
        if (!(target instanceof JButton)) {
            return;
        }
        int idx = Integer.parseInt(ae.getActionCommand());
        final FilterProperties window = FilterProperties.getCurWindow();
        if (window != null && window.isShowing()) {
            window.filterDef.setText(PlanFilter.PREDEFFILTERS[idx]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                window.filterDefSp.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 201) {
            this.hide();
        }
        return super.handleEvent(e);
    }
}

