/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Save;
import cds.tools.Util;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class Export
implements Runnable {
    static final int DEFAULT_PORT = 4128;
    static final int MAX = 5;
    static final int SERVER = 0;
    static final int SOCKET = 1;
    private static Export export = null;
    private static boolean serverRunning;
    private ServerSocket server;
    private int port;
    private int nbExport;
    private Socket _sk;
    private int _modeRun;
    private boolean lock;
    private boolean isStopping;
    private Aladin aladin;

    protected Export(Aladin aladin) {
        this.aladin = aladin;
        this.nbExport = 0;
    }

    protected static String export(Plan plan) {
        Aladin aladin = plan.aladin;
        try {
            if (export == null) {
                if (!Aladin.confirmation(aladin.dialog, Aladin.chaine.getString("EXPORTWARNING"))) {
                    return null;
                }
                export = new Export(aladin);
            }
            export.setStopping(false);
            if (!export.isServerRunning()) {
                Export.export.port = 4128;
                int i = 0;
                while (i < 5 && !export.launchServer(Export.export.port)) {
                    ++i;
                    ++Export.export.port;
                }
                if (i == 5) {
                    return null;
                }
            }
            export.addNbExport(1);
            String ip = InetAddress.getLocalHost().getHostAddress();
            String url = "http://" + ip + ":" + Export.export.port + "/" + URLEncoder.encode(plan.label);
            Aladin cfr_ignored_0 = Export.export.aladin;
            Aladin.trace(1, "export(" + plan + ") via url=" + url);
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    synchronized void addNbExport(int n) {
        this.nbExport += n;
    }

    synchronized void unlock() {
        this.lock = false;
    }

    private void waitLock() {
        while (!this.getLock()) {
            Util.pause(100);
        }
    }

    private synchronized boolean getLock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return true;
    }

    synchronized void setServerRunning(boolean flag) {
        serverRunning = flag;
    }

    synchronized boolean isServerRunning() {
        return serverRunning;
    }

    synchronized void setStopping(boolean flag) {
        this.isStopping = flag;
    }

    synchronized boolean isStopping() {
        return this.isStopping;
    }

    private boolean launchServer(int port) throws Exception {
        try {
            this.server = new ServerSocket(port);
        }
        catch (Exception e) {
            return false;
        }
        this.waitLock();
        this.setServerRunning(true);
        this._modeRun = 0;
        new Thread((Runnable)this, "AladinHttpd").start();
        return true;
    }

    private void runServer() {
        Aladin.trace(2, "Aladin tiny httpd is starting on port " + this.port);
        this.unlock();
        try {
            while (!this.isStopping()) {
                this.server.setSoTimeout(10000);
                try {
                    Socket sk = this.server.accept();
                    this.waitLock();
                    this._sk = sk;
                    this._modeRun = 1;
                    new Thread((Runnable)this, "AladinHttpdBis").start();
                }
                catch (Exception e1) {}
            }
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Aladin.trace(2, "Aladin tiny httpd is stopped !");
        this.setServerRunning(false);
        this.server = null;
    }

    @Override
    public void run() {
        switch (this._modeRun) {
            case 0: {
                this.runServer();
                break;
            }
            case 1: {
                this.runSocket();
            }
        }
    }

    public void runSocket() {
        Socket sk = this._sk;
        this.unlock();
        try {
            String s1;
            InputStream in = sk.getInputStream();
            BufferedOutputStream out = new BufferedOutputStream(sk.getOutputStream());
            DataInputStream dis = new DataInputStream(in);
            String s = dis.readLine();
            while ((s1 = dis.readLine()) != null && s1.length() > 0) {
            }
            StringTokenizer st = new StringTokenizer(s);
            if (st.nextToken().equals("GET")) {
                String planID = URLDecoder.decode(st.nextToken().substring(1));
                Aladin.trace(2, "Sending plane [" + planID + "] to " + sk.getInetAddress().getHostAddress() + "...");
                this.send(out, planID);
            }
            out.flush();
            in.close();
            out.close();
            sk.close();
            this.addNbExport(-1);
            if (this.nbExport <= 0) {
                this.setStopping(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendString(OutputStream out, String s) throws Exception {
        char[] a = s.toCharArray();
        byte[] b = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = (byte)a[i];
        }
        out.write(b);
    }

    private void sendError(OutputStream out, String msg) throws Exception {
        this.sendString(out, "HTTP/1.0 404 OK\r\nContent-type: text/plain\r\n\r\n" + msg);
    }

    private void send(OutputStream out, String planID) throws Exception {
        Plan p = this.aladin.command.getNumber(planID);
        if (p == null) {
            this.sendError(out, "Plane [" + planID + "] no longer existing");
            return;
        }
        if (p.isSimpleImage() && p.flagOk) {
            this.sendString(out, "HTTP/1.0 200 OK\r\nContent-type: image/x-fits\r\n\r\n");
            if (this.aladin.save == null) {
                this.aladin.save = new Save(this.aladin);
            }
            this.aladin.save.saveImageFITS(out, (PlanImage)p);
        } else if (p.isSimpleCatalog() && p.flagOk) {
            this.sendString(out, "HTTP/1.0 200 OK\r\nContent-type: text/xml\r\n\r\n");
            this.aladin.writePlaneInVOTable(p, out, false, false);
        } else {
            this.sendError(out, "Plan [" + planID + "] is not a valid Aladin plane");
        }
    }
}

