/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.CoteBase;
import cds.aladin.CoteDist;
import cds.aladin.Couleur;
import cds.aladin.Ligne;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.astro.AstroMath;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;

public class Cote
extends Ligne {
    protected double dist = -1.0;
    protected double distRA = -1.0;
    protected double distDE = -1.0;
    private double distXY = -1.0;
    private boolean withTriangle = false;
    private int labelMode = -1;
    private static final String[] LABELMODES = new String[]{"No label when unselected", "Only distance label when unselected", "Triangle distance lines and labels"};
    private int[] vBresenham = null;
    private int[] repBresenham = null;

    protected Cote(Plan plan, ViewSimple v, double x, double y) {
        super(plan, v, x, y, (String)null);
        this.bout = (byte)2;
    }

    protected Cote(Plan plan) {
        super(plan);
        this.bout = (byte)2;
    }

    protected Cote(Plan plan, ViewSimple v, double x, double y, String id) {
        super(plan, v, x, y, id);
        this.bout = (byte)2;
    }

    protected Cote(Plan plan, ViewSimple v, double x, double y, Cote debcote) {
        this(plan, v, x, y, "", debcote);
    }

    protected Cote(Plan plan, ViewSimple v, double x, double y, String id, Cote debcote) {
        super(plan, v, x, y, id, (Ligne)debcote);
        this.bout = (byte)2;
    }

    protected Cote(double ra, double dec, Plan plan, ViewSimple v, Cote debcote) {
        super(ra, dec, plan, v, (Ligne)debcote);
        this.bout = (byte)2;
    }

    protected Cote(double ra, double dec, Plan plan, ViewSimple v, Ligne debcote) {
        super(ra, dec, plan, v, debcote);
        this.bout = (byte)2;
    }

    @Override
    public Vector getProp() {
        Cote deb = (Cote)this.getFirstBout();
        Cote fin = (Cote)this.getLastBout();
        Vector propList = deb.getProp1();
        propList.addAll(fin.getProp1());
        final Couleur col = new Couleur(this.couleur, true);
        final PropAction changeCouleur = new PropAction(){

            @Override
            public int action() {
                Color c = col.getCouleur();
                if (c == Cote.this.couleur) {
                    return -1;
                }
                Cote.this.setColor(c);
                return 1;
            }
        };
        col.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeCouleur.action();
                Cote.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("color", "Color", "Alternative color", col, null, changeCouleur));
        final JComboBox<String> pole = new JComboBox<String>(LABELMODES);
        PropAction updatePole = new PropAction(){

            @Override
            public int action() {
                Cote.this.labelMode = Cote.this.isWithLabel() ? (Cote.this.isWithTriangle() ? 2 : 1) : 0;
                pole.setSelectedIndex(Cote.this.labelMode);
                return 1;
            }
        };
        final PropAction changeLabel = new PropAction(){

            @Override
            public int action() {
                int mode = pole.getSelectedIndex();
                if (Cote.this.labelMode == mode) {
                    return -1;
                }
                Cote.this.setWithLabel(mode > 0);
                Cote.this.setWithTriangle(mode == 2);
                return 1;
            }
        };
        pole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeLabel.action();
                Cote.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("Labels", "Labels", "Distance labels control", pole, updatePole, changeLabel));
        return propList;
    }

    public Vector getProp1() {
        Vector propList = super.getProp();
        Prop.remove(propList, "color");
        return propList;
    }

    @Override
    public String getObjType() {
        return this.finligne == null ? "Arrow" : "Arrow+";
    }

    @Override
    protected void status(Aladin aladin) {
        this.setId();
        super.status(aladin);
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        if (!super.in(v, x, y)) {
            return false;
        }
        this.setId(v);
        return true;
    }

    protected double getDist() {
        return this.dist;
    }

    protected double getDistXY() {
        return this.distXY;
    }

    @Override
    protected void deltaPosition(ViewSimple v, double x, double y) {
        super.deltaPosition(v, x, y);
        if (this.finligne != null && this.finligne instanceof Cote) {
            ((Cote)this.finligne).setId(v);
        } else {
            this.setId(v);
        }
    }

    @Override
    protected void deltaRaDec(double dra, double dde) {
        super.deltaRaDec(dra, dde);
        if (this.finligne != null && this.finligne instanceof Cote) {
            ((Cote)this.finligne).setId();
        } else {
            this.setId();
        }
    }

    @Override
    protected void setPosition(ViewSimple v, double x, double y) {
        super.setPosition(v, x, y);
        if (this.finligne != null && this.finligne instanceof Cote) {
            ((Cote)this.finligne).setId();
        }
        this.setId();
    }

    protected void setId() {
        this.setId(null);
    }

    protected void setId(ViewSimple v) {
        double dy;
        double dx;
        Ligne p1;
        Ligne p2;
        block11: {
            if (this.debligne != null) {
                p2 = this;
                p1 = this.debligne;
            } else {
                p2 = this.finligne;
                p1 = this;
            }
            if (v == null) {
                v = this.plan.aladin.view.getCurrentView();
            }
            if (v == null) {
                return;
            }
            int frame = this.plan.aladin.localisation.getFrame();
            if (frame != 11 && frame != 12 && frame != 13) {
                try {
                    if (Projection.isOk(v.getProj())) {
                        Coord c1 = new Coord(p1.raj, p1.dej);
                        Coord c2 = new Coord(p2.raj, p2.dej);
                        if (!Double.isNaN(c1.al) && !Double.isNaN(c2.al)) {
                            double drac;
                            double angle;
                            double dra = c2.al - c1.al;
                            double dde = Math.abs(c1.del - c2.del);
                            double cosc2 = AstroMath.cosd(c2.del);
                            double num = cosc2 * AstroMath.sind(dra);
                            double den = AstroMath.sind(c2.del) * AstroMath.cosd(c1.del) - cosc2 * AstroMath.sind(c1.del) * AstroMath.cosd(dra);
                            double d = dra == 0.0 && dde == 0.0 ? -1000.0 : (angle = den == 0.0 ? 90.0 : Math.atan2(num, den) * 180.0 / Math.PI);
                            if (angle < 0.0) {
                                angle += 360.0;
                            }
                            if ((dra = Math.abs(dra)) > 180.0) {
                                dra -= 360.0;
                            }
                            this.distRA = drac = dra * AstroMath.cosd(c1.del);
                            this.distDE = dde;
                            this.dist = Coord.getDist(c1, c2);
                            this.id = this.dist == 0.0 ? "Null distance" : "Dist = " + Coord.getUnit(this.dist) + " (RA=" + Coord.getUnit(drac) + "/" + Coord.getUnitTime(dra / 15.0) + ", DE=" + Coord.getUnit(dde) + ")" + (angle == -1000.0 ? "" : " PA = " + (double)Math.round(angle * 10.0) / 10.0 + " deg");
                            v.getProj().getXY(c1);
                            v.getProj().getXY(c2);
                            double dx2 = c1.x - c2.x;
                            double dy2 = c1.y - c2.y;
                            this.distXY = (int)(Math.sqrt(dx2 * dx2 + dy2 * dy2) + 0.5);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block11;
                    e.printStackTrace();
                }
            }
        }
        this.distRA = dx = v.HItoI(p1.xv[v.n]) - v.HItoI(p2.xv[v.n]);
        this.distDE = dy = v.HItoI(p1.yv[v.n]) - v.HItoI(p2.yv[v.n]);
        this.dist = this.distXY = Math.sqrt(dx * dx + dy * dy);
        this.id = Util.myRound(this.distXY + "", 1) + " (delta x=" + Util.myRound(dx + "", 2) + ", delta y=" + Util.myRound(dy + "", 2) + ")";
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        Ligne autreCote;
        Ligne bout;
        if (!this.isVisible()) {
            return false;
        }
        if (this.nearArrow(v, x, y)) {
            return true;
        }
        if (this.debligne == null) {
            autreCote = bout = this.finligne;
        } else {
            autreCote = this.debligne;
            bout = this;
        }
        return bout.in(v, x, y) && !autreCote.nearArrow(v, x, y);
    }

    @Override
    protected final void setWithLabel(boolean withLabel) {
        Ligne autreCote;
        Ligne bout;
        if (this.debligne == null) {
            autreCote = bout = this.finligne;
        } else {
            autreCote = this.debligne;
            bout = this;
        }
        if (withLabel) {
            bout.flags = (byte)(bout.flags | 8);
            autreCote.flags = (byte)(autreCote.flags | 8);
        } else {
            bout.flags = (byte)(bout.flags & 0xFFFFFFF7);
            autreCote.flags = (byte)(autreCote.flags & 0xFFFFFFF7);
        }
    }

    @Override
    protected boolean isWithLabel() {
        Ligne autreCote;
        Ligne bout;
        if (this.debligne == null) {
            autreCote = bout = this.finligne;
        } else {
            autreCote = this.debligne;
            bout = this;
        }
        return (bout.flags & 8) != 0 || (autreCote.flags & 8) != 0;
    }

    protected boolean isWithTriangle() {
        return this.withTriangle;
    }

    protected void setWithTriangle(boolean withTriangle) {
        this.withTriangle = withTriangle;
    }

    @Override
    protected void drawID(Graphics g, ViewSimple v, Point p1, Point p2) {
        if (!this.isCoteSelected() && !this.isWithLabel()) {
            return;
        }
        this.drawID1(g, v, p1, p2);
    }

    protected void drawID1(Graphics g, ViewSimple v, Point p1, Point p2) {
        int frame = this.plan.aladin.localisation.getFrame();
        String s = this.raj == Double.NaN || frame == 11 || frame == 12 || frame == 13 ? Util.myRound(this.dist + "", 2) : Coord.getUnit(this.dist);
        this.drawLabel(g, v, p1, p2, s, Aladin.BOLD);
    }

    private boolean isCoteSelected() {
        if (this.debligne != null) {
            return this.isSelected() || this.debligne.isSelected();
        }
        return this.isSelected() || this.finligne.isSelected();
    }

    @Override
    protected int clipXId() {
        return !this.isCoteSelected() ? 0 : 12 * Coord.getUnit(this.dist).length();
    }

    @Override
    protected int clipYId() {
        return !this.isCoteSelected() ? 0 : 15;
    }

    @Override
    protected boolean tooLarge(ViewSimple v, Point p1, Point p2) {
        return false;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (this instanceof CoteDist) {
            return super.draw(g, v, dx, dy);
        }
        if (!this.isVisible()) {
            return false;
        }
        if (!super.draw(g, v, dx, dy)) {
            this.cutOff();
            return false;
        }
        this.drawCoteBase(g, v, dx, dy);
        if ((this.isSelected() || this.debligne != null && this.debligne.isSelected() || this.finligne != null && this.finligne.isSelected()) && this.plan.aladin.view.hasOneCoteSelected()) {
            this.cutOn();
        } else {
            this.cutOff();
        }
        return true;
    }

    private boolean isDrawingTriangle() {
        return this.withTriangle;
    }

    @Override
    protected void drawCoteBase(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isDrawingTriangle()) {
            return;
        }
        if (this.debligne == null) {
            return;
        }
        double lon = this.raj;
        double lat = this.debligne.dej;
        CoteBase base = new CoteBase(lon, lat, this.plan, v, (Ligne)new CoteBase(this.debligne, v), Coord.getUnit(this.distRA));
        base.draw(g, v, dx, dy);
        CoteBase hauteur = new CoteBase(lon, lat, this.plan, v, (Ligne)new CoteBase(this, v), Coord.getUnit(this.distDE));
        hauteur.draw(g, v, dx, dy);
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        if (!this.isVisible()) {
            return clip;
        }
        clip = super.extendClip(v, clip);
        if (!this.isDrawingTriangle()) {
            return clip;
        }
        double lon = this.debligne == null ? this.finligne.raj : this.raj;
        double lat = this.debligne == null ? this.dej : this.debligne.dej;
        Position a = new Position(this.plan, v, 0.0, 0.0, lon, lat, 2, null);
        a.projection(v);
        return a.extendClip(v, clip);
    }

    protected void cutOff() {
        this.plan.aladin.calque.zoom.zoomView.cutOff(this);
    }

    @Override
    protected boolean cutOn() {
        boolean rep = this.cutOn1();
        if (!rep) {
            this.plan.aladin.calque.zoom.zoomView.setCut(null);
        }
        return rep;
    }

    protected boolean cutOn1() {
        int y2;
        int x2;
        int y1;
        int x1;
        ViewSimple v = this.plan.aladin.view.getCurrentView();
        if (v == null || this.plan.aladin.toolBox.getTool() == 8) {
            return false;
        }
        Plan p = v.pref;
        if (p == null || !p.hasAvailablePixels() && !(p instanceof PlanImageRGB)) {
            return false;
        }
        PlanImage pi = (PlanImage)p;
        if (this.debligne == null) {
            x1 = (int)this.xv[v.n];
            y1 = (int)this.yv[v.n];
            x2 = (int)this.finligne.xv[v.n];
            y2 = (int)this.finligne.yv[v.n];
        } else {
            x1 = (int)this.debligne.xv[v.n];
            y1 = (int)this.debligne.yv[v.n];
            x2 = (int)this.xv[v.n];
            y2 = (int)this.yv[v.n];
        }
        if (x1 != x2 || y1 != y2) {
            if (v.northUp || v.isProjSync()) {
                PointD p1 = new PointD(x1, y1);
                p1 = v.northOrSyncToRealPosition(p1);
                x1 = (int)p1.x;
                y1 = (int)p1.y;
                p1 = new PointD(x2, y2);
                p1 = v.northOrSyncToRealPosition(p1);
                x2 = (int)p1.x;
                y2 = (int)p1.y;
            }
            int[] res = this.bresenham(pi, x1, y1, x2, y2);
            int mode = pi.type == 2 || pi.type == 20 ? 1 : 0;
            this.plan.aladin.calque.zoom.zoomView.setCut(this, res, mode);
        }
        return true;
    }

    protected int[] bresenham(PlanImage pi, int x1, int y1, int x2, int y2) {
        int i;
        boolean croissant;
        int diago;
        int e;
        int yend;
        int xend;
        int y;
        int x;
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int width = pi.width;
        int height = pi.height;
        int n = 0;
        if (this.vBresenham == null || this.vBresenham.length != dx + dy + 2) {
            this.vBresenham = new int[dx + dy + 2];
        }
        n = 0;
        boolean inverse = false;
        if (dx > dy) {
            if (x1 < x2) {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            } else {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
                inverse = true;
            }
            e = 2 * dy - dx;
            int horiz = 2 * dy;
            diago = 2 * (dy - dx);
            croissant = y < yend;
            for (i = 0; i < dx; ++i) {
                int n2 = this.vBresenham[n++] = x < 0 || x >= width || y < 0 || y >= height ? -1 : pi.getPixel8(x, y);
                if (e > 0) {
                    y = croissant ? ++y : --y;
                    e += diago;
                } else {
                    e += horiz;
                }
                ++x;
            }
        } else {
            if (y1 < y2) {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            } else {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
                inverse = true;
            }
            e = 2 * dx - dy;
            int verti = 2 * dx;
            diago = 2 * (dx - dy);
            croissant = x < xend;
            for (i = 0; i < dy; ++i) {
                int n3 = this.vBresenham[n++] = x < 0 || x >= width || y < 0 || y >= height ? -1 : pi.getPixel8(x, y);
                if (e > 0) {
                    x = croissant ? ++x : --x;
                    e += diago;
                } else {
                    e += verti;
                }
                ++y;
            }
        }
        int n4 = this.vBresenham[n++] = xend < 0 || xend >= width || yend < 0 || yend >= height ? -1 : pi.getPixel8(xend, yend);
        if (this.repBresenham == null || this.repBresenham.length != n) {
            this.repBresenham = new int[n];
        }
        if (inverse) {
            for (int i2 = 0; i2 < n; ++i2) {
                this.repBresenham[n - i2 - 1] = this.vBresenham[i2];
            }
        } else {
            System.arraycopy(this.vBresenham, 0, this.repBresenham, 0, n);
        }
        this.vBresenham = null;
        return this.repBresenham;
    }
}

