/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.LigneConst;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.TagConstellation;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public class Constellation {
    private static final String CONSTELLATION_FILE = "Constellation.txt";
    private static Color COLOR = new Color(255, 200, 68);
    private Aladin aladin;
    private HashMap<String, ArrayList<Position>> cstMap;
    private short[] projOk;

    protected Constellation(Aladin aladin) {
        block2: {
            this.cstMap = null;
            this.projOk = new short[16];
            this.aladin = aladin;
            try {
                this.load();
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws Exception {
        try (BufferedReader is = null;){
            is = new BufferedReader(new InputStreamReader(this.aladin.getClass().getResourceAsStream("/Constellation.txt")));
            this.cstMap = new HashMap();
            String oCst = null;
            ArrayList<Position> cc = null;
            LigneConst oc = null;
            Projection proj = null;
            double minX = 0.0;
            double maxX = 0.0;
            double minY = 0.0;
            double maxY = 0.0;
            boolean flagInit = true;
            boolean encore = true;
            while (encore) {
                String s = is.readLine();
                if (s == null) {
                    encore = false;
                }
                try {
                    Coord coo;
                    LigneConst c;
                    String cst;
                    double ra = 0.0;
                    double dec = 0.0;
                    if (!encore) {
                        cst = "";
                    } else {
                        Tok tok = new Tok(s, " ");
                        ra = Double.parseDouble(tok.nextToken());
                        dec = Double.parseDouble(tok.nextToken());
                        cst = tok.nextToken();
                    }
                    if (!cst.equals(oCst)) {
                        if (cc != null) {
                            c = (LigneConst)cc.get(0);
                            c = new LigneConst(oc.raj, oc.dej, oc);
                            c.bout = (byte)3;
                            cc.add(c);
                            coo = new Coord();
                            coo.x = (minX + maxX) / 2.0;
                            coo.y = (minY + maxY) / 2.0;
                            if (oCst.equals("DRA")) {
                                coo.x -= (maxX - minX) / 3.0;
                            } else if (oCst.equals("ERI")) {
                                coo.x -= (maxX - minX) / 4.0;
                            } else if (oCst.equals("PUP")) {
                                coo.x -= (maxX - minX) / 4.0;
                            } else if (oCst.equals("PSC")) {
                                coo.x -= (maxX - minX) / 4.0;
                            } else if (oCst.equals("SER2")) {
                                coo.y -= (maxX - minX) / 6.0;
                            } else if (oCst.equals("SCO")) {
                                coo.y += (maxX - minX) / 5.0;
                            }
                            proj.getCoordNative(coo);
                            TagConstellation tag = new TagConstellation(coo, oCst);
                            tag.setColor(COLOR);
                            cc.add(tag);
                            this.cstMap.put(cst, cc);
                            oc = null;
                            flagInit = true;
                            if (!encore) {
                                break;
                            }
                        }
                        cc = new ArrayList<Position>();
                        proj = new Projection(null, 2, ra, dec, 60.0, 0.0, 0.0, 60.0, 0.0, false, 1, Calib.FK5);
                    }
                    oCst = cst;
                    c = new LigneConst(ra, dec, oc);
                    c.setColor(COLOR);
                    cc.add(c);
                    oc = c;
                    coo = new Coord(ra, dec);
                    proj.getXYNative(coo);
                    if (minX > coo.x || flagInit) {
                        minX = coo.x;
                    }
                    if (maxX < coo.x || flagInit) {
                        maxX = coo.x;
                    }
                    if (minY > coo.y || flagInit) {
                        minY = coo.y;
                    }
                    if (maxY < coo.y || flagInit) {
                        maxY = coo.y;
                    }
                    flagInit = false;
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) continue;
                    e.printStackTrace();
                }
            }
        }
    }

    protected void draw(Graphics g, ViewSimple v, int dx, int dy) {
        boolean flagProj = this.projOk[v.n] != v.iz;
        for (ArrayList<Position> cst : this.cstMap.values()) {
            for (Position o : cst) {
                if (flagProj) {
                    o.projection(v);
                }
                o.draw(g, v, dx, dy);
            }
        }
        this.projOk[v.n] = v.iz;
    }
}

