/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.CouleurBox;
import cds.aladin.Default;
import cds.aladin.Directory;
import cds.aladin.DirectoryFilter;
import cds.aladin.FrameColorMap;
import cds.aladin.Function;
import cds.aladin.Glu;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.TapManager;
import cds.aladin.Tok;
import cds.aladin.prop.PropPanel;
import cds.moc.SMoc;
import cds.mocmulti.MultiMoc;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingDeque;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Configuration
extends JFrame
implements Runnable,
ActionListener,
ItemListener,
ChangeListener {
    static final int DEF_MHEIGHT = 150;
    static final int DEF_HWIDTH = 250;
    static final int DEF_ZWIDTH = 220;
    static final int DEF_ZHEIGHT = 150;
    static final String ASTRONOMER = "astronomer";
    static final String UNDERGRADUATE = "undergraduate";
    static final String PREVIEW = "preview";
    private static String CONFIGNAME = "Aladin.conf";
    private static String MOCFILTER = "MocFilter";
    private static String CONFIGBKM = "Bookmarks.ajs";
    protected static String BROWSER = "UnixBrowser";
    protected static String GLU = "DefaultGluSite";
    protected static String DIR = "DefaultDir";
    protected static String CM = "DefaultCM";
    protected static String BKG = "BackgroundCM";
    protected static String POSITION = "PositionMode";
    protected static String LANG = "Language";
    protected static String CSV = "CSVchar";
    protected static String AUTODIST = "AutoDistance";
    protected static String SIMBAD = "SimbadPointer";
    protected static String VIZIERSED = "VizierSEDPointer";
    protected static String FILTER = "DedicatedFilter";
    protected static String TRANSOLD = "FootprintTransparency";
    protected static String TRANS = "Transparency";
    protected static String TRANSLEVEL = "TransparencyLevel";
    protected static String SURVEY = "Survey";
    protected static String SERVER = "Server";
    protected static String WINLOC = "WindowLocation";
    protected static String RETICLE = "Reticle";
    protected static String TOOLTIP = "Tooltip";
    protected static String SCROLL = "AutoScroll";
    protected static String MOD = "Profile";
    protected static String HPXGRID = "HealpixGrid";
    protected static String MHEIGHT = "SplitMeasureHeight";
    protected static String ZHEIGHT = "SplitZoomHeight";
    protected static String ZWIDTH = "SplitZoomWidth";
    protected static String HWIDTH = "SplitHiPSWidth";
    protected static String BOOKMARKS = "Bookmarks";
    protected static String FRAME = "Frame";
    protected static String FRAMEALLSKY = "FrameAllsky";
    protected static String PROJALLSKY = "ProjAllsky";
    protected static String VERSION = "Version";
    protected static String OFFICIALVERSION = "OfficialVersion";
    protected static String CDSMESSAGE = "CDSMessage";
    protected static String CACHE = "HpxCacheSize";
    protected static String MAXCACHE = "HpxMaxCacheSize";
    protected static String LOG = "Log";
    protected static String LOOKANDFEEL = "LookAndFeel";
    protected static String HELP = "Wizard";
    protected static String SLEPOCH = "SliderEpoch";
    protected static String SLSIZE = "SliderSize";
    protected static String SLDENS = "SliderDensity";
    protected static String SLCUBE = "SliderCube";
    protected static String SLOPAC = "SliderOpac";
    protected static String SLZOOM = "SliderZoom";
    protected static String SEDWAVE = "SEDWave";
    protected static String DIRFILER = "DirFilter";
    protected static String LASTFILE = "LastFile";
    protected static String LASTTARGET = "LastTarget";
    protected static String LASTTARGETNAME = "LastTargetName";
    protected static String LASTGLU = "LastGlu";
    protected static String LASTRUN = "LastRun";
    protected static String STOPHELP = "StopHelp";
    protected static String LOOKANDFEELTHEME = "LookAndFeelTheme";
    protected static String GRIDC = "GridColor";
    protected static String GRIDCRA = "GridColorRA";
    protected static String GRIDCDE = "GridColorDE";
    protected static String GRIDF = "GridColorFont";
    protected static String INFOC = "InfoColor";
    protected static String INFOCL = "InfoColorLabel";
    protected static String INFOF = "InfoFont";
    protected static String INFOB = "InfoBorder";
    protected static String TAPSCHEMADISPLAY = "TapSchemaDisplay";
    protected static String FILTERHDU = "FilterHDU";
    static final String[] DEPRECATED = new String[]{"MeasurementHeight"};
    static String NOTACTIVATED = "Not activated";
    static String ACTIVATED = "Activated";
    static String JAVA = "Java";
    static String OPSYS = "OS native";
    static String TITLE;
    static String DEFDIR;
    static String DEFDIRH;
    static String LANGUE;
    static String LANGUEH;
    static String LANGCONTRIB;
    static String CSVCHAR;
    static String CSVCHARH;
    static String PIXB;
    static String PIX8;
    static String PIXF;
    static String CMB;
    static String CMH;
    static String CMV;
    static String CMM;
    static String CMC;
    static String CMF;
    static String WEBB;
    static String WEBH;
    static String RELOAD;
    static String REGB;
    static String REGH;
    static String APPLY;
    static String CLOSE;
    static String BROWSE;
    static String FRAMEB;
    static String FRAMEALLSKYB;
    static String FRAMEH;
    static String OPALEVEL;
    static String PROJALLSKYB;
    static String PROJALLSKYH;
    static String FILTERB;
    static String FILTERH;
    static String FILTERN;
    static String FILTERY;
    static String SMBB;
    static String SMBH;
    static String TRANSB;
    static String TRANSH;
    static String IMGB;
    static String IMGH;
    static String IMGS;
    static String IMGC;
    static String MODE;
    static String MODEH;
    static String CACHES;
    static String CACHEH;
    static String UPHIDETAPSCHEMA;
    static String UPHIDETAPSCHEMAH;
    static String CLEARCACHE;
    static String LOGS;
    static String LOGH;
    static String HELPS;
    static String HELPH;
    static String FILTERHDUS;
    static String FILTERHDUH;
    static String SLIDERS;
    static String SLIDERH;
    static String SLIDEREPOCH;
    static String SLIDERDENSITY;
    static String SLIDERCUBE;
    static String SLIDERSIZE;
    static String SLIDEROPAC;
    static String SLIDERZOOM;
    static String FILEDIALOG;
    static String FILEDIALOGHELP;
    static String FILEDIALOGJAVA;
    static String FILEDIALOGNATIVE;
    static String THEME;
    static String THEMEHELP;
    static String RESTART;
    static String GRID;
    static String GRIDH;
    static String GRIDFONT;
    static String GRIDCOLOR;
    static String GRIDRACOLOR;
    static String GRIDDECOLOR;
    static String INFO;
    static String INFOH;
    static String INFOFONT;
    static String INFOCOLOR;
    static String INFOLABELCOLOR;
    static String INFOFONTBORDER;
    private static String[] CSVITEM;
    private static String[] CSVITEMLONG;
    private Aladin aladin;
    private Vector prop;
    private boolean flagModif;
    private boolean first = true;
    private boolean flagModifLang = true;
    private String currentLang = "En";
    protected LinkedBlockingDeque<String> lastFile;
    protected LinkedHashMap<String, String> filterExpr;
    protected HashMap<String, SMoc> filterMoc;
    private JTextField dir;
    private JTextField maxCache;
    private JLabel cache;
    private JComboBox frameChoice;
    private JComboBox frameAllskyChoice;
    private JComboBox projAllskyChoice;
    private JComboBox videoChoice;
    private JComboBox mapChoice;
    private JComboBox cutChoice;
    private JComboBox fctChoice;
    private JComboBox gluChoice;
    private JComboBox lfChoice;
    private JComboBox themeChoice;
    private JComboBox langChoice;
    private JComboBox modeChoice;
    private JComboBox filterChoice;
    private JComboBox transparencyChoice;
    private JComboBox logChoice;
    private JComboBox helpChoice;
    private JComboBox filterHDUChoice;
    private JSlider transparencyLevel;
    private JComboBox csvChoice;
    private int langItem;
    private int modeItem;
    private int csvItem;
    private Vector gluUrl;
    private JTextField serverTxt;
    private JTextField surveyTxt;
    private int lastGluChoice = -1;
    private JButton reload;
    private JCheckBox bxEpoch;
    private JCheckBox bxSize;
    private JCheckBox bxDens;
    private JCheckBox bxCube;
    private JCheckBox bxOpac;
    private JCheckBox bxZoom;
    private JComboBox gridFontCombo;
    private CouleurBox gridColorBox;
    private CouleurBox gridColorRABox;
    private CouleurBox gridColorDEBox;
    private JComboBox infoFontCombo;
    private JComboBox infoFontBorderCombo;
    private CouleurBox infoColorBox;
    private CouleurBox infoLabelColorBox;
    private static Langue[] lang;
    private Vector remoteLang = null;
    private int previousTheme = 0;
    private JCheckBox hideTapSchema = null;
    protected static String[] CMPARAM;
    private Thread gluTestThread = null;
    private Vector<String> stopHelp = null;
    private boolean setConfFrame = false;
    private Point initWinLocXY = new Point();
    private Dimension initWinLocWH = new Dimension();
    private int initMesureHeight = 0;
    private int oFrame = 0;
    private static final int MAXLASTFILE = 20;
    private ArrayList<String> memoGlu = null;

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("UPTITLE");
        DEFDIR = Aladin.chaine.getString("UPDEFDIR");
        DEFDIRH = Aladin.chaine.getString("UPDEFDIRH");
        LANGUE = Aladin.chaine.getString("UPLANGUE");
        LANGUEH = Aladin.chaine.getString("UPLANGUEH");
        LANGCONTRIB = Aladin.chaine.getString("UPLANGCONTRIB");
        MODE = Aladin.chaine.getString("UPMODE");
        MODEH = Aladin.chaine.getString("UPMODEH");
        CSVCHAR = Aladin.chaine.getString("UPCSVCHAR");
        CSVCHARH = Aladin.chaine.getString("UPCSVCHARH");
        PIXB = Aladin.chaine.getString("UPPIXB");
        PIX8 = "8 bit grey level";
        PIXF = "Full pixel";
        CMB = Aladin.chaine.getString("UPCMB");
        CMH = Aladin.chaine.getString("UPCMH");
        CMV = Aladin.chaine.getString("UPCMV");
        CMM = Aladin.chaine.getString("UPCMM");
        CMC = Aladin.chaine.getString("UPCMC");
        CMF = Aladin.chaine.getString("UPCMF");
        WEBB = Aladin.chaine.getString("UPWEBB");
        WEBH = Aladin.chaine.getString("UPWEBH");
        REGB = Aladin.chaine.getString("UPREGB");
        REGH = Aladin.chaine.getString("UPREGH");
        RELOAD = Aladin.chaine.getString("PROPRELOAD");
        APPLY = Aladin.chaine.getString("UPAPPLY");
        CLOSE = Aladin.chaine.getString("UPCLOSE");
        BROWSE = Aladin.chaine.getString("FILEBROWSE");
        FRAMEB = Aladin.chaine.getString("UPFRAMEB");
        CACHES = Aladin.chaine.getString("UPCACHE");
        CLEARCACHE = Aladin.chaine.getString("NPRESET");
        CACHEH = Aladin.chaine.getString("UPCACHEH");
        UPHIDETAPSCHEMA = Aladin.chaine.getString("UPHIDETAPSCHEMA");
        UPHIDETAPSCHEMAH = Aladin.chaine.getString("UPHIDETAPSCHEMAH");
        FRAMEALLSKYB = Aladin.chaine.getString("UPFRAMEALLSKYB");
        FRAMEH = Aladin.chaine.getString("UPFRAMEH");
        PROJALLSKYB = Aladin.chaine.getString("UPPROJALLSKYB");
        PROJALLSKYH = Aladin.chaine.getString("UPPROJALLSKYH");
        OPALEVEL = Aladin.chaine.getString("PROPOPACITYLEVEL");
        SMBB = Aladin.chaine.getString("UPSMBB");
        SMBH = Aladin.chaine.getString("UPSMBH");
        FILTERB = Aladin.chaine.getString("UPFILTERB");
        FILTERH = Aladin.chaine.getString("UPFILTERH");
        TRANSB = Aladin.chaine.getString("UPTRANSB");
        TRANSH = Aladin.chaine.getString("UPTRANSH");
        IMGB = Aladin.chaine.getString("UPIMGB");
        IMGH = Aladin.chaine.getString("UPIMGH");
        IMGS = Aladin.chaine.getString("UPIMGS");
        IMGC = Aladin.chaine.getString("UPIMGC");
        LOGS = Aladin.chaine.getString("UPLOG");
        LOGH = Aladin.chaine.getString("UPLOGH");
        HELPS = Aladin.chaine.getString("UPHELP");
        HELPH = Aladin.chaine.getString("UPHELPH");
        FILTERHDUS = Aladin.chaine.getString("UPFILTERHDU");
        FILTERHDUH = Aladin.chaine.getString("UPFILTERHDUH");
        SLIDERS = Aladin.chaine.getString("UPSLIDERS");
        SLIDERH = Aladin.chaine.getString("UPSLIDERH");
        SLIDEREPOCH = Aladin.chaine.getString("SLIDEREPOCH");
        SLIDERDENSITY = Aladin.chaine.getString("SLIDERDENSITY");
        SLIDERSIZE = Aladin.chaine.getString("SLIDERSIZE");
        SLIDERCUBE = Aladin.chaine.getString("SLIDERCUBE");
        SLIDEROPAC = Aladin.chaine.getString("OPACITY");
        SLIDERZOOM = Aladin.chaine.getString("ZOOM");
        FILEDIALOG = Aladin.chaine.getString("FILEDIALOG");
        FILEDIALOGHELP = Aladin.chaine.getString("FILEDIALOGHELP");
        FILEDIALOGJAVA = Aladin.chaine.getString("FILEDIALOGJAVA");
        FILEDIALOGNATIVE = Aladin.chaine.getString("FILEDIALOGNATIVE");
        THEME = Aladin.chaine.getString("THEME");
        THEMEHELP = Aladin.chaine.getString("THEMEHELP");
        RESTART = Aladin.chaine.getString("RESTART");
        GRID = Aladin.chaine.getString("UPGRID");
        GRIDH = Aladin.chaine.getString("UPGRIDH");
        GRIDFONT = Aladin.chaine.getString("UPGRIDFONT");
        GRIDCOLOR = Aladin.chaine.getString("UPGRIDCOLOR");
        GRIDRACOLOR = Aladin.chaine.getString("UPGRIDRACOLOR");
        GRIDDECOLOR = Aladin.chaine.getString("UPGRIDDECOLOR");
        INFO = Aladin.chaine.getString("UPINFO");
        INFOH = Aladin.chaine.getString("UPINFOH");
        INFOFONT = Aladin.chaine.getString("UPINFOFONT");
        INFOCOLOR = Aladin.chaine.getString("UPINFOCOLOR");
        INFOLABELCOLOR = Aladin.chaine.getString("UPINFOLABELCOLOR");
        INFOFONTBORDER = Aladin.chaine.getString("UPINFOFONTBORDER");
        CSVITEMLONG = new String[]{"Tab", "Pipe (|)", "Semicolon (;)", "Comma (,)", "Tab or Pipe (|)", "Tab, Pipe (|) or Semicolon (;)"};
    }

    public Configuration(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.prop = new Vector(10);
        this.filterMoc = new HashMap();
        this.filterExpr = new LinkedHashMap();
        this.setDirFilter("Color surveys", "dataproduct_subtype=color && moc_sky_fraction>0.2", null);
        this.setDirFilter("Large catalogs", "nb_rows>1000000", null);
        this.setDirFilter("Log missions", "ID=CDS/B*", null);
        this.flagModif = false;
    }

    protected JPanel getValidPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        JButton b = new JButton(APPLY);
        p.add(b);
        b.addActionListener(this);
        b.setFont(b.getFont().deriveFont(1));
        b = new JButton(CLOSE);
        p.add(b);
        b.addActionListener(this);
        return p;
    }

    @Override
    public void show() {
        if (this.first) {
            this.createChaine();
            this.setTitle(TITLE);
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            Aladin.makeAdd(this.getContentPane(), this.createPanel(), "Center");
            Aladin.makeAdd(this.getContentPane(), this.getValidPanel(), "South");
            this.pack();
            this.first = false;
            this.setLocation(Aladin.computeLocation(this));
        }
        this.updateWidgets();
        super.show();
    }

    private void createGluChoice() {
        this.gluChoice = new JComboBox();
        this.gluChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Configuration.this.reload != null) {
                    int index = Configuration.this.gluChoice.getSelectedIndex();
                    Configuration.this.reload.setEnabled(index == Configuration.this.lastGluChoice);
                }
            }
        });
        this.gluUrl = new Vector();
        Enumeration e = this.aladin.glu.aladinDic.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            int j;
            String key = (String)e.nextElement();
            if (!key.startsWith("AlaU.")) continue;
            String v = (String)this.aladin.glu.aladinDic.get(key);
            int k = v.indexOf("//");
            if (i < 0 || (j = v.indexOf("/", k + 2)) < 0) continue;
            this.gluUrl.addElement(v);
            v = v.substring(k + 2, j);
            this.gluChoice.addItem(v);
            ++i;
        }
    }

    private void setSyncMode(String mode) throws Exception {
        mode = Util.toUpper(mode);
        this.aladin.command.setSyncMode(mode == null || mode.indexOf("OFF") >= 0 || mode.indexOf("AUTO") >= 0 ? 0 : 0);
    }

    private void setSimbadMode(String mode) throws Exception {
        boolean flag;
        this.aladin.calque.flagSimbad = flag = (mode = Util.toUpper(mode)) != null && mode.indexOf("NO") < 0 && mode.indexOf("OFF") < 0;
        this.aladin.setButtonMode();
    }

    private void setFilterMode(String mode) throws Exception {
        this.aladin.FILTERDEFAULT = Util.toUpper(mode);
    }

    private void setCMMode(String mode) throws Exception {
        this.setMode1(mode, false);
    }

    private void setBkgMode(String mode) throws Exception {
        this.setMode1(mode, true);
    }

    private void setMode1(String mode, boolean flagBackground) throws Exception {
        if (CMPARAM == null) {
            CMPARAM = new String[4 + PlanImage.TRANSFERTFCT.length + FrameColorMap.CMA.length];
            Configuration.CMPARAM[0] = "reverse";
            Configuration.CMPARAM[1] = "noreverse";
            Configuration.CMPARAM[2] = "autocut";
            Configuration.CMPARAM[3] = "noautocut";
            System.arraycopy(PlanImage.TRANSFERTFCT, 0, CMPARAM, 4, PlanImage.TRANSFERTFCT.length);
            System.arraycopy(FrameColorMap.CMA, 0, CMPARAM, 4 + PlanImage.TRANSFERTFCT.length, FrameColorMap.CMA.length);
        }
        Tok tok = new Tok(mode);
        StringBuffer cm = null;
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (cm == null) {
                cm = new StringBuffer();
            } else {
                cm.append(' ');
            }
            int i = Util.indexInArrayOf(s, CMPARAM, true);
            if (i < 0) {
                throw new Exception("Not available cm mode ! [" + s + "]");
            }
            cm.append(CMPARAM[i]);
        }
        if (flagBackground) {
            this.aladin.BKGDEFAULT = cm.toString();
        } else {
            this.aladin.CMDEFAULT = cm.toString();
        }
        this.updateWidgets();
    }

    private void setCSV(String cs) {
        if (cs == null) {
            return;
        }
        StringBuffer colsep = new StringBuffer();
        StringTokenizer st = new StringTokenizer(cs, " ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("tab")) {
                colsep.append('\t');
                continue;
            }
            colsep.append(s.charAt(0));
        }
        this.aladin.CSVCHAR = colsep.toString();
    }

    private void setMaxCache(String s) {
        if (s == null) {
            return;
        }
        try {
            long maxCache = Long.parseLong(s);
            PlanBG.setMaxCacheSize(maxCache);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTransparency(String s, float level) {
        float oLevel;
        this.transparencyLevel.setToolTipText(OPALEVEL + " : " + (int)(level * 100.0f));
        boolean oTrans = Aladin.ENABLE_FOOTPRINT_OPACITY;
        boolean trans = !s.equals(NOTACTIVATED);
        if (trans != oTrans) {
            Aladin.ENABLE_FOOTPRINT_OPACITY = trans;
            this.aladin.calque.repaintAll();
        }
        if (level != (oLevel = Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL)) {
            Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL = level;
            this.aladin.calque.updateFootprintOpacity(oLevel, level);
            this.aladin.calque.repaintAll();
        }
    }

    protected void setSelectGluChoice(String s) {
        Enumeration e = this.gluUrl.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            if (s != null && s.startsWith((String)e.nextElement())) {
                this.gluChoice.setSelectedIndex(i);
                this.lastGluChoice = i;
                return;
            }
            ++i;
        }
    }

    @Override
    public void run() {
        this.launchGluTest();
    }

    private void launchGluTest() {
        Aladin.makeCursor(this, 1);
        this.aladin.glu.testAlaSites(false, true);
        Aladin.makeCursor(this, 0);
        Glu cfr_ignored_0 = this.aladin.glu;
        this.setSelectGluChoice(Glu.NPHGLUALADIN);
    }

    private boolean isUnixStandalone() {
        if (Aladin.isApplet()) {
            return false;
        }
        String syst = System.getProperty("os.name");
        return syst != null && !syst.startsWith("Windows") && !syst.startsWith("Mac");
    }

    protected int getBkgVideo() {
        String s;
        String string = s = this.aladin.BKGDEFAULT == null ? this.get(BKG) : this.aladin.BKGDEFAULT;
        if (s != null && s.indexOf("noreverse") == -1) {
            return 1;
        }
        return 0;
    }

    protected int getBkgFct() {
        String s = this.aladin.BKGDEFAULT == null ? this.get(BKG) : this.aladin.BKGDEFAULT;
        return this.getFct1(s);
    }

    private int getFct1(String s) {
        if (s != null) {
            for (int i = 0; i < PlanImage.TRANSFERTFCT.length; ++i) {
                if (s.indexOf(PlanImage.TRANSFERTFCT[i]) < 0) continue;
                return i;
            }
        }
        return 3;
    }

    protected int getBkgMap() {
        String s = this.aladin.BKGDEFAULT == null ? this.get(BKG) : this.aladin.BKGDEFAULT;
        return this.getMap1(s);
    }

    private int getMap1(String s) {
        if (s != null) {
            int i;
            for (i = 0; i < FrameColorMap.CMA.length; ++i) {
                if (s.indexOf(FrameColorMap.CMA[i]) < 0) continue;
                return i;
            }
            if (CanvasColorMap.customCMName != null) {
                Enumeration e = CanvasColorMap.customCMName.elements();
                while (e.hasMoreElements()) {
                    String t = (String)e.nextElement();
                    if (s.indexOf(t) >= 0) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return 0;
    }

    protected int getCMVideo() {
        String s;
        String string = s = this.aladin.CMDEFAULT == null ? this.get(CM) : this.aladin.CMDEFAULT;
        if (s != null && s.indexOf("noreverse") == -1) {
            return 1;
        }
        return 0;
    }

    protected boolean getCMCut() {
        String s;
        String string = s = this.aladin.CMDEFAULT == null ? this.get(CM) : this.aladin.CMDEFAULT;
        return s == null || s.indexOf("noautocut") < 0;
    }

    protected int getCMFct() {
        String s = this.aladin.CMDEFAULT == null ? this.get(CM) : this.aladin.CMDEFAULT;
        return this.getFct1(s);
    }

    protected int getCMMap() {
        String s = this.aladin.CMDEFAULT == null ? this.get(CM) : this.aladin.CMDEFAULT;
        return this.getMap1(s);
    }

    protected String getServer() {
        String s = this.get(SERVER);
        s = s == null || s.equalsIgnoreCase("allsky") || s.trim().length() == 0 ? "hips" : s;
        return s;
    }

    public String getBookmarks() {
        return this.get(BOOKMARKS);
    }

    public void resetBookmarks() {
        this.remove(BOOKMARKS);
    }

    protected String getSurvey() {
        String s = this.get(SURVEY);
        s = s == null || s.length() == 0 ? "P/DSS2/color" : s;
        return s;
    }

    protected String getOfficialVersion() {
        return this.get(OFFICIALVERSION);
    }

    protected String getCDSMessage() {
        return this.get(CDSMESSAGE);
    }

    protected String getVersion() {
        return this.get(VERSION);
    }

    protected String getLoadImgCmd() {
        String survey = this.getSurvey();
        return this.getServer() + (survey == null ? "" : "(" + survey + ")");
    }

    protected int getFilter() {
        String s;
        String string = s = this.aladin.FILTERDEFAULT == null ? this.get(FILTER) : this.aladin.FILTERDEFAULT;
        if (s != null && (Util.indexOfIgnoreCase(s, "NO") >= 0 || Util.indexOfIgnoreCase(s, "OFF") >= 0)) {
            return -1;
        }
        return 0;
    }

    protected boolean showHelpIfOk(String key) {
        if (this.stopHelp == null) {
            this.stopHelp = new Vector();
        }
        if (this.stopHelp.contains(key)) {
            return false;
        }
        this.aladin.calque.select.setMessageTip(key, Aladin.chaine.getString(key));
        return true;
    }

    protected boolean mustShowHelp(String key) {
        return this.stopHelp == null || !this.stopHelp.contains(key);
    }

    protected void showHelpDone(String key) {
        if (this.stopHelp == null) {
            this.stopHelp = new Vector();
        }
        this.stopHelp.add(key);
    }

    private void initStopHelp(String s) {
        if (s == null) {
            return;
        }
        this.stopHelp = new Vector();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            this.stopHelp.add(st.nextToken());
        }
    }

    private void majStopHelp() {
        if (this.stopHelp == null || this.stopHelp.size() == 0) {
            this.remove(STOPHELP);
        } else {
            StringBuilder s = new StringBuilder();
            Enumeration<String> e = this.stopHelp.elements();
            while (e.hasMoreElements()) {
                if (s.length() > 0) {
                    s.append(' ');
                }
                s.append(e.nextElement());
            }
            this.set(STOPHELP, s.toString());
        }
    }

    protected void stopWizard() {
        this.set(HELP, NOTACTIVATED);
    }

    protected String getLang() {
        if (this.flagModifLang) {
            String modeLang = "User";
            this.flagModifLang = false;
            String s = this.get(LANG);
            if (s == null) {
                try {
                    modeLang = "Default";
                    s = System.getProperty("user.language");
                    s = this.getLanguage(s);
                }
                catch (Exception e) {
                    s = null;
                }
            }
            this.currentLang = this.getLangSuffix(s);
            Aladin.trace(2, modeLang + " language [" + s + "] => assume [" + this.currentLang + "]");
        }
        return this.currentLang;
    }

    protected boolean isDarkTheme() {
        String s = Aladin.THEME != null ? Aladin.THEME : this.get(LOOKANDFEELTHEME);
        return s == null || s.equals("dark");
    }

    protected int getFrame() {
        try {
            String frame = this.get(FRAME);
            int i = Util.indexInArrayOf(frame, Localisation.REPERE);
            if (i >= 0) {
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected String getProj() {
        String s = this.get(PROJALLSKY);
        if (s == null) {
            return "Aitoff";
        }
        if (this.aladin.isCinema()) {
            return "Arc";
        }
        return s;
    }

    protected int getProjAllsky() {
        if (this.aladin.isCinema()) {
            return 3;
        }
        try {
            String proj = this.get(PROJALLSKY);
            int i = Projection.getAlaProjIndex(proj);
            String calibProj = Projection.alaProjToType[i];
            i = Calib.getProjType(calibProj);
            if (i >= 0) {
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 4;
    }

    protected void setProjAllsky(String s) throws Exception {
        int i = Projection.getAlaProjIndex(s);
        if (i < 0) {
            throw new Exception("Unknown projection [" + s + "]");
        }
        String s1 = Projection.getAlaProj(i);
        this.set(PROJALLSKY, s1);
        this.aladin.projSelector.setProjection(s1);
    }

    private void setPositionMode(String mode) throws Exception {
        if (mode.equalsIgnoreCase("UNKNOWNFrame")) {
            return;
        }
        if (!this.aladin.localisation.setPositionMode(mode)) {
            throw new Exception("Not available position mode ! [" + mode + "]");
        }
        this.setConfFrame = true;
    }

    protected boolean getSEDWave() {
        String flag = this.get(SEDWAVE);
        if (flag == null) {
            return false;
        }
        return flag.equalsIgnoreCase("On");
    }

    protected boolean getAutoDist() {
        String flag = this.get(AUTODIST);
        if (flag == null) {
            return false;
        }
        return flag.equalsIgnoreCase("On");
    }

    protected boolean getSimbadFlag() {
        String flag = this.get(SIMBAD);
        if (flag == null) {
            return true;
        }
        return !flag.equalsIgnoreCase("Off");
    }

    protected boolean getVizierSEDFlag() {
        String flag = this.get(VIZIERSED);
        if (flag == null) {
            return true;
        }
        return !flag.equalsIgnoreCase("Off");
    }

    protected int getFrameDrawing() {
        if (this.setConfFrame) {
            return this.getFrame();
        }
        String frame = this.get(FRAMEALLSKY);
        try {
            int i = Util.indexInArrayOf(frame, Localisation.FRAME);
            if (i >= 0) {
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected String getLanguage() {
        String s = this.getLang();
        if (s.length() == 0) {
            return "en";
        }
        return s.substring(1);
    }

    protected Color getGridColor() {
        try {
            return CouleurBox.getCouleur(this.get(GRIDC));
        }
        catch (Exception exception) {
            return Aladin.COLOR_GREEN;
        }
    }

    protected Color getGridColorRA() {
        try {
            return CouleurBox.getCouleur(this.get(GRIDCRA));
        }
        catch (Exception exception) {
            return Aladin.COLOR_GREEN_LIGHT;
        }
    }

    protected Color getGridColorDE() {
        try {
            return CouleurBox.getCouleur(this.get(GRIDCDE));
        }
        catch (Exception exception) {
            return Aladin.COLOR_GREEN_LIGHTER;
        }
    }

    protected int getGridFontSize() {
        try {
            return Integer.parseInt(this.get(GRIDF));
        }
        catch (Exception exception) {
            return Aladin.SSIZE;
        }
    }

    protected int getInfoFontSize() {
        try {
            return Integer.parseInt(this.get(INFOF));
        }
        catch (Exception exception) {
            return Aladin.SSIZE;
        }
    }

    protected boolean isInfoBorder() {
        String s = this.get(INFOB);
        return s == null || !s.equals("off");
    }

    protected Color getInfoColor() {
        try {
            return CouleurBox.getCouleur(this.get(INFOC));
        }
        catch (Exception exception) {
            return Color.cyan;
        }
    }

    protected Color getInfoLabelColor() {
        try {
            return CouleurBox.getCouleur(this.get(INFOCL));
        }
        catch (Exception exception) {
            return Color.yellow;
        }
    }

    protected void setLog(boolean flag) {
        this.set(LOG, flag ? ACTIVATED : NOTACTIVATED);
    }

    protected boolean isLog() {
        if (Aladin.SETLOG) {
            return Default.LOG;
        }
        String s = this.get(LOG);
        if (s == null) {
            return Default.LOG;
        }
        return s.equals(ACTIVATED);
    }

    protected boolean isSliderEpoch() {
        String s = this.get(SLEPOCH);
        return s == null || !s.equals("off");
    }

    protected boolean isSliderSize() {
        String s = this.get(SLSIZE);
        return s == null || !s.equals("off");
    }

    protected boolean isSliderDensity() {
        String s = this.get(SLDENS);
        return s == null || !s.equals("off");
    }

    protected boolean isSliderCube() {
        String s = this.get(SLCUBE);
        return s != null && s.equals("on");
    }

    protected boolean isSliderOpac() {
        String s = this.get(SLOPAC);
        return s == null || !s.equals("off");
    }

    protected boolean isSliderZoom() {
        String s = this.get(SLZOOM);
        return s == null || !s.equals("off");
    }

    protected boolean isHelp() {
        String s = this.get(HELP);
        return s == null || s.equals(ACTIVATED);
    }

    protected boolean isFilterHDU() {
        String s = this.get(FILTERHDU);
        return s == null || s.startsWith(ACTIVATED);
    }

    public boolean isLookAndFeelJava() {
        String s = this.get(LOOKANDFEEL);
        return s == null || s.equals(JAVA);
    }

    protected boolean isBeginner() {
        String s = this.get(MOD);
        return s != null && s.charAt(0) == 'p';
    }

    public boolean isTransparent() {
        return true;
    }

    public float getTransparencyLevel() {
        String s = this.get(TRANSLEVEL);
        if (s == null) {
            return 0.150111f;
        }
        try {
            float f = Float.parseFloat(s);
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.150111f;
        }
    }

    private void addRemoteLanguage() {
        Enumeration e = this.remoteLang.elements();
        while (e.hasMoreElements()) {
            int i;
            Langue lg = (Langue)e.nextElement();
            int n = this.langChoice.getItemCount();
            for (i = 0; i < n && !((String)this.langChoice.getItemAt(i)).equals(lg.langue); ++i) {
            }
            if (i != n) continue;
            this.langChoice.addItem(lg.langue);
        }
    }

    private void setRemoteLanguage(String t) {
        block6: {
            try {
                int t1 = t.indexOf(45);
                int t2 = t.indexOf(45, t1 + 1);
                int dot = t.indexOf(".string");
                StringBuffer name = new StringBuffer();
                for (int i = t1 + 1; i < t2; ++i) {
                    char ch = t.charAt(i);
                    if (i > t1 + 1 && Character.isUpperCase(ch)) {
                        name.append(' ');
                    }
                    name.append(ch);
                }
                Langue lg = new Langue(name.toString());
                try {
                    lg.version = Double.parseDouble(t.substring(t2 + 1, dot));
                }
                catch (Exception e) {
                    // empty catch block
                }
                lg.file = t;
                this.remoteLang.addElement(lg);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block6;
                e.printStackTrace();
            }
        }
    }

    protected void loadRemoteLang() {
        this.remoteLang = new Vector();
        if (!Aladin.STANDALONE) {
            return;
        }
        new Thread("loadLang"){

            @Override
            public void run() {
                block4: {
                    try {
                        Langue clg;
                        String s;
                        Util.pause(1000);
                        Aladin.trace(3, "Checking language support...");
                        Configuration.this.aladin;
                        InputStream in = Aladin.cache.get("http://aladin.u-strasbg.fr/java/nph-aladin.pl?frame=getLang");
                        BufferedReader dis = new BufferedReader(new InputStreamReader(in));
                        while ((s = dis.readLine()) != null) {
                            Configuration.this.setRemoteLanguage(s);
                        }
                        in.close();
                        s = Configuration.this.get(LANG);
                        Langue lg = Configuration.this.getBestLangVersion(s);
                        if (lg != null && (clg = Configuration.this.findLangue(s)) != null && clg.version != lg.version) {
                            Util.pause(10000);
                            Configuration.this.installRemoteLanguage(s);
                        }
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace < 3) break block4;
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private Langue findLangue(String s) {
        for (int i = 0; i < lang.length; ++i) {
            if (!lang[i].isLangue(s)) continue;
            return lang[i];
        }
        return null;
    }

    private String getLangSuffix(String s) {
        if (lang == null) {
            return "";
        }
        if (s == null) {
            return "";
        }
        for (int i = 0; i < lang.length; ++i) {
            if (!s.equals(Configuration.lang[i].langue)) continue;
            return (Configuration.lang[i].code.length() > 0 ? "." : "") + Configuration.lang[i].code;
        }
        return "";
    }

    protected String getLanguage(String s) {
        for (int i = 0; i < lang.length; ++i) {
            if (!lang[i].isLangue(s)) continue;
            return Configuration.lang[i].langue;
        }
        return null;
    }

    protected String getLanguageAuthor(String s) {
        for (int i = 0; i < lang.length; ++i) {
            if (!lang[i].isLangue(s)) continue;
            return Configuration.lang[i].auteur;
        }
        return null;
    }

    protected long getHpxCacheSize() {
        long size;
        String s = this.get(CACHE);
        if (s == null) {
            return -1L;
        }
        try {
            size = Long.parseLong(s);
        }
        catch (Exception e) {
            size = -1L;
        }
        return size;
    }

    private boolean sameWinParam() {
        Configuration configuration = this;
        if (configuration.aladin.isApplet()) {
            return true;
        }
        Dimension d = this.aladin.f.getSize();
        Point p = this.aladin.f.getLocation();
        return this.initWinLocXY.equals(p) && this.initWinLocWH.equals(d);
    }

    protected Rectangle getWinLocation() {
        try {
            String s = this.get(WINLOC);
            StringTokenizer st = new StringTokenizer(s);
            Rectangle r = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            this.setInitWinLoc(r.x, r.y, r.width, r.height);
            return r;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int getSplitMesureHeight() {
        try {
            int m = Integer.parseInt(this.get(MHEIGHT));
            if (m < 20) {
                throw new Exception();
            }
            return m;
        }
        catch (Exception exception) {
            return 150;
        }
    }

    protected int getSplitHiPSWidth() {
        try {
            return Integer.parseInt(this.get(HWIDTH));
        }
        catch (Exception exception) {
            return 250;
        }
    }

    protected int getSplitZoomWidth() {
        try {
            return Integer.parseInt(this.get(ZWIDTH));
        }
        catch (Exception exception) {
            return 220;
        }
    }

    protected int getSplitZoomHeight() {
        try {
            return Integer.parseInt(this.get(ZHEIGHT));
        }
        catch (Exception exception) {
            return 150;
        }
    }

    protected void setInitWinLoc(int x, int y, int width, int height) {
        this.initWinLocXY.x = x;
        this.initWinLocXY.y = y;
        this.initWinLocWH.width = width;
        this.initWinLocWH.height = height;
    }

    protected void setInitMesureHeight(int mesureHeight) {
        this.initMesureHeight = mesureHeight;
    }

    private int extendLang(int n) {
        int i;
        if (lang != null) {
            Langue[] a = lang;
            lang = new Langue[a.length + n];
            System.arraycopy(a, 0, lang, 0, a.length);
            i = a.length;
        } else {
            lang = new Langue[n];
            i = 0;
        }
        return i;
    }

    protected void setLanguage(String t) {
        StringTokenizer st = new StringTokenizer(t, ",");
        for (int i = this.extendLang(st.countTokens()); i < lang.length; ++i) {
            block11: {
                String s = st.nextToken();
                int n = s.length();
                Configuration.lang[i] = new Langue(s);
                int j = s.indexOf(40);
                int k = -1;
                if (j > 0 && (k = s.indexOf(41, j)) > 0) {
                    Configuration.lang[i].langue = s.substring(0, j).trim();
                    Configuration.lang[i].code = s.substring(j + 1, k);
                }
                try {
                    int l;
                    if (k <= 0) break block11;
                    j = k;
                    while (k < n && !Character.isDigit(s.charAt(k))) {
                        ++k;
                    }
                    if (k < n) {
                        l = s.indexOf(32, k);
                        if (l == -1) {
                            l = n;
                        }
                        try {
                            Configuration.lang[i].version = Double.parseDouble(s.substring(k, l));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    for (l = j + 1; l < n && !Character.isLetter(s.charAt(l)); ++l) {
                    }
                    if (l < n) {
                        Configuration.lang[i].auteur = k > l ? s.substring(l, k).trim() : s.substring(l).trim();
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block11;
                    e.printStackTrace();
                }
            }
            Aladin.trace(2, "Supported language [" + Configuration.lang[i].langue + "] (" + Configuration.lang[i].code + ") " + (Configuration.lang[i].version > 0.0 ? Configuration.lang[i].version + "" : "") + " " + Configuration.lang[i].auteur);
        }
    }

    protected JPanel createPanel() {
        JPanel p = new JPanel(new BorderLayout());
        JScrollPane sc = new JScrollPane(this.createPanel1());
        p.add((Component)sc, "Center");
        return p;
    }

    private JPanel createPanel1() {
        CouleurBox y;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel p = new JPanel();
        p.setLayout(g);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        this.langChoice = new JComboBox();
        this.langChoice.addItem("-- default --");
        for (int i = 0; i < lang.length; ++i) {
            this.langChoice.addItem(Configuration.lang[i].langue);
        }
        JLabel l = new JLabel(LANGUE);
        l.setFont(l.getFont().deriveFont(1));
        panel.add((Component)this.langChoice, "Center");
        JButton b = new JButton(LANGCONTRIB);
        b.addActionListener(this);
        b.setMargin(new Insets(2, 4, 2, 4));
        panel.add((Component)b, "East");
        PropPanel.addCouple(this, p, l, LANGUEH, panel, g, c, 13);
        this.addRemoteLanguage();
        this.modeChoice = new JComboBox();
        this.modeChoice.addItem(ASTRONOMER);
        this.modeChoice.addItem(UNDERGRADUATE);
        if (Aladin.PROTO) {
            this.modeChoice.addItem(PREVIEW);
        }
        l = new JLabel(MODE);
        l.setFont(l.getFont().deriveFont(1));
        l = new JLabel(HELPS);
        l.setFont(l.getFont().deriveFont(1));
        this.helpChoice = new JComboBox();
        this.helpChoice.addItem(ACTIVATED);
        this.helpChoice.addItem(NOTACTIVATED);
        PropPanel.addCouple(this, p, l, HELPH, this.helpChoice, g, c, 13);
        l = new JLabel(THEME);
        l.setFont(l.getFont().deriveFont(1));
        this.themeChoice = new JComboBox();
        this.themeChoice.addItem("dark");
        this.themeChoice.addItem("classic");
        this.themeChoice.addActionListener(this);
        PropPanel.addCouple(this, p, l, THEMEHELP, this.themeChoice, g, c, 13);
        l = new JLabel(FILEDIALOG);
        l.setFont(l.getFont().deriveFont(1));
        this.lfChoice = new JComboBox();
        this.lfChoice.addItem(FILEDIALOGJAVA);
        this.lfChoice.addItem(FILEDIALOGNATIVE);
        this.lfChoice.addActionListener(this);
        PropPanel.addCouple(this, p, l, FILEDIALOGHELP, this.lfChoice, g, c, 13);
        l = new JLabel(SLIDERS);
        l.setFont(l.getFont().deriveFont(1));
        JPanel sliderPanel = new JPanel(new GridLayout(1, 0));
        this.bxEpoch = new JCheckBox(SLIDEREPOCH);
        sliderPanel.add(this.bxEpoch);
        this.bxSize = new JCheckBox(SLIDERSIZE);
        sliderPanel.add(this.bxSize);
        this.bxDens = new JCheckBox(SLIDERDENSITY);
        sliderPanel.add(this.bxDens);
        this.bxCube = new JCheckBox(SLIDERCUBE);
        sliderPanel.add(this.bxCube);
        this.bxOpac = new JCheckBox(SLIDEROPAC);
        sliderPanel.add(this.bxOpac);
        this.bxZoom = new JCheckBox(SLIDERZOOM);
        sliderPanel.add(this.bxZoom);
        PropPanel.addCouple(this, p, l, SLIDERH, sliderPanel, g, c, 13);
        this.dir = new JTextField(35);
        b = new JButton(BROWSE);
        b.addActionListener(this);
        b.setMargin(new Insets(2, 4, 2, 4));
        l = new JLabel(DEFDIR);
        l.setFont(l.getFont().deriveFont(1));
        panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)this.dir, "Center");
        panel.add((Component)b, "East");
        PropPanel.addCouple(this, p, l, DEFDIRH, panel, g, c, 13);
        this.frameChoice = this.aladin.localisation.createSimpleChoice();
        Aladin aladin = this.aladin;
        this.frameAllskyChoice = aladin.localisation.createFrameCombo();
        l = new JLabel(FRAMEB);
        l.setFont(l.getFont().deriveFont(1));
        panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(this.frameChoice);
        panel.add(new JLabel(" - " + FRAMEALLSKYB));
        panel.add(this.frameAllskyChoice);
        PropPanel.addCouple(this, p, l, FRAMEH, panel, g, c, 13);
        this.projAllskyChoice = new JComboBox<String>(Projection.getAlaProj());
        this.projAllskyChoice.setMaximumRowCount(10);
        l = new JLabel(PROJALLSKYB);
        l.setFont(l.getFont().deriveFont(1));
        panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(this.projAllskyChoice);
        PropPanel.addCouple(this, p, l, PROJALLSKYH, panel, g, c, 13);
        JComboBox<Object> x = new JComboBox<String>();
        this.videoChoice = x;
        x.addItem("reverse");
        x.addItem("noreverse");
        x = FrameColorMap.createComboCM();
        this.mapChoice = x;
        x = new JComboBox();
        this.cutChoice = x;
        x.addItem("autocut");
        x.addItem("noautocut");
        x = new JComboBox();
        this.fctChoice = x;
        for (int i = 0; i < PlanImage.TRANSFERTFCT.length; ++i) {
            x.addItem(PlanImage.TRANSFERTFCT[i]);
        }
        panel = new JPanel(new GridLayout(2, 2, 4, 4));
        panel.add(new JLabel("- " + CMV, 2));
        panel.add(this.videoChoice);
        panel.add(new JLabel("  - " + CMM, 2));
        panel.add(this.mapChoice);
        panel.add(new JLabel("- " + CMC, 2));
        panel.add(this.cutChoice);
        panel.add(new JLabel("  - " + CMF, 2));
        panel.add(this.fctChoice);
        l = new JLabel(CMB);
        l.setFont(l.getFont().deriveFont(1));
        PropPanel.addCouple(this, p, l, CMH, panel, g, c, 13);
        this.filterChoice = new JComboBox();
        this.filterChoice.addItem(NOTACTIVATED);
        this.filterChoice.addItem(ACTIVATED);
        l = new JLabel(FILTERB);
        l.setFont(l.getFont().deriveFont(1));
        PropPanel.addCouple(this, p, l, FILTERH, this.filterChoice, g, c, 13);
        JPanel transparencyPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.transparencyLevel = new JSlider(0, 100);
        this.transparencyLevel.setValue((int)(100.0f * Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL));
        this.transparencyLevel.setMajorTickSpacing(20);
        this.transparencyLevel.setPaintLabels(true);
        this.transparencyLevel.setPaintTicks(true);
        this.transparencyLevel.setPaintTrack(true);
        this.transparencyLevel.setPreferredSize(new Dimension(230, this.transparencyLevel.getPreferredSize().height));
        this.transparencyLevel.setToolTipText(OPALEVEL + " : " + this.transparencyLevel.getValue());
        this.transparencyLevel.addChangeListener(this);
        transparencyPanel.add(this.transparencyLevel);
        l = new JLabel(TRANSB);
        l.setFont(l.getFont().deriveFont(1));
        PropPanel.addCouple(this, p, l, TRANSH, transparencyPanel, g, c, 13);
        this.serverTxt = new JTextField(10);
        this.surveyTxt = new JTextField(10);
        JPanel p1 = new JPanel(new FlowLayout(0, 5, 0));
        p1.add(new JLabel(IMGS, 2));
        p1.add(this.serverTxt);
        p1.add(new JLabel(IMGC, 2));
        p1.add(this.surveyTxt);
        l = new JLabel(IMGB);
        l.setFont(l.getFont().deriveFont(1));
        PropPanel.addCouple(this, p, l, IMGH, p1, g, c, 13);
        l = new JLabel(REGB);
        l.setFont(l.getFont().deriveFont(1));
        this.reload = b = new JButton(RELOAD);
        this.createGluChoice();
        panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)this.gluChoice, "West");
        b.setMargin(new Insets(2, 4, 2, 4));
        b.addActionListener(this);
        panel.add((Component)b, "East");
        PropPanel.addCouple(this, p, l, REGH, panel, g, c, 13);
        panel = new JPanel(new GridLayout(2, 2, 4, 4));
        this.gridFontCombo = new JComboBox<String>(new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "16"});
        this.gridFontCombo.setPrototypeDisplayValue(new Integer(100000000));
        this.gridFontCombo.setSelectedItem(this.getGridFontSize() + "");
        panel.add(new JLabel("- " + GRIDFONT, 2));
        panel.add(this.gridFontCombo);
        this.gridColorBox = y = new CouleurBox(Aladin.COLOR_GREEN, this.aladin.view.gridColor);
        panel.add(new JLabel("  - " + GRIDCOLOR, 2));
        panel.add(y);
        this.gridColorRABox = y = new CouleurBox(Aladin.COLOR_GREEN_LIGHT, this.aladin.view.gridColorRA);
        panel.add(new JLabel("- " + GRIDRACOLOR, 2));
        panel.add(y);
        this.gridColorDEBox = y = new CouleurBox(Aladin.COLOR_GREEN_LIGHTER, this.aladin.view.gridColorDEC);
        panel.add(new JLabel("  - " + GRIDDECOLOR, 2));
        panel.add(y);
        l = new JLabel(GRID);
        l.setFont(l.getFont().deriveFont(1));
        PropPanel.addCouple(this, p, l, GRIDH, panel, g, c, 13);
        panel = new JPanel(new GridLayout(2, 2, 4, 4));
        this.infoFontCombo = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "13", "14", "16", "18", "20"});
        this.infoFontCombo.setPrototypeDisplayValue(new Integer(100000000));
        this.infoFontCombo.setSelectedItem(this.getInfoFontSize() + "");
        panel.add(new JLabel("- " + INFOFONT, 2));
        panel.add(this.infoFontCombo);
        this.infoFontBorderCombo = new JComboBox<String>(new String[]{"on", "off"});
        this.infoFontBorderCombo.setSelectedIndex(this.isInfoBorder() ? 0 : 1);
        panel.add(new JLabel("- " + INFOFONTBORDER, 2));
        panel.add(this.infoFontBorderCombo);
        this.infoColorBox = y = new CouleurBox(Color.cyan, this.getInfoColor());
        panel.add(new JLabel("- " + INFOCOLOR, 2));
        panel.add(y);
        this.infoLabelColorBox = y = new CouleurBox(Color.yellow, this.getInfoLabelColor());
        panel.add(new JLabel("  - " + INFOLABELCOLOR, 2));
        panel.add(y);
        l = new JLabel(INFO);
        l.setFont(l.getFont().deriveFont(1));
        PropPanel.addCouple(this, p, l, INFOH, panel, g, c, 13);
        if (!Aladin.SETLOG) {
            l = new JLabel(LOGS);
            l.setFont(l.getFont().deriveFont(1));
            this.logChoice = new JComboBox();
            this.logChoice.addItem(ACTIVATED);
            this.logChoice.addItem(NOTACTIVATED);
            PropPanel.addCouple(this, p, l, LOGH, this.logChoice, g, c, 13);
        }
        l = new JLabel(CACHES);
        l.setFont(l.getFont().deriveFont(1));
        panel = new JPanel(new FlowLayout(0, 5, 0));
        this.cache = new JLabel("???? / ");
        panel.add(this.cache);
        this.maxCache = new JTextField(6);
        panel.add(this.maxCache);
        panel.add(new JLabel("MB"));
        b = new JButton(CLEARCACHE);
        b.addActionListener(this);
        b.setMargin(new Insets(2, 4, 2, 4));
        panel.add(b);
        PropPanel.addCouple(this, p, l, CACHEH, panel, g, c, 13);
        l = new JLabel(FILTERHDUS);
        l.setFont(l.getFont().deriveFont(1));
        this.filterHDUChoice = new JComboBox();
        this.filterHDUChoice.addItem(ACTIVATED);
        this.filterHDUChoice.addItem(NOTACTIVATED);
        PropPanel.addCouple(this, p, l, FILTERHDUH, this.filterHDUChoice, g, c, 13);
        if (Aladin.BETA || Aladin.PROTO) {
            l = new JLabel(UPHIDETAPSCHEMA);
            l.setFont(l.getFont().deriveFont(1));
            this.hideTapSchema = new JCheckBox();
            this.hideTapSchema.setSelected(this.hideTapSchema());
            PropPanel.addCouple(this, p, l, UPHIDETAPSCHEMAH, this.hideTapSchema, g, c, 13);
        }
        return p;
    }

    private void clearCache() {
        Aladin.makeCursor(this, 1);
        Aladin.cache.clear();
        PlanBG.clearCache();
        this.set(CACHE, "0");
        this.cache.setText("0 / ");
        Aladin.makeCursor(this, 0);
    }

    private void updateWidgets() {
        if (this.dir == null) {
            return;
        }
        String s = this.get(DIR);
        if (s == null) {
            s = "";
        }
        this.dir.setText(s);
        s = this.get(LANG);
        if (s == null) {
            this.langChoice.setSelectedIndex(0);
        } else {
            this.langChoice.setSelectedItem(s);
        }
        this.langItem = this.langChoice.getSelectedIndex();
        s = this.get(MOD);
        if (s == null) {
            this.modeChoice.setSelectedIndex(0);
        } else {
            this.modeChoice.setSelectedItem(s);
        }
        this.modeItem = this.modeChoice.getSelectedIndex();
        s = this.get(LOOKANDFEEL);
        if (s == null && Aladin.macPlateform) {
            this.lfChoice.setSelectedIndex(1);
        }
        if (s == null || s.equals(JAVA)) {
            this.lfChoice.setSelectedIndex(0);
        } else {
            this.lfChoice.setSelectedIndex(1);
        }
        s = this.get(LOOKANDFEELTHEME);
        if (s != null) {
            this.themeChoice.setSelectedItem("classic");
        } else {
            this.themeChoice.setSelectedIndex(0);
        }
        s = this.get(FRAME);
        if (s == null) {
            this.frameChoice.setSelectedItem("ICRS");
        } else {
            this.frameChoice.setSelectedItem(s);
        }
        s = this.get(PROJALLSKY);
        if (s == null) {
            this.projAllskyChoice.setSelectedItem("Aitoff");
        } else {
            this.projAllskyChoice.setSelectedItem(s);
        }
        s = this.get(FRAMEALLSKY);
        if (s == null) {
            this.frameAllskyChoice.setSelectedItem("GAL");
        } else {
            this.frameAllskyChoice.setSelectedItem(s);
        }
        this.fctChoice.setSelectedIndex(3);
        String string = s = this.aladin.CMDEFAULT != null ? this.aladin.CMDEFAULT : this.get(CM);
        if (s != null) {
            Tok tok = new Tok(s);
            block2: while (tok.hasMoreTokens()) {
                s = tok.nextToken();
                for (int i = 0; i < 4; ++i) {
                    JComboBox c = i == 0 ? this.videoChoice : (i == 1 ? this.mapChoice : (i == 2 ? this.cutChoice : this.fctChoice));
                    for (int j = 0; j < c.getItemCount(); ++j) {
                        if (!((String)c.getItemAt(j)).equalsIgnoreCase(s)) continue;
                        c.setSelectedIndex(j);
                        continue block2;
                    }
                }
            }
        } else {
            this.videoChoice.setSelectedIndex(1);
            this.mapChoice.setSelectedIndex(0);
        }
        s = this.get(FILTER);
        if (s != null && s.charAt(0) == 'N') {
            this.filterChoice.setSelectedIndex(0);
        } else {
            this.filterChoice.setSelectedIndex(1);
        }
        s = this.get(TRANSLEVEL);
        if (s == null) {
            this.transparencyLevel.setValue(15);
        }
        s = this.getServer();
        this.serverTxt.setText(s);
        s = this.getSurvey();
        this.surveyTxt.setText(s);
        String defaultGlu = this.get(GLU);
        if (defaultGlu == null) {
            defaultGlu = Glu.NPHGLUALADIN;
        }
        this.setSelectGluChoice(defaultGlu);
        this.reload.setEnabled(true);
        if (this.logChoice != null) {
            this.logChoice.setSelectedIndex(this.isLog() ? 0 : 1);
        }
        if (this.helpChoice != null) {
            this.helpChoice.setSelectedIndex(this.isHelp() ? 0 : 1);
        }
        if (this.filterHDUChoice != null) {
            this.filterHDUChoice.setSelectedIndex(this.isFilterHDU() ? 0 : 1);
        }
        if (this.bxEpoch != null) {
            this.bxEpoch.setSelected(this.isSliderEpoch());
        }
        if (this.bxSize != null) {
            this.bxSize.setSelected(this.isSliderSize());
        }
        if (this.bxDens != null) {
            this.bxDens.setSelected(this.isSliderDensity());
        }
        if (this.bxOpac != null) {
            this.bxOpac.setSelected(this.isSliderOpac());
        }
        if (this.bxCube != null) {
            this.bxCube.setSelected(this.isSliderCube());
        }
        if (this.bxZoom != null) {
            this.bxZoom.setSelected(this.isSliderZoom());
        }
        if (this.cache != null) {
            long cacheSize = PlanBG.cacheSize;
            try {
                if (cacheSize == -1L) {
                    cacheSize = Long.parseLong(this.get(CACHE));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (cacheSize == -1L) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        long cacheSize = PlanBG.getCacheSize(new File(PlanBG.getCacheDirStatic()), null);
                        PlanBG.setCacheSize(cacheSize);
                        Configuration.this.cache.setText(cacheSize / 1024L + " / ");
                    }
                });
            } else {
                this.cache.setText(cacheSize / 1024L + " / ");
            }
            int mCache = (int)(PlanBG.MAXCACHE / 1024L);
            this.maxCache.setText(mCache + "");
        }
    }

    protected String get(String key) {
        ConfigurationItem item = this.getItem(key);
        if (item == null) {
            return null;
        }
        return item.value;
    }

    protected void remove(String key) {
        ConfigurationItem item = this.getItem(key);
        if (item != null) {
            this.prop.removeElement(item);
            this.flagModif = true;
        }
    }

    protected void set(String key, String value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        key.replace(' ', '_');
        this.flagModif = true;
        ConfigurationItem item = this.getItem(key);
        if (item == null) {
            item = new ConfigurationItem(key, value);
            this.prop.addElement(item);
        } else {
            item.value = value;
        }
    }

    private ConfigurationItem getItem(String key) {
        Enumeration e = this.prop.elements();
        while (e.hasMoreElements()) {
            ConfigurationItem item = (ConfigurationItem)e.nextElement();
            if (!item.key.equals(key)) continue;
            return item;
        }
        return null;
    }

    protected void save() throws Exception {
        try {
            this.save1();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void save1() throws Exception {
        block60: {
            block61: {
                if (Aladin.NOGUI) {
                    return;
                }
                for (String k : Configuration.DEPRECATED) {
                    this.remove(k);
                }
                this.majStopHelp();
                this.setLastRun();
                this.set(Configuration.VERSION, "v11.024");
                if (this.aladin.calque.reticleMode == 2 && this.get(Configuration.RETICLE) == null) {
                    this.set(Configuration.RETICLE, "Large");
                }
                if (this.aladin.calque.reticleMode != 2 && this.get(Configuration.RETICLE) != null) {
                    this.remove(Configuration.RETICLE);
                }
                if (this.aladin.calque.flagTip && this.get(Configuration.TOOLTIP) == null) {
                    this.set(Configuration.TOOLTIP, "On");
                }
                if (!this.aladin.calque.flagTip && this.get(Configuration.TOOLTIP) != null) {
                    this.remove(Configuration.TOOLTIP);
                }
                if (this.aladin.splitZoomHeight != null) {
                    n = this.aladin.splitZoomHeight.getCompSize();
                    if (n != 150) {
                        this.set(Configuration.ZHEIGHT, "" + n);
                    } else {
                        this.remove(Configuration.ZHEIGHT);
                    }
                }
                if (this.aladin.splitZoomWidth != null) {
                    n = this.aladin.splitZoomWidth.getCompSize();
                    if (n != 220) {
                        this.set(Configuration.ZWIDTH, "" + n);
                    } else {
                        this.remove(Configuration.ZWIDTH);
                    }
                }
                if (Aladin.TREEWIDTH == null && this.aladin.splitHiPSWidth != null) {
                    n = this.aladin.splitHiPSWidth.getCompSize();
                    if (n != 250) {
                        this.set(Configuration.HWIDTH, "" + n);
                    } else {
                        this.remove(Configuration.HWIDTH);
                    }
                }
                if (this.aladin.splitMesureHeight != null) {
                    n = this.aladin.splitMesureHeight.getCompSize();
                    if (n != 150) {
                        this.set(Configuration.MHEIGHT, "" + n);
                    } else {
                        this.remove(Configuration.MHEIGHT);
                    }
                }
                if (this.aladin.bookmarks.canBeSaved()) {
                    list = this.aladin.bookmarks.getBookmarkList();
                    Aladin.trace(4, "Configuration.save(): updating bookmark list => " + list);
                    if (this.aladin.bookmarks.isDefaultList()) {
                        this.remove(Configuration.BOOKMARKS);
                    } else if (this.get(Configuration.BOOKMARKS) == null || !this.get(Configuration.BOOKMARKS).equals(list)) {
                        this.set(Configuration.BOOKMARKS, list);
                    }
                }
                ocache = this.get(Configuration.CACHE);
                if (PlanBG.cacheSize != -1L) {
                    s = PlanBG.cacheSize + "";
                    if (ocache == null || !s.equals(ocache)) {
                        this.set(Configuration.CACHE, s);
                    }
                }
                ocache = this.get(Configuration.MAXCACHE);
                s1 = PlanBG.MAXCACHE + "";
                if (ocache == null || !s1.equals(ocache)) {
                    this.set(Configuration.MAXCACHE, s1);
                }
                if ((s = this.get(Configuration.HELP)) != null && s.equals(Configuration.ACTIVATED)) {
                    this.remove(Configuration.HELP);
                }
                if ((s = this.get(Configuration.FILTERHDU)) != null && s.equals(Configuration.ACTIVATED)) {
                    this.remove(Configuration.FILTERHDU);
                }
                if ((s = this.get(Configuration.LOOKANDFEEL)) != null && s.equals(Configuration.JAVA)) {
                    this.remove(Configuration.LOOKANDFEEL);
                }
                if ((s = this.get(Configuration.LOOKANDFEELTHEME)) != null && s.equals("dark")) {
                    this.remove(Configuration.LOOKANDFEELTHEME);
                }
                if (!this.aladin.calque.flagSimbad) {
                    this.set(Configuration.SIMBAD, "Off");
                } else {
                    this.remove(Configuration.SIMBAD);
                }
                if (!this.aladin.calque.flagVizierSED) {
                    this.set(Configuration.VIZIERSED, "Off");
                } else {
                    this.remove(Configuration.VIZIERSED);
                }
                if (this.aladin.calque.flagAutoDist && !this.getAutoDist()) {
                    this.set(Configuration.AUTODIST, "On");
                }
                if (!this.aladin.calque.flagAutoDist && this.getAutoDist()) {
                    this.remove(Configuration.AUTODIST);
                }
                try {
                    if (this.aladin.calque.zoom.zoomView.sed.getSEDWave()) {
                        this.set(Configuration.SEDWAVE, "On");
                    } else {
                        this.remove(Configuration.SEDWAVE);
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                if (!this.flagModif && this.sameWinParam()) {
                    return;
                }
                configDir = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
                f = new File(configDir);
                if (!f.isDirectory() && !f.mkdir()) {
                    throw new Exception("Cannot create " + Aladin.CACHE + " directory");
                }
                configName = configDir + Util.FS + Configuration.CONFIGNAME;
                f = new File(configName);
                f.delete();
                bw = new BufferedWriter(new FileWriter(f));
                v0 = this;
                if (v0.aladin.isApplet()) break block61;
                max = (this.aladin.f.getExtendedState() & 6) != 0;
                this.aladin.f.setExtendedState(0);
                p = this.aladin.f.getLocation();
                d = this.aladin.f.getSize();
                if (p.x < 0) {
                    p.x = 0;
                }
                if (p.y < 0) {
                    p.y = 0;
                }
                if (Aladin.LOCATION != null) break block61;
                if (Math.abs(p.x) > Aladin.SCREENSIZE.width) ** GOTO lbl-1000
                if (Math.abs(p.y) > Aladin.SCREENSIZE.height || d.width < 100) ** GOTO lbl-1000
                if ((double)d.width > (double)Aladin.SCREENSIZE.width * 1.5 || d.height < 100) ** GOTO lbl-1000
                if ((double)d.height > (double)Aladin.SCREENSIZE.height * 1.5) lbl-1000:
                // 4 sources

                {
                    this.remove(Configuration.WINLOC);
                } else {
                    this.set(Configuration.WINLOC, p.x + " " + p.y + " " + (max != false ? -d.width : d.width) + " " + (max != false ? -d.height : d.height));
                }
            }
            first = true;
            e = this.prop.elements();
            while (e.hasMoreElements()) {
                item = (ConfigurationItem)e.nextElement();
                if (!(!first || item.key.equals("#") && item.value.startsWith("#Aladin"))) {
                    bw.write("#Aladin user configuration file");
                    bw.newLine();
                    bw.newLine();
                }
                first = false;
                if (item.key.equals("#")) {
                    bw.write(item.value);
                } else if (item.key.trim().length() > 0) {
                    bw.write(Util.align(item.key, 20) + item.value);
                }
                bw.newLine();
            }
            i = 1;
            if (this.lastFile != null) {
                for (String path : this.lastFile) {
                    key = Configuration.LASTFILE + i++;
                    bw.write(Util.align(key, 20) + path);
                    bw.newLine();
                }
            }
            try {
                this.aladin.glu.saveGluHistory(bw);
            }
            catch (Exception e1) {
                if (Aladin.levelTrace < 3) break block60;
                e1.printStackTrace();
            }
        }
        i = 1;
        for (String target : this.aladin.targetHistory.list) {
            key = Configuration.LASTTARGET + i++;
            bw.write(Util.align(key, 20) + target);
            bw.newLine();
            if (i <= 40) continue;
            break;
        }
        filterMocDir = configDir + Util.FS + Configuration.MOCFILTER;
        mocDir = new File(filterMocDir);
        Util.deleteDir(mocDir);
        mocDirCreated = false;
        if (this.filterExpr.size() > 0) {
            i = 1;
            try {
                for (String name : this.filterExpr.keySet()) {
                    if (name.equals(Directory.ALLCOLL) || name.equals(Directory.MYLIST)) continue;
                    expr = this.filterExpr.get(name);
                    moc = this.filterMoc.get(name);
                    if (moc == null && (expr == null || expr.equals("*") || expr.equals(""))) continue;
                    mocInfo = moc == null ? "" : MultiMoc.INTERSECT[DirectoryFilter.getIntersect(moc)] + ":";
                    key = Configuration.DIRFILER + i++;
                    bw.write(Util.align(key, 20) + name + ":" + mocInfo + (expr == null ? "" : expr));
                    bw.newLine();
                    if (moc == null) continue;
                    if (!mocDirCreated) {
                        mocDir.mkdir();
                        Util.pause(100);
                        mocDirCreated = true;
                    }
                    mocName = this.name2MocName(name);
                    out = new FileOutputStream(filterMocDir + Util.FS + mocName);
                    moc.writeFITS(out);
                    out.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        bw.close();
        this.flagModif = false;
        Aladin.trace(3, "Aladin user configuration file saved");
    }

    private String name2MocName(String name) {
        String s = name.replace('/', '_').replace('\\', '_').replace(':', '_').replace('.', '_').replace('?', '_');
        return s + ".fits";
    }

    protected void saveLocalFunction() throws Exception {
        if (!this.aladin.command.functionModif()) {
            return;
        }
        String configDir = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        File f = new File(configDir + Util.FS + CONFIGBKM);
        f.delete();
        StringBuffer s = new StringBuffer();
        BufferedWriter bw = null;
        Enumeration<Function> e = this.aladin.command.getLocalFunctions().elements();
        while (e.hasMoreElements()) {
            Function f1 = e.nextElement();
            if (!f1.isLocalDefinition()) continue;
            if (s.length() > 0) {
                s.append(',');
            }
            s.append(f1.getName());
            if (bw == null) {
                bw = new BufferedWriter(new FileWriter(f));
            }
            bw.write(f1.toString(Util.CR) + Util.CR);
        }
        if (bw != null) {
            bw.close();
        }
        Aladin.trace(3, "Aladin user local functions saved: " + s);
    }

    public String getLocalBookmarksFileName() {
        return System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + CONFIGBKM;
    }

    protected void load() throws Exception {
        String s;
        String configDir = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        File f = new File(configDir);
        if (!f.isDirectory()) {
            return;
        }
        String configName = configDir + Util.FS + CONFIGNAME;
        f = new File(configName);
        if (!f.exists()) {
            return;
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        this.prop = new Vector();
        int line = 0;
        Aladin.trace(2, "Loading Aladin user configuration file...");
        while ((s = br.readLine()) != null) {
            int j;
            int i;
            ++line;
            if (s.trim().length() == 0) {
                this.prop.addElement(new ConfigurationItem(" ", null));
                continue;
            }
            if (s.charAt(0) == '#') {
                this.prop.addElement(new ConfigurationItem("#", s));
                continue;
            }
            char[] a = s.toCharArray();
            for (i = 0; i < a.length && !Character.isSpace(a[i]); ++i) {
            }
            String key = new String(a, 0, i);
            for (j = i; j < a.length && Character.isSpace(a[j]); ++j) {
            }
            String value = new String(a, j, a.length - j);
            if (key.equals(TRANSOLD)) {
                key = TRANS;
            }
            if (key.equals(LOOKANDFEELTHEME) && !value.equals("dark")) {
                this.previousTheme = 1;
            }
            Aladin.trace(6, "Configuration.load() [" + key + "] = [" + value + "]");
            if (Aladin.TREEWIDTH != null && key.equals(HWIDTH)) {
                value = Aladin.TREEWIDTH;
            }
            if (key.startsWith(LASTFILE)) {
                this.setLastFile(value, false);
                continue;
            }
            if (key.startsWith(LASTTARGET)) {
                this.setLastTarget(value);
                continue;
            }
            if (key.startsWith(DIRFILER)) {
                this.loadDirFilter(value);
                continue;
            }
            if (key.startsWith(LASTGLU)) {
                this.memoLastGlu(value);
                continue;
            }
            this.set(key, value);
        }
        br.close();
        this.setCSV(this.get(CSV));
        this.setMaxCache(this.get(MAXCACHE));
        this.initStopHelp(this.get(STOPHELP));
        this.flagModif = false;
    }

    private void reloadGlu() {
        try {
            Aladin.makeCursor(this, 1);
            this.aladin.glu.reload(true, false);
            this.aladin.directory.reload();
            Aladin.makeCursor(this, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected long getLastRun() {
        try {
            return Long.parseLong(this.get(LASTRUN));
        }
        catch (Exception e) {
            return System.currentTimeMillis();
        }
    }

    protected void setLastRun() {
        this.set(LASTRUN, System.currentTimeMillis() + "");
    }

    private void langContrib() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridwidth = 0;
        c.anchor = 17;
        TextField lang = new TextField(15);
        TextField code = new TextField(3);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        panel.add(new Label("Language name:"));
        panel.add(lang);
        panel.add(new Label("2 letter code:"));
        panel.add(code);
        g.setConstraints(panel, c);
        if (!Aladin.question(this, "Specify the new language name (in english)\nand the corresponding 2 letter abbreviation.\nOr just press \"Ok\" for checking/completing the current language translation.", panel)) {
            return;
        }
        String s = Util.toLower(code.getText()) + " " + Util.toUpLower(lang.getText());
        Aladin.chaine.testLanguage(s);
        this.dispose();
    }

    public boolean apply() throws Exception {
        String s;
        boolean rep = true;
        if (this.gridColorBox != null) {
            this.set(GRIDC, this.gridColorBox.getCouleur());
        }
        if (this.gridColorRABox != null) {
            this.set(GRIDCRA, this.gridColorRABox.getCouleur());
        }
        if (this.gridColorDEBox != null) {
            this.set(GRIDCDE, this.gridColorDEBox.getCouleur());
        }
        if (this.gridFontCombo != null) {
            s = this.gridFontCombo.getSelectedItem() + "";
            if ((Aladin.SSIZE + "").equals(s)) {
                s = null;
            }
            this.set(GRIDF, s);
        }
        this.aladin.view.initGridParam(true);
        if (this.infoFontBorderCombo != null) {
            this.set(INFOB, (String)this.infoFontBorderCombo.getSelectedItem());
        }
        if (this.infoColorBox != null) {
            this.set(INFOC, this.infoColorBox.getCouleur());
        }
        if (this.infoLabelColorBox != null) {
            this.set(INFOCL, this.infoLabelColorBox.getCouleur());
        }
        if (this.infoFontCombo != null) {
            s = this.infoFontCombo.getSelectedItem() + "";
            if ((Aladin.SSIZE + "").equals(s)) {
                s = null;
            }
            this.set(INFOF, s);
        }
        this.aladin.view.initInfoParam(true);
        if (this.logChoice != null) {
            this.set(LOG, (String)this.logChoice.getSelectedItem());
        }
        if (this.helpChoice != null) {
            if (this.helpChoice.getSelectedIndex() == 1) {
                this.set(HELP, (String)this.helpChoice.getSelectedItem());
            } else {
                this.remove(HELP);
            }
        }
        if (this.filterHDUChoice != null) {
            if (this.filterHDUChoice.getSelectedIndex() == 1) {
                this.set(FILTERHDU, (String)this.filterHDUChoice.getSelectedItem());
            } else {
                this.remove(FILTERHDU);
            }
        }
        if (this.lfChoice != null) {
            if (this.lfChoice.getSelectedIndex() == 1) {
                this.set(LOOKANDFEEL, OPSYS);
            } else {
                this.remove(LOOKANDFEEL);
            }
        }
        if (this.themeChoice != null) {
            int t = this.themeChoice.getSelectedIndex();
            if (t != 0) {
                this.set(LOOKANDFEELTHEME, (String)this.themeChoice.getSelectedItem());
            } else {
                this.remove(LOOKANDFEELTHEME);
            }
            if (t != this.previousTheme) {
                Aladin.info(this, RESTART);
            }
        }
        if (this.bxEpoch != null) {
            if (!this.bxEpoch.isSelected()) {
                this.set(SLEPOCH, "off");
            } else {
                this.remove(SLEPOCH);
            }
        }
        if (this.bxSize != null) {
            if (!this.bxSize.isSelected()) {
                this.set(SLSIZE, "off");
            } else {
                this.remove(SLSIZE);
            }
        }
        if (this.bxDens != null) {
            if (!this.bxDens.isSelected()) {
                this.set(SLDENS, "off");
            } else {
                this.remove(SLDENS);
            }
        }
        if (this.bxCube != null) {
            if (!this.bxCube.isSelected()) {
                this.remove(SLCUBE);
            } else {
                this.set(SLCUBE, "on");
            }
        }
        if (this.bxOpac != null) {
            if (!this.bxOpac.isSelected()) {
                this.set(SLOPAC, "off");
            } else {
                this.remove(SLOPAC);
            }
        }
        if (this.bxZoom != null) {
            if (!this.bxZoom.isSelected()) {
                this.set(SLZOOM, "off");
            } else {
                this.remove(SLZOOM);
            }
        }
        this.aladin.calque.slider.adjustSliderPanel();
        int index = this.gluChoice.getSelectedIndex();
        if (index != -1 && index != this.lastGluChoice) {
            s = (String)this.gluUrl.elementAt(index);
            String sNew = this.aladin.glu.setDefaultGluSite(s);
            this.lastGluChoice = index;
            if (sNew != null) {
                this.setSelectGluChoice(sNew);
                rep = false;
            }
            this.reloadGlu();
        }
        this.set(FRAME, (String)this.frameChoice.getSelectedItem());
        this.set(FRAMEALLSKY, (String)this.frameAllskyChoice.getSelectedItem());
        this.set(PROJALLSKY, (String)this.projAllskyChoice.getSelectedItem());
        s = this.videoChoice.getSelectedItem() + " " + this.mapChoice.getSelectedItem() + " " + this.cutChoice.getSelectedItem() + " " + this.fctChoice.getSelectedItem();
        this.set(CM, s);
        this.aladin.CMDEFAULT = null;
        this.set(SERVER, this.serverTxt.getText().trim());
        this.set(SURVEY, this.surveyTxt.getText().trim());
        this.set(FILTER, (String)this.filterChoice.getSelectedItem());
        float level = (float)((double)this.transparencyLevel.getValue() / 100.0);
        level = level >= 1.0f ? (level -= 1.11E-4f) : (level += 1.11E-4f);
        this.set(TRANSLEVEL, level + "");
        index = this.langChoice.getSelectedIndex();
        if (index != this.langItem) {
            this.langItem = index;
            if (index > lang.length) {
                this.installRemoteLanguage((String)this.langChoice.getSelectedItem());
            } else {
                this.setLang(index == 0 ? null : (String)this.langChoice.getSelectedItem());
            }
            Aladin.info(this, RESTART);
        }
        if ((index = this.modeChoice.getSelectedIndex()) != this.modeItem) {
            this.modeItem = index;
            this.setMode(index == 0 ? null : (String)this.modeChoice.getSelectedItem());
            Aladin.info(this, RESTART);
        }
        if (this.csvChoice != null && (index = this.csvChoice.getSelectedIndex()) != this.csvItem) {
            this.set(CSV, CSVITEM[index]);
            this.setCSV(CSVITEM[index]);
        }
        if (this.dir != null) {
            s = this.dir.getText().trim();
            if (s.length() == 0) {
                this.remove(DIR);
            } else {
                this.setDir(s);
                this.set(DIR, s);
            }
        }
        if (this.maxCache != null) {
            try {
                s = this.maxCache.getText();
                long maxCacheSize = Long.parseLong(s);
                PlanBG.setMaxCacheSize(maxCacheSize * 1024L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.hideTapSchema != null && this.hideTapSchema.isSelected() != TapManager.getInstance((Aladin)this.aladin).hideTapSchema) {
            this.set(TAPSCHEMADISPLAY, String.valueOf(this.hideTapSchema.isSelected()));
            Aladin.info(this, RESTART);
        }
        this.save();
        this.updateWidgets();
        return rep;
    }

    private Langue getBestLangVersion(String s) {
        Langue bestLang = null;
        try {
            double minDiff = Double.MAX_VALUE;
            double v = Double.parseDouble("v11.024".substring(1));
            Enumeration e = this.remoteLang.elements();
            while (e.hasMoreElements()) {
                double diff;
                Langue lg = (Langue)e.nextElement();
                if (!lg.isLangue(s) || !(minDiff > (diff = Math.abs(v - lg.version)))) continue;
                minDiff = diff;
                bestLang = lg;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bestLang;
    }

    private void clearPreviousRemoteLang() {
        block3: {
            try {
                String dir = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return Util.matchMaskIgnoreCase("Aladin*.string*", name);
                    }
                };
                File fdir = new File(dir);
                File[] list = fdir.listFiles(filter);
                for (int i = 0; i < list.length; ++i) {
                    String name = list[i].getName();
                    if (!name.endsWith(".utf") && !name.endsWith(".string") || name.endsWith("-perso.string") || name.endsWith("-perso.string.utf")) continue;
                    list[i].delete();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    private void installRemoteLanguage(String s) throws Exception {
        Langue lg = this.getBestLangVersion(s);
        URL u = new URL("http://aladin.u-strasbg.fr/java/nph-aladin.pl?frame=getLang&id=" + lg.file);
        MyInputStream in = Util.openStream(u);
        byte[] buf = in.readFully();
        in.close();
        if (buf.length < 10) {
            throw new Exception("Cannot download translation file [" + u + "]");
        }
        this.clearPreviousRemoteLang();
        this.installLanguage(s, lg.file, buf);
    }

    protected void installLanguage(String langue, String filename, byte[] buf) throws Exception {
        File f2;
        String dir = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        String fullName = dir + Util.FS + filename;
        File f = new File(fullName + ".tmp");
        RandomAccessFile rf = new RandomAccessFile(f, "rw");
        rf.write(buf);
        rf.close();
        if (fullName.endsWith(".string")) {
            f2 = new File(fullName + ".utf");
            f2.delete();
        } else if (fullName.endsWith(".utf")) {
            f2 = new File(fullName.substring(0, fullName.length() - 4));
            f2.delete();
        }
        File f1 = new File(fullName);
        f1.delete();
        f.renameTo(f1);
        Aladin.trace(1, "Translation file installed [" + fullName + "]");
        this.set(LANG, langue);
    }

    private void setLang(String s) throws Exception {
        if (s == null) {
            this.remove(LANG);
            return;
        }
        String s1 = this.getLanguage(s);
        if (s1 == null) {
            throw new Exception("Language not supported ! [" + s + "]");
        }
        this.set(LANG, s1);
    }

    private void setMode(String s) throws Exception {
        if (s == null) {
            this.remove(MOD);
            return;
        }
        this.set(MOD, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDirFilter(String s) {
        int i = s.indexOf(58);
        if (i < 0) {
            return;
        }
        SMoc moc = null;
        int intersect = -1;
        String name = s.substring(0, i).trim();
        String expr = s.substring(i + 1).trim();
        int j = s.indexOf(58, i + 1);
        if (j > i) {
            File f;
            String mocInfo = s.substring(i + 1, j).trim();
            intersect = Util.indexInArrayOf(mocInfo, MultiMoc.INTERSECT);
            if (intersect >= 0) {
                expr = s.substring(j + 1).trim();
            }
            if ((f = new File(System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + MOCFILTER + Util.FS + this.name2MocName(name))).exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    moc = new SMoc(in);
                    DirectoryFilter.setIntersect(moc, intersect);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                }
                finally {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        this.setDirFilter(name, expr, moc);
    }

    protected void setDirFilter(String name, String expr, SMoc moc) {
        this.filterExpr.put(name, expr);
        if (moc != null) {
            this.filterMoc.put(name, moc);
        }
    }

    protected void setLastFile(String path, boolean checkDoublon) {
        if (this.lastFile == null) {
            this.lastFile = new LinkedBlockingDeque(20);
        }
        if (checkDoublon) {
            path = path.replace('\\', '/');
            File f1 = new File(path);
            for (String f2 : this.lastFile) {
                if (!f1.equals(new File(f2))) continue;
                this.lastFile.remove(f2);
                break;
            }
        }
        if (this.lastFile.size() == 20) {
            this.lastFile.removeFirst();
        }
        this.lastFile.add(path);
    }

    protected void setLastTarget(String target) {
        if (this.aladin.targetHistory != null) {
            this.aladin.targetHistory.add(target);
        }
    }

    private void memoLastGlu(String gluSerialized) {
        if (this.memoGlu == null) {
            this.memoGlu = new ArrayList();
        }
        this.memoGlu.add(gluSerialized);
    }

    protected void proceedLastGlu() {
        if (this.memoGlu == null) {
            return;
        }
        for (String s : this.memoGlu) {
            this.aladin.glu.setGluHistory(s);
        }
        this.memoGlu = null;
    }

    private void setDir(String d) throws Exception {
        if (d == null) {
            this.remove(DIR);
            return;
        }
        File f = new File(d);
        if (!f.isDirectory()) {
            throw new Exception("Not a directory ! [" + d + "]");
        }
        this.set(DIR, d);
    }

    protected void setOfficialVersion(String s) {
        this.set(OFFICIALVERSION, s);
    }

    protected void setCDSMessage(String s) {
        this.set(CDSMESSAGE, s);
    }

    protected void setconf(String prop, String value) throws Exception {
        if (prop.equalsIgnoreCase(DIR) || prop.equalsIgnoreCase("dir")) {
            this.setDir(value);
        } else if (prop.equalsIgnoreCase(CSV)) {
            this.setCSV(value);
        } else if (prop.equalsIgnoreCase("sync")) {
            this.setSyncMode(value);
        } else if (prop.equalsIgnoreCase(POSITION) || prop.equalsIgnoreCase("position") || prop.equalsIgnoreCase("frame")) {
            this.setPositionMode(value);
        } else if (prop.equalsIgnoreCase(SIMBAD) || prop.equalsIgnoreCase("simbad")) {
            this.setSimbadMode(value);
        } else if (prop.equalsIgnoreCase(FILTER) || prop.equalsIgnoreCase("filter")) {
            this.setFilterMode(value);
        } else if (prop.equalsIgnoreCase(CM) || prop.equalsIgnoreCase("Colormap") || prop.equalsIgnoreCase("cm")) {
            this.setCMMode(value);
        } else if (prop.equalsIgnoreCase(BKG) || prop.equalsIgnoreCase("Background")) {
            this.setBkgMode(value);
        } else if (prop.equalsIgnoreCase(PROJALLSKY) || prop.equalsIgnoreCase("projection") || prop.equalsIgnoreCase("Proj")) {
            this.setProjAllsky(value);
        } else {
            throw new Exception("Unknown conf. propertie [" + prop + "]");
        }
    }

    protected boolean hideTapSchema() {
        String s = this.get(TAPSCHEMADISPLAY);
        return s == null || !s.equals("false");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String what;
        Object src = evt.getSource();
        String string = what = src instanceof JButton ? ((JButton)src).getActionCommand() : "";
        if (CLOSE.equals(what)) {
            this.dispose();
        } else if (LANGCONTRIB.equals(what)) {
            this.langContrib();
        } else if (RELOAD.equals(what)) {
            this.reloadGlu();
        } else if (APPLY.equals(what)) {
            try {
                if (this.apply()) {
                    this.aladin.calque.repaintAll();
                }
            }
            catch (Exception e) {
                Aladin.error(this, " " + e.getMessage(), 1);
            }
        } else if (CLEARCACHE.equals(what)) {
            this.clearCache();
        } else if (BROWSE.equals(what)) {
            String path;
            String initDir = this.dir.getText();
            if (initDir.length() == 0) {
                initDir = null;
            }
            if ((path = Util.dirBrowser("", initDir, this.dir, 3)) != null) {
                this.aladin.memoDefaultDirectory(path);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        float level = (float)((double)this.transparencyLevel.getValue() / 100.0);
        level = level >= 1.0f ? (level -= 1.11E-4f) : (level += 1.11E-4f);
        if ((double)Math.abs(level - Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL) > 0.02) {
            this.setTransparency(ACTIVATED, level);
            this.set(TRANSLEVEL, level + "");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        this.transparencyLevel.setEnabled(e.getItem().equals(FILTERY));
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(e);
    }

    static {
        CSVITEM = new String[]{"tab", "|", ";", ",", "tab |", "tab | ;"};
        CMPARAM = null;
    }

    class Langue {
        String code;
        String langue;
        double version;
        String auteur;
        String file;

        Langue(String s) {
            this.langue = s;
            this.auteur = "";
            this.code = "";
            this.version = 0.0;
            this.file = null;
        }

        boolean isLangue(String s) {
            try {
                return this.code != null && s.equalsIgnoreCase(this.code) || this.langue != null && s.equalsIgnoreCase(this.langue);
            }
            catch (Exception e) {
                return false;
            }
        }

        public String toString() {
            return this.langue + " (" + this.code + ") " + this.version + " " + this.auteur + (this.file != null ? " " + this.file : "");
        }
    }

    private class ConfigurationItem {
        protected String key;
        protected String value;

        private ConfigurationItem(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

