/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.tools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public final class Cache
implements Runnable {
    private Aladin aladin;
    private String dir = null;
    static final String CACHE = "Cache";
    static final int WAIT = 10000;
    static final int OUTOFDATE = 86400000;
    private Vector todo;
    boolean cacheLock = false;
    private Thread thread = null;
    private static char PREFIX = (char)95;
    static final String HEX = "0123456789ABCDEF";

    protected Cache(Aladin aladin) {
        this.aladin = aladin;
        if (!aladin.createCache()) {
            return;
        }
        this.dir = Cache.getCacheDir();
        File f = new File(this.dir);
        if (!f.isDirectory() && !f.mkdir()) {
            this.dir = null;
            return;
        }
        this.todo = new Vector();
    }

    public static String getCacheDir() {
        return System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + CACHE;
    }

    void clear() {
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.cacheLock = true;
            File cache = new File(this.dir);
            String[] f = cache.list();
            for (int i = 0; f != null && i < f.length; ++i) {
                if (f[i].equals("Multiprop.bin")) continue;
                try {
                    new File(this.dir + Util.FS + f[i]).delete();
                    continue;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cacheLock = false;
        Aladin.trace(3, "Clear cache");
    }

    protected boolean isAvailable() {
        while (this.cacheLock) {
            try {
                Util.pause(100);
            }
            catch (Exception exception) {}
        }
        return this.dir != null;
    }

    public InputStream get(URL url) throws Exception {
        return this.get(url.toString());
    }

    public InputStream get(String url) throws Exception {
        if (!this.isAvailable()) {
            return Util.openStream(url);
        }
        String id = Cache.codage(url);
        File f = new File(this.dir + Util.FS + id);
        if (f.isFile() && f.canRead() && f.length() > 0L) {
            if (this.outOfDate(f)) {
                this.add(url);
            }
            Aladin.trace(3, "[" + url + "] read in cache !");
            return new FileInputStream(f);
        }
        if (this.putInCache(url)) {
            return this.get(url);
        }
        System.err.println("Caching not available for [" + url + "] !!!");
        return Util.openStream(url);
    }

    public InputStream getWithBackup(String url) throws Exception {
        if (!this.isAvailable()) {
            return Util.openStream(url);
        }
        Exception eBackup = null;
        MyInputStream is = null;
        try {
            is = Util.openStream(url, true, true, 3000);
            if (is == null) {
                throw new Exception("cache openStream error");
            }
        }
        catch (Exception e) {
            is = null;
            eBackup = e;
        }
        String id = Cache.codage(url);
        File f = new File(this.dir + Util.FS + id);
        if (is != null) {
            if (!f.isFile() || this.outOfDate(f)) {
                this.add(url);
            }
            return is;
        }
        if (f.isFile() && f.canRead() && f.length() > 0L) {
            Aladin.trace(3, "[" + url + "] backup from cache !");
            return new FileInputStream(f);
        }
        throw eBackup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putInCache(String url) throws Exception {
        try (MyInputStream in = null;){
            in = Util.openStream(url);
            byte[] buf = in.readFully();
            String id = Cache.codage(url);
            File g = new File(this.dir + Util.FS + id);
            g.delete();
            try (RandomAccessFile f = null;){
                f = new RandomAccessFile(this.dir + Util.FS + id, "rw");
                f.write(buf);
            }
            Aladin.trace(3, "Put in cache [" + url + "]");
            boolean bl = true;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() {
        Vector v;
        Aladin.trace(2, "Start cache updater...");
        Cache cache = this;
        synchronized (cache) {
            v = (Vector)this.todo.clone();
            this.todo.clear();
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String url = (String)e.nextElement();
            try {
                this.putInCache(url);
            }
            catch (Exception e1) {
                // empty catch block
            }
            Util.pause(1000);
        }
        this.fin();
    }

    private synchronized void add(String url) {
        Aladin.trace(3, "Add [" + url + "] for cache upgrade");
        this.todo.addElement(url);
        this.startThread();
    }

    private synchronized void fin() {
        this.thread = null;
    }

    private synchronized void startThread() {
        if (!Aladin.NETWORK) {
            return;
        }
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Cache updater");
        Util.decreasePriority(Thread.currentThread(), this.thread);
        this.thread.start();
    }

    private boolean outOfDate(File f) {
        return System.currentTimeMillis() - f.lastModified() > 86400000L;
    }

    public static String codage(String s) {
        StringBuffer r = new StringBuffer();
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            char c = a[i];
            if (!Character.isLetterOrDigit(c)) {
                r.append(PREFIX + Util.hex(c));
                continue;
            }
            r.append(c);
        }
        return r.toString();
    }

    public static String decodage(String s) {
        StringBuffer r = new StringBuffer();
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            char c = a[i];
            if (c != PREFIX) {
                r.append(c);
                continue;
            }
            c = (char)(Cache.code(a[i + 1]) * 16 + Cache.code(a[i + 2]));
            r.append(c);
            i += 2;
        }
        return r.toString();
    }

    private static int code(char c) {
        return HEX.indexOf(Character.toUpperCase(c));
    }

    @Override
    public void run() {
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateCache();
        this.thread = null;
    }
}

