/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Forme;
import cds.aladin.Ligne;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.RectangleD;
import cds.aladin.Tag;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Box
extends Forme {
    protected double angle;

    protected Box(Plan plan, ViewSimple v, double xv, double yv, double w, double h, double angle, String label) {
        super(plan, new Position[5]);
        this.angle = angle;
        this.o[0] = new Position(plan, v, xv, yv, 0.0, 0.0, 5, label);
        Coord c = new Coord(this.o[0].raj, this.o[0].dej);
        this.o[0] = new Tag(plan, null, 0.0, 0.0, label);
        this.o[0].raj = c.al;
        this.o[0].dej = c.del;
        double demiDia = Math.sqrt(w * w / 4.0 + h * h / 4.0);
        double a = Math.atan2(h / 2.0, w / 2.0);
        double b = Math.toRadians(90.0 + angle);
        double d = b + a;
        double x = xv + demiDia * Math.sin(d);
        double y = yv + demiDia * Math.cos(d);
        this.o[1] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        d = b - a;
        x = xv + demiDia * Math.sin(d);
        y = yv + demiDia * Math.cos(d);
        this.o[2] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        d = b + Math.PI - a;
        x = xv + demiDia * Math.sin(d);
        y = yv + demiDia * Math.cos(d);
        this.o[4] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        d = b + Math.PI + a;
        x = xv + demiDia * Math.sin(d);
        y = yv + demiDia * Math.cos(d);
        this.o[3] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        this.setObjet(this.o);
    }

    protected Box(Plan plan, Coord c, double w, double h, double angle, String label) {
        super(plan, new Position[5]);
        this.angle = angle;
        double b = 90.0;
        this.o[0] = new Tag(plan, null, 0.0, 0.0, label);
        this.o[0].raj = c.al;
        this.o[0].dej = c.del;
        ((Tag)this.o[0]).setDist(40);
        double demiDia = Math.sqrt(w * w / 4.0 + h * h / 4.0);
        double a = Math.toDegrees(Math.atan2(h, w));
        Coord c1 = this.applySphereRot(c, demiDia, b + a + angle);
        this.o[1] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        c1 = this.applySphereRot(c, demiDia, b - a + angle);
        this.o[2] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        c1 = this.applySphereRot(c, demiDia, b + 180.0 + a + angle);
        this.o[3] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        c1 = this.applySphereRot(c, demiDia, b + 180.0 - a + angle);
        this.o[4] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        this.setObjet(this.o);
    }

    protected Box(Plan plan, Position[] o) {
        super(plan, o);
    }

    @Override
    public String getObjType() {
        return "box";
    }

    protected double getAngle() {
        return this.angle;
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        return this.in(v, x, y);
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        for (int i = 1; i < this.o.length; ++i) {
            if (this.o[i].in(v, x, y)) {
                return true;
            }
            if (!this.inLigne(i, v, x, y)) continue;
            return true;
        }
        return false;
    }

    private boolean inLigne(int i, ViewSimple v, double x, double y) {
        PointD p1 = v.getViewCoordDble(this.o[i - 1].xv[v.n], this.o[i - 1].yv[v.n]);
        PointD p2 = v.getViewCoordDble(this.o[i].xv[v.n], this.o[i].yv[v.n]);
        PointD p = v.getViewCoordDble(x, y);
        return Ligne.inLigne(p1.x, p1.y, p2.x, p2.y, p.x, p.y, this.mouseDist(v));
    }

    @Override
    protected boolean inBout(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        for (int i = 1; i < this.o.length; ++i) {
            if (!this.o[i].in(v, x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean inRectangle(ViewSimple v, RectangleD r) {
        for (int i = 1; i < this.o.length; ++i) {
            if (!this.o[i].inRectangle(v, r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vector getProp() {
        Vector propList = super.getProp();
        final JTextArea textId = new JTextArea(3, 25);
        JScrollPane paneId = new JScrollPane(textId);
        PropAction updateId = new PropAction(){

            @Override
            public int action() {
                textId.setText(Box.this.o[0].id);
                return 1;
            }
        };
        PropAction changeId = new PropAction(){

            @Override
            public int action() {
                String s = textId.getText();
                if (s.equals(Box.this.o[0].id)) {
                    return -1;
                }
                Box.this.o[0].id = textId.getText();
                return 1;
            }
        };
        propList.add(Prop.propFactory("id", "Label", "Box label", paneId, updateId, changeId));
        return propList;
    }

    @Override
    public String getInfo() {
        return this.o[0].id;
    }

    @Override
    public void setInfo(String info) {
        this.o[0].setInfo(info);
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        Color c = this.getColor();
        Point op = null;
        for (int i = 0; i < this.o.length; ++i) {
            int j;
            int n = j = i == 0 ? 4 : i;
            if (this.o[j].xv == null) {
                return false;
            }
            Point p = v.getViewCoord(this.o[j].xv[v.n], this.o[j].yv[v.n]);
            if (p == null) {
                return false;
            }
            p.x += dx;
            p.y += dy;
            if (op != null) {
                g.setColor(c);
                g.drawLine(op.x, op.y, p.x, p.y);
                if (this.isSelected()) {
                    this.drawSelect(g, v, j);
                }
            }
            op = p;
        }
        if (this.o[0].id != null && this.o[0].id.length() > 0) {
            this.o[0].draw(g, v, dx, dy);
        }
        return true;
    }
}

