/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Cercle;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.Position;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import java.awt.Graphics;
import java.awt.Point;

public class Arc
extends Cercle {
    protected double angle;

    protected Arc(Plan plan, ViewSimple v, double xv, double yv, double rv, double startAngleNorth, double angle) {
        super(plan, new Position[3]);
        this.angle = angle;
        this.o[0] = new Position(plan, v, xv, yv, 0.0, 0.0, 5, null);
        double a = startAngleNorth;
        a = Math.PI * a / 180.0;
        double x = xv + rv * Math.sin(a);
        double y = yv + rv * Math.cos(a);
        this.o[1] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        a = startAngleNorth + angle;
        a = Math.PI * a / 180.0;
        x = xv + rv * Math.sin(a);
        y = yv + rv * Math.cos(a);
        this.o[2] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        this.setObjet(this.o);
    }

    protected Arc(Plan plan, Coord c, double radius, double startAngleNorth, double angle) {
        super(plan, new Position[3]);
        this.angle = angle;
        this.o[0] = new Position(plan, null, 0.0, 0.0, c.al, c.del, 2, null);
        Coord c1 = this.applySphereRot(c, radius, startAngleNorth);
        this.o[1] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        Coord c2 = this.applySphereRot(c, radius, startAngleNorth + angle);
        this.o[2] = new Position(plan, null, 0.0, 0.0, c2.al, c2.del, 2, null);
        this.setObjet(this.o);
    }

    protected Arc(Plan plan, Position[] o) {
        super(plan, o);
    }

    @Override
    public String getObjType() {
        return "Arc";
    }

    protected double getStartAngle3H(ViewSimple v) {
        return 180.0 * Math.atan2(this.o[0].yv[v.n] - this.o[1].yv[v.n], this.o[1].xv[v.n] - this.o[0].xv[v.n]) / Math.PI;
    }

    protected double getEndAngle3H(ViewSimple v) {
        return 180.0 * Math.atan2(this.o[0].yv[v.n] - this.o[2].yv[v.n], this.o[2].xv[v.n] - this.o[0].xv[v.n]) / Math.PI;
    }

    protected double getAngle() {
        return this.angle;
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        return this.in(v, x, y);
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        if (!super.in(v, x, y)) {
            return false;
        }
        double sa = this.getStartAngle3H(v);
        double a = 180.0 * Math.atan2(this.o[0].yv[v.n] - y, x - this.o[0].xv[v.n]) / Math.PI;
        double a1 = a - sa;
        return this.getAngle() > 0.0 ? -1.0 < a1 && a1 < this.getAngle() + 1.0 : this.getAngle() - 1.0 < a1 && a1 < 1.0;
    }

    @Override
    protected boolean inBout(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        return this.o[1].in(v, x, y) || this.o[2].in(v, x, y);
    }

    @Override
    protected boolean inRectangle(ViewSimple v, RectangleD r) {
        for (int i = 1; i < this.o.length; ++i) {
            if (!this.o[i].inRectangle(v, r)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        int L = (int)Math.round(this.getRayon(v) * v.getZoom());
        Point p = this.o[0].getViewCoord(v, L * 2, L * 2);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(this.getColor());
        double sa = this.getStartAngle3H(v);
        double a = this.getAngle();
        g.drawArc(p.x - L, p.y - L, L * 2, L * 2, (int)Math.round(sa), (int)Math.round(a));
        if (this.isSelected()) {
            if (this.plan != null && this.plan.type == 10) {
                return true;
            }
            this.drawSelect(g, v, 1);
            this.drawSelect(g, v, 2);
        }
        return true;
    }
}

