/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBType;
import adql.db.STCS;
import adql.parser.ParseException;
import adql.query.IdentifierField;
import adql.query.operand.StringConstant;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.translator.JDBCTranslator;
import adql.translator.TranslationException;

public class PostgreSQLTranslator
extends JDBCTranslator {
    protected byte caseSensitivity = 0;

    public PostgreSQLTranslator() {
        this.caseSensitivity = (byte)15;
    }

    public PostgreSQLTranslator(boolean bl) {
        this.caseSensitivity = (byte)(bl ? 15 : 0);
    }

    public PostgreSQLTranslator(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.caseSensitivity = IdentifierField.CATALOG.setCaseSensitive(this.caseSensitivity, bl);
        this.caseSensitivity = IdentifierField.SCHEMA.setCaseSensitive(this.caseSensitivity, bl2);
        this.caseSensitivity = IdentifierField.TABLE.setCaseSensitive(this.caseSensitivity, bl3);
        this.caseSensitivity = IdentifierField.COLUMN.setCaseSensitive(this.caseSensitivity, bl4);
    }

    @Override
    public boolean isCaseSensitive(IdentifierField identifierField) {
        return identifierField == null ? false : identifierField.isCaseSensitive(this.caseSensitivity);
    }

    @Override
    public String translate(StringConstant stringConstant) throws TranslationException {
        if (stringConstant.getValue() != null && stringConstant.getValue().contains("\\")) {
            return "E'" + stringConstant.getValue() + "'";
        }
        return super.translate(stringConstant);
    }

    @Override
    public String translate(MathFunction mathFunction) throws TranslationException {
        switch (mathFunction.getType()) {
            case LOG: {
                return "ln(" + (mathFunction.getNbParameters() >= 1 ? this.translate(mathFunction.getParameter(0)) : "") + ")";
            }
            case LOG10: {
                return "log(10, " + (mathFunction.getNbParameters() >= 1 ? this.translate(mathFunction.getParameter(0)) : "") + ")";
            }
            case RAND: {
                return "random()";
            }
            case TRUNCATE: {
                return "trunc(" + (mathFunction.getNbParameters() >= 2 ? this.translate(mathFunction.getParameter(0)) + ", " + this.translate(mathFunction.getParameter(1)) : "") + ")";
            }
        }
        return this.getDefaultADQLFunction(mathFunction);
    }

    @Override
    public String translate(ExtractCoord extractCoord) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoord);
    }

    @Override
    public String translate(ExtractCoordSys extractCoordSys) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoordSys);
    }

    @Override
    public String translate(AreaFunction areaFunction) throws TranslationException {
        return this.getDefaultADQLFunction(areaFunction);
    }

    @Override
    public String translate(CentroidFunction centroidFunction) throws TranslationException {
        return this.getDefaultADQLFunction(centroidFunction);
    }

    @Override
    public String translate(DistanceFunction distanceFunction) throws TranslationException {
        return this.getDefaultADQLFunction(distanceFunction);
    }

    @Override
    public String translate(ContainsFunction containsFunction) throws TranslationException {
        return this.getDefaultADQLFunction(containsFunction);
    }

    @Override
    public String translate(IntersectsFunction intersectsFunction) throws TranslationException {
        return this.getDefaultADQLFunction(intersectsFunction);
    }

    @Override
    public String translate(BoxFunction boxFunction) throws TranslationException {
        return this.getDefaultADQLFunction(boxFunction);
    }

    @Override
    public String translate(CircleFunction circleFunction) throws TranslationException {
        return this.getDefaultADQLFunction(circleFunction);
    }

    @Override
    public String translate(PointFunction pointFunction) throws TranslationException {
        return this.getDefaultADQLFunction(pointFunction);
    }

    @Override
    public String translate(PolygonFunction polygonFunction) throws TranslationException {
        return this.getDefaultADQLFunction(polygonFunction);
    }

    @Override
    public String translate(RegionFunction regionFunction) throws TranslationException {
        return this.getDefaultADQLFunction(regionFunction);
    }

    @Override
    public DBType convertTypeFromDB(int n, String string, String string2, String[] stringArray) {
        if (string2 == null || string2.trim().length() == 0) {
            return new DBType(DBType.DBDatatype.VARCHAR, -1);
        }
        string2 = string2.toLowerCase();
        int n2 = -1;
        if (stringArray != null && stringArray.length > 0) {
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string2.equals("smallint") || string2.equals("int2") || string2.equals("smallserial") || string2.equals("serial2") || string2.equals("boolean") || string2.equals("bool")) {
            return new DBType(DBType.DBDatatype.SMALLINT);
        }
        if (string2.equals("integer") || string2.equals("int") || string2.equals("int4") || string2.equals("serial") || string2.equals("serial4")) {
            return new DBType(DBType.DBDatatype.INTEGER);
        }
        if (string2.equals("bigint") || string2.equals("int8") || string2.equals("bigserial") || string2.equals("bigserial8")) {
            return new DBType(DBType.DBDatatype.BIGINT);
        }
        if (string2.equals("real") || string2.equals("float4")) {
            return new DBType(DBType.DBDatatype.REAL);
        }
        if (string2.equals("double precision") || string2.equals("float8")) {
            return new DBType(DBType.DBDatatype.DOUBLE);
        }
        if (string2.equals("bit")) {
            return new DBType(DBType.DBDatatype.BINARY, n2);
        }
        if (string2.equals("bit varying") || string2.equals("varbit")) {
            return new DBType(DBType.DBDatatype.VARBINARY, n2);
        }
        if (string2.equals("char") || string2.equals("character")) {
            return new DBType(DBType.DBDatatype.CHAR, n2);
        }
        if (string2.equals("varchar") || string2.equals("character varying")) {
            return new DBType(DBType.DBDatatype.VARCHAR, n2);
        }
        if (string2.equals("bytea")) {
            return new DBType(DBType.DBDatatype.BLOB);
        }
        if (string2.equals("text")) {
            return new DBType(DBType.DBDatatype.CLOB);
        }
        if (string2.equals("timestamp") || string2.equals("timestamptz") || string2.equals("time") || string2.equals("timetz") || string2.equals("date")) {
            return new DBType(DBType.DBDatatype.TIMESTAMP);
        }
        return new DBType(DBType.DBDatatype.VARCHAR, -1);
    }

    @Override
    public String convertTypeToDB(DBType dBType) {
        if (dBType == null) {
            return "VARCHAR";
        }
        switch (dBType.type) {
            case SMALLINT: 
            case INTEGER: 
            case REAL: 
            case BIGINT: 
            case CHAR: 
            case VARCHAR: 
            case TIMESTAMP: {
                return dBType.type.toString();
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case BINARY: 
            case VARBINARY: {
                return "bytea";
            }
            case BLOB: {
                return "bytea";
            }
            case CLOB: {
                return "TEXT";
            }
        }
        return "VARCHAR";
    }

    @Override
    public STCS.Region translateGeometryFromDB(Object object) throws ParseException {
        throw new ParseException("Unsupported geometrical value! The value \"" + object + "\" can not be parsed as a region.");
    }

    @Override
    public Object translateGeometryToDB(STCS.Region region) throws ParseException {
        throw new ParseException("Geometries can not be uploaded in the database in this implementation!");
    }
}

