/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DBType;
import adql.db.STCS;
import adql.db.exception.UnresolvedJoinException;
import adql.parser.ParseException;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ClauseConstraints;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.IdentifierField;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.Between;
import adql.query.constraint.Comparison;
import adql.query.constraint.ConstraintsGroup;
import adql.query.constraint.Exists;
import adql.query.constraint.In;
import adql.query.constraint.IsNull;
import adql.query.constraint.NotConstraint;
import adql.query.from.ADQLJoin;
import adql.query.from.ADQLTable;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NumericConstant;
import adql.query.operand.Operation;
import adql.query.operand.StringConstant;
import adql.query.operand.WrappedOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.SQLFunction;
import adql.query.operand.function.SQLFunctionType;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.translator.ADQLTranslator;
import adql.translator.TranslationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class JDBCTranslator
implements ADQLTranslator {
    public abstract boolean isCaseSensitive(IdentifierField var1);

    public String getQualifiedSchemaName(DBTable dBTable) {
        if (dBTable == null || dBTable.getDBSchemaName() == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (dBTable.getDBCatalogName() != null) {
            this.appendIdentifier(stringBuffer, dBTable.getDBCatalogName(), IdentifierField.CATALOG).append('.');
        }
        this.appendIdentifier(stringBuffer, dBTable.getDBSchemaName(), IdentifierField.SCHEMA);
        return stringBuffer.toString();
    }

    public String getQualifiedTableName(DBTable dBTable) {
        return this.getTableName(dBTable, true);
    }

    public String getTableName(DBTable dBTable, boolean bl) {
        if (dBTable == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.getQualifiedSchemaName(dBTable));
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
        }
        this.appendIdentifier(stringBuffer, dBTable.getDBName(), IdentifierField.TABLE);
        return stringBuffer.toString();
    }

    public String getColumnName(DBColumn dBColumn) {
        return dBColumn == null ? "" : this.appendIdentifier(new StringBuffer(), dBColumn.getDBName(), IdentifierField.COLUMN).toString();
    }

    public final StringBuffer appendIdentifier(StringBuffer stringBuffer, String string, IdentifierField identifierField) {
        return JDBCTranslator.appendIdentifier(stringBuffer, string, this.isCaseSensitive(identifierField));
    }

    public static final StringBuffer appendIdentifier(StringBuffer stringBuffer, String string, boolean bl) {
        if (bl) {
            return stringBuffer.append('\"').append(string).append('\"');
        }
        return stringBuffer.append(string);
    }

    @Override
    public String translate(ADQLObject aDQLObject) throws TranslationException {
        if (aDQLObject instanceof ADQLQuery) {
            return this.translate((ADQLQuery)aDQLObject);
        }
        if (aDQLObject instanceof ADQLList) {
            return this.translate((ADQLList)aDQLObject);
        }
        if (aDQLObject instanceof SelectItem) {
            return this.translate((SelectItem)aDQLObject);
        }
        if (aDQLObject instanceof ColumnReference) {
            return this.translate((ColumnReference)aDQLObject);
        }
        if (aDQLObject instanceof ADQLTable) {
            return this.translate((ADQLTable)aDQLObject);
        }
        if (aDQLObject instanceof ADQLJoin) {
            return this.translate((ADQLJoin)aDQLObject);
        }
        if (aDQLObject instanceof ADQLOperand) {
            return this.translate((ADQLOperand)aDQLObject);
        }
        if (aDQLObject instanceof ADQLConstraint) {
            return this.translate((ADQLConstraint)aDQLObject);
        }
        return aDQLObject.toADQL();
    }

    @Override
    public String translate(ADQLQuery aDQLQuery) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer(this.translate(aDQLQuery.getSelect()));
        stringBuffer.append("\nFROM ").append(this.translate(aDQLQuery.getFrom()));
        if (!aDQLQuery.getWhere().isEmpty()) {
            stringBuffer.append('\n').append(this.translate(aDQLQuery.getWhere()));
        }
        if (!aDQLQuery.getGroupBy().isEmpty()) {
            stringBuffer.append('\n').append(this.translate(aDQLQuery.getGroupBy()));
        }
        if (!aDQLQuery.getHaving().isEmpty()) {
            stringBuffer.append('\n').append(this.translate(aDQLQuery.getHaving()));
        }
        if (!aDQLQuery.getOrderBy().isEmpty()) {
            stringBuffer.append('\n').append(this.translate(aDQLQuery.getOrderBy()));
        }
        if (aDQLQuery.getSelect().hasLimit()) {
            stringBuffer.append("\nLimit ").append(aDQLQuery.getSelect().getLimit());
        }
        return stringBuffer.toString();
    }

    @Override
    public String translate(ADQLList<? extends ADQLObject> aDQLList) throws TranslationException {
        if (aDQLList instanceof ClauseSelect) {
            return this.translate((ClauseSelect)aDQLList);
        }
        if (aDQLList instanceof ClauseConstraints) {
            return this.translate((ClauseConstraints)aDQLList);
        }
        return this.getDefaultADQLList(aDQLList);
    }

    protected String getDefaultADQLList(ADQLList<? extends ADQLObject> aDQLList) throws TranslationException {
        String string = aDQLList.getName() == null ? "" : aDQLList.getName() + " ";
        for (int i = 0; i < aDQLList.size(); ++i) {
            string = string + (i == 0 ? "" : " " + aDQLList.getSeparator(i) + " ") + this.translate(aDQLList.get(i));
        }
        return string;
    }

    @Override
    public String translate(ClauseSelect clauseSelect) throws TranslationException {
        String string = null;
        for (int i = 0; i < clauseSelect.size(); ++i) {
            string = i == 0 ? clauseSelect.getName() + (clauseSelect.distinctColumns() ? " DISTINCT" : "") : string + " " + clauseSelect.getSeparator(i);
            string = string + " " + this.translate((SelectItem)clauseSelect.get(i));
        }
        return string;
    }

    @Override
    public String translate(ClauseConstraints clauseConstraints) throws TranslationException {
        if (clauseConstraints instanceof ConstraintsGroup) {
            return "(" + this.getDefaultADQLList(clauseConstraints) + ")";
        }
        return this.getDefaultADQLList(clauseConstraints);
    }

    @Override
    public String translate(SelectItem selectItem) throws TranslationException {
        if (selectItem instanceof SelectAllColumns) {
            return this.translate((SelectAllColumns)selectItem);
        }
        StringBuffer stringBuffer = new StringBuffer(this.translate(selectItem.getOperand()));
        if (selectItem.hasAlias()) {
            stringBuffer.append(" AS ");
            JDBCTranslator.appendIdentifier(stringBuffer, selectItem.getAlias(), selectItem.isCaseSensitive());
        } else {
            stringBuffer.append(" AS ");
            JDBCTranslator.appendIdentifier(stringBuffer, selectItem.getName(), true);
        }
        return stringBuffer.toString();
    }

    @Override
    public String translate(SelectAllColumns selectAllColumns) throws TranslationException {
        String string;
        ArrayList<ADQLTable> arrayList;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        Iterable<DBColumn> iterable = null;
        if (selectAllColumns.getAdqlTable() != null && selectAllColumns.getAdqlTable().getDBLink() != null) {
            arrayList = selectAllColumns.getAdqlTable();
            iterable = ((ADQLTable)((Object)arrayList)).getDBLink();
            if (((ADQLTable)((Object)arrayList)).hasAlias()) {
                Iterator<ADQLTable> iterator = this.getQualifiedTableName(((ADQLTable)((Object)arrayList)).getDBLink());
                hashMap.put(iterator, ((ADQLTable)((Object)arrayList)).isCaseSensitive(IdentifierField.ALIAS) ? "\"" + ((ADQLTable)((Object)arrayList)).getAlias() + "\"" : ((ADQLTable)((Object)arrayList)).getAlias());
            }
        } else if (selectAllColumns.getQuery() != null) {
            try {
                iterable = selectAllColumns.getQuery().getFrom().getDBColumns();
            }
            catch (UnresolvedJoinException unresolvedJoinException) {
                throw new TranslationException("Due to a join problem, the ADQL to SQL translation can not be completed!", unresolvedJoinException);
            }
            arrayList = selectAllColumns.getQuery().getFrom().getTables();
            for (ADQLTable object : arrayList) {
                if (!object.hasAlias()) continue;
                string = this.getQualifiedTableName(object.getDBLink());
                hashMap.put(string, object.isCaseSensitive(IdentifierField.ALIAS) ? "\"" + object.getAlias() + "\"" : object.getAlias());
            }
        }
        if (iterable != null) {
            arrayList = new StringBuffer();
            for (DBColumn dBColumn : iterable) {
                if (((StringBuffer)((Object)arrayList)).length() > 0) {
                    ((StringBuffer)((Object)arrayList)).append(',');
                }
                if (dBColumn.getTable() != null) {
                    string = this.getQualifiedTableName(dBColumn.getTable());
                    if (hashMap.containsKey(string)) {
                        JDBCTranslator.appendIdentifier(arrayList, (String)hashMap.get(string), false).append('.');
                    } else {
                        ((StringBuffer)((Object)arrayList)).append(string).append('.');
                    }
                }
                this.appendIdentifier((StringBuffer)((Object)arrayList), dBColumn.getDBName(), IdentifierField.COLUMN);
                ((StringBuffer)((Object)arrayList)).append(" AS \"").append(dBColumn.getADQLName()).append('\"');
            }
            return ((StringBuffer)((Object)arrayList)).length() > 0 ? ((StringBuffer)((Object)arrayList)).toString() : selectAllColumns.toADQL();
        }
        return selectAllColumns.toADQL();
    }

    @Override
    public String translate(ColumnReference columnReference) throws TranslationException {
        if (columnReference instanceof ADQLOrder) {
            return this.translate((ADQLOrder)columnReference);
        }
        return this.getDefaultColumnReference(columnReference);
    }

    protected String getDefaultColumnReference(ColumnReference columnReference) throws TranslationException {
        if (columnReference.isIndex()) {
            return "" + columnReference.getColumnIndex();
        }
        if (columnReference.getDBLink() == null) {
            return columnReference.isCaseSensitive() ? "\"" + columnReference.getColumnName() + "\"" : columnReference.getColumnName();
        }
        DBColumn dBColumn = columnReference.getDBLink();
        StringBuffer stringBuffer = new StringBuffer();
        if (columnReference.getAdqlTable() != null && columnReference.getAdqlTable().hasAlias()) {
            JDBCTranslator.appendIdentifier(stringBuffer, columnReference.getAdqlTable().getAlias(), columnReference.getAdqlTable().isCaseSensitive(IdentifierField.ALIAS)).append('.');
        } else if (dBColumn.getTable() != null) {
            stringBuffer.append(this.getQualifiedTableName(dBColumn.getTable())).append('.');
        }
        this.appendIdentifier(stringBuffer, dBColumn.getDBName(), IdentifierField.COLUMN);
        return stringBuffer.toString();
    }

    @Override
    public String translate(ADQLOrder aDQLOrder) throws TranslationException {
        return this.getDefaultColumnReference(aDQLOrder) + (aDQLOrder.isDescSorting() ? " DESC" : " ASC");
    }

    @Override
    public String translate(FromContent fromContent) throws TranslationException {
        if (fromContent instanceof ADQLTable) {
            return this.translate((ADQLTable)fromContent);
        }
        if (fromContent instanceof ADQLJoin) {
            return this.translate((ADQLJoin)fromContent);
        }
        return fromContent.toADQL();
    }

    @Override
    public String translate(ADQLTable aDQLTable) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (aDQLTable.isSubQuery()) {
            stringBuffer.append('(').append(this.translate(aDQLTable.getSubQuery())).append(')');
        } else if (aDQLTable.getDBLink() != null) {
            stringBuffer.append(this.getQualifiedTableName(aDQLTable.getDBLink()));
        } else {
            stringBuffer.append(aDQLTable.getFullTableName());
        }
        if (aDQLTable.hasAlias()) {
            stringBuffer.append(" AS ");
            JDBCTranslator.appendIdentifier(stringBuffer, aDQLTable.getAlias(), aDQLTable.isCaseSensitive(IdentifierField.ALIAS));
        }
        return stringBuffer.toString();
    }

    @Override
    public String translate(ADQLJoin aDQLJoin) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer(this.translate(aDQLJoin.getLeftTable()));
        if (aDQLJoin.isNatural()) {
            stringBuffer.append(" NATURAL");
        }
        stringBuffer.append(' ').append(aDQLJoin.getJoinType()).append(' ').append(this.translate(aDQLJoin.getRightTable())).append(' ');
        if (!aDQLJoin.isNatural()) {
            if (aDQLJoin.getJoinCondition() != null) {
                stringBuffer.append(this.translate(aDQLJoin.getJoinCondition()));
            } else if (aDQLJoin.hasJoinedColumns()) {
                StringBuffer stringBuffer2 = new StringBuffer();
                Iterator<ADQLColumn> iterator = aDQLJoin.getJoinedColumns();
                while (iterator.hasNext()) {
                    ADQLColumn aDQLColumn = iterator.next();
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(", ");
                    }
                    if (aDQLColumn.getDBLink() == null) {
                        JDBCTranslator.appendIdentifier(stringBuffer2, aDQLColumn.getColumnName(), aDQLColumn.isCaseSensitive(IdentifierField.COLUMN));
                        continue;
                    }
                    this.appendIdentifier(stringBuffer2, aDQLColumn.getDBLink().getDBName(), IdentifierField.COLUMN);
                }
                stringBuffer.append("USING (").append(stringBuffer2).append(')');
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String translate(ADQLOperand aDQLOperand) throws TranslationException {
        if (aDQLOperand instanceof ADQLColumn) {
            return this.translate((ADQLColumn)aDQLOperand);
        }
        if (aDQLOperand instanceof Concatenation) {
            return this.translate((Concatenation)aDQLOperand);
        }
        if (aDQLOperand instanceof NegativeOperand) {
            return this.translate((NegativeOperand)aDQLOperand);
        }
        if (aDQLOperand instanceof NumericConstant) {
            return this.translate((NumericConstant)aDQLOperand);
        }
        if (aDQLOperand instanceof StringConstant) {
            return this.translate((StringConstant)aDQLOperand);
        }
        if (aDQLOperand instanceof WrappedOperand) {
            return this.translate((WrappedOperand)aDQLOperand);
        }
        if (aDQLOperand instanceof Operation) {
            return this.translate((Operation)aDQLOperand);
        }
        if (aDQLOperand instanceof ADQLFunction) {
            return this.translate((ADQLFunction)aDQLOperand);
        }
        return aDQLOperand.toADQL();
    }

    @Override
    public String translate(ADQLColumn aDQLColumn) throws TranslationException {
        if (aDQLColumn.getDBLink() != null) {
            DBColumn dBColumn = aDQLColumn.getDBLink();
            StringBuffer stringBuffer = new StringBuffer();
            if (aDQLColumn.getAdqlTable() != null && aDQLColumn.getAdqlTable().hasAlias()) {
                JDBCTranslator.appendIdentifier(stringBuffer, aDQLColumn.getAdqlTable().getAlias(), aDQLColumn.getAdqlTable().isCaseSensitive(IdentifierField.ALIAS)).append('.');
            } else if (dBColumn.getTable() != null && dBColumn.getTable().getDBName() != null) {
                stringBuffer.append(this.getQualifiedTableName(dBColumn.getTable())).append('.');
            } else if (aDQLColumn.getTableName() != null) {
                stringBuffer = aDQLColumn.getFullColumnPrefix().append('.');
            }
            this.appendIdentifier(stringBuffer, dBColumn.getDBName(), IdentifierField.COLUMN);
            return stringBuffer.toString();
        }
        return aDQLColumn.getFullColumnName();
    }

    @Override
    public String translate(Concatenation concatenation) throws TranslationException {
        return this.translate((ADQLList<? extends ADQLObject>)concatenation);
    }

    @Override
    public String translate(NegativeOperand negativeOperand) throws TranslationException {
        return "-" + this.translate(negativeOperand.getOperand());
    }

    @Override
    public String translate(NumericConstant numericConstant) throws TranslationException {
        return numericConstant.getValue();
    }

    @Override
    public String translate(StringConstant stringConstant) throws TranslationException {
        return "'" + stringConstant.getValue() + "'";
    }

    @Override
    public String translate(WrappedOperand wrappedOperand) throws TranslationException {
        return "(" + this.translate(wrappedOperand.getOperand()) + ")";
    }

    @Override
    public String translate(Operation operation) throws TranslationException {
        return this.translate(operation.getLeftOperand()) + operation.getOperation().toADQL() + this.translate(operation.getRightOperand());
    }

    @Override
    public String translate(ADQLConstraint aDQLConstraint) throws TranslationException {
        if (aDQLConstraint instanceof Comparison) {
            return this.translate((Comparison)aDQLConstraint);
        }
        if (aDQLConstraint instanceof Between) {
            return this.translate((Between)aDQLConstraint);
        }
        if (aDQLConstraint instanceof Exists) {
            return this.translate((Exists)aDQLConstraint);
        }
        if (aDQLConstraint instanceof In) {
            return this.translate((In)aDQLConstraint);
        }
        if (aDQLConstraint instanceof IsNull) {
            return this.translate((IsNull)aDQLConstraint);
        }
        if (aDQLConstraint instanceof NotConstraint) {
            return this.translate((NotConstraint)aDQLConstraint);
        }
        return aDQLConstraint.toADQL();
    }

    @Override
    public String translate(Comparison comparison) throws TranslationException {
        return this.translate(comparison.getLeftOperand()) + " " + comparison.getOperator().toADQL() + " " + this.translate(comparison.getRightOperand());
    }

    @Override
    public String translate(Between between) throws TranslationException {
        return this.translate(between.getLeftOperand()) + " " + between.getName() + " " + this.translate(between.getMinOperand()) + " AND " + this.translate(between.getMaxOperand());
    }

    @Override
    public String translate(Exists exists) throws TranslationException {
        return "EXISTS(" + this.translate(exists.getSubQuery()) + ")";
    }

    @Override
    public String translate(In in) throws TranslationException {
        return this.translate(in.getOperand()) + " " + in.getName() + " (" + (in.hasSubQuery() ? this.translate(in.getSubQuery()) : this.translate(in.getValuesList())) + ")";
    }

    @Override
    public String translate(IsNull isNull) throws TranslationException {
        return this.translate(isNull.getColumn()) + " " + isNull.getName();
    }

    @Override
    public String translate(NotConstraint notConstraint) throws TranslationException {
        return "NOT " + this.translate(notConstraint.getConstraint());
    }

    @Override
    public String translate(ADQLFunction aDQLFunction) throws TranslationException {
        if (aDQLFunction instanceof GeometryFunction) {
            return this.translate((GeometryFunction)aDQLFunction);
        }
        if (aDQLFunction instanceof MathFunction) {
            return this.translate((MathFunction)aDQLFunction);
        }
        if (aDQLFunction instanceof SQLFunction) {
            return this.translate((SQLFunction)aDQLFunction);
        }
        if (aDQLFunction instanceof UserDefinedFunction) {
            return this.translate((UserDefinedFunction)aDQLFunction);
        }
        return this.getDefaultADQLFunction(aDQLFunction);
    }

    protected final String getDefaultADQLFunction(ADQLFunction aDQLFunction) throws TranslationException {
        String string = aDQLFunction.getName() + "(";
        for (int i = 0; i < aDQLFunction.getNbParameters(); ++i) {
            string = string + (i == 0 ? "" : ", ") + this.translate(aDQLFunction.getParameter(i));
        }
        return string + ")";
    }

    @Override
    public String translate(SQLFunction sQLFunction) throws TranslationException {
        if (sQLFunction.getType() == SQLFunctionType.COUNT_ALL) {
            return "COUNT(" + (sQLFunction.isDistinct() ? "DISTINCT " : "") + "*)";
        }
        return sQLFunction.getName() + "(" + (sQLFunction.isDistinct() ? "DISTINCT " : "") + this.translate(sQLFunction.getParameter(0)) + ")";
    }

    @Override
    public String translate(MathFunction mathFunction) throws TranslationException {
        return this.getDefaultADQLFunction(mathFunction);
    }

    @Override
    public String translate(UserDefinedFunction userDefinedFunction) throws TranslationException {
        return userDefinedFunction.translate(this);
    }

    @Override
    public String translate(GeometryFunction geometryFunction) throws TranslationException {
        if (geometryFunction instanceof AreaFunction) {
            return this.translate((AreaFunction)geometryFunction);
        }
        if (geometryFunction instanceof BoxFunction) {
            return this.translate((BoxFunction)geometryFunction);
        }
        if (geometryFunction instanceof CentroidFunction) {
            return this.translate((CentroidFunction)geometryFunction);
        }
        if (geometryFunction instanceof CircleFunction) {
            return this.translate((CircleFunction)geometryFunction);
        }
        if (geometryFunction instanceof ContainsFunction) {
            return this.translate((ContainsFunction)geometryFunction);
        }
        if (geometryFunction instanceof DistanceFunction) {
            return this.translate((DistanceFunction)geometryFunction);
        }
        if (geometryFunction instanceof ExtractCoord) {
            return this.translate((ExtractCoord)geometryFunction);
        }
        if (geometryFunction instanceof ExtractCoordSys) {
            return this.translate((ExtractCoordSys)geometryFunction);
        }
        if (geometryFunction instanceof IntersectsFunction) {
            return this.translate((IntersectsFunction)geometryFunction);
        }
        if (geometryFunction instanceof PointFunction) {
            return this.translate((PointFunction)geometryFunction);
        }
        if (geometryFunction instanceof PolygonFunction) {
            return this.translate((PolygonFunction)geometryFunction);
        }
        if (geometryFunction instanceof RegionFunction) {
            return this.translate((RegionFunction)geometryFunction);
        }
        return this.getDefaultADQLFunction(geometryFunction);
    }

    @Override
    public String translate(GeometryFunction.GeometryValue<? extends GeometryFunction> geometryValue) throws TranslationException {
        return this.translate(geometryValue.getValue());
    }

    public abstract DBType convertTypeFromDB(int var1, String var2, String var3, String[] var4);

    public abstract String convertTypeToDB(DBType var1);

    public abstract STCS.Region translateGeometryFromDB(Object var1) throws ParseException;

    public abstract Object translateGeometryToDB(STCS.Region var1) throws ParseException;
}

