/*
 * Decompiled with CFR 0.152.
 */
package adql.search;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.search.ISearchHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public abstract class SimpleSearchHandler
implements ISearchHandler {
    private boolean recursive = false;
    private boolean firstMatch = false;
    protected final ArrayList<ADQLObject> results = new ArrayList();

    public SimpleSearchHandler() {
    }

    public SimpleSearchHandler(boolean bl) {
        this();
        this.recursive = bl;
    }

    public SimpleSearchHandler(boolean bl, boolean bl2) {
        this(bl);
        this.firstMatch = bl2;
    }

    public final boolean isRecursive() {
        return this.recursive;
    }

    public final void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public final boolean onlyFirstMatch() {
        return this.firstMatch;
    }

    public final void setOnlyFirstMatch(boolean bl) {
        this.firstMatch = bl;
    }

    @Override
    public final Iterator<ADQLObject> iterator() {
        return this.results.iterator();
    }

    @Override
    public final int getNbMatch() {
        return this.results.size();
    }

    protected boolean isFinished() {
        return this.firstMatch && !this.results.isEmpty();
    }

    protected boolean goInto(ADQLObject aDQLObject) {
        return this.recursive || !(aDQLObject instanceof ADQLQuery);
    }

    protected void addMatch(ADQLObject aDQLObject, ADQLIterator aDQLIterator) {
        this.results.add(aDQLObject);
    }

    protected void reset() {
        this.results.clear();
    }

    @Override
    public final void search(ADQLObject aDQLObject) {
        this.reset();
        if (aDQLObject == null) {
            return;
        }
        if (this.match(aDQLObject)) {
            this.addMatch(aDQLObject, null);
        }
        Stack<ADQLIterator> stack = new Stack<ADQLIterator>();
        ADQLObject aDQLObject2 = null;
        ADQLIterator aDQLIterator = aDQLObject.adqlIterator();
        while (!this.isFinished()) {
            do {
                if (aDQLIterator != null && aDQLIterator.hasNext()) {
                    aDQLObject2 = (ADQLObject)aDQLIterator.next();
                    continue;
                }
                if (!stack.isEmpty()) {
                    aDQLIterator = (ADQLIterator)stack.pop();
                    continue;
                }
                return;
            } while (aDQLObject2 == null);
            if (this.match(aDQLObject2)) {
                this.addMatch(aDQLObject2, aDQLIterator);
            }
            if (this.goInto(aDQLObject2)) {
                stack.push(aDQLIterator);
                aDQLIterator = aDQLObject2.adqlIterator();
            }
            aDQLObject2 = null;
        }
    }

    protected abstract boolean match(ADQLObject var1);
}

