/*
 * Decompiled with CFR 0.152.
 */
package adql.search;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.search.IReplaceHandler;
import adql.search.SimpleSearchHandler;

public abstract class SimpleReplaceHandler
extends SimpleSearchHandler
implements IReplaceHandler {
    protected boolean replaceActive = false;
    protected int nbReplacement = 0;

    public SimpleReplaceHandler() {
    }

    public SimpleReplaceHandler(boolean bl) {
        super(bl);
    }

    public SimpleReplaceHandler(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    @Override
    public int getNbReplacement() {
        return this.nbReplacement;
    }

    @Override
    protected void reset() {
        super.reset();
        this.nbReplacement = 0;
    }

    @Override
    protected void addMatch(ADQLObject aDQLObject, ADQLIterator aDQLIterator) {
        super.addMatch(aDQLObject, aDQLIterator);
        if (this.replaceActive && aDQLIterator != null) {
            try {
                ADQLObject aDQLObject2 = this.getReplacer(aDQLObject);
                if (aDQLObject2 == null) {
                    aDQLIterator.remove();
                } else {
                    aDQLIterator.replace(aDQLObject2);
                }
                ++this.nbReplacement;
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void searchAndReplace(ADQLObject aDQLObject) {
        this.replaceActive = true;
        this.search(aDQLObject);
        this.replaceActive = false;
    }

    protected abstract ADQLObject getReplacer(ADQLObject var1) throws UnsupportedOperationException;
}

