/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.MathFunctionType;

public class MathFunction
extends ADQLFunction {
    private final MathFunctionType type;
    private ADQLOperand param1 = null;
    private ADQLOperand param2 = null;
    private int nbParams;

    public MathFunction(MathFunctionType mathFunctionType) throws Exception {
        this(mathFunctionType, null, null);
    }

    public MathFunction(MathFunctionType mathFunctionType, ADQLOperand aDQLOperand) throws Exception {
        this(mathFunctionType, aDQLOperand, null);
    }

    public MathFunction(MathFunctionType mathFunctionType, ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2) throws Exception {
        this.type = mathFunctionType;
        if (this.type.nbMaxParams() > 2) {
            throw new Exception("Impossible for MathFunction object to have " + this.type.nbMaxParams() + " ! It is limited to 2 parameters !");
        }
        this.nbParams = (aDQLOperand != null ? 1 : 0) + (aDQLOperand2 != null ? 1 : 0);
        if (this.nbParams < this.type.nbMinParams() || this.nbParams > this.type.nbMaxParams()) {
            if (this.type.nbMinParams() == this.type.nbMaxParams()) {
                throw new Exception("The function " + this.type.name() + " must have " + (this.type.nbMaxParams() == 0 ? "no parameter!" : "exactly " + this.type.nbMaxParams() + " parameters!"));
            }
            switch (this.type.nbMaxParams()) {
                case 0: {
                    throw new Exception("The function " + this.type.name() + " must have no parameter !");
                }
                case 1: {
                    throw new Exception("The function " + this.type.name() + " must have only one parameter !");
                }
                case 2: {
                    throw new Exception("The function " + this.type.name() + " must have two parameters !");
                }
            }
        }
        this.param1 = aDQLOperand;
        this.param2 = aDQLOperand2;
    }

    public MathFunction(MathFunction mathFunction) throws Exception {
        this.type = mathFunction.type;
        this.param1 = (ADQLOperand)mathFunction.param1.getCopy();
        this.param2 = (ADQLOperand)mathFunction.param2.getCopy();
    }

    public final MathFunctionType getType() {
        return this.type;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new MathFunction(this);
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLOperand[] getParameters() {
        switch (this.getNbParameters()) {
            case 1: {
                return new ADQLOperand[]{this.param1};
            }
            case 2: {
                return new ADQLOperand[]{this.param1, this.param2};
            }
        }
        return new ADQLOperand[0];
    }

    @Override
    public int getNbParameters() {
        return this.nbParams;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.type.name() + "\" (nb required params = " + this.type.nbMaxParams() + ") !");
        }
        switch (n) {
            case 0: {
                return this.param1;
            }
            case 1: {
                return this.param2;
            }
        }
        return null;
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (n < 0 || n >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.type.name() + "\" (nb required params = " + this.type.nbMaxParams() + ") !");
        }
        if (aDQLOperand == null) {
            throw new NullPointerException("Impossible to remove any parameter from a mathematical function ! All parameters are required !");
        }
        ADQLOperand aDQLOperand2 = null;
        switch (n) {
            case 0: {
                aDQLOperand2 = this.param1;
                this.param1 = aDQLOperand;
                break;
            }
            case 1: {
                aDQLOperand2 = this.param2;
                this.param2 = aDQLOperand;
            }
        }
        return aDQLOperand2;
    }
}

