/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.db.FunctionDef;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.ClauseADQL;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.UserDefinedFunction;
import adql.translator.ADQLTranslator;
import adql.translator.TranslationException;

public final class DefaultUDF
extends UserDefinedFunction {
    protected FunctionDef definition = null;
    protected final ADQLList<ADQLOperand> parameters;
    protected final String functionName;

    public DefaultUDF(String string, ADQLOperand[] aDQLOperandArray) throws NullPointerException {
        this.functionName = string;
        this.parameters = new ClauseADQL<ADQLOperand>();
        if (aDQLOperandArray != null) {
            for (ADQLOperand aDQLOperand : aDQLOperandArray) {
                this.parameters.add(aDQLOperand);
            }
        }
    }

    public DefaultUDF(DefaultUDF defaultUDF) throws Exception {
        this.functionName = defaultUDF.functionName;
        this.parameters = (ADQLList)defaultUDF.parameters.getCopy();
    }

    public final FunctionDef getDefinition() {
        return this.definition;
    }

    public final void setDefinition(FunctionDef functionDef) throws IllegalArgumentException {
        if (!(functionDef == null || functionDef.name != null && this.functionName.equalsIgnoreCase(functionDef.name))) {
            throw new IllegalArgumentException("The parsed function name (" + this.functionName + ") does not match to the name of the given UDF definition (" + functionDef.name + ").");
        }
        this.definition = functionDef;
    }

    @Override
    public final boolean isNumeric() {
        return this.definition == null || this.definition.isNumeric();
    }

    @Override
    public final boolean isString() {
        return this.definition == null || this.definition.isString();
    }

    @Override
    public final boolean isGeometry() {
        return this.definition == null || this.definition.isGeometry();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        DefaultUDF defaultUDF = new DefaultUDF(this);
        defaultUDF.setDefinition(this.definition);
        return defaultUDF;
    }

    @Override
    public final String getName() {
        return this.functionName;
    }

    @Override
    public final ADQLOperand[] getParameters() {
        ADQLOperand[] aDQLOperandArray = new ADQLOperand[this.parameters.size()];
        int n = 0;
        for (ADQLOperand aDQLOperand : this.parameters) {
            aDQLOperandArray[n++] = aDQLOperand;
        }
        return aDQLOperandArray;
    }

    @Override
    public final int getNbParameters() {
        return this.parameters.size();
    }

    @Override
    public final ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        return this.parameters.get(n);
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        return this.parameters.set(n, aDQLOperand);
    }

    @Override
    public String translate(ADQLTranslator aDQLTranslator) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer(this.functionName);
        stringBuffer.append('(');
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(',').append(' ');
            }
            stringBuffer.append(aDQLTranslator.translate(this.parameters.get(i)));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

