/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ADQLFunction
implements ADQLOperand {
    public abstract int getNbParameters();

    public abstract ADQLOperand[] getParameters();

    public abstract ADQLOperand getParameter(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract ADQLOperand setParameter(int var1, ADQLOperand var2) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception;

    public Iterator<ADQLOperand> paramIterator() {
        return new ParameterIterator(this);
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;

            @Override
            public ADQLObject next() {
                try {
                    return ADQLFunction.this.getParameter(++this.index);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < ADQLFunction.this.getNbParameters();
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else if (aDQLObject instanceof ADQLOperand) {
                    try {
                        ADQLFunction.this.setParameter(this.index, (ADQLOperand)aDQLObject);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new UnsupportedOperationException(exception);
                    }
                } else {
                    throw new UnsupportedOperationException("Impossible to replace the " + this.index + "-th parameter of \"" + ADQLFunction.this.toADQL() + "\" by an object whose the class (" + aDQLObject.getClass().getName() + ") is not ADQLOperand !");
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove a parameter of an ADQL function (here the " + this.index + "-th parameter of \"" + ADQLFunction.this.toADQL() + "\")");
            }
        };
    }

    @Override
    public String toADQL() {
        String string = this.getName() + "(";
        for (int i = 0; i < this.getNbParameters(); ++i) {
            string = string + (i == 0 ? "" : ", ") + this.getParameter(i).toADQL();
        }
        return string + ")";
    }

    protected class ParameterIterator
    implements Iterator<ADQLOperand> {
        protected final ADQLFunction function;
        protected int index = -1;

        public ParameterIterator(ADQLFunction aDQLFunction2) throws NullPointerException {
            if (aDQLFunction2 == null) {
                throw new NullPointerException("Impossible to build an iterator on a function without the function on which the iterator must be applied !");
            }
            this.function = aDQLFunction2;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.function.getNbParameters();
        }

        @Override
        public ADQLOperand next() {
            ++this.index;
            return this.function.getParameter(this.index);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            try {
                this.function.setParameter(this.index, null);
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException(exception);
            }
        }
    }
}

