/*
 * Decompiled with CFR 0.152.
 */
package adql.query.from;

import adql.db.DBColumn;
import adql.db.DBCommonColumn;
import adql.db.SearchColumnList;
import adql.db.exception.UnresolvedJoinException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ClauseConstraints;
import adql.query.IdentifierField;
import adql.query.from.ADQLTable;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class ADQLJoin
implements ADQLObject,
FromContent {
    private FromContent leftTable;
    private FromContent rightTable;
    protected boolean natural = false;
    protected ClauseConstraints condition = null;
    protected ArrayList<ADQLColumn> lstColumns = null;

    public ADQLJoin(FromContent fromContent, FromContent fromContent2) {
        this.leftTable = fromContent;
        this.rightTable = fromContent2;
    }

    public ADQLJoin(ADQLJoin aDQLJoin) throws Exception {
        this.leftTable = (FromContent)aDQLJoin.leftTable.getCopy();
        this.rightTable = (FromContent)aDQLJoin.rightTable.getCopy();
        this.natural = aDQLJoin.natural;
        this.condition = (ClauseConstraints)aDQLJoin.condition.getCopy();
        if (aDQLJoin.lstColumns != null) {
            this.lstColumns = new ArrayList(aDQLJoin.lstColumns.size());
            for (ADQLColumn aDQLColumn : aDQLJoin.lstColumns) {
                this.lstColumns.add((ADQLColumn)aDQLColumn.getCopy());
            }
        }
    }

    public final boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean bl) {
        this.natural = bl;
        if (bl) {
            this.condition = null;
            this.lstColumns = null;
        }
    }

    public final FromContent getLeftTable() {
        return this.leftTable;
    }

    public void setLeftTable(FromContent fromContent) {
        this.leftTable = fromContent;
    }

    public final FromContent getRightTable() {
        return this.rightTable;
    }

    public void setRightTable(FromContent fromContent) {
        this.rightTable = fromContent;
    }

    public final ClauseConstraints getJoinCondition() {
        return this.condition;
    }

    public void setJoinCondition(ClauseConstraints clauseConstraints) {
        this.condition = clauseConstraints;
        if (this.condition != null) {
            this.natural = false;
            this.lstColumns = null;
        }
    }

    public final Iterator<ADQLColumn> getJoinedColumns() {
        if (this.lstColumns == null) {
            return new Iterator<ADQLColumn>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ADQLColumn next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.lstColumns.iterator();
    }

    public final boolean hasJoinedColumns() {
        return this.lstColumns != null;
    }

    public void setJoinedColumns(Collection<ADQLColumn> collection) {
        if (collection != null && !collection.isEmpty()) {
            if (this.lstColumns == null) {
                this.lstColumns = new ArrayList(collection.size());
            } else {
                this.lstColumns.clear();
            }
            this.lstColumns.addAll(collection);
            this.natural = false;
            this.condition = null;
        }
    }

    @Override
    public String getName() {
        return this.getJoinType();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;
            private final int nbItems;
            private final int offset;
            private Iterator<ADQLColumn> itCol;
            {
                this.nbItems = 2 + (ADQLJoin.this.condition == null ? 0 : 1) + (ADQLJoin.this.lstColumns == null ? 0 : ADQLJoin.this.lstColumns.size());
                this.offset = 2 + (ADQLJoin.this.condition == null ? 0 : 1);
                this.itCol = null;
            }

            @Override
            public ADQLObject next() {
                ++this.index;
                if (this.index == 0) {
                    return ADQLJoin.this.leftTable;
                }
                if (this.index == 1) {
                    return ADQLJoin.this.rightTable;
                }
                if (this.index == 2 && ADQLJoin.this.condition != null) {
                    return ADQLJoin.this.condition;
                }
                if (ADQLJoin.this.lstColumns != null && !ADQLJoin.this.lstColumns.isEmpty()) {
                    if (this.itCol == null) {
                        this.itCol = ADQLJoin.this.lstColumns.iterator();
                    }
                    return this.itCol.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.itCol != null && this.itCol.hasNext() || this.index + 1 < this.nbItems;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                    return;
                } else if (this.index == 0) {
                    if (!(aDQLObject instanceof FromContent)) throw new UnsupportedOperationException("Impossible to replace the left \"table\" of the join (" + ADQLJoin.this.leftTable.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") ! The replacer must be a FromContent instance.");
                    ADQLJoin.this.leftTable = (FromContent)aDQLObject;
                    return;
                } else if (this.index == 1) {
                    if (!(aDQLObject instanceof FromContent)) throw new UnsupportedOperationException("Impossible to replace the right \"table\" of the join (" + ADQLJoin.this.rightTable.toADQL() + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") ! The replacer must be a FromContent instance.");
                    ADQLJoin.this.rightTable = (FromContent)aDQLObject;
                    return;
                } else if (this.index == 2 && this.itCol == null) {
                    if (!(aDQLObject instanceof ClauseConstraints)) throw new UnsupportedOperationException("Impossible to replace an ADQLConstraint (" + ADQLJoin.this.condition + ") by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                    ADQLJoin.this.condition = (ClauseConstraints)aDQLObject;
                    return;
                } else {
                    if (this.itCol == null) return;
                    if (!(aDQLObject instanceof ADQLColumn)) throw new UnsupportedOperationException("Impossible to replace an ADQLColumn by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                    ADQLJoin.this.lstColumns.set(this.index - this.offset, (ADQLColumn)aDQLObject);
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                if (this.index == 0) {
                    throw new UnsupportedOperationException("Impossible to remove the left \"table\" of the join (" + ADQLJoin.this.leftTable.toADQL() + ") !");
                }
                if (this.index == 1) {
                    throw new UnsupportedOperationException("Impossible to remove the right \"table\" of the join (" + ADQLJoin.this.rightTable.toADQL() + ") !");
                }
                if (this.index == 2 && this.itCol == null) {
                    throw new UnsupportedOperationException("Impossible to remove a condition (" + ADQLJoin.this.condition.toADQL() + ") from a join (" + ADQLJoin.this.toADQL() + ") !");
                }
                if (this.itCol != null) {
                    this.itCol.remove();
                    --this.index;
                }
            }
        };
    }

    @Override
    public String toADQL() {
        StringBuffer stringBuffer = new StringBuffer(this.leftTable.toADQL());
        stringBuffer.append(this.natural ? " NATURAL " : " ").append(this.getJoinType()).append(' ').append(this.rightTable.toADQL());
        if (this.condition != null) {
            stringBuffer.append(" ON ").append(this.condition.toADQL());
        } else if (this.lstColumns != null) {
            String string = null;
            for (ADQLColumn aDQLColumn : this.lstColumns) {
                string = string == null ? "\"" + aDQLColumn.toADQL() + "\"" : string + ", \"" + aDQLColumn.toADQL() + "\"";
            }
            stringBuffer.append(" USING (").append(string).append(')');
        }
        return stringBuffer.toString();
    }

    @Override
    public SearchColumnList getDBColumns() throws UnresolvedJoinException {
        SearchColumnList searchColumnList = new SearchColumnList();
        SearchColumnList searchColumnList2 = this.leftTable.getDBColumns();
        SearchColumnList searchColumnList3 = this.rightTable.getDBColumns();
        HashMap<String, DBCommonColumn> hashMap = new HashMap<String, DBCommonColumn>();
        if (this.natural) {
            for (DBColumn dBColumn : searchColumnList2) {
                DBColumn dBColumn2 = ADQLJoin.findAtMostOneColumn(dBColumn.getADQLName(), (byte)0, searchColumnList3, false);
                if (dBColumn2 == null) continue;
                ADQLJoin.findExactlyOneColumn(dBColumn.getADQLName(), (byte)0, searchColumnList2, true);
                hashMap.put(dBColumn.getADQLName().toLowerCase(), new DBCommonColumn(dBColumn, dBColumn2));
            }
        } else if (this.lstColumns != null && !this.lstColumns.isEmpty()) {
            for (ADQLColumn aDQLColumn : this.lstColumns) {
                DBColumn dBColumn = ADQLJoin.findExactlyOneColumn(aDQLColumn.getColumnName(), aDQLColumn.getCaseSensitive(), searchColumnList2, true);
                DBColumn dBColumn3 = ADQLJoin.findExactlyOneColumn(aDQLColumn.getColumnName(), aDQLColumn.getCaseSensitive(), searchColumnList3, false);
                hashMap.put(aDQLColumn.isCaseSensitive(IdentifierField.COLUMN) ? "\"" + aDQLColumn.getColumnName() + "\"" : aDQLColumn.getColumnName().toLowerCase(), new DBCommonColumn(dBColumn, dBColumn3));
            }
        } else {
            searchColumnList.addAll(searchColumnList2);
            searchColumnList.addAll(searchColumnList3);
            return searchColumnList;
        }
        ADQLJoin.addAllExcept(searchColumnList2, searchColumnList, hashMap);
        ADQLJoin.addAllExcept(searchColumnList3, searchColumnList, hashMap);
        searchColumnList.addAll((Collection<? extends DBColumn>)hashMap.values());
        return searchColumnList;
    }

    public static final void addAllExcept(SearchColumnList searchColumnList, SearchColumnList searchColumnList2, Map<String, DBCommonColumn> map) {
        for (DBColumn dBColumn : searchColumnList) {
            if (map.containsKey(dBColumn.getADQLName().toLowerCase()) || map.containsKey("\"" + dBColumn.getADQLName() + "\"")) continue;
            searchColumnList2.add(dBColumn);
        }
    }

    public static final DBColumn findExactlyOneColumn(String string, byte by, SearchColumnList searchColumnList, boolean bl) throws UnresolvedJoinException {
        DBColumn dBColumn = ADQLJoin.findAtMostOneColumn(string, by, searchColumnList, bl);
        if (dBColumn == null) {
            throw new UnresolvedJoinException("Column \"" + string + "\" specified in USING clause does not exist in " + (bl ? "left" : "right") + " table!");
        }
        return dBColumn;
    }

    public static final DBColumn findAtMostOneColumn(String string, byte by, SearchColumnList searchColumnList, boolean bl) throws UnresolvedJoinException {
        ArrayList<DBColumn> arrayList = searchColumnList.search(null, null, null, string, by);
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() > 1) {
            throw new UnresolvedJoinException("Common column name \"" + string + "\" appears more than once in " + (bl ? "left" : "right") + " table!");
        }
        return arrayList.get(0);
    }

    public static final boolean isCommonColumn(DBColumn dBColumn) {
        return dBColumn != null && dBColumn instanceof DBCommonColumn;
    }

    @Override
    public ArrayList<ADQLTable> getTables() {
        ArrayList<ADQLTable> arrayList = this.leftTable.getTables();
        arrayList.addAll(this.rightTable.getTables());
        return arrayList;
    }

    @Override
    public ArrayList<ADQLTable> getTablesByAlias(String string, boolean bl) {
        ArrayList<ADQLTable> arrayList = this.leftTable.getTablesByAlias(string, bl);
        arrayList.addAll(this.rightTable.getTablesByAlias(string, bl));
        return arrayList;
    }

    public abstract String getJoinType();

    @Override
    public abstract ADQLObject getCopy() throws Exception;
}

