/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.constraint.ADQLConstraint;
import java.util.NoSuchElementException;

public class NotConstraint
implements ADQLConstraint {
    private ADQLConstraint constraint;

    public NotConstraint(ADQLConstraint aDQLConstraint) throws NullPointerException {
        if (aDQLConstraint == null) {
            throw new NullPointerException("Impossible to apply the logical operator NOT on a NULL constraint !");
        }
        this.constraint = aDQLConstraint;
    }

    public final ADQLConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new NotConstraint((ADQLConstraint)this.constraint.getCopy());
    }

    @Override
    public String getName() {
        return "NOT " + this.constraint.getName();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean constraintGot;
            {
                this.constraintGot = NotConstraint.this.constraint == null;
            }

            @Override
            public ADQLObject next() {
                if (this.constraintGot) {
                    throw new NoSuchElementException();
                }
                this.constraintGot = true;
                return NotConstraint.this.constraint;
            }

            @Override
            public boolean hasNext() {
                return !this.constraintGot;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (!this.constraintGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else if (aDQLObject instanceof ADQLConstraint) {
                    NotConstraint.this.constraint = (ADQLConstraint)aDQLObject;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLConstraint by a " + aDQLObject.getClass().getName() + " !");
                }
            }

            @Override
            public void remove() {
                if (!this.constraintGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the constraint of a NOT predicated !");
            }
        };
    }

    @Override
    public String toADQL() {
        return "NOT " + this.constraint.toADQL();
    }
}

