/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.constraint.ADQLConstraint;
import java.util.NoSuchElementException;

public class Exists
implements ADQLConstraint {
    private ADQLQuery subQuery;

    public Exists(ADQLQuery aDQLQuery) {
        this.subQuery = aDQLQuery;
    }

    public Exists(Exists exists) throws Exception {
        this.subQuery = (ADQLQuery)exists.subQuery.getCopy();
    }

    public final ADQLQuery getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(ADQLQuery aDQLQuery) throws NullPointerException {
        if (aDQLQuery == null) {
            throw new NullPointerException("Impossible to build an EXISTS constraint with a sub-query NULL !");
        }
        this.subQuery = aDQLQuery;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new Exists(this);
    }

    @Override
    public String getName() {
        return "EXISTS";
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean subQueryGot;
            {
                this.subQueryGot = Exists.this.subQuery == null;
            }

            @Override
            public ADQLObject next() {
                if (this.subQueryGot) {
                    throw new NoSuchElementException();
                }
                this.subQueryGot = true;
                return Exists.this.subQuery;
            }

            @Override
            public boolean hasNext() {
                return !this.subQueryGot;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else if (aDQLObject instanceof ADQLQuery) {
                    Exists.this.subQuery = (ADQLQuery)aDQLObject;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLQuery by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                }
            }

            @Override
            public void remove() {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the sub-query of an EXISTS constraint !");
            }
        };
    }

    @Override
    public String toADQL() {
        return this.getName() + "(" + this.subQuery.toADQL() + ")";
    }
}

