/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.constraint.ADQLConstraint;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class Between
implements ADQLConstraint {
    private ADQLOperand leftOperand;
    private ADQLOperand minOperand;
    private ADQLOperand maxOperand;
    private boolean notBetween = false;

    public Between(ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3) throws NullPointerException {
        this(aDQLOperand, aDQLOperand2, aDQLOperand3, false);
    }

    public Between(ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3, boolean bl) throws NullPointerException {
        this.setLeftOperand(aDQLOperand);
        this.setMinOperand(aDQLOperand2);
        this.setMaxOperand(aDQLOperand3);
        this.setNotBetween(bl);
    }

    public Between(Between between) throws Exception {
        this.setLeftOperand((ADQLOperand)between.leftOperand.getCopy());
        this.setMinOperand((ADQLOperand)between.minOperand.getCopy());
        this.setMaxOperand((ADQLOperand)between.maxOperand.getCopy());
    }

    public final ADQLOperand getLeftOperand() {
        return this.leftOperand;
    }

    public void setLeftOperand(ADQLOperand aDQLOperand) throws NullPointerException {
        this.leftOperand = aDQLOperand;
    }

    public final ADQLOperand getMinOperand() {
        return this.minOperand;
    }

    public void setMinOperand(ADQLOperand aDQLOperand) throws NullPointerException {
        this.minOperand = aDQLOperand;
    }

    public final ADQLOperand getMaxOperand() {
        return this.maxOperand;
    }

    public void setMaxOperand(ADQLOperand aDQLOperand) throws NullPointerException {
        this.maxOperand = aDQLOperand;
    }

    public final boolean isNotBetween() {
        return this.notBetween;
    }

    public void setNotBetween(boolean bl) {
        this.notBetween = bl;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new Between(this);
    }

    @Override
    public String getName() {
        return (this.isNotBetween() ? "NOT " : "") + "BETWEEN";
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;

            @Override
            public ADQLObject next() {
                switch (++this.index) {
                    case 0: {
                        return Between.this.leftOperand;
                    }
                    case 1: {
                        return Between.this.minOperand;
                    }
                    case 2: {
                        return Between.this.maxOperand;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < 3;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (aDQLObject == null) {
                    this.remove();
                } else if (aDQLObject instanceof ADQLOperand) {
                    switch (this.index) {
                        case 0: {
                            Between.this.leftOperand = (ADQLOperand)aDQLObject;
                            break;
                        }
                        case 1: {
                            Between.this.minOperand = (ADQLOperand)aDQLObject;
                            break;
                        }
                        case 2: {
                            Between.this.maxOperand = (ADQLOperand)aDQLObject;
                        }
                    }
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLOperand by a " + aDQLObject.getClass().getName() + " (" + aDQLObject.toADQL() + ") !");
                }
            }

            @Override
            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove this operand from the BETWEEN constraint !");
            }
        };
    }

    @Override
    public String toADQL() {
        return this.leftOperand.toADQL() + " " + this.getName() + " " + this.minOperand.toADQL() + " AND " + this.maxOperand.toADQL();
    }
}

