/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.db.DBColumn;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.from.ADQLTable;

public class ColumnReference
implements ADQLObject {
    private TextPosition position = null;
    private int columnIndex = -1;
    private String columnName = null;
    private DBColumn dbLink = null;
    private ADQLTable adqlTable = null;
    private boolean caseSensitive = false;

    public ColumnReference(int n) throws ArrayIndexOutOfBoundsException {
        if (n <= 0) {
            throw new IndexOutOfBoundsException("Impossible to make a reference to the " + n + "th column: a column index must be greater or equal 1 !");
        }
        this.columnIndex = n;
        this.columnName = null;
    }

    public ColumnReference(String string) throws NullPointerException {
        if (!this.setColumnName(string)) {
            throw new NullPointerException("Impossible to make a reference: the given column name is null or is an empty string !");
        }
    }

    public ColumnReference(ColumnReference columnReference) {
        this.columnName = columnReference.columnName;
        this.caseSensitive = columnReference.caseSensitive;
        this.columnIndex = columnReference.columnIndex;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public void setPosition(TextPosition textPosition) {
        this.position = textPosition;
    }

    public final int getColumnIndex() {
        return this.columnIndex;
    }

    public final boolean setColumnIndex(int n) {
        if (n > 0) {
            this.columnName = null;
            this.columnIndex = n;
            return true;
        }
        return false;
    }

    public final boolean isIndex() {
        return this.columnName == null;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public final boolean setColumnName(String string) {
        if (string == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.trimToSize();
        if (stringBuffer.length() > 1 && stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(string.length() - 1) == '\"') {
            stringBuffer.deleteCharAt(0);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.trimToSize();
            if (stringBuffer.length() > 0) {
                this.caseSensitive = true;
            }
        }
        if (stringBuffer.length() == 0) {
            return false;
        }
        this.columnIndex = -1;
        this.columnName = stringBuffer.toString();
        return true;
    }

    public final boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public final void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public final DBColumn getDBLink() {
        return this.dbLink;
    }

    public final void setDBLink(DBColumn dBColumn) {
        this.dbLink = dBColumn;
    }

    public final ADQLTable getAdqlTable() {
        return this.adqlTable;
    }

    public final void setAdqlTable(ADQLTable aDQLTable) {
        this.adqlTable = aDQLTable;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ColumnReference(this);
    }

    @Override
    public String getName() {
        return this.isIndex() ? this.columnIndex + "" : this.columnName;
    }

    @Override
    public final ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    @Override
    public String toADQL() {
        return this.isIndex() ? "" + this.columnIndex : (this.isCaseSensitive() ? "\"" + this.columnName + "\"" : this.columnName);
    }
}

