/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLObject;
import adql.query.ClauseADQL;
import adql.query.constraint.ADQLConstraint;
import java.util.Vector;

public class ClauseConstraints
extends ClauseADQL<ADQLConstraint> {
    public static final String OR = "OR";
    public static final String AND = "AND";
    protected final String defaultSeparator;
    private Vector<String> vSeparators = new Vector();

    public ClauseConstraints(String string) {
        super(string);
        this.defaultSeparator = OR;
    }

    public ClauseConstraints(String string, String string2) {
        super(string);
        this.defaultSeparator = ClauseConstraints.checkSeparator(string2);
    }

    public ClauseConstraints(ClauseConstraints clauseConstraints) throws Exception {
        super(clauseConstraints);
        this.defaultSeparator = ClauseConstraints.checkSeparator(clauseConstraints.defaultSeparator);
    }

    public final String getDefaultSeparator() {
        return this.defaultSeparator;
    }

    public static final String checkSeparator(String string) {
        if (string != null && string.equalsIgnoreCase(AND)) {
            return AND;
        }
        return OR;
    }

    @Override
    public boolean add(ADQLConstraint aDQLConstraint) throws NullPointerException {
        return this.add(this.defaultSeparator, aDQLConstraint);
    }

    @Override
    public void add(int n, ADQLConstraint aDQLConstraint) throws NullPointerException, ArrayIndexOutOfBoundsException {
        this.add(n, this.defaultSeparator, aDQLConstraint);
    }

    public boolean add(String string, ADQLConstraint aDQLConstraint) throws NullPointerException {
        boolean bl = super.add(aDQLConstraint);
        if (bl && this.size() > 1) {
            this.vSeparators.add(ClauseConstraints.checkSeparator(string));
        }
        return bl;
    }

    public void add(int n, String string, ADQLConstraint aDQLConstraint) throws NullPointerException, ArrayIndexOutOfBoundsException {
        super.add(n, aDQLConstraint);
        if (n > 0) {
            this.vSeparators.add(n - 1, ClauseConstraints.checkSeparator(string));
        }
    }

    @Override
    public ADQLConstraint set(int n, ADQLConstraint aDQLConstraint) throws NullPointerException, ArrayIndexOutOfBoundsException {
        return this.set(n, null, aDQLConstraint);
    }

    public ADQLConstraint set(int n, String string, ADQLConstraint aDQLConstraint) throws NullPointerException, ArrayIndexOutOfBoundsException {
        ADQLConstraint aDQLConstraint2 = super.set(n, aDQLConstraint);
        if (aDQLConstraint2 != null && string != null && n > 0) {
            this.vSeparators.set(n - 1, string);
        }
        return aDQLConstraint2;
    }

    @Override
    public void clear() {
        super.clear();
        this.vSeparators.clear();
    }

    @Override
    public ADQLConstraint remove(int n) throws ArrayIndexOutOfBoundsException {
        ADQLConstraint aDQLConstraint = (ADQLConstraint)super.remove(n);
        if (aDQLConstraint != null) {
            if (n > 0) {
                this.vSeparators.remove(n - 1);
            } else if (n == 0) {
                this.vSeparators.remove(n);
            }
        }
        return aDQLConstraint;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ClauseConstraints(this);
    }

    @Override
    public String[] getPossibleSeparators() {
        return new String[]{AND, OR};
    }

    @Override
    public String getSeparator(int n) throws ArrayIndexOutOfBoundsException {
        if (n <= 0 || n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Impossible to get the logical separator between the item " + (n - 1) + " and " + n + " !");
        }
        return this.vSeparators.get(n - 1);
    }
}

