/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.parser.IdentifierItems;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ClauseConstraints;
import adql.query.ColumnReference;
import adql.query.IdentifierField;
import adql.query.SelectItem;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.Between;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.constraint.ConstraintsGroup;
import adql.query.constraint.Exists;
import adql.query.constraint.In;
import adql.query.constraint.IsNull;
import adql.query.constraint.NotConstraint;
import adql.query.from.ADQLJoin;
import adql.query.from.ADQLTable;
import adql.query.from.CrossJoin;
import adql.query.from.FromContent;
import adql.query.from.InnerJoin;
import adql.query.from.OuterJoin;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.NegativeOperand;
import adql.query.operand.NumericConstant;
import adql.query.operand.Operation;
import adql.query.operand.OperationType;
import adql.query.operand.StringConstant;
import adql.query.operand.WrappedOperand;
import adql.query.operand.function.DefaultUDF;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.MathFunctionType;
import adql.query.operand.function.SQLFunction;
import adql.query.operand.function.SQLFunctionType;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import java.util.Collection;

public class ADQLQueryFactory {
    public ADQLQuery createQuery() throws Exception {
        return new ADQLQuery();
    }

    public ADQLTable createTable(IdentifierItems identifierItems, IdentifierItems.IdentifierItem identifierItem) throws Exception {
        ADQLTable aDQLTable = new ADQLTable(identifierItems.getCatalog(), identifierItems.getSchema(), identifierItems.getTable());
        if (identifierItem != null) {
            aDQLTable.setAlias(identifierItem.identifier);
        }
        byte by = identifierItems.getCaseSensitivity();
        if (identifierItem != null) {
            by = IdentifierField.ALIAS.setCaseSensitive(by, identifierItem.caseSensitivity);
        }
        aDQLTable.setCaseSensitive(by);
        aDQLTable.setPosition(identifierItems.getPosition());
        return aDQLTable;
    }

    public ADQLTable createTable(ADQLQuery aDQLQuery, IdentifierItems.IdentifierItem identifierItem) throws Exception {
        ADQLTable aDQLTable = new ADQLTable(aDQLQuery);
        if (identifierItem != null) {
            aDQLTable.setAlias(identifierItem.identifier);
            aDQLTable.setCaseSensitive(IdentifierField.ALIAS, identifierItem.caseSensitivity);
        }
        return aDQLTable;
    }

    public ADQLJoin createJoin(JoinType joinType, FromContent fromContent, FromContent fromContent2) throws Exception {
        switch (joinType) {
            case CROSS: {
                return new CrossJoin(fromContent, fromContent2);
            }
            case INNER: {
                return new InnerJoin(fromContent, fromContent2);
            }
            case OUTER_LEFT: {
                return new OuterJoin(fromContent, fromContent2, OuterJoin.OuterType.LEFT);
            }
            case OUTER_RIGHT: {
                return new OuterJoin(fromContent, fromContent2, OuterJoin.OuterType.RIGHT);
            }
            case OUTER_FULL: {
                return new OuterJoin(fromContent, fromContent2, OuterJoin.OuterType.FULL);
            }
        }
        throw new Exception("Unknown join type: " + (Object)((Object)joinType));
    }

    public ADQLJoin createJoin(JoinType joinType, FromContent fromContent, FromContent fromContent2, ClauseConstraints clauseConstraints) throws Exception {
        switch (joinType) {
            case CROSS: {
                throw new Exception("A cross join must have no condition (that's to say: no part ON) !");
            }
        }
        ADQLJoin aDQLJoin = this.createJoin(joinType, fromContent, fromContent2);
        aDQLJoin.setJoinCondition(clauseConstraints);
        return aDQLJoin;
    }

    public ADQLJoin createJoin(JoinType joinType, FromContent fromContent, FromContent fromContent2, Collection<ADQLColumn> collection) throws Exception {
        switch (joinType) {
            case CROSS: {
                throw new Exception("A cross join must have no columns list (that's to say: no part USING) !");
            }
        }
        ADQLJoin aDQLJoin = this.createJoin(joinType, fromContent, fromContent2);
        aDQLJoin.setJoinedColumns(collection);
        return aDQLJoin;
    }

    public SelectItem createSelectItem(ADQLOperand aDQLOperand, String string) throws Exception {
        return new SelectItem(aDQLOperand, string);
    }

    public ADQLColumn createColumn(IdentifierItems identifierItems) throws Exception {
        ADQLColumn aDQLColumn = new ADQLColumn(identifierItems.getCatalog(), identifierItems.getSchema(), identifierItems.getTable(), identifierItems.getColumn());
        aDQLColumn.setCaseSensitive(identifierItems.getCaseSensitivity());
        aDQLColumn.setPosition(identifierItems.getPosition());
        return aDQLColumn;
    }

    public ADQLColumn createColumn(IdentifierItems.IdentifierItem identifierItem) throws Exception {
        ADQLColumn aDQLColumn = new ADQLColumn(null, null, null, identifierItem.identifier);
        aDQLColumn.setCaseSensitive(IdentifierField.COLUMN, identifierItem.caseSensitivity);
        aDQLColumn.setPosition(identifierItem.position);
        return aDQLColumn;
    }

    public NumericConstant createNumericConstant(String string) throws Exception {
        return new NumericConstant(string, true);
    }

    public StringConstant createStringConstant(String string) throws Exception {
        return new StringConstant(string);
    }

    public Operation createOperation(ADQLOperand aDQLOperand, OperationType operationType, ADQLOperand aDQLOperand2) throws Exception {
        return new Operation(aDQLOperand, operationType, aDQLOperand2);
    }

    public NegativeOperand createNegativeOperand(ADQLOperand aDQLOperand) throws Exception {
        return new NegativeOperand(aDQLOperand);
    }

    public Concatenation createConcatenation() throws Exception {
        return new Concatenation();
    }

    public WrappedOperand createWrappedOperand(ADQLOperand aDQLOperand) throws Exception {
        return new WrappedOperand(aDQLOperand);
    }

    public ConstraintsGroup createGroupOfConstraints() throws Exception {
        return new ConstraintsGroup();
    }

    public NotConstraint createNot(ADQLConstraint aDQLConstraint) throws Exception {
        return new NotConstraint(aDQLConstraint);
    }

    public Comparison createComparison(ADQLOperand aDQLOperand, ComparisonOperator comparisonOperator, ADQLOperand aDQLOperand2) throws Exception {
        return new Comparison(aDQLOperand, comparisonOperator, aDQLOperand2);
    }

    public Between createBetween(boolean bl, ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3) throws Exception {
        return new Between(aDQLOperand, aDQLOperand2, aDQLOperand3, bl);
    }

    public IsNull createIsNull(boolean bl, ADQLColumn aDQLColumn) throws Exception {
        return new IsNull(aDQLColumn, bl);
    }

    public Exists createExists(ADQLQuery aDQLQuery) throws Exception {
        return new Exists(aDQLQuery);
    }

    public In createIn(ADQLOperand aDQLOperand, ADQLQuery aDQLQuery, boolean bl) throws Exception {
        return new In(aDQLOperand, aDQLQuery, bl);
    }

    public In createIn(ADQLOperand aDQLOperand, ADQLOperand[] aDQLOperandArray, boolean bl) throws Exception {
        return new In(aDQLOperand, aDQLOperandArray, bl);
    }

    public SQLFunction createSQLFunction(SQLFunctionType sQLFunctionType, ADQLOperand aDQLOperand, boolean bl) throws Exception {
        return new SQLFunction(sQLFunctionType, aDQLOperand, bl);
    }

    public MathFunction createMathFunction(MathFunctionType mathFunctionType, ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2) throws Exception {
        return new MathFunction(mathFunctionType, aDQLOperand, aDQLOperand2);
    }

    public UserDefinedFunction createUserDefinedFunction(String string, ADQLOperand[] aDQLOperandArray) throws Exception {
        return new DefaultUDF(string, aDQLOperandArray);
    }

    public DistanceFunction createDistance(PointFunction pointFunction, PointFunction pointFunction2) throws Exception {
        return new DistanceFunction(new GeometryFunction.GeometryValue<PointFunction>(pointFunction), new GeometryFunction.GeometryValue<PointFunction>(pointFunction2));
    }

    public DistanceFunction createDistance(GeometryFunction.GeometryValue<PointFunction> geometryValue, GeometryFunction.GeometryValue<PointFunction> geometryValue2) throws Exception {
        return new DistanceFunction(geometryValue, geometryValue2);
    }

    public PointFunction createPoint(ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3) throws Exception {
        return new PointFunction(aDQLOperand, aDQLOperand2, aDQLOperand3);
    }

    public BoxFunction createBox(ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3, ADQLOperand aDQLOperand4, ADQLOperand aDQLOperand5) throws Exception {
        return new BoxFunction(aDQLOperand, aDQLOperand2, aDQLOperand3, aDQLOperand4, aDQLOperand5);
    }

    public CircleFunction createCircle(ADQLOperand aDQLOperand, ADQLOperand aDQLOperand2, ADQLOperand aDQLOperand3, ADQLOperand aDQLOperand4) throws Exception {
        return new CircleFunction(aDQLOperand, aDQLOperand2, aDQLOperand3, aDQLOperand4);
    }

    public CentroidFunction createCentroid(GeometryFunction geometryFunction) throws Exception {
        return new CentroidFunction(new GeometryFunction.GeometryValue<GeometryFunction>(geometryFunction));
    }

    public CentroidFunction createCentroid(GeometryFunction.GeometryValue<GeometryFunction> geometryValue) throws Exception {
        return new CentroidFunction(geometryValue);
    }

    public RegionFunction createRegion(ADQLOperand aDQLOperand) throws Exception {
        return new RegionFunction(aDQLOperand);
    }

    public PolygonFunction createPolygon(ADQLOperand aDQLOperand, Collection<? extends ADQLOperand> collection) throws Exception {
        return new PolygonFunction(aDQLOperand, collection);
    }

    public AreaFunction createArea(GeometryFunction geometryFunction) throws Exception {
        return new AreaFunction(new GeometryFunction.GeometryValue<GeometryFunction>(geometryFunction));
    }

    public AreaFunction createArea(GeometryFunction.GeometryValue<GeometryFunction> geometryValue) throws Exception {
        return new AreaFunction(geometryValue);
    }

    public ExtractCoord createCoord1(PointFunction pointFunction) throws Exception {
        return new ExtractCoord(1, new GeometryFunction.GeometryValue<PointFunction>(pointFunction));
    }

    public ExtractCoord createCoord1(ADQLColumn aDQLColumn) throws Exception {
        return new ExtractCoord(1, new GeometryFunction.GeometryValue<ADQLColumn>(aDQLColumn));
    }

    public ExtractCoord createCoord2(PointFunction pointFunction) throws Exception {
        return new ExtractCoord(2, new GeometryFunction.GeometryValue<PointFunction>(pointFunction));
    }

    public ExtractCoord createCoord2(ADQLColumn aDQLColumn) throws Exception {
        return new ExtractCoord(2, new GeometryFunction.GeometryValue<ADQLColumn>(aDQLColumn));
    }

    public ExtractCoordSys createExtractCoordSys(GeometryFunction geometryFunction) throws Exception {
        return new ExtractCoordSys(new GeometryFunction.GeometryValue<GeometryFunction>(geometryFunction));
    }

    public ExtractCoordSys createExtractCoordSys(ADQLColumn aDQLColumn) throws Exception {
        return new ExtractCoordSys(new GeometryFunction.GeometryValue<ADQLColumn>(aDQLColumn));
    }

    public ExtractCoordSys createExtractCoordSys(GeometryFunction.GeometryValue<GeometryFunction> geometryValue) throws Exception {
        return new ExtractCoordSys(new GeometryFunction.GeometryValue<GeometryFunction>(geometryValue));
    }

    public ContainsFunction createContains(GeometryFunction geometryFunction, GeometryFunction geometryFunction2) throws Exception {
        return new ContainsFunction(new GeometryFunction.GeometryValue<GeometryFunction>(geometryFunction), new GeometryFunction.GeometryValue<GeometryFunction>(geometryFunction2));
    }

    public ContainsFunction createContains(GeometryFunction.GeometryValue<GeometryFunction> geometryValue, GeometryFunction.GeometryValue<GeometryFunction> geometryValue2) throws Exception {
        return new ContainsFunction(geometryValue, geometryValue2);
    }

    public IntersectsFunction createIntersects(GeometryFunction geometryFunction, GeometryFunction geometryFunction2) throws Exception {
        return new IntersectsFunction(new GeometryFunction.GeometryValue<GeometryFunction>(geometryFunction), new GeometryFunction.GeometryValue<GeometryFunction>(geometryFunction2));
    }

    public IntersectsFunction createIntersects(GeometryFunction.GeometryValue<GeometryFunction> geometryValue, GeometryFunction.GeometryValue<GeometryFunction> geometryValue2) throws Exception {
        return new IntersectsFunction(geometryValue, geometryValue2);
    }

    public ADQLOrder createOrder(int n, boolean bl, TextPosition textPosition) throws Exception {
        ADQLOrder aDQLOrder = new ADQLOrder(n, bl);
        if (aDQLOrder != null) {
            aDQLOrder.setPosition(textPosition);
        }
        return aDQLOrder;
    }

    public ADQLOrder createOrder(IdentifierItems identifierItems, boolean bl) throws Exception {
        ADQLOrder aDQLOrder = new ADQLOrder(identifierItems.join("."), bl);
        if (aDQLOrder != null) {
            aDQLOrder.setPosition(identifierItems.getPosition());
            aDQLOrder.setCaseSensitive(identifierItems.getColumnCaseSensitivity());
        }
        return aDQLOrder;
    }

    public ColumnReference createColRef(IdentifierItems identifierItems) throws Exception {
        ColumnReference columnReference = new ColumnReference(identifierItems.join("."));
        if (columnReference != null) {
            columnReference.setPosition(identifierItems.getPosition());
            columnReference.setCaseSensitive(identifierItems.getColumnCaseSensitivity());
        }
        return columnReference;
    }

    public ColumnReference createColRef(int n, TextPosition textPosition) throws Exception {
        ColumnReference columnReference = new ColumnReference(n);
        if (columnReference != null) {
            columnReference.setPosition(textPosition);
        }
        return columnReference;
    }

    public static enum JoinType {
        CROSS,
        INNER,
        OUTER_LEFT,
        OUTER_RIGHT,
        OUTER_FULL;

    }
}

