/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.db.exception.UnresolvedIdentifiersException;
import adql.parser.ADQLParserConstants;
import adql.parser.ADQLParserTokenManager;
import adql.parser.ADQLQueryFactory;
import adql.parser.IdentifierItems;
import adql.parser.ParseException;
import adql.parser.QueryChecker;
import adql.parser.SimpleCharStream;
import adql.parser.Token;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseSelect;
import adql.query.ColumnReference;
import adql.query.SelectAllColumns;
import adql.query.SelectItem;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.Between;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.constraint.ConstraintsGroup;
import adql.query.constraint.In;
import adql.query.from.ADQLJoin;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.Concatenation;
import adql.query.operand.OperationType;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.MathFunctionType;
import adql.query.operand.function.SQLFunction;
import adql.query.operand.function.SQLFunctionType;
import adql.query.operand.function.UserDefinedFunction;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.translator.PostgreSQLTranslator;
import adql.translator.TranslationException;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class ADQLParser
implements ADQLParserConstants {
    private ADQLQueryFactory queryFactory = new ADQLQueryFactory();
    private Stack<ADQLQuery> stackQuery = new Stack();
    private ADQLQuery query = null;
    private QueryChecker queryChecker = null;
    private Token currentIdentifierToken = null;
    public ADQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[98];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[16];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ADQLParser() {
        this(new ByteArrayInputStream("".getBytes()));
    }

    public ADQLParser(QueryChecker queryChecker, ADQLQueryFactory aDQLQueryFactory) {
        this();
        this.queryChecker = queryChecker;
        if (aDQLQueryFactory != null) {
            this.queryFactory = aDQLQueryFactory;
        }
    }

    public ADQLParser(QueryChecker queryChecker) {
        this(queryChecker, null);
    }

    public ADQLParser(ADQLQueryFactory aDQLQueryFactory) {
        this((QueryChecker)null, aDQLQueryFactory);
    }

    public ADQLParser(InputStream inputStream, QueryChecker queryChecker, ADQLQueryFactory aDQLQueryFactory) {
        this(inputStream);
        this.queryChecker = queryChecker;
        if (aDQLQueryFactory != null) {
            this.queryFactory = aDQLQueryFactory;
        }
    }

    public ADQLParser(InputStream inputStream, QueryChecker queryChecker) {
        this(inputStream, queryChecker, null);
    }

    public ADQLParser(InputStream inputStream, ADQLQueryFactory aDQLQueryFactory) {
        this(inputStream, (QueryChecker)null, aDQLQueryFactory);
    }

    public ADQLParser(InputStream inputStream, String string, QueryChecker queryChecker, ADQLQueryFactory aDQLQueryFactory) {
        this(inputStream, string);
        this.queryChecker = queryChecker;
        if (aDQLQueryFactory != null) {
            this.queryFactory = aDQLQueryFactory;
        }
    }

    public ADQLParser(InputStream inputStream, String string, QueryChecker queryChecker) {
        this(inputStream, string, queryChecker, null);
    }

    public ADQLParser(InputStream inputStream, String string, ADQLQueryFactory aDQLQueryFactory) {
        this(inputStream, string, null, aDQLQueryFactory);
    }

    public ADQLParser(Reader reader, QueryChecker queryChecker, ADQLQueryFactory aDQLQueryFactory) {
        this(reader);
        this.queryChecker = queryChecker;
        if (aDQLQueryFactory != null) {
            this.queryFactory = aDQLQueryFactory;
        }
    }

    public ADQLParser(Reader reader, QueryChecker queryChecker) {
        this(reader, queryChecker, null);
    }

    public ADQLParser(Reader reader, ADQLQueryFactory aDQLQueryFactory) {
        this(reader, null, aDQLQueryFactory);
    }

    public ADQLParser(ADQLParserTokenManager aDQLParserTokenManager, QueryChecker queryChecker, ADQLQueryFactory aDQLQueryFactory) {
        this(aDQLParserTokenManager);
        this.queryChecker = queryChecker;
        if (aDQLQueryFactory != null) {
            this.queryFactory = aDQLQueryFactory;
        }
    }

    public ADQLParser(ADQLParserTokenManager aDQLParserTokenManager, QueryChecker queryChecker) {
        this(aDQLParserTokenManager, queryChecker, null);
    }

    public ADQLParser(ADQLParserTokenManager aDQLParserTokenManager, ADQLQueryFactory aDQLQueryFactory) {
        this(aDQLParserTokenManager, null, aDQLQueryFactory);
    }

    public final ADQLQuery parseQuery() throws ParseException {
        this.stackQuery.clear();
        this.query = null;
        return this.Query();
    }

    public final ADQLQuery parseQuery(String string) throws ParseException {
        this.stackQuery.clear();
        this.query = null;
        this.ReInit(new ByteArrayInputStream(string.getBytes()));
        return this.Query();
    }

    public final ADQLQuery parseQuery(InputStream inputStream) throws ParseException {
        this.stackQuery.clear();
        this.query = null;
        this.ReInit(inputStream);
        return this.Query();
    }

    public final void setDebug(boolean bl) {
        if (bl) {
            this.enable_tracing();
        } else {
            this.disable_tracing();
        }
    }

    public final QueryChecker getQueryChecker() {
        return this.queryChecker;
    }

    public final void setQueryChecker(QueryChecker queryChecker) {
        this.queryChecker = queryChecker;
    }

    public final ADQLQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public final void setQueryFactory(ADQLQueryFactory aDQLQueryFactory) {
        this.queryFactory = aDQLQueryFactory != null ? aDQLQueryFactory : new ADQLQueryFactory();
    }

    private final ParseException generateParseException(Exception exception) {
        if (!(exception instanceof ParseException)) {
            ParseException parseException = new ParseException("[" + exception.getClass().getName() + "] " + exception.getMessage());
            parseException.setStackTrace(exception.getStackTrace());
            return parseException;
        }
        return (ParseException)exception;
    }

    public static final void main(String[] stringArray) throws Exception {
        String string = null;
        Object var5_2 = null;
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-d") || stringArray[i].equalsIgnoreCase("--debug")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-v") || stringArray[i].equalsIgnoreCase("--verbose")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-e") || stringArray[i].equalsIgnoreCase("--explain")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-a") || stringArray[i].equalsIgnoreCase("--adql")) {
                if (n != -1) {
                    System.err.println("((!)) Too much parameter: you must choose between -s, -c, -a or nothing ((!))\nUsage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).");
                    System.exit(1);
                    continue;
                }
                n = 1;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-s") || stringArray[i].equalsIgnoreCase("--sql")) {
                if (n != -1) {
                    System.err.println("((!)) Too much parameter: you must choose between -s, -c, -a or nothing ((!))\nUsage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).");
                    System.exit(1);
                    continue;
                }
                n = 2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-h") || stringArray[i].equalsIgnoreCase("--help")) {
                System.out.println("Usage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).");
                System.exit(0);
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                System.err.println("((!)) Unknown parameter: \"" + stringArray[i] + "\" ((!))\n" + "Usage:\n\tadqlParser.jar [-d] [-v] [-e] [-a|-s] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard input. This query must end with a ';' !\n\nParameters:\n\t-v or --verbose : Print the main steps of the parsing\n\t-d or --debug   : Print stack traces when a grave error occurs\n\t-e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n\t-a or --adql    : Display the understood ADQL query\n\t-s or --sql     : Ask the SQL translation of the given ADQL query (SQL compatible with PostgreSQL)\n\nReturn:\n\tBy default: nothing if the query is correct. Otherwise a message explaining why the query is not correct is displayed.\n\tWith the -s option, the SQL translation of the given ADQL query will be returned.\n\tWith the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n\t0\tOK !\n\t1\tParameter error (missing or incorrect parameter)\n\t2\tFile error (incorrect file/url, reading error, ...)\n\t3\tParsing error (syntactic or semantic error)\n\t4\tTranslation error (a problem has occurred during the translation of the given ADQL query in SQL).");
                System.exit(1);
                continue;
            }
            string = stringArray[i].trim();
        }
        try {
            ADQLParser aDQLParser = string == null || string.isEmpty() ? new ADQLParser(System.in) : (string.matches("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]") ? new ADQLParser(new URL(string).openStream()) : new ADQLParser(new FileReader(string)));
            aDQLParser.setDebug(bl3);
            try {
                if (bl) {
                    System.out.print("((i)) Parsing ADQL query...");
                }
                ADQLQuery aDQLQuery = aDQLParser.parseQuery();
                if (bl) {
                    System.out.println("((i)) CORRECT ADQL QUERY ((i))");
                }
                if (n == 2) {
                    PostgreSQLTranslator postgreSQLTranslator = new PostgreSQLTranslator();
                    if (bl) {
                        System.out.print("((i)) Translating in SQL...");
                    }
                    String string2 = postgreSQLTranslator.translate(aDQLQuery);
                    if (bl) {
                        System.out.println("ok");
                    }
                    System.out.println(string2);
                } else if (n == 1) {
                    System.out.println(aDQLQuery.toADQL());
                }
            }
            catch (UnresolvedIdentifiersException unresolvedIdentifiersException) {
                System.err.println("((X)) " + unresolvedIdentifiersException.getNbErrors() + " unresolved identifiers:");
                for (ParseException parseException : unresolvedIdentifiersException) {
                    System.err.println("\t - at " + parseException.getPosition() + ": " + unresolvedIdentifiersException.getMessage());
                }
                if (bl2) {
                    unresolvedIdentifiersException.printStackTrace(System.err);
                }
                System.exit(3);
            }
            catch (ParseException parseException) {
                System.err.println("((X)) Syntax error: " + parseException.getMessage() + " ((X))");
                if (bl2) {
                    parseException.printStackTrace(System.err);
                }
                System.exit(3);
            }
            catch (TranslationException translationException) {
                if (bl) {
                    System.out.println("error");
                }
                System.err.println("((X)) Translation error: " + translationException.getMessage() + " ((X))");
                if (bl2) {
                    translationException.printStackTrace(System.err);
                }
                System.exit(4);
            }
        }
        catch (IOException iOException) {
            System.err.println("\n((X)) Error while reading the file \"" + string + "\": " + iOException.getMessage() + " ((X))");
            if (bl2) {
                iOException.printStackTrace(System.err);
            }
            System.exit(2);
        }
    }

    public final ADQLQuery Query() throws ParseException {
        ADQLQuery aDQLQuery = null;
        aDQLQuery = this.QueryExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.queryChecker != null) {
            this.queryChecker.check(aDQLQuery);
        }
        return aDQLQuery;
    }

    public final ADQLQuery QueryExpression() throws ParseException {
        try {
            this.query = this.queryFactory.createQuery();
            this.stackQuery.push(this.query);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
        this.Select();
        this.From();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.Where();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.GroupBy();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.Having();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.OrderBy();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        ADQLQuery aDQLQuery = this.stackQuery.pop();
        this.query = this.stackQuery.isEmpty() ? null : this.stackQuery.peek();
        return aDQLQuery;
    }

    public final ADQLQuery SubQueryExpression() throws ParseException {
        ADQLQuery aDQLQuery = null;
        this.jj_consume_token(2);
        aDQLQuery = this.QueryExpression();
        this.jj_consume_token(3);
        return aDQLQuery;
    }

    public final void Select() throws ParseException {
        ClauseSelect clauseSelect = this.query.getSelect();
        SelectItem selectItem = null;
        Token token = null;
        this.jj_consume_token(18);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                token = this.jj_consume_token(19);
                clauseSelect.setDistinctColumns(token.image.equalsIgnoreCase("DISTINCT"));
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                token = this.jj_consume_token(101);
                try {
                    clauseSelect.setLimit(Integer.parseInt(token.image));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("[l." + token.beginLine + ";c." + token.beginColumn + "] The TOP limit (\"" + token.image + "\") isn't a regular unsigned integer !");
                }
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        selectItem = this.SelectItem();
        clauseSelect.add(selectItem);
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block11;
                }
            }
            this.jj_consume_token(5);
            selectItem = this.SelectItem();
            clauseSelect.add(selectItem);
        }
    }

    public final SelectItem SelectItem() throws ParseException {
        IdentifierItems identifierItems = new IdentifierItems(true);
        IdentifierItems.IdentifierItem identifierItem = null;
        IdentifierItems.IdentifierItem identifierItem2 = null;
        ADQLOperand aDQLOperand = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                return new SelectAllColumns(this.query);
            }
        }
        this.jj_la1[11] = this.jj_gen;
        if (this.jj_2_1(7)) {
            identifierItem = this.Identifier();
            this.jj_consume_token(4);
            identifierItems.append(identifierItem);
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 96: 
                case 97: {
                    identifierItem = this.Identifier();
                    this.jj_consume_token(4);
                    identifierItems.append(identifierItem);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 96: 
                        case 97: {
                            identifierItem = this.Identifier();
                            this.jj_consume_token(4);
                            identifierItems.append(identifierItem);
                            break block5;
                        }
                    }
                    this.jj_la1[8] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                }
            }
            this.jj_consume_token(10);
            try {
                return new SelectAllColumns(this.queryFactory.createTable(identifierItems, null));
            }
            catch (Exception exception) {
                throw this.generateParseException(exception);
            }
        }
        block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 8: 
            case 9: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 93: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: {
                aDQLOperand = this.ValueExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        identifierItem2 = this.Identifier();
                        break block11;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            SelectItem selectItem = this.queryFactory.createSelectItem(aDQLOperand, identifierItem2 == null ? null : identifierItem2.identifier);
            if (identifierItem2 != null) {
                selectItem.setCaseSensitive(identifierItem2.caseSensitivity);
            }
            return selectItem;
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final void From() throws ParseException {
        FromContent fromContent = null;
        FromContent fromContent2 = null;
        try {
            this.jj_consume_token(21);
            fromContent = this.TableRef();
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block5;
                    }
                }
                this.jj_consume_token(5);
                fromContent2 = this.TableRef();
                fromContent = this.queryFactory.createJoin(ADQLQueryFactory.JoinType.CROSS, fromContent, fromContent2);
            }
            this.query.setFrom(fromContent);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final void Where() throws ParseException {
        ClauseConstraints clauseConstraints = this.query.getWhere();
        this.jj_consume_token(32);
        this.ConditionsList(clauseConstraints);
    }

    public final void GroupBy() throws ParseException {
        ClauseADQL<ColumnReference> clauseADQL = this.query.getGroupBy();
        ColumnReference columnReference = null;
        this.jj_consume_token(42);
        columnReference = this.ColumnRef();
        clauseADQL.add(columnReference);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
            columnReference = this.ColumnRef();
            clauseADQL.add(columnReference);
        }
    }

    public final void Having() throws ParseException {
        ClauseConstraints clauseConstraints = this.query.getHaving();
        this.jj_consume_token(43);
        this.ConditionsList(clauseConstraints);
    }

    public final void OrderBy() throws ParseException {
        ClauseADQL<ADQLOrder> clauseADQL = this.query.getOrderBy();
        ADQLOrder aDQLOrder = null;
        this.jj_consume_token(44);
        aDQLOrder = this.OrderItem();
        clauseADQL.add(aDQLOrder);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
            aDQLOrder = this.OrderItem();
            clauseADQL.add(aDQLOrder);
        }
    }

    public final IdentifierItems.IdentifierItem Identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 97: {
                Token token = this.jj_consume_token(97);
                return new IdentifierItems.IdentifierItem(token, false);
            }
            case 96: {
                Token token = this.jj_consume_token(96);
                return new IdentifierItems.IdentifierItem(token, true);
            }
        }
        this.jj_la1[16] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final IdentifierItems TableName() throws ParseException {
        IdentifierItems identifierItems = new IdentifierItems(true);
        IdentifierItems.IdentifierItem identifierItem = null;
        identifierItem = this.Identifier();
        identifierItems.append(identifierItem);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                identifierItem = this.Identifier();
                identifierItems.append(identifierItem);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                identifierItem = this.Identifier();
                identifierItems.append(identifierItem);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        return identifierItems;
    }

    public final IdentifierItems ColumnName() throws ParseException {
        IdentifierItems identifierItems = null;
        IdentifierItems identifierItems2 = new IdentifierItems(false);
        IdentifierItems.IdentifierItem identifierItem = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                identifierItems = this.TableName();
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        identifierItems2.append(identifierItem);
        if (identifierItems != null) {
            for (int i = 0; i < identifierItems.size(); ++i) {
                identifierItems2.append(identifierItems.get(i));
            }
        }
        return identifierItems2;
    }

    public final ADQLColumn Column() throws ParseException {
        IdentifierItems identifierItems = this.ColumnName();
        try {
            return this.queryFactory.createColumn(identifierItems);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final ColumnReference ColumnRef() throws ParseException {
        IdentifierItems identifierItems = null;
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: {
                identifierItems = this.ColumnName();
                break;
            }
            case 101: {
                token = this.jj_consume_token(101);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            ColumnReference columnReference = null;
            columnReference = identifierItems != null ? this.queryFactory.createColRef(identifierItems) : this.queryFactory.createColRef(Integer.parseInt(token.image), new TextPosition(token));
            return columnReference;
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final ADQLOrder OrderItem() throws ParseException {
        IdentifierItems identifierItems = null;
        Token token = null;
        Token token2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: {
                identifierItems = this.ColumnName();
                break;
            }
            case 101: {
                token = this.jj_consume_token(101);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: 
            case 46: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 45: {
                        this.jj_consume_token(45);
                        break block5;
                    }
                    case 46: {
                        token2 = this.jj_consume_token(46);
                        break block5;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        try {
            ADQLOrder aDQLOrder = null;
            aDQLOrder = identifierItems != null ? this.queryFactory.createOrder(identifierItems, token2 != null) : this.queryFactory.createOrder(Integer.parseInt(token.image), token2 != null, new TextPosition(token));
            return aDQLOrder;
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final FromContent SimpleTableRef() throws ParseException {
        IdentifierItems.IdentifierItem identifierItem = null;
        IdentifierItems identifierItems = null;
        ADQLQuery aDQLQuery = null;
        FromContent fromContent = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 96: 
                case 97: {
                    identifierItems = this.TableName();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: 
                        case 96: 
                        case 97: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 22: {
                                    this.jj_consume_token(22);
                                    break;
                                }
                                default: {
                                    this.jj_la1[24] = this.jj_gen;
                                }
                            }
                            identifierItem = this.Identifier();
                            break;
                        }
                        default: {
                            this.jj_la1[25] = this.jj_gen;
                        }
                    }
                    return this.queryFactory.createTable(identifierItems, identifierItem);
                }
            }
            this.jj_la1[27] = this.jj_gen;
            if (this.jj_2_2(2)) {
                aDQLQuery = this.SubQueryExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                identifierItem = this.Identifier();
                return this.queryFactory.createTable(aDQLQuery, identifierItem);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    this.jj_consume_token(2);
                    fromContent = this.JoinedTable();
                    this.jj_consume_token(3);
                    return fromContent;
                }
            }
            this.jj_la1[28] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final FromContent TableRef() throws ParseException {
        FromContent fromContent = this.SimpleTableRef();
        while (this.jj_2_3(2)) {
            fromContent = this.JoinSpecification(fromContent);
        }
        return fromContent;
    }

    public final FromContent JoinedTable() throws ParseException {
        FromContent fromContent = this.SimpleTableRef();
        block3: while (true) {
            fromContent = this.JoinSpecification(fromContent);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[29] = this.jj_gen;
        return fromContent;
    }

    public final ADQLJoin JoinSpecification(FromContent fromContent) throws ParseException {
        boolean bl = false;
        ADQLQueryFactory.JoinType joinType = ADQLQueryFactory.JoinType.INNER;
        ClauseConstraints clauseConstraints = new ClauseConstraints("ON");
        ArrayList<ADQLColumn> arrayList = new ArrayList<ADQLColumn>();
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    this.jj_consume_token(23);
                    bl = true;
                    block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: 
                        case 26: 
                        case 27: 
                        case 28: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 24: {
                                    this.jj_consume_token(24);
                                    break block5;
                                }
                                case 26: 
                                case 27: 
                                case 28: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 27: {
                                            this.jj_consume_token(27);
                                            joinType = ADQLQueryFactory.JoinType.OUTER_LEFT;
                                            break;
                                        }
                                        case 26: {
                                            this.jj_consume_token(26);
                                            joinType = ADQLQueryFactory.JoinType.OUTER_RIGHT;
                                            break;
                                        }
                                        case 28: {
                                            this.jj_consume_token(28);
                                            joinType = ADQLQueryFactory.JoinType.OUTER_FULL;
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[30] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 25: {
                                            this.jj_consume_token(25);
                                            break block5;
                                        }
                                    }
                                    this.jj_la1[31] = this.jj_gen;
                                    break block5;
                                }
                            }
                            this.jj_la1[32] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[33] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(29);
                    FromContent fromContent2 = this.TableRef();
                    return this.queryFactory.createJoin(joinType, fromContent, fromContent2);
                }
                case 24: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    block20 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: 
                        case 26: 
                        case 27: 
                        case 28: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 24: {
                                    this.jj_consume_token(24);
                                    break block20;
                                }
                                case 26: 
                                case 27: 
                                case 28: {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 27: {
                                            this.jj_consume_token(27);
                                            joinType = ADQLQueryFactory.JoinType.OUTER_LEFT;
                                            break;
                                        }
                                        case 26: {
                                            this.jj_consume_token(26);
                                            joinType = ADQLQueryFactory.JoinType.OUTER_RIGHT;
                                            break;
                                        }
                                        case 28: {
                                            this.jj_consume_token(28);
                                            joinType = ADQLQueryFactory.JoinType.OUTER_FULL;
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[34] = this.jj_gen;
                                            this.jj_consume_token(-1);
                                            throw new ParseException();
                                        }
                                    }
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 25: {
                                            this.jj_consume_token(25);
                                            break block20;
                                        }
                                    }
                                    this.jj_la1[35] = this.jj_gen;
                                    break block20;
                                }
                            }
                            this.jj_la1[36] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(29);
                    FromContent fromContent3 = this.TableRef();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 30: {
                            this.jj_consume_token(30);
                            this.ConditionsList(clauseConstraints);
                            return this.queryFactory.createJoin(joinType, fromContent, fromContent3, clauseConstraints);
                        }
                        case 31: {
                            this.jj_consume_token(31);
                            this.jj_consume_token(2);
                            IdentifierItems.IdentifierItem identifierItem = this.Identifier();
                            arrayList.add(this.queryFactory.createColumn(identifierItem));
                            block43: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 5: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[38] = this.jj_gen;
                                        break block43;
                                    }
                                }
                                this.jj_consume_token(5);
                                identifierItem = this.Identifier();
                                arrayList.add(this.queryFactory.createColumn(identifierItem));
                            }
                            this.jj_consume_token(3);
                            return this.queryFactory.createJoin(joinType, fromContent, fromContent3, arrayList);
                        }
                    }
                    this.jj_la1[39] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_la1[40] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final String String() throws ParseException {
        String string = "";
        block3: while (true) {
            Token token = this.jj_consume_token(93);
            string = string + token.image.substring(1, token.image.length() - 1).replaceAll("''", "'");
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[41] = this.jj_gen;
        return string;
    }

    public final String UnsignedNumeric() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 99: {
                token = this.jj_consume_token(99);
                break;
            }
            case 100: {
                token = this.jj_consume_token(100);
                break;
            }
            case 101: {
                token = this.jj_consume_token(101);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    public final String UnsignedFloat() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: {
                token = this.jj_consume_token(101);
                break;
            }
            case 100: {
                token = this.jj_consume_token(100);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    public final String SignedInteger() throws ParseException {
        Token token = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        token = this.jj_consume_token(8);
                        break block0;
                    }
                    case 9: {
                        token = this.jj_consume_token(9);
                        break block0;
                    }
                }
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        Token token2 = this.jj_consume_token(101);
        return (token == null ? "" : token.image) + token2.image;
    }

    public final ADQLOperand NumericValueExpressionPrimary() throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 99: 
                case 100: 
                case 101: {
                    String string = this.UnsignedNumeric();
                    return this.queryFactory.createNumericConstant(string);
                }
                case 96: 
                case 97: {
                    ADQLColumn aDQLColumn = this.Column();
                    aDQLColumn.setExpectedType('N');
                    return aDQLColumn;
                }
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    SQLFunction sQLFunction = this.SqlFunction();
                    return sQLFunction;
                }
                case 2: {
                    this.jj_consume_token(2);
                    ADQLOperand aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    return this.queryFactory.createWrappedOperand(aDQLOperand);
                }
            }
            this.jj_la1[46] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final ADQLOperand StringValueExpressionPrimary() throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: {
                    String string = this.String();
                    return this.queryFactory.createStringConstant(string);
                }
                case 96: 
                case 97: {
                    ADQLColumn aDQLColumn = this.Column();
                    aDQLColumn.setExpectedType('S');
                    return aDQLColumn;
                }
                case 2: {
                    this.jj_consume_token(2);
                    ADQLOperand aDQLOperand = this.StringExpression();
                    this.jj_consume_token(3);
                    return this.queryFactory.createWrappedOperand(aDQLOperand);
                }
            }
            this.jj_la1[47] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final ADQLOperand ValueExpression() throws ParseException {
        ADQLOperand aDQLOperand = null;
        try {
            if (this.jj_2_4(Integer.MAX_VALUE)) {
                aDQLOperand = this.NumericExpression();
            } else if (this.jj_2_5(Integer.MAX_VALUE)) {
                aDQLOperand = this.StringExpression();
            } else if (this.jj_2_6(Integer.MAX_VALUE)) {
                this.jj_consume_token(2);
                aDQLOperand = this.ValueExpression();
                this.jj_consume_token(3);
                aDQLOperand = this.queryFactory.createWrappedOperand(aDQLOperand);
            } else if (this.jj_2_7(Integer.MAX_VALUE)) {
                aDQLOperand = this.UserDefinedFunction();
            } else {
                block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        aDQLOperand = this.GeometryValueFunction();
                        break;
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        if (this.jj_2_8(Integer.MAX_VALUE)) {
                            aDQLOperand = this.Column();
                            break;
                        }
                        if (this.jj_2_9(Integer.MAX_VALUE)) {
                            aDQLOperand = this.StringFactor();
                            break;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 2: 
                            case 8: 
                            case 9: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 96: 
                            case 97: 
                            case 99: 
                            case 100: 
                            case 101: {
                                aDQLOperand = this.Factor();
                                break block1;
                            }
                        }
                        this.jj_la1[49] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return aDQLOperand;
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final ADQLOperand NumericExpression() throws ParseException {
        Token token = null;
        ADQLOperand aDQLOperand = null;
        ADQLOperand aDQLOperand2 = this.NumericTerm();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        token = this.jj_consume_token(8);
                        break;
                    }
                    case 9: {
                        token = this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                aDQLOperand = this.NumericExpression();
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        if (token == null) {
            return aDQLOperand2;
        }
        try {
            return this.queryFactory.createOperation(aDQLOperand2, OperationType.getOperator(token.image), aDQLOperand);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final ADQLOperand NumericTerm() throws ParseException {
        Token token = null;
        ADQLOperand aDQLOperand = null;
        ADQLOperand aDQLOperand2 = this.Factor();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 11: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        token = this.jj_consume_token(10);
                        break;
                    }
                    case 11: {
                        token = this.jj_consume_token(11);
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                aDQLOperand = this.NumericTerm();
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
            }
        }
        if (token == null) {
            return aDQLOperand2;
        }
        try {
            return this.queryFactory.createOperation(aDQLOperand2, OperationType.getOperator(token.image), aDQLOperand);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final ADQLOperand Factor() throws ParseException {
        ADQLOperand aDQLOperand;
        boolean bl = false;
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        break block1;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        bl = true;
                        break block1;
                    }
                }
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
            }
        }
        if (this.jj_2_10(2)) {
            aDQLOperand = this.NumericFunction();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: {
                    aDQLOperand = this.NumericValueExpressionPrimary();
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (bl) {
            try {
                aDQLOperand = this.queryFactory.createNegativeOperand(aDQLOperand);
            }
            catch (Exception exception) {
                throw this.generateParseException(exception);
            }
        }
        return aDQLOperand;
    }

    public final ADQLOperand StringExpression() throws ParseException {
        ADQLOperand aDQLOperand = null;
        ADQLOperand aDQLOperand2 = this.StringFactor();
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(7);
            aDQLOperand = this.StringFactor();
            if (!(aDQLOperand2 instanceof Concatenation)) {
                try {
                    ADQLOperand aDQLOperand3 = aDQLOperand2;
                    aDQLOperand2 = this.queryFactory.createConcatenation();
                    ((Concatenation)aDQLOperand2).add(aDQLOperand3);
                }
                catch (Exception exception) {
                    throw this.generateParseException(exception);
                }
            }
            ((Concatenation)aDQLOperand2).add(aDQLOperand);
        }
        return aDQLOperand2;
    }

    public final ADQLOperand StringFactor() throws ParseException {
        ADQLOperand aDQLOperand;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                aDQLOperand = this.ExtractCoordSys();
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
                if (this.jj_2_11(2)) {
                    aDQLOperand = this.UserDefinedFunction();
                    ((UserDefinedFunction)aDQLOperand).setExpectedType('S');
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: 
                    case 93: 
                    case 96: 
                    case 97: {
                        aDQLOperand = this.StringValueExpressionPrimary();
                        break block0;
                    }
                }
                this.jj_la1[59] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return aDQLOperand;
    }

    public final GeometryFunction.GeometryValue<GeometryFunction> GeometryExpression() throws ParseException {
        ADQLColumn aDQLColumn = null;
        GeometryFunction geometryFunction = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: {
                aDQLColumn = this.Column();
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                geometryFunction = this.GeometryValueFunction();
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (aDQLColumn != null) {
            aDQLColumn.setExpectedType('G');
            return new GeometryFunction.GeometryValue<GeometryFunction>(aDQLColumn);
        }
        return new GeometryFunction.GeometryValue<GeometryFunction>(geometryFunction);
    }

    public final ClauseConstraints ConditionsList(ClauseConstraints clauseConstraints) throws ParseException {
        block21: {
            ADQLConstraint aDQLConstraint = null;
            Token token = null;
            boolean bl = false;
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        this.jj_consume_token(35);
                        bl = true;
                        break;
                    }
                    default: {
                        this.jj_la1[61] = this.jj_gen;
                    }
                }
                aDQLConstraint = this.Constraint();
                if (bl) {
                    aDQLConstraint = this.queryFactory.createNot(aDQLConstraint);
                }
                bl = false;
                if (clauseConstraints instanceof ADQLConstraint) {
                    clauseConstraints.add(aDQLConstraint);
                } else {
                    clauseConstraints.add(aDQLConstraint);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: 
                        case 34: {
                            break;
                        }
                        default: {
                            this.jj_la1[62] = this.jj_gen;
                            break block21;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: {
                            token = this.jj_consume_token(33);
                            break;
                        }
                        case 34: {
                            token = this.jj_consume_token(34);
                            break;
                        }
                        default: {
                            this.jj_la1[63] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            this.jj_consume_token(35);
                            bl = true;
                            break;
                        }
                        default: {
                            this.jj_la1[64] = this.jj_gen;
                        }
                    }
                    aDQLConstraint = this.Constraint();
                    if (bl) {
                        aDQLConstraint = this.queryFactory.createNot(aDQLConstraint);
                    }
                    bl = false;
                    if (clauseConstraints instanceof ADQLConstraint) {
                        clauseConstraints.add(token.image, aDQLConstraint);
                        continue;
                    }
                    clauseConstraints.add(token.image, aDQLConstraint);
                }
            }
            catch (Exception exception) {
                throw this.generateParseException(exception);
            }
        }
        return clauseConstraints;
    }

    public final ADQLConstraint Constraint() throws ParseException {
        ADQLConstraint aDQLConstraint = null;
        if (this.jj_2_12(Integer.MAX_VALUE)) {
            aDQLConstraint = this.Predicate();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    this.jj_consume_token(2);
                    try {
                        aDQLConstraint = this.queryFactory.createGroupOfConstraints();
                    }
                    catch (Exception exception) {
                        throw this.generateParseException(exception);
                    }
                    this.ConditionsList((ConstraintsGroup)aDQLConstraint);
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return aDQLConstraint;
    }

    public final ADQLConstraint Predicate() throws ParseException {
        ADQLQuery aDQLQuery = null;
        ADQLColumn aDQLColumn = null;
        ADQLOperand aDQLOperand = null;
        ADQLOperand aDQLOperand2 = null;
        Token token = null;
        ADQLConstraint aDQLConstraint = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    this.jj_consume_token(41);
                    aDQLQuery = this.SubQueryExpression();
                    return this.queryFactory.createExists(aDQLQuery);
                }
            }
            this.jj_la1[70] = this.jj_gen;
            if (this.jj_2_14(Integer.MAX_VALUE)) {
                aDQLColumn = this.Column();
                this.jj_consume_token(36);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        token = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                    }
                }
                this.jj_consume_token(37);
                return this.queryFactory.createIsNull(token != null, aDQLColumn);
            }
            if (this.jj_2_15(Integer.MAX_VALUE)) {
                aDQLOperand = this.StringExpression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        token = this.jj_consume_token(35);
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                    }
                }
                this.jj_consume_token(39);
                aDQLOperand2 = this.StringExpression();
                return this.queryFactory.createComparison(aDQLOperand, token == null ? ComparisonOperator.LIKE : ComparisonOperator.NOTLIKE, aDQLOperand2);
            }
            block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 8: 
                case 9: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 93: 
                case 96: 
                case 97: 
                case 99: 
                case 100: 
                case 101: {
                    ADQLOperand aDQLOperand3 = this.ValueExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            aDQLConstraint = this.ComparisonEnd(aDQLOperand3);
                            break block10;
                        }
                    }
                    this.jj_la1[68] = this.jj_gen;
                    if (this.jj_2_13(2)) {
                        aDQLConstraint = this.BetweenEnd(aDQLOperand3);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: 
                        case 40: {
                            aDQLConstraint = this.InEnd(aDQLOperand3);
                            break block10;
                        }
                    }
                    this.jj_la1[69] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
        return aDQLConstraint;
    }

    public final Comparison ComparisonEnd(ADQLOperand aDQLOperand) throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                token = this.jj_consume_token(12);
                break;
            }
            case 13: {
                token = this.jj_consume_token(13);
                break;
            }
            case 14: {
                token = this.jj_consume_token(14);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ADQLOperand aDQLOperand2 = this.ValueExpression();
        try {
            return this.queryFactory.createComparison(aDQLOperand, ComparisonOperator.getOperator(token.image), aDQLOperand2);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final Between BetweenEnd(ADQLOperand aDQLOperand) throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
            }
        }
        this.jj_consume_token(38);
        ADQLOperand aDQLOperand2 = this.ValueExpression();
        this.jj_consume_token(33);
        ADQLOperand aDQLOperand3 = this.ValueExpression();
        try {
            return this.queryFactory.createBetween(token != null, aDQLOperand, aDQLOperand2, aDQLOperand3);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final In InEnd(ADQLOperand aDQLOperand) throws ParseException {
        Token token = null;
        ADQLQuery aDQLQuery = null;
        Vector<ADQLOperand> vector = new Vector<ADQLOperand>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                token = this.jj_consume_token(35);
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
            }
        }
        this.jj_consume_token(40);
        if (this.jj_2_16(2)) {
            aDQLQuery = this.SubQueryExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    this.jj_consume_token(2);
                    ADQLOperand aDQLOperand2 = this.ValueExpression();
                    vector.add(aDQLOperand2);
                    block11: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[75] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(5);
                        aDQLOperand2 = this.ValueExpression();
                        vector.add(aDQLOperand2);
                    }
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[76] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        try {
            if (aDQLQuery != null) {
                return this.queryFactory.createIn(aDQLOperand, aDQLQuery, token != null);
            }
            ADQLOperand[] aDQLOperandArray = new ADQLOperand[vector.size()];
            int n = 0;
            for (ADQLOperand aDQLOperand3 : vector) {
                aDQLOperandArray[n++] = aDQLOperand3;
            }
            return this.queryFactory.createIn(aDQLOperand, aDQLOperandArray, token != null);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final SQLFunction SqlFunction() throws ParseException {
        Token token = null;
        Token token2 = null;
        ADQLOperand aDQLOperand = null;
        SQLFunction sQLFunction = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    this.jj_consume_token(51);
                    this.jj_consume_token(2);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: {
                            token2 = this.jj_consume_token(19);
                            break;
                        }
                        default: {
                            this.jj_la1[77] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 10: {
                            token = this.jj_consume_token(10);
                            break;
                        }
                        case 2: 
                        case 8: 
                        case 9: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 93: 
                        case 96: 
                        case 97: 
                        case 99: 
                        case 100: 
                        case 101: {
                            aDQLOperand = this.ValueExpression();
                            break;
                        }
                        default: {
                            this.jj_la1[78] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(3);
                    sQLFunction = this.queryFactory.createSQLFunction(token != null ? SQLFunctionType.COUNT_ALL : SQLFunctionType.COUNT, aDQLOperand, token2 != null && token2.image.equalsIgnoreCase("distinct"));
                    break;
                }
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    Token token3;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 47: {
                            token3 = this.jj_consume_token(47);
                            break;
                        }
                        case 48: {
                            token3 = this.jj_consume_token(48);
                            break;
                        }
                        case 49: {
                            token3 = this.jj_consume_token(49);
                            break;
                        }
                        case 50: {
                            token3 = this.jj_consume_token(50);
                            break;
                        }
                        default: {
                            this.jj_la1[79] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(2);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: {
                            token2 = this.jj_consume_token(19);
                            break;
                        }
                        default: {
                            this.jj_la1[80] = this.jj_gen;
                        }
                    }
                    aDQLOperand = this.ValueExpression();
                    this.jj_consume_token(3);
                    sQLFunction = this.queryFactory.createSQLFunction(SQLFunctionType.valueOf(token3.image.toUpperCase()), aDQLOperand, token2 != null && token2.image.equalsIgnoreCase("distinct"));
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
        return sQLFunction;
    }

    public final ADQLOperand[] Coordinates() throws ParseException {
        ADQLOperand[] aDQLOperandArray = new ADQLOperand[2];
        aDQLOperandArray[0] = this.NumericExpression();
        this.jj_consume_token(5);
        aDQLOperandArray[1] = this.NumericExpression();
        return aDQLOperandArray;
    }

    public final GeometryFunction GeometryFunction() throws ParseException {
        Token token = null;
        GeometryFunction geometryFunction = null;
        PointFunction pointFunction = null;
        PointFunction pointFunction2 = null;
        ADQLColumn aDQLColumn = null;
        ADQLColumn aDQLColumn2 = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 58: 
                case 59: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 58: {
                            token = this.jj_consume_token(58);
                            break;
                        }
                        case 59: {
                            token = this.jj_consume_token(59);
                            break;
                        }
                        default: {
                            this.jj_la1[82] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(2);
                    GeometryFunction.GeometryValue<GeometryFunction> geometryValue = this.GeometryExpression();
                    this.jj_consume_token(5);
                    GeometryFunction.GeometryValue<GeometryFunction> geometryValue2 = this.GeometryExpression();
                    this.jj_consume_token(3);
                    if (token.image.equalsIgnoreCase("contains")) {
                        geometryFunction = this.queryFactory.createContains(geometryValue, geometryValue2);
                        break;
                    }
                    geometryFunction = this.queryFactory.createIntersects(geometryValue, geometryValue2);
                    break;
                }
                case 60: {
                    this.jj_consume_token(60);
                    this.jj_consume_token(2);
                    GeometryFunction.GeometryValue<GeometryFunction> geometryValue = this.GeometryExpression();
                    this.jj_consume_token(3);
                    geometryFunction = this.queryFactory.createArea(geometryValue);
                    break;
                }
                case 61: {
                    this.jj_consume_token(61);
                    this.jj_consume_token(2);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            pointFunction = this.Point();
                            geometryFunction = this.queryFactory.createCoord1(pointFunction);
                            break;
                        }
                        case 96: 
                        case 97: {
                            aDQLColumn = this.Column();
                            aDQLColumn.setExpectedType('G');
                            geometryFunction = this.queryFactory.createCoord1(aDQLColumn);
                            break;
                        }
                        default: {
                            this.jj_la1[83] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(3);
                    break;
                }
                case 62: {
                    this.jj_consume_token(62);
                    this.jj_consume_token(2);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            pointFunction = this.Point();
                            geometryFunction = this.queryFactory.createCoord2(pointFunction);
                            break;
                        }
                        case 96: 
                        case 97: {
                            aDQLColumn = this.Column();
                            aDQLColumn.setExpectedType('G');
                            geometryFunction = this.queryFactory.createCoord2(aDQLColumn);
                            break;
                        }
                        default: {
                            this.jj_la1[84] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.jj_consume_token(3);
                    break;
                }
                case 64: {
                    GeometryFunction.GeometryValue<PointFunction> geometryValue;
                    GeometryFunction.GeometryValue<PointFunction> geometryValue3;
                    this.jj_consume_token(64);
                    this.jj_consume_token(2);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            pointFunction = this.Point();
                            break;
                        }
                        case 96: 
                        case 97: {
                            aDQLColumn = this.Column();
                            break;
                        }
                        default: {
                            this.jj_la1[85] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (pointFunction != null) {
                        geometryValue3 = new GeometryFunction.GeometryValue<PointFunction>(pointFunction);
                    } else {
                        aDQLColumn.setExpectedType('G');
                        geometryValue3 = new GeometryFunction.GeometryValue(aDQLColumn);
                    }
                    this.jj_consume_token(5);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            pointFunction2 = this.Point();
                            break;
                        }
                        case 96: 
                        case 97: {
                            aDQLColumn2 = this.Column();
                            break;
                        }
                        default: {
                            this.jj_la1[86] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    if (pointFunction2 != null) {
                        geometryValue = new GeometryFunction.GeometryValue<PointFunction>(pointFunction2);
                    } else {
                        aDQLColumn2.setExpectedType('G');
                        geometryValue = new GeometryFunction.GeometryValue(aDQLColumn2);
                    }
                    this.jj_consume_token(3);
                    geometryFunction = this.queryFactory.createDistance(geometryValue3, geometryValue);
                    break;
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
        return geometryFunction;
    }

    public final ADQLOperand CoordinateSystem() throws ParseException {
        ADQLOperand aDQLOperand = null;
        aDQLOperand = this.StringExpression();
        return aDQLOperand;
    }

    public final GeometryFunction GeometryValueFunction() throws ParseException {
        ADQLOperand aDQLOperand = null;
        GeometryFunction.GeometryValue<GeometryFunction> geometryValue = null;
        GeometryFunction geometryFunction = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 52: {
                    this.jj_consume_token(52);
                    this.jj_consume_token(2);
                    ADQLOperand aDQLOperand2 = this.CoordinateSystem();
                    this.jj_consume_token(5);
                    ADQLOperand[] aDQLOperandArray = this.Coordinates();
                    this.jj_consume_token(5);
                    ADQLOperand aDQLOperand3 = this.NumericExpression();
                    this.jj_consume_token(5);
                    ADQLOperand aDQLOperand4 = this.NumericExpression();
                    this.jj_consume_token(3);
                    geometryFunction = this.queryFactory.createBox(aDQLOperand2, aDQLOperandArray[0], aDQLOperandArray[1], aDQLOperand3, aDQLOperand4);
                    break;
                }
                case 53: {
                    this.jj_consume_token(53);
                    this.jj_consume_token(2);
                    geometryValue = this.GeometryExpression();
                    this.jj_consume_token(3);
                    geometryFunction = this.queryFactory.createCentroid(geometryValue);
                    break;
                }
                case 54: {
                    this.jj_consume_token(54);
                    this.jj_consume_token(2);
                    ADQLOperand aDQLOperand5 = this.CoordinateSystem();
                    this.jj_consume_token(5);
                    ADQLOperand[] aDQLOperandArray = this.Coordinates();
                    this.jj_consume_token(5);
                    ADQLOperand aDQLOperand6 = this.NumericExpression();
                    this.jj_consume_token(3);
                    geometryFunction = this.queryFactory.createCircle(aDQLOperand5, aDQLOperandArray[0], aDQLOperandArray[1], aDQLOperand6);
                    break;
                }
                case 55: {
                    geometryFunction = this.Point();
                    break;
                }
                case 56: {
                    this.jj_consume_token(56);
                    this.jj_consume_token(2);
                    ADQLOperand aDQLOperand7 = this.CoordinateSystem();
                    Vector<ADQLOperand> vector = new Vector<ADQLOperand>();
                    this.jj_consume_token(5);
                    ADQLOperand[] aDQLOperandArray = this.Coordinates();
                    vector.add(aDQLOperandArray[0]);
                    vector.add(aDQLOperandArray[1]);
                    this.jj_consume_token(5);
                    aDQLOperandArray = this.Coordinates();
                    vector.add(aDQLOperandArray[0]);
                    vector.add(aDQLOperandArray[1]);
                    this.jj_consume_token(5);
                    aDQLOperandArray = this.Coordinates();
                    vector.add(aDQLOperandArray[0]);
                    vector.add(aDQLOperandArray[1]);
                    block13: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[88] = this.jj_gen;
                                break block13;
                            }
                        }
                        this.jj_consume_token(5);
                        aDQLOperandArray = this.Coordinates();
                        vector.add(aDQLOperandArray[0]);
                        vector.add(aDQLOperandArray[1]);
                    }
                    this.jj_consume_token(3);
                    geometryFunction = this.queryFactory.createPolygon(aDQLOperand7, vector);
                    break;
                }
                case 57: {
                    this.jj_consume_token(57);
                    this.jj_consume_token(2);
                    aDQLOperand = this.StringExpression();
                    this.jj_consume_token(3);
                    geometryFunction = this.queryFactory.createRegion(aDQLOperand);
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
        return geometryFunction;
    }

    public final PointFunction Point() throws ParseException {
        this.jj_consume_token(55);
        this.jj_consume_token(2);
        ADQLOperand aDQLOperand = this.CoordinateSystem();
        this.jj_consume_token(5);
        ADQLOperand[] aDQLOperandArray = this.Coordinates();
        this.jj_consume_token(3);
        try {
            return this.queryFactory.createPoint(aDQLOperand, aDQLOperandArray[0], aDQLOperandArray[1]);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final GeometryFunction ExtractCoordSys() throws ParseException {
        this.jj_consume_token(63);
        this.jj_consume_token(2);
        GeometryFunction.GeometryValue<GeometryFunction> geometryValue = this.GeometryExpression();
        this.jj_consume_token(3);
        try {
            return this.queryFactory.createExtractCoordSys(geometryValue);
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final ADQLFunction NumericFunction() throws ParseException {
        ADQLFunction aDQLFunction;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                aDQLFunction = this.MathFunction();
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                aDQLFunction = this.TrigFunction();
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: {
                aDQLFunction = this.GeometryFunction();
                break;
            }
            case 97: {
                aDQLFunction = this.UserDefinedFunction();
                ((UserDefinedFunction)aDQLFunction).setExpectedType('N');
                break;
            }
            default: {
                this.jj_la1[90] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return aDQLFunction;
    }

    public final MathFunction MathFunction() throws ParseException {
        Token token = null;
        ADQLOperand aDQLOperand = null;
        ADQLOperand aDQLOperand2 = null;
        String string = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    token = this.jj_consume_token(65);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 66: {
                    token = this.jj_consume_token(66);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 67: {
                    token = this.jj_consume_token(67);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 68: {
                    token = this.jj_consume_token(68);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 69: {
                    token = this.jj_consume_token(69);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 70: {
                    token = this.jj_consume_token(70);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 71: {
                    token = this.jj_consume_token(71);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 72: {
                    token = this.jj_consume_token(72);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(5);
                    aDQLOperand2 = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 73: {
                    token = this.jj_consume_token(73);
                    this.jj_consume_token(2);
                    this.jj_consume_token(3);
                    break;
                }
                case 74: {
                    token = this.jj_consume_token(74);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(5);
                    aDQLOperand2 = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 75: {
                    token = this.jj_consume_token(75);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 76: {
                    token = this.jj_consume_token(76);
                    this.jj_consume_token(2);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 2: 
                        case 8: 
                        case 9: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 96: 
                        case 97: 
                        case 99: 
                        case 100: 
                        case 101: {
                            aDQLOperand = this.NumericExpression();
                            break;
                        }
                        default: {
                            this.jj_la1[91] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(3);
                    break;
                }
                case 77: {
                    token = this.jj_consume_token(77);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            this.jj_consume_token(5);
                            string = this.SignedInteger();
                            aDQLOperand2 = this.queryFactory.createNumericConstant(string);
                            break;
                        }
                        default: {
                            this.jj_la1[92] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(3);
                    break;
                }
                case 78: {
                    token = this.jj_consume_token(78);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    this.jj_consume_token(3);
                    break;
                }
                case 79: {
                    token = this.jj_consume_token(79);
                    this.jj_consume_token(2);
                    aDQLOperand = this.NumericExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            this.jj_consume_token(5);
                            string = this.SignedInteger();
                            aDQLOperand2 = this.queryFactory.createNumericConstant(string);
                            break;
                        }
                        default: {
                            this.jj_la1[93] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(3);
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (aDQLOperand != null) {
                return this.queryFactory.createMathFunction(MathFunctionType.valueOf(token.image.toUpperCase()), aDQLOperand, aDQLOperand2);
            }
            return null;
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final MathFunction TrigFunction() throws ParseException {
        Token token = null;
        ADQLOperand aDQLOperand = null;
        ADQLOperand aDQLOperand2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 80: {
                token = this.jj_consume_token(80);
                this.jj_consume_token(2);
                aDQLOperand = this.NumericExpression();
                this.jj_consume_token(3);
                break;
            }
            case 81: {
                token = this.jj_consume_token(81);
                this.jj_consume_token(2);
                aDQLOperand = this.NumericExpression();
                this.jj_consume_token(3);
                break;
            }
            case 82: {
                token = this.jj_consume_token(82);
                this.jj_consume_token(2);
                aDQLOperand = this.NumericExpression();
                this.jj_consume_token(3);
                break;
            }
            case 83: {
                token = this.jj_consume_token(83);
                this.jj_consume_token(2);
                aDQLOperand = this.NumericExpression();
                this.jj_consume_token(5);
                aDQLOperand2 = this.NumericExpression();
                this.jj_consume_token(3);
                break;
            }
            case 84: {
                token = this.jj_consume_token(84);
                this.jj_consume_token(2);
                aDQLOperand = this.NumericExpression();
                this.jj_consume_token(3);
                break;
            }
            case 85: {
                token = this.jj_consume_token(85);
                this.jj_consume_token(2);
                aDQLOperand = this.NumericExpression();
                this.jj_consume_token(3);
                break;
            }
            case 86: {
                token = this.jj_consume_token(86);
                this.jj_consume_token(2);
                aDQLOperand = this.NumericExpression();
                this.jj_consume_token(3);
                break;
            }
            case 87: {
                token = this.jj_consume_token(87);
                this.jj_consume_token(2);
                aDQLOperand = this.NumericExpression();
                this.jj_consume_token(3);
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            if (aDQLOperand != null) {
                return this.queryFactory.createMathFunction(MathFunctionType.valueOf(token.image.toUpperCase()), aDQLOperand, aDQLOperand2);
            }
            return null;
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    public final UserDefinedFunction UserDefinedFunction() throws ParseException {
        Vector<ADQLOperand> vector = new Vector<ADQLOperand>();
        Token token = this.jj_consume_token(97);
        this.jj_consume_token(2);
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 8: 
            case 9: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 93: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: {
                ADQLOperand aDQLOperand = this.ValueExpression();
                vector.add(aDQLOperand);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[96] = this.jj_gen;
                            break block1;
                        }
                    }
                    this.jj_consume_token(5);
                    aDQLOperand = this.ValueExpression();
                    vector.add(aDQLOperand);
                }
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        this.jj_consume_token(3);
        try {
            ADQLOperand[] aDQLOperandArray = new ADQLOperand[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                aDQLOperandArray[i] = (ADQLOperand)vector.get(i);
            }
            return this.queryFactory.createUserDefinedFunction(token.image, aDQLOperandArray);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ParseException(unsupportedOperationException.getMessage(), new TextPosition(token, this.token));
        }
        catch (Exception exception) {
            throw this.generateParseException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, n);
        }
    }

    private boolean jj_3R_185() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_146() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_46();
    }

    private boolean jj_3R_149() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_161()) {
            this.jj_scanpos = token;
            if (this.jj_3_1()) {
                this.jj_scanpos = token;
                if (this.jj_3R_162()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_150() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_149();
    }

    private boolean jj_3R_145() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_163() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_185()) {
            this.jj_scanpos = token;
        }
        if (this.jj_3R_186()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_187());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_148() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(101);
    }

    private boolean jj_3R_147() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_48() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_147()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_148()) {
            this.jj_scanpos = token;
        }
        if (this.jj_3R_149()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_150());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_144() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_16() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_31()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_53() {
        return this.jj_3R_74();
    }

    private boolean jj_3R_122() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_144()) {
            this.jj_scanpos = token;
            if (this.jj_3R_145()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_55() {
        return this.jj_3R_76();
    }

    private boolean jj_3_11() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_54() {
        return this.jj_3R_75();
    }

    private boolean jj_3R_35() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = token;
            if (this.jj_3_11()) {
                this.jj_scanpos = token;
                if (this.jj_3R_55()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_133() {
        return this.jj_3R_155();
    }

    private boolean jj_3R_132() {
        return this.jj_3R_154();
    }

    private boolean jj_3R_131() {
        return this.jj_3R_153();
    }

    private boolean jj_3R_130() {
        return this.jj_3R_152();
    }

    private boolean jj_3R_123() {
        Token token;
        if (this.jj_3R_46()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_146());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_47() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_35();
    }

    private boolean jj_3R_174() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_191();
    }

    private boolean jj_3R_173() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_191();
    }

    private boolean jj_3R_31() {
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_3R_129()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_131()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_132()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_133()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_27() {
        Token token;
        if (this.jj_3R_35()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_47());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_73() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_10() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_52() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = token;
            if (this.jj_3R_73()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_168() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(11)) {
                return true;
            }
        }
        return this.jj_3R_135();
    }

    private boolean jj_3R_112() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_34() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = token;
            if (this.jj_3R_53()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_24() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_123()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_156() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(9)) {
                return true;
            }
        }
        return this.jj_3R_108();
    }

    private boolean jj_3R_19() {
        if (this.jj_3R_34()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(9)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(10)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(11)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_172() {
        return this.jj_3R_108();
    }

    private boolean jj_3R_20() {
        if (this.jj_3R_35()) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_135() {
        if (this.jj_3R_34()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_168()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_100() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_9() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_99() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_8() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_98() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_115() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_97() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_96() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_95() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_5() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(63)) {
            this.jj_scanpos = token;
            if (this.jj_3R_20()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_94() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_4() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = token;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_18() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(9)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_93() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_58() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = token;
            if (this.jj_3R_94()) {
                this.jj_scanpos = token;
                if (this.jj_3R_95()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_96()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_97()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_98()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_99()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_100()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_69() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_68() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_67() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_108() {
        if (this.jj_3R_135()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_156()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_92() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_174()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_66() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_91() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_65() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_90() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_173()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_64() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_46()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_89() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_172()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_63() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_88() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_87() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_62() {
        return this.jj_3R_108();
    }

    private boolean jj_3R_86() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_111() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_85() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_84() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_83() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_82() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_81() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_80() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_126() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_27()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_79() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_125() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_78() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_46() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = token;
            if (this.jj_3R_63()) {
                this.jj_scanpos = token;
                if (this.jj_3R_64()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_65()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_66()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_67()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_68()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_69()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_124() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_57() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_78()) {
            this.jj_scanpos = token;
            if (this.jj_3R_79()) {
                this.jj_scanpos = token;
                if (this.jj_3R_80()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_81()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_82()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_83()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_84()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_85()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_86()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_87()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_88()) {
                                                    this.jj_scanpos = token;
                                                    if (this.jj_3R_89()) {
                                                        this.jj_scanpos = token;
                                                        if (this.jj_3R_90()) {
                                                            this.jj_scanpos = token;
                                                            if (this.jj_3R_91()) {
                                                                this.jj_scanpos = token;
                                                                if (this.jj_3R_92()) {
                                                                    return true;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_121() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_120() {
        return this.jj_3R_143();
    }

    private boolean jj_3R_41() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_76() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_124()) {
            this.jj_scanpos = token;
            if (this.jj_3R_125()) {
                this.jj_scanpos = token;
                if (this.jj_3R_126()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_40() {
        return this.jj_3R_59();
    }

    private boolean jj_3R_114() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_119() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_39() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_118() {
        return this.jj_3R_142();
    }

    private boolean jj_3R_38() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_23() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = token;
            if (this.jj_3R_39()) {
                this.jj_scanpos = token;
                if (this.jj_3R_40()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_41()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_201() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_74() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_118()) {
            this.jj_scanpos = token;
            if (this.jj_3R_119()) {
                this.jj_scanpos = token;
                if (this.jj_3R_120()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_121()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_110() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_70() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_110()) {
            this.jj_scanpos = token;
            if (this.jj_3R_111()) {
                this.jj_scanpos = token;
                if (this.jj_3R_112()) {
                    return true;
                }
            }
        }
        token = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_75() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_122()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_178() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_171() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_170();
    }

    private boolean jj_3R_176() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_197() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(9)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_191() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_197()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(101);
    }

    private boolean jj_3R_49() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = token;
            if (this.jj_3R_70()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_141() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_27()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_158() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_170()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_142() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(99)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(100)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(101)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_200() {
        Token token;
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_201());
        this.jj_scanpos = token;
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_113() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_140() {
        Token token;
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_170()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_170()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_170()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_171());
        this.jj_scanpos = token;
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_71() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = token;
            if (this.jj_3R_114()) {
                this.jj_scanpos = token;
                if (this.jj_3R_115()) {
                    return true;
                }
            }
        }
        token = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_199() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_3R_163();
    }

    private boolean jj_3R_139() {
        return this.jj_3R_158();
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(93);
    }

    private boolean jj_3R_22() {
        Token token;
        if (this.jj_3R_37()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_37());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_138() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_170()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_50() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(24)) {
            this.jj_scanpos = token;
            if (this.jj_3R_71()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_33() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_3R_51()) {
            return true;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_199()) {
            this.jj_scanpos = token;
            if (this.jj_3R_200()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_137() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_122()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_51();
    }

    private boolean jj_3R_136() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_169()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_170()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_108()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_192() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(22)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_182() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_190() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(45)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(46)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_183() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_180() {
        return this.jj_3R_21();
    }

    private boolean jj_3R_109() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_136()) {
            this.jj_scanpos = token;
            if (this.jj_3R_137()) {
                this.jj_scanpos = token;
                if (this.jj_3R_138()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_139()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_140()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_141()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_181() {
        return this.jj_3R_158();
    }

    private boolean jj_3R_177() {
        return this.jj_3R_158();
    }

    private boolean jj_3R_175() {
        return this.jj_3R_158();
    }

    private boolean jj_3R_17() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = token;
            if (this.jj_3R_33()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_169() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_198() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_117() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_193()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_193() {
        Token token;
        if (this.jj_3R_72()) {
            return true;
        }
        if (this.jj_3R_198()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_198());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_179() {
        return this.jj_3R_158();
    }

    private boolean jj_3_3() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_116() {
        if (this.jj_3R_77()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_192()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_51() {
        Token token;
        if (this.jj_3R_72()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3_3());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3_2() {
        if (this.jj_3R_16()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(22)) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_105() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_179()) {
            this.jj_scanpos = token;
            if (this.jj_3R_180()) {
                return true;
            }
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_181()) {
            this.jj_scanpos = token;
            if (this.jj_3R_182()) {
                return true;
            }
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_104() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_177()) {
            this.jj_scanpos = token;
            if (this.jj_3R_178()) {
                return true;
            }
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_103() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_175()) {
            this.jj_scanpos = token;
            if (this.jj_3R_176()) {
                return true;
            }
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_102() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_122()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_72() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_116()) {
            this.jj_scanpos = token;
            if (this.jj_3_2()) {
                this.jj_scanpos = token;
                if (this.jj_3R_117()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_101() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(58)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(59)) {
                return true;
            }
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_122()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_122()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_157() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_46();
    }

    private boolean jj_3R_189() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_166() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_189()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(101)) {
                return true;
            }
        }
        token = this.jj_scanpos;
        if (this.jj_3R_190()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_59() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_101()) {
            this.jj_scanpos = token;
            if (this.jj_3R_102()) {
                this.jj_scanpos = token;
                if (this.jj_3R_103()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_104()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_105()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_160() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(47)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(48)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(49)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(50)) {
                        return true;
                    }
                }
            }
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        token = this.jj_scanpos;
        if (this.jj_scan_token(19)) {
            this.jj_scanpos = token;
        }
        if (this.jj_3R_46()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_170() {
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_108();
    }

    private boolean jj_3R_159() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(19)) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = token;
            if (this.jj_3R_183()) {
                return true;
            }
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_188() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_164() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_188()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(101)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_56() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_77();
    }

    private boolean jj_3R_143() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_159()) {
            this.jj_scanpos = token;
            if (this.jj_3R_160()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_21() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_36() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_128() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_127() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_134() {
        Token token;
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_46()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_157());
        this.jj_scanpos = token;
        return this.jj_scan_token(3);
    }

    private boolean jj_3_16() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_107() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(40)) {
            return true;
        }
        token = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = token;
            if (this.jj_3R_134()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_77() {
        if (this.jj_3R_14()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_127()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_128()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(96);
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(97);
    }

    private boolean jj_3R_26() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_3R_46();
    }

    private boolean jj_3R_61() {
        return this.jj_3R_107();
    }

    private boolean jj_3R_14() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = token;
            if (this.jj_3R_29()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_3R_26();
    }

    private boolean jj_3_15() {
        if (this.jj_3R_27()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_60() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_167() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_166();
    }

    private boolean jj_3_14() {
        if (this.jj_3R_21()) {
            return true;
        }
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_106() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(13)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(14)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(15)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(16)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(17)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_46();
    }

    private boolean jj_3R_155() {
        Token token;
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_3R_166()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_167());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_154() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_3R_163();
    }

    private boolean jj_3R_45() {
        if (this.jj_3R_46()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = token;
            if (this.jj_3_13()) {
                this.jj_scanpos = token;
                if (this.jj_3R_61()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_44() {
        if (this.jj_3R_27()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private boolean jj_3R_165() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_164();
    }

    private boolean jj_3R_43() {
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_scan_token(36)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_184() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_153() {
        Token token;
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_3R_164()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_165());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_42() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_16();
    }

    private boolean jj_3R_151() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_51();
    }

    private boolean jj_3R_152() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_3R_163();
    }

    private boolean jj_3R_30() {
        if (this.jj_3R_14()) {
            return true;
        }
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_25() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = token;
            if (this.jj_3R_43()) {
                this.jj_scanpos = token;
                if (this.jj_3R_44()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_45()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_129() {
        Token token;
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_3R_51()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_151());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3_12() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_162() {
        if (this.jj_3R_46()) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_184()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_15() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(4)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_195() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_3R_163()) {
            return true;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_194() {
        return this.jj_3R_25();
    }

    private boolean jj_3R_186() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_194()) {
            this.jj_scanpos = token;
            if (this.jj_3R_195()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_196() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3R_187() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(33)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(34)) {
                return true;
            }
        }
        token = this.jj_scanpos;
        if (this.jj_3R_196()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_186();
    }

    private boolean jj_3R_161() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3_1() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_scan_token(4)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_15()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(10);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{65, 0, 0, 0, 0, 524288, 0x100000, 32, 0, 0, 0x400000, 1024, 772, 32, 32, 32, 0, 16, 16, 16, 0, 0, 0, 0, 0x400000, 0x400000, 0x400000, 0, 4, 1031798784, 0x1C000000, 0x2000000, 0x1D000000, 0x1D000000, 0x1C000000, 0x2000000, 0x1D000000, 0x1D000000, 32, -1073741824, 1031798784, 0, 0, 0, 768, 768, 4, 4, 0, 772, 768, 768, 3072, 3072, 768, 768, 4, 128, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 258048, 0, 0, 772, 258048, 0, 0, 32, 4, 524288, 1796, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 772, 32, 32, 0, 0, 32, 772};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 1, 1024, 2048, 4096, 0, 0, 0, 0, 0, 0, 0, Short.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24576, 24576, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1015808, 0, 0x3F00000, 2081390592, 0, 0, 0, 0, 0, 0, 1015808, 0, Integer.MIN_VALUE, 0, 0x3F00000, 8, 6, 6, 8, 0, 8, 8, 0, 264, 512, Short.MIN_VALUE, 0, 8, 8, 0, 0, 0, Short.MIN_VALUE, 491520, 0, 1015808, 0xC000000, 0x800000, 0x800000, 0x800000, 0x800000, 0x7C000000, 0, 0x3F00000, 0x7C000000, 2081390592, 0, 0, 0, 0, 0, Short.MIN_VALUE};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20FFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0x20000000, 0, 0xFFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20FFFFFF, 0, 0, 0, 0, 0, 0, 0x20FFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0xFFFFFF, 0xFFFFFF, 0, 0, 65534, 0xFF0000, 0, 0x20FFFFFF};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 59, 0, 0, 0, 3, 0, 0, 0, 35, 35, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 48, 0, 0, 59, 3, 0, 59, 0, 0, 0, 0, 0, 0, 59, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 0, 2, 59, 0, 0, 0, 0, 0, 59};
    }

    public ADQLParser(InputStream inputStream) {
        this(inputStream, (String)null);
    }

    public ADQLParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new ADQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 98; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 98; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ADQLParser(Reader reader) {
        int n;
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new ADQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 98; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 98; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ADQLParser(ADQLParserTokenManager aDQLParserTokenManager) {
        int n;
        this.token_source = aDQLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 98; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ADQLParserTokenManager aDQLParserTokenManager) {
        int n;
        this.token_source = aDQLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 98; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] nArray : this.jj_expentries) {
                if (nArray.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[103];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 98; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) != 0) {
                    blArray[64 + n] = true;
                }
                if ((jj_la1_3[n2] & 1 << n) == 0) continue;
                blArray[96 + n] = true;
            }
        }
        for (n2 = 0; n2 < 103; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 16; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        ADQLParser.jj_la1_init_0();
        ADQLParser.jj_la1_init_1();
        ADQLParser.jj_la1_init_2();
        ADQLParser.jj_la1_init_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

