/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBTable;
import adql.query.IdentifierField;
import adql.query.from.ADQLTable;
import cds.utils.TextualSearchList;
import java.util.ArrayList;
import java.util.Collection;

public class SearchTableList
extends TextualSearchList<DBTable> {
    private static final long serialVersionUID = 1L;
    private boolean distinct = false;

    public SearchTableList() {
        super(new DBTableKeyExtractor());
    }

    public SearchTableList(Collection<? extends DBTable> collection) {
        super(collection, new DBTableKeyExtractor());
    }

    public SearchTableList(int n) {
        super(n, new DBTableKeyExtractor());
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public ArrayList<DBTable> search(String string) {
        return this.get(string);
    }

    public final ArrayList<DBTable> search(String string, String string2, String string3) {
        return this.search(string, string2, string3, (byte)0);
    }

    public ArrayList<DBTable> search(ADQLTable aDQLTable) {
        return this.search(aDQLTable.getCatalogName(), aDQLTable.getSchemaName(), aDQLTable.getTableName(), aDQLTable.getCaseSensitive());
    }

    public ArrayList<DBTable> search(String string, String string2, String string3, byte by) {
        ArrayList<DBTable> arrayList = this.get(string3, IdentifierField.TABLE.isCaseSensitive(by));
        if (string2 != null) {
            ArrayList<DBTable> arrayList2 = new ArrayList<DBTable>();
            for (DBTable dBTable : arrayList) {
                if (dBTable.getADQLSchemaName() != null) {
                    if (!IdentifierField.SCHEMA.isCaseSensitive(by) ? !dBTable.getADQLSchemaName().equalsIgnoreCase(string2) : !dBTable.getADQLSchemaName().equals(string2)) continue;
                    if (string != null && dBTable.getADQLCatalogName() != null && (IdentifierField.CATALOG.isCaseSensitive(by) ? !dBTable.getADQLCatalogName().equals(string) : !dBTable.getADQLCatalogName().equalsIgnoreCase(string))) continue;
                }
                arrayList2.add(dBTable);
            }
            return arrayList2;
        }
        return arrayList;
    }

    @Override
    public boolean add(DBTable dBTable) {
        if (this.distinct && this.contains(dBTable)) {
            return false;
        }
        return super.add(dBTable);
    }

    private static class DBTableKeyExtractor
    implements TextualSearchList.KeyExtractor<DBTable> {
        private DBTableKeyExtractor() {
        }

        @Override
        public String getKey(DBTable dBTable) {
            return dBTable.getADQLName();
        }
    }
}

