/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBCommonColumn;
import adql.db.DBTable;
import adql.query.IdentifierField;
import adql.query.from.ADQLJoin;
import adql.query.operand.ADQLColumn;
import cds.utils.TextualSearchList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class SearchColumnList
extends TextualSearchList<DBColumn> {
    private static final long serialVersionUID = 1L;
    private boolean distinct = false;
    private final HashMap<String, String> tableAliases = new HashMap();
    private final HashMap<String, ArrayList<String>> mapAliases = new HashMap();

    public SearchColumnList() {
        super(new DBColumnKeyExtractor());
    }

    public SearchColumnList(Collection<DBColumn> collection) {
        super(collection, new DBColumnKeyExtractor());
    }

    public SearchColumnList(int n) {
        super(n, new DBColumnKeyExtractor());
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public final void putTableAlias(String string, String string2) {
        if (string != null && string2 != null) {
            this.tableAliases.put(string, string2);
            ArrayList<String> arrayList = this.mapAliases.get(string.toLowerCase());
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.mapAliases.put(string.toLowerCase(), arrayList);
            }
            arrayList.add(string);
        }
    }

    public final void removeTableAlias(String string) {
        this.tableAliases.remove(string);
        ArrayList<String> arrayList = this.mapAliases.get(string.toLowerCase());
        if (arrayList != null) {
            arrayList.remove(string);
            if (arrayList.isEmpty()) {
                this.mapAliases.remove(string.toLowerCase());
            }
        }
    }

    public final void removeAllTableAliases() {
        this.tableAliases.clear();
        this.mapAliases.clear();
    }

    public final int getNbTableAliases() {
        return this.tableAliases.size();
    }

    public ArrayList<DBColumn> search(String string) {
        return this.get(string);
    }

    public final ArrayList<DBColumn> search(String string, String string2, String string3, String string4) {
        return this.search(string, string2, string3, string4, (byte)0);
    }

    public ArrayList<DBColumn> search(ADQLColumn aDQLColumn) {
        return this.search(aDQLColumn.getCatalogName(), aDQLColumn.getSchemaName(), aDQLColumn.getTableName(), aDQLColumn.getColumnName(), aDQLColumn.getCaseSensitive());
    }

    public ArrayList<DBColumn> search(String string, String string2, String string3, String string4, byte by) {
        ArrayList<DBColumn> arrayList = this.get(string4, IdentifierField.COLUMN.isCaseSensitive(by));
        if (string3 != null) {
            String string5 = null;
            ArrayList<String> arrayList2 = null;
            if (IdentifierField.TABLE.isCaseSensitive(by)) {
                string5 = this.tableAliases.get(string3);
                if (string5 == null) {
                    string5 = string3;
                }
            } else {
                arrayList2 = this.mapAliases.get(string3.toLowerCase());
                if (arrayList2 == null || arrayList2.isEmpty()) {
                    string5 = string3;
                }
            }
            ArrayList<DBColumn> arrayList3 = new ArrayList<DBColumn>();
            for (DBColumn dBColumn : arrayList) {
                Iterator<DBTable> iterator = ADQLJoin.isCommonColumn(dBColumn) ? ((DBCommonColumn)dBColumn).getCoveredTables() : new SingleIterator<DBTable>(dBColumn.getTable());
                while (iterator.hasNext()) {
                    DBTable dBTable = iterator.next();
                    if (arrayList2 == null) {
                        if (IdentifierField.TABLE.isCaseSensitive(by) ? !dBTable.getADQLName().equals(string5) : !dBTable.getADQLName().equalsIgnoreCase(string5)) {
                            continue;
                        }
                    } else {
                        boolean bl = false;
                        for (int i = 0; !bl && i < arrayList2.size(); ++i) {
                            String string6 = this.tableAliases.get(arrayList2.get(i));
                            if (string6 == null) continue;
                            bl = dBTable.getADQLName().equalsIgnoreCase(string6);
                        }
                        if (!bl) continue;
                    }
                    if (string2 != null && dBTable.getADQLSchemaName() != null && ((!IdentifierField.SCHEMA.isCaseSensitive(by) ? !dBTable.getADQLSchemaName().equalsIgnoreCase(string2) : !dBTable.getADQLSchemaName().equals(string2)) || string != null && (IdentifierField.CATALOG.isCaseSensitive(by) ? !dBTable.getADQLCatalogName().equals(string) : !dBTable.getADQLCatalogName().equalsIgnoreCase(string)))) continue;
                    DBColumn dBColumn2 = dBTable.getColumn(dBColumn.getADQLName(), true);
                    arrayList3.add(dBColumn2);
                }
            }
            return arrayList3;
        }
        if (arrayList.size() > 1) {
            ArrayList<DBColumn> arrayList4 = new ArrayList<DBColumn>(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!ADQLJoin.isCommonColumn(arrayList.get(i))) continue;
                DBCommonColumn dBCommonColumn = (DBCommonColumn)arrayList.remove(i);
                arrayList4.add(dBCommonColumn);
                Iterator<DBTable> iterator = dBCommonColumn.getCoveredTables();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next().getColumn(string4, true));
                }
            }
            if (arrayList4.size() == 1) {
                return arrayList4;
            }
        }
        return arrayList;
    }

    @Override
    public boolean add(DBColumn dBColumn) {
        if (this.distinct && this.contains(dBColumn)) {
            return false;
        }
        return super.add(dBColumn);
    }

    @Override
    public boolean addAll(Collection<? extends DBColumn> collection) {
        boolean bl = super.addAll(collection);
        if (bl && collection instanceof SearchColumnList) {
            SearchColumnList searchColumnList = (SearchColumnList)collection;
            for (Map.Entry<String, String> entry : searchColumnList.tableAliases.entrySet()) {
                this.putTableAlias(entry.getKey(), entry.getValue());
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = super.removeAll(collection);
        if (bl && collection instanceof SearchColumnList) {
            SearchColumnList searchColumnList = (SearchColumnList)collection;
            for (String string : searchColumnList.tableAliases.keySet()) {
                this.removeTableAlias(string);
            }
        }
        return bl;
    }

    private static class SingleIterator<E>
    implements Iterator<E> {
        private final E item;
        private boolean done = false;

        public SingleIterator(E e) {
            this.item = e;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public E next() {
            if (!this.done) {
                this.done = true;
                return this.item;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DBColumnKeyExtractor
    implements TextualSearchList.KeyExtractor<DBColumn> {
        private DBColumnKeyExtractor() {
        }

        @Override
        public String getKey(DBColumn dBColumn) {
            return dBColumn.getADQLName();
        }
    }
}

