/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.plc.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.plc.CtrlTaskType;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class CtrlTaskTypeNodeBase
extends BaseObjectTypeNode
implements CtrlTaskType {
    protected CtrlTaskTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getPriorityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Priority");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getPriority() {
        Object object = this.getPriorityNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Priority does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setPriority(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getPriorityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Priority failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Priority failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Interval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getInterval() {
        Object object = this.getIntervalNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setInterval(String string) {
        UaProperty uaProperty = this.getIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Interval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Interval failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSingleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Single");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getSingle() {
        Object object = this.getSingleNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSingle(String string) {
        UaProperty uaProperty = this.getSingleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Single failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Single failed unexpectedly", statusException);
        }
    }
}

