/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.plc.server;

import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.di.server.ConfigurableObjectTypeNode;
import com.prosysopc.ua.types.di.server.DeviceTypeNode;
import com.prosysopc.ua.types.di.server.FunctionalGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.plc.CtrlResourceType;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class CtrlResourceTypeNodeBase
extends DeviceTypeNode
implements CtrlResourceType {
    protected CtrlResourceTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getMethodSetNode());
        this.callAfterCreateIfExists(this.getTasksNode());
        this.callAfterCreateIfExists(this.getProgramsNode());
        this.callAfterCreateIfExists(this.getGlobalVarsNode());
        this.callAfterCreateIfExists(this.getConfigurationNode());
        this.callAfterCreateIfExists(this.getDiagnosticNode());
    }

    @Override
    @Optional
    public BaseObjectTypeNode getMethodSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "MethodSet");
        return (BaseObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ConfigurableObjectTypeNode getTasksNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Tasks");
        return (ConfigurableObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ConfigurableObjectTypeNode getProgramsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Programs");
        return (ConfigurableObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FunctionalGroupTypeNode getGlobalVarsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "GlobalVars");
        return (FunctionalGroupTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FunctionalGroupTypeNode getConfigurationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Configuration");
        return (FunctionalGroupTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FunctionalGroupTypeNode getDiagnosticNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Diagnostic");
        return (FunctionalGroupTypeNode)this.getComponent(qualifiedName);
    }
}

