/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.plc.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.plc.CtrlProgramType;
import com.prosysopc.ua.types.plc.server.CtrlProgramOrganizationUnitTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;

public abstract class CtrlProgramTypeNodeBase
extends CtrlProgramOrganizationUnitTypeNode
implements CtrlProgramType {
    protected CtrlProgramTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getProgramNode());
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getProgramNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://PLCopen.org/OpcUa/IEC61131-3/", "Program");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Structure getProgram() {
        Object object = this.getProgramNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Structure)object;
    }

    @Override
    @Optional
    public void setProgram(Structure structure) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getProgramNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Program failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(structure);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Program failed unexpectedly", statusException);
        }
    }
}

